/*
 * Decompiled with CFR 0.152.
 */
package nicelee.bilibili.parsers.impl;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.regex.Pattern;
import nicelee.bilibili.annotations.Bilibili;
import nicelee.bilibili.model.ClipInfo;
import nicelee.bilibili.model.VideoInfo;
import nicelee.bilibili.parsers.impl.AbstractBaseParser;
import nicelee.bilibili.util.HttpCookies;
import nicelee.bilibili.util.HttpHeaders;
import nicelee.bilibili.util.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

@Bilibili(name="URL4PictureCVParser", note="\u56fe\u7247\u89e3\u6790 - \u4e13\u680f")
public class URL4PictureCVParser
extends AbstractBaseParser {
    private static final Pattern pattern = Pattern.compile("\\.bilibili\\.com/read/(mobile\\?id=|cv)([0-9]+)");
    private String cvIdNumber;
    protected static final HashMap<String, String> headers = new HttpHeaders().getCommonHeaders("www.bilibili.com");

    public URL4PictureCVParser(Object ... objectArray) {
        super(objectArray);
    }

    @Override
    public boolean matches(String string) {
        this.matcher = pattern.matcher(string);
        if (this.matcher.find()) {
            this.cvIdNumber = this.matcher.group(2);
            Logger.println("\u5339\u914dURL4PictureCVParser: cv" + this.cvIdNumber);
            return true;
        }
        return false;
    }

    @Override
    public String validStr(String string) {
        return string;
    }

    @Override
    public VideoInfo result(String string, int n, boolean bl) {
        return this.getCVDetail(this.cvIdNumber);
    }

    protected VideoInfo getCVDetail(String string) {
        String string2;
        Object object;
        Object object2;
        int n;
        Object object3;
        Logger.println("URL4PictureCVParser\u6b63\u5728\u83b7\u53d6\u7ed3\u679c: cv" + string);
        String string3 = "cv" + string;
        VideoInfo videoInfo = new VideoInfo();
        videoInfo.setVideoId(string3);
        String string4 = "https://www.bilibili.com/read/" + string3;
        String string5 = this.util.getContent(string4, headers, HttpCookies.globalCookiesWithFingerprint());
        int n2 = string5.indexOf("window.__INITIAL_STATE__=");
        int n3 = string5.indexOf(";(function()", n2);
        String string6 = string5.substring(n2 + 25, n3);
        Logger.println(string6);
        JSONObject jSONObject = new JSONObject(string6);
        jSONObject = jSONObject.getJSONObject("detail");
        JSONArray jSONArray = null;
        JSONArray jSONArray2 = null;
        JSONArray jSONArray3 = jSONObject.getJSONArray("modules");
        JSONObject jSONObject2 = null;
        for (int i = 0; i < jSONArray3.length(); ++i) {
            object3 = jSONArray3.getJSONObject(i);
            String string7 = ((JSONObject)object3).getString("module_type");
            if (string7.equals("MODULE_TYPE_AUTHOR")) {
                jSONObject2 = ((JSONObject)object3).getJSONObject("module_author");
            } else if (string7.equals("MODULE_TYPE_CONTENT")) {
                jSONArray = ((JSONObject)object3).getJSONObject("module_content").getJSONArray("paragraphs");
            } else if (string7.equals("MODULE_TYPE_TOP")) {
                jSONArray2 = ((JSONObject)object3).getJSONObject("module_top").getJSONObject("display").getJSONObject("album").getJSONArray("pics");
            } else if (string7.equals("MODULE_TYPE_TITLE")) {
                videoInfo.setVideoName(((JSONObject)object3).getJSONObject("module_title").getString("text"));
            }
            if (jSONObject2 != null && jSONArray != null && jSONArray2 != null && videoInfo.getVideoName() != null) break;
        }
        String string8 = jSONObject2.getString("name");
        object3 = jSONObject2.optString("mid");
        long l = jSONObject2.optLong("pub_ts") * 1000L;
        videoInfo.setAuthor(string8);
        videoInfo.setAuthorId((String)object3);
        block1: for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject3 = jSONArray.getJSONObject(i);
            n = jSONObject3.optInt("para_type");
            if (n != 1) continue;
            object2 = jSONObject3.getJSONObject("text").getJSONArray("nodes");
            for (int j = 0; j < ((JSONArray)object2).length(); ++j) {
                object = ((JSONArray)object2).getJSONObject(j);
                if (!"TEXT_NODE_TYPE_WORD".equals(((JSONObject)object).getString("type"))) continue;
                String string9 = ((JSONObject)object).getJSONObject("word").getString("words");
                videoInfo.setBrief(string9);
                if (videoInfo.getVideoName() != null) continue block1;
                string2 = string9;
                if (string2.length() > 15) {
                    string2 = string2.substring(0, 15);
                }
                videoInfo.setVideoName(string2);
                continue block1;
            }
        }
        if (videoInfo.getVideoName() == null) {
            videoInfo.setVideoName("\u7a7a");
        }
        LinkedHashMap<Long, ClipInfo> linkedHashMap = new LinkedHashMap<Long, ClipInfo>();
        int n4 = 0;
        if (jSONArray2 != null) {
            for (n = 0; n < jSONArray2.length(); ++n) {
                object2 = jSONArray2.getJSONObject(n).getString("url");
                ClipInfo clipInfo = this.newCommonClip(string3, videoInfo, string8, (String)object3, l, null, null);
                this.setPicOfClip(clipInfo, linkedHashMap, n4, (String)object2);
                if (videoInfo.getVideoPreview() == null) {
                    videoInfo.setVideoPreview((String)object2);
                }
                ++n4;
            }
        }
        for (n = 0; n < jSONArray.length(); ++n) {
            object2 = jSONArray.getJSONObject(n);
            int n5 = ((JSONObject)object2).optInt("para_type");
            if (n5 != 2) continue;
            object = ((JSONObject)object2).getJSONObject("pic").getJSONArray("pics");
            for (int i = 0; i < ((JSONArray)object).length(); ++i) {
                string2 = ((JSONArray)object).getJSONObject(i).getString("url");
                ClipInfo clipInfo = this.newCommonClip(string3, videoInfo, string8, (String)object3, l, null, null);
                this.setPicOfClip(clipInfo, linkedHashMap, n4, string2);
                if (videoInfo.getVideoPreview() == null) {
                    videoInfo.setVideoPreview(string2);
                }
                ++n4;
            }
        }
        videoInfo.setClips(linkedHashMap);
        return videoInfo;
    }

    protected void setPicOfClip(ClipInfo clipInfo, LinkedHashMap<Long, ClipInfo> linkedHashMap, int n, String string) {
        clipInfo.setcId(n);
        clipInfo.setPage(n);
        clipInfo.setRemark(n);
        clipInfo.setTitle("\u7b2c" + n + "\u5f20");
        clipInfo.setPicPreview(string);
        LinkedHashMap<Integer, String> linkedHashMap2 = new LinkedHashMap<Integer, String>();
        linkedHashMap2.put(0, string);
        clipInfo.setLinks(linkedHashMap2);
        linkedHashMap.put(clipInfo.getcId(), clipInfo);
    }

    protected ClipInfo newCommonClip(String string, VideoInfo videoInfo, String string2, String string3, long l, String string4, String string5) {
        ClipInfo clipInfo = new ClipInfo();
        clipInfo.setAvTitle(videoInfo.getVideoName());
        clipInfo.setAvId(string);
        clipInfo.setUpName(string2);
        clipInfo.setUpId(string3);
        clipInfo.setcTime(l);
        clipInfo.setListName(string4);
        clipInfo.setListOwnerName(string5);
        return clipInfo;
    }
}

