/*
 * Decompiled with CFR 0.152.
 */
package nicelee.bilibili.parsers.impl;

import java.util.LinkedHashMap;
import java.util.regex.Pattern;
import nicelee.bilibili.annotations.Bilibili;
import nicelee.bilibili.model.ClipInfo;
import nicelee.bilibili.model.VideoInfo;
import nicelee.bilibili.parsers.impl.AbstractPageQueryParser;
import nicelee.bilibili.util.HttpHeaders;
import nicelee.bilibili.util.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

@Bilibili(name="URL4ChannelParser", ifLoad="listAll", note="UP \u67d0\u4e3b\u9898\u9891\u9053\u6587\u4ef6\u5939\u7684\u89c6\u9891\u89e3\u6790")
public class URL4ChannelParser
extends AbstractPageQueryParser<VideoInfo> {
    private static final Pattern pattern = Pattern.compile("space\\.bilibili\\.com/([0-9]+)/channel/detail\\?cid=([0-9]+)");
    private String spaceID;
    private String cid;

    public URL4ChannelParser(Object ... objectArray) {
        super(objectArray);
    }

    @Override
    public boolean matches(String string) {
        this.matcher = pattern.matcher(string);
        if (this.matcher.find()) {
            System.out.println("\u5339\u914dUP\u4e3b\u4e3b\u9875\u7279\u5b9a\u9891\u9053,\u8fd4\u56de av1 av2 av3 ...");
            this.spaceID = this.matcher.group(1);
            this.cid = this.matcher.group(2);
            return true;
        }
        return false;
    }

    @Override
    public String validStr(String string) {
        return this.matcher.group().trim() + "p=" + this.paramSetter.getPage();
    }

    @Override
    public VideoInfo result(String string, int n, boolean bl) {
        return (VideoInfo)this.result(this.pageSize, this.paramSetter.getPage(), n, bl);
    }

    @Override
    public void initPageQueryParam() {
        this.API_PMAX = 20;
        this.pageQueryResult = new VideoInfo();
        ((VideoInfo)this.pageQueryResult).setClips(new LinkedHashMap<Long, ClipInfo>());
    }

    @Override
    protected boolean query(int n, int n2, int n3, Object ... objectArray) {
        int n4 = (Integer)objectArray[0];
        boolean bl = (Boolean)objectArray[1];
        try {
            String string = "https://api.bilibili.com/x/space/channel/video?mid=%s&cid=%s&pn=%d&ps=%d&order=0";
            String string2 = String.format(string, this.spaceID, this.cid, n, this.API_PMAX);
            String string3 = this.util.getContent(string2, new HttpHeaders().getCommonHeaders("api.bilibili.com"));
            Logger.println(string2);
            JSONObject jSONObject = new JSONObject(string3);
            JSONObject jSONObject2 = jSONObject.getJSONObject("data").getJSONObject("list");
            JSONArray jSONArray = jSONObject2.getJSONArray("archives");
            if (((VideoInfo)this.pageQueryResult).getVideoName() == null) {
                ((VideoInfo)this.pageQueryResult).setVideoId(this.spaceID + " - " + this.cid);
                ((VideoInfo)this.pageQueryResult).setVideoName(jSONObject2.getString("name"));
                ((VideoInfo)this.pageQueryResult).setBrief(jSONObject2.getString("intro"));
                ((VideoInfo)this.pageQueryResult).setAuthor(jSONArray.getJSONObject(0).getJSONObject("owner").getString("name"));
                ((VideoInfo)this.pageQueryResult).setAuthorId(this.spaceID);
                ((VideoInfo)this.pageQueryResult).setVideoPreview(jSONObject2.getString("cover"));
            }
            LinkedHashMap<Long, ClipInfo> linkedHashMap = ((VideoInfo)this.pageQueryResult).getClips();
            for (int i = n2 - 1; i < jSONArray.length() && i < n3; ++i) {
                JSONObject jSONObject3 = jSONArray.getJSONObject(i);
                try {
                    linkedHashMap.putAll(this.convertVideoToClipMap(jSONObject3.getString("bvid"), (n - 1) * this.API_PMAX + i + 1, n4, bl));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private LinkedHashMap<Long, ClipInfo> convertVideoToClipMap(String string, int n, int n2, boolean bl) {
        LinkedHashMap<Long, ClipInfo> linkedHashMap = new LinkedHashMap<Long, ClipInfo>();
        VideoInfo videoInfo = this.getAVDetail(string, n2, bl);
        for (ClipInfo clipInfo : videoInfo.getClips().values()) {
            clipInfo.setListName(((VideoInfo)this.pageQueryResult).getVideoName().replaceAll("[/\\\\]", "_"));
            clipInfo.setListOwnerName(((VideoInfo)this.pageQueryResult).getAuthor().replaceAll("[/\\\\]", "_"));
            clipInfo.setListOwnerId(((VideoInfo)this.pageQueryResult).getAuthorId());
            clipInfo.setRemark(n);
            linkedHashMap.put(clipInfo.getcId(), clipInfo);
        }
        return linkedHashMap;
    }
}

