/*
 * Decompiled with CFR 0.152.
 */
package nicelee.bilibili.parsers.impl;

import java.net.HttpCookie;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Matcher;
import nicelee.bilibili.API;
import nicelee.bilibili.enums.DownloadModeEnum;
import nicelee.bilibili.exceptions.ApiLinkQueryParseError;
import nicelee.bilibili.exceptions.NoSubtitleException;
import nicelee.bilibili.exceptions.QualityTooLowException;
import nicelee.bilibili.model.ClipInfo;
import nicelee.bilibili.model.StoryClipInfo;
import nicelee.bilibili.model.VideoInfo;
import nicelee.bilibili.parsers.IInputParser;
import nicelee.bilibili.parsers.IParamSetter;
import nicelee.bilibili.util.HttpCookies;
import nicelee.bilibili.util.HttpHeaders;
import nicelee.bilibili.util.HttpRequestUtil;
import nicelee.bilibili.util.Logger;
import nicelee.bilibili.util.convert.ConvertUtil;
import nicelee.ui.Global;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class AbstractBaseParser
implements IInputParser {
    protected Matcher matcher;
    protected HttpRequestUtil util;
    protected int pageSize = 20;
    protected IParamSetter paramSetter;

    public AbstractBaseParser(Object ... objectArray) {
        this.util = (HttpRequestUtil)objectArray[0];
        this.paramSetter = (IParamSetter)objectArray[1];
        this.pageSize = (Integer)objectArray[2];
    }

    @Override
    public abstract boolean matches(String var1);

    @Override
    public abstract String validStr(String var1);

    @Override
    public abstract VideoInfo result(String var1, int var2, boolean var3);

    public VideoInfo getAVDetail(String string, int n, boolean bl) {
        int n2;
        long l;
        Object object;
        VideoInfo videoInfo = new VideoInfo();
        videoInfo.setVideoId(string);
        String string2 = String.format("https://api.bilibili.com/x/player/pagelist?bvid=%s&jsonp=jsonp", string);
        HashMap<String, String> hashMap = new HttpHeaders().getBiliJsonAPIHeaders(string);
        String string3 = this.util.getContent(string2, hashMap, HttpCookies.globalCookiesWithFingerprint());
        Logger.println(string2);
        Logger.println(string3);
        JSONArray jSONArray = new JSONObject(string3).getJSONArray("data");
        JSONObject jSONObject = jSONArray.getJSONObject(0);
        long l2 = jSONObject.getLong("cid");
        String string4 = "https://api.bilibili.com/x/web-interface/wbi/view/detail?platform=web&page_no=1&p=1&need_operation_card=1&web_rm_repeat=1&need_elec=1&bvid=" + string;
        string4 = string4 + API.genDmImgParams();
        string4 = API.encWbi(string4);
        String string5 = this.util.getContent(string4, hashMap, HttpCookies.globalCookiesWithFingerprint());
        Logger.println(string4);
        Logger.println(string5);
        JSONObject jSONObject2 = new JSONObject(string5);
        long l3 = ConvertUtil.Bv2Av(string);
        if (jSONObject2.optInt("code") == -403) {
            string4 = String.format("https://api.bilibili.com/x/v3/fav/resource/infos?resources=%d:2&platform=web&folder_mid=&folder_id=", l3);
            string5 = this.util.getContent(string4, hashMap, HttpCookies.globalCookiesWithFingerprint());
            Logger.println(string4);
            Logger.println(string5);
            object = new JSONObject(string5).getJSONArray("data").getJSONObject(0);
            l = ((JSONObject)object).optLong("ctime") * 1000L;
            n2 = ((JSONObject)object).optInt("page");
            videoInfo.setVideoName(((JSONObject)object).getString("title"));
            videoInfo.setBrief(((JSONObject)object).getString("intro"));
            videoInfo.setAuthor(((JSONObject)object).getJSONObject("upper").getString("name"));
            videoInfo.setAuthorId(String.valueOf(((JSONObject)object).getJSONObject("upper").getLong("mid")));
            videoInfo.setVideoPreview(((JSONObject)object).getString("cover"));
        } else {
            object = jSONObject2.getJSONObject("data").getJSONObject("View");
            l = ((JSONObject)object).optLong("ctime") * 1000L;
            n2 = ((JSONObject)object).optInt("videos");
            videoInfo.setVideoName(((JSONObject)object).getString("title"));
            videoInfo.setBrief(((JSONObject)object).getString("desc"));
            videoInfo.setAuthor(((JSONObject)object).getJSONObject("owner").getString("name"));
            videoInfo.setAuthorId(String.valueOf(((JSONObject)object).getJSONObject("owner").getLong("mid")));
            videoInfo.setVideoPreview(((JSONObject)object).getString("pic"));
        }
        if (n2 > 1 && jSONArray.length() == 1) {
            object = String.format("https://api.bilibili.com/x/player/wbi/v2?aid=%d&cid=%d&isGaiaAvoided=false", l3, l2);
            object = (String)object + API.genDmImgParams();
            object = API.encWbi((String)object);
            String string6 = this.util.getContent((String)object, hashMap, HttpCookies.globalCookiesWithFingerprint());
            Logger.println((String)object);
            Logger.println(string6);
            String string7 = new JSONObject(string6).getJSONObject("data").getJSONObject("interaction").optString("graph_version");
            Logger.println(string7);
            ArrayList<List<StoryClipInfo>> arrayList = new ArrayList<List<StoryClipInfo>>();
            ArrayList<StoryClipInfo> arrayList2 = new ArrayList<StoryClipInfo>();
            StoryClipInfo storyClipInfo = new StoryClipInfo(l2);
            arrayList2.add(storyClipInfo);
            HashSet<StoryClipInfo> hashSet = new HashSet<StoryClipInfo>();
            this.collectStoryList(string, "", string7, arrayList2, arrayList, hashSet);
            LinkedHashMap<Long, ClipInfo> linkedHashMap = this.storyList2Map(string, n, bl, videoInfo, arrayList);
            videoInfo.setClips(linkedHashMap);
            videoInfo.print();
            return videoInfo;
        }
        object = new LinkedHashMap();
        int[] nArray = null;
        if (jSONArray.length() > 5) {
            nArray = new int[]{120, 116, 112, 80, 74, 64, 32, 16};
        }
        for (int i = 0; i < jSONArray.length(); ++i) {
            jSONObject = jSONArray.getJSONObject(i);
            l2 = jSONObject.getLong("cid");
            ClipInfo clipInfo = new ClipInfo();
            clipInfo.setAvTitle(videoInfo.getVideoName());
            clipInfo.setAvId(string);
            clipInfo.setcId(l2);
            clipInfo.setPage(jSONObject.getInt("page"));
            clipInfo.setTitle(jSONObject.getString("part"));
            clipInfo.setPicPreview(videoInfo.getVideoPreview());
            clipInfo.setUpName(videoInfo.getAuthor());
            clipInfo.setUpId(videoInfo.getAuthorId());
            clipInfo.setcTime(l);
            LinkedHashMap<Integer, String> linkedHashMap = new LinkedHashMap<Integer, String>();
            try {
                int[] nArray2;
                for (int n3 : nArray2 = nArray != null ? nArray : this.getVideoQNList(string, String.valueOf(clipInfo.getcId()))) {
                    if (bl) {
                        String string8 = this.getVideoLink(string, String.valueOf(clipInfo.getcId()), n3, n);
                        linkedHashMap.put(n3, string8);
                        continue;
                    }
                    linkedHashMap.put(n3, "");
                }
                clipInfo.setLinks(linkedHashMap);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                clipInfo.setLinks(linkedHashMap);
            }
            ((HashMap)object).put(clipInfo.getcId(), clipInfo);
        }
        videoInfo.setClips((LinkedHashMap<Long, ClipInfo>)object);
        videoInfo.print();
        return videoInfo;
    }

    public int[] getVideoQNList(String string, String string2) {
        switch (Global.infoQueryStrategy) {
            case "tryNormalTypeFirst": {
                return this.getVideoQNList_TryNormalTypeFirst(string, string2);
            }
            case "judgeTypeFirst": {
                return this.getVideoQNList_JudgeTypeFirst(string, string2);
            }
        }
        return new int[]{120, 116, 112, 80, 74, 64, 32, 16};
    }

    private int[] getVideoQNList_JudgeTypeFirst(String string, String string2) {
        Object object;
        HttpHeaders httpHeaders = new HttpHeaders();
        JSONArray jSONArray = null;
        String string3 = "https://api.bilibili.com/x/web-interface/wbi/view/detail?platform=web&bvid=" + string;
        string3 = string3 + API.genDmImgParams();
        string3 = API.encWbi(string3);
        HashMap<String, String> hashMap = httpHeaders.getBiliJsonAPIHeaders(string);
        String string4 = this.util.getContent(string3, hashMap, HttpCookies.globalCookiesWithFingerprint());
        Logger.println(string4);
        JSONObject jSONObject = new JSONObject(string4).getJSONObject("data").getJSONObject("View");
        Long l = jSONObject.optLong("aid");
        if (jSONObject.optString("redirect_url").isEmpty()) {
            string3 = "https://api.bilibili.com/x/player/playurl?cid=%s&bvid=%s&qn=%d&type=&otype=json&fnver=0&fnval=4048&fourk=1";
            string3 = String.format(string3, string2, string, 32);
            Logger.println(string3);
            object = this.util.getContent(string3, httpHeaders.getBiliJsonAPIHeaders(string), HttpCookies.globalCookiesWithFingerprint());
            Logger.println((String)object);
            jSONArray = new JSONObject((String)object).getJSONObject("data").getJSONArray("accept_quality");
        } else {
            string3 = "https://api.bilibili.com/pgc/player/web/playurl?fnval=4048&fnver=0&fourk=1&otype=json&avid=%s&cid=%s&qn=%s";
            string3 = String.format(string3, l, string2, 32);
            Logger.println(string3);
            object = this.util.getContent(string3, httpHeaders.getBiliJsonAPIHeaders("av" + l), HttpCookies.globalCookiesWithFingerprint());
            Logger.println((String)object);
            jSONArray = new JSONObject((String)object).getJSONObject("result").getJSONArray("accept_quality");
        }
        object = new int[jSONArray.length()];
        for (int i = 0; i < ((Object)object).length; ++i) {
            object[i] = jSONArray.getInt(i);
        }
        return object;
    }

    private int[] getVideoQNList_TryNormalTypeFirst(String string, String string2) {
        Object object;
        HttpHeaders httpHeaders = new HttpHeaders();
        JSONArray jSONArray = null;
        try {
            object = "https://api.bilibili.com/x/player/playurl?cid=%s&bvid=%s&qn=%d&type=&otype=json&fnver=0&fnval=4048&fourk=1";
            object = String.format((String)object, string2, string, 32);
            Logger.println((String)object);
            String string3 = this.util.getContent((String)object, httpHeaders.getBiliJsonAPIHeaders(string), HttpCookies.globalCookiesWithFingerprint());
            Logger.println(string3);
            jSONArray = new JSONObject(string3).getJSONObject("data").getJSONArray("accept_quality");
        }
        catch (Exception exception) {
            long l = ConvertUtil.Bv2Av(string);
            String string4 = "https://api.bilibili.com/pgc/player/web/playurl?fnval=4048&fnver=0&fourk=1&otype=json&avid=%d&cid=%s&qn=%s";
            string4 = String.format(string4, l, string2, 32);
            Logger.println(string4);
            String string5 = this.util.getContent(string4, httpHeaders.getBiliJsonAPIHeaders("av" + l), HttpCookies.globalCookiesWithFingerprint());
            Logger.println(string5);
            jSONArray = new JSONObject(string5).getJSONObject("result").getJSONArray("accept_quality");
        }
        object = new int[jSONArray.length()];
        for (int i = 0; i < ((Object)object).length; ++i) {
            object[i] = jSONArray.getInt(i);
        }
        return object;
    }

    @Override
    public String getVideoLink(String string, String string2, int n, int n2) {
        if (string.startsWith("au") && (n > 3 || n < 0)) {
            n = 3;
        }
        switch (n) {
            case 800: {
                return this.getVideoSubtitleLink(string, string2, n);
            }
            case 801: {
                this.paramSetter.setRealQN(n);
                return "https://api.bilibili.com/x/v1/dm/list.so?oid=" + string2;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return this.getAudioLink(string, string2, n);
            }
        }
        return this.getVideoLinkByFormat(string, string2, n, n2);
    }

    protected String getAudioLink(String string, String string2, int n) {
        String string3 = string.substring(2);
        String string4 = String.format("https://www.bilibili.com/audio/music-service-c/url?songid=%s&privilege=2&quality=%d&mid=&platform=web", string3, n);
        Logger.println(string4);
        HashMap<String, String> hashMap = new HttpHeaders().getCommonHeaders();
        String string5 = this.util.getContent(string4, hashMap, HttpCookies.globalCookiesWithFingerprint());
        Logger.println(string5);
        JSONObject jSONObject = new JSONObject(string5).getJSONObject("data");
        int n2 = jSONObject.optInt("type");
        Logger.printf("\u9884\u671f\u4e0b\u8f7d\u6e05\u6670\u5ea6\uff1a%d, \u5b9e\u9645\u6e05\u6670\u5ea6\uff1a%d", n, n2);
        this.paramSetter.setRealQN(n2);
        String string6 = jSONObject.getJSONArray("cdns").getString(0);
        Logger.println(string6);
        return string6;
    }

    protected String getVideoSubtitleLink(String string, String string2, int n) {
        String string3 = String.format("https://api.bilibili.com/x/player/wbi/v2?bvid=%s&cid=%s&isGaiaAvoided=false", string, string2);
        string3 = string3 + API.genDmImgParams();
        string3 = API.encWbi(string3);
        Logger.println(string3);
        HashMap<String, String> hashMap = new HttpHeaders().getBiliJsonAPIHeaders(string);
        String string4 = this.util.getContent(string3, hashMap, HttpCookies.globalCookiesWithFingerprint());
        this.paramSetter.setRealQN(n);
        try {
            JSONArray jSONArray = new JSONObject(string4).getJSONObject("data").getJSONObject("subtitle").getJSONArray("subtitles");
            for (int i = 0; i < jSONArray.length(); ++i) {
                JSONObject jSONObject = jSONArray.getJSONObject(i);
                String string5 = jSONObject.getString("lan");
                if (!Global.cc_lang.equals(string5)) continue;
                return "https:" + jSONObject.getString("subtitle_url");
            }
            return "https:" + jSONArray.getJSONObject(0).getString("subtitle_url");
        }
        catch (Exception exception) {
            String string6 = Global.isLogin ? "\u672a\u80fd\u627e\u5230\u5b57\u5e55 " + string : "\u672a\u80fd\u627e\u5230\u5b57\u5e55\uff0c\u8fd9\u53ef\u80fd\u662f\u6ca1\u6709\u767b\u5f55\u9020\u6210\u7684\u3002" + string;
            throw new NoSubtitleException(string6, exception);
        }
    }

    String getVideoLinkByFormat(String string, String string2, int n, int n2) {
        int n3;
        boolean bl;
        Object object;
        Object object2;
        Object object3;
        Long l;
        System.out.println("\u6b63\u5728\u67e5\u8be2MP4/FLV\u94fe\u63a5...");
        HttpHeaders httpHeaders = new HttpHeaders();
        JSONObject jSONObject = null;
        String string3 = (n2 & 1) == 0 ? "4048" : "2";
        String string4 = "https://api.bilibili.com/x/web-interface/wbi/view/detail?platform=web&bvid=" + string;
        string4 = string4 + API.genDmImgParams();
        string4 = API.encWbi(string4);
        HashMap<String, String> hashMap = httpHeaders.getBiliJsonAPIHeaders(string);
        String string5 = this.util.getContent(string4, hashMap, HttpCookies.globalCookiesWithFingerprint());
        JSONObject jSONObject2 = new JSONObject(string5);
        if (jSONObject2.optInt("code") == -403) {
            l = ConvertUtil.Bv2Av(string);
            object3 = String.format("https://api.bilibili.com/x/v3/fav/resource/infos?resources=%d:2&platform=web&folder_mid=&folder_id=", l);
            object2 = this.util.getContent((String)object3, hashMap, HttpCookies.globalCookiesWithFingerprint());
            Logger.println((String)object3);
            Logger.println((String)object2);
            object = new JSONObject((String)object2).getJSONArray("data").getJSONObject(0);
            bl = ((JSONObject)object).getInt("attr") != 2;
        } else {
            object3 = jSONObject2.getJSONObject("data").getJSONObject("View");
            l = ((JSONObject)object3).optLong("aid");
            bl = ((JSONObject)object3).optString("redirect_url").isEmpty();
        }
        if (bl) {
            object3 = Global.isLogin ? "" : "&try_look=1";
            string4 = n2 == 2 ? "https://api.bilibili.com/x/player/wbi/playurl?cid=%s&bvid=%s&qn=%d" : "https://api.bilibili.com/x/player/wbi/playurl?cid=%s&bvid=%s&qn=%d&type=&otype=json&fnver=0&fnval=%s&fourk=1";
            string4 = string4 + (String)object3;
            string4 = String.format(string4, string2, string, n, string3);
            string4 = API.encWbi(string4);
            Logger.println(string4);
            object2 = HttpCookies.globalCookiesWithFingerprint();
            object = this.util.getContent(string4, httpHeaders.getBiliJsonAPIHeaders(string), (List<HttpCookie>)object2);
            Logger.println((String)object);
            jSONObject = new JSONObject((String)object).getJSONObject("data");
        } else {
            string4 = "https://api.bilibili.com/pgc/player/web/playurl?fnver=0&fourk=1&otype=json&avid=%s&cid=%s&qn=%s&fnval=%s";
            string4 = String.format(string4, l, string2, n, string3);
            object3 = this.util.getContent(string4, httpHeaders.getBiliJsonAPIHeaders("av" + l), HttpCookies.globalCookiesWithFingerprint());
            Logger.println(string4);
            Logger.println((String)object3);
            jSONObject = new JSONObject((String)object3).getJSONObject("result");
        }
        int n4 = jSONObject.getInt("quality");
        if (n != n4 && (object2 = jSONObject.optJSONObject("dash")) != null && n4 < (n3 = ((JSONArray)(object = ((JSONObject)object2).getJSONArray("video"))).getJSONObject(0).getInt("id"))) {
            n4 = n3 > n ? n : n3;
        }
        this.paramSetter.setRealQN(n4);
        object2 = String.format("%s:%s - \u67e5\u8be2\u8d28\u91cf\u4e3a: %d\u7684\u94fe\u63a5, \u5f97\u5230\u8d28\u91cf\u4e3a: %d\u7684\u94fe\u63a5", string, string2, n, n4);
        Logger.println((String)object2);
        if (Global.alertIfQualityUnexpected && n4 < 64 && n > n4 && Global.isLogin) {
            object = (String)object2 + "\n\u8be5\u89c6\u9891\u7684\u6700\u9ad8\u753b\u8d28\u6e05\u6670\u5ea6\u8f83\u4f4e\uff0c\u8bf7\u66f4\u6362\u76f8\u5339\u914d\u7684\u4f18\u5148\u6e05\u6670\u5ea6\u4e4b\u540e\u518d\u8fdb\u884c\u5c1d\u8bd5\u3002\n\u5982\u679c\u4f60\u8ba4\u4e3a\u6b64\u5904\u5e94\u5f53\u7ee7\u7eed\u4e0b\u8f7d\uff0c\u800c\u4e0d\u662f\u62a5\u9519\uff0c\u8bf7\u5728\u914d\u7f6e\u9875\u641c\u7d22 qualityUnexpected \u5e76\u8fdb\u884c\u914d\u7f6e\n";
            throw new QualityTooLowException((String)object);
        }
        try {
            return this.parseType1(jSONObject, n4, httpHeaders.getBiliWwwM4sHeaders(string));
        }
        catch (Exception exception) {
            Logger.println("\u5207\u6362\u89e3\u6790\u65b9\u5f0f");
            try {
                return this.parseType2(jSONObject);
            }
            catch (Exception exception2) {
                exception.printStackTrace();
                exception2.printStackTrace();
                throw new ApiLinkQueryParseError("\u67e5\u8be2\u4e0b\u8f7d\u94fe\u63a5\u65f6api\u89e3\u6790\u5931\u8d25", exception);
            }
        }
    }

    private void collectStoryList(String string, String string2, String string3, List<StoryClipInfo> list, List<List<StoryClipInfo>> list2, HashSet<StoryClipInfo> hashSet) {
        Object object;
        String string4 = "https://api.bilibili.com/x/stein/edgeinfo_v2?bvid=%s&edge_id=%s&graph_version=%s&platform=pc&portal=0&screen=0";
        String string5 = String.format(string4, string, string2, string3);
        Logger.println(string5);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Referer", "https://www.bilibili.com/video/" + string);
        String string6 = this.util.getContent(string5, hashMap, HttpCookies.globalCookiesWithFingerprint());
        Logger.println(string6);
        JSONObject jSONObject = new JSONObject(string6).getJSONObject("data");
        JSONArray jSONArray = jSONObject.optJSONObject("edges").optJSONArray("questions");
        if (string2 == null || "".equals(string2)) {
            object = list.get(0);
            ((StoryClipInfo)object).setNode_id(jSONObject.optLong("node_id"));
            ((StoryClipInfo)object).setOption(jSONObject.getString("title"));
            hashSet.add((StoryClipInfo)object);
        }
        if (jSONArray == null) {
            list2.add(list);
        } else {
            object = jSONArray.getJSONObject(0).getJSONArray("choices");
            boolean bl = false;
            for (int i = 0; i < ((JSONArray)object).length(); ++i) {
                JSONObject jSONObject2 = ((JSONArray)object).getJSONObject(i);
                StoryClipInfo storyClipInfo = new StoryClipInfo(jSONObject2.optLong("cid"), jSONObject2.getLong("id"), jSONObject2.getString("option"));
                if (hashSet.contains(storyClipInfo)) {
                    bl = true;
                    continue;
                }
                ArrayList<StoryClipInfo> arrayList = new ArrayList<StoryClipInfo>(list);
                arrayList.add(storyClipInfo);
                hashSet.add(storyClipInfo);
                this.collectStoryList(string, "" + jSONObject2.getLong("id"), string3, arrayList, list2, hashSet);
            }
            if (bl) {
                list2.add(list);
            }
        }
    }

    String getUrlOfMedia(JSONObject jSONObject, boolean bl, HashMap<String, String> hashMap) {
        String string = jSONObject.getString("base_url");
        if (!bl) {
            return string;
        }
        if (this.util.checkValid(string, hashMap, null)) {
            return string;
        }
        JSONArray jSONArray = jSONObject.getJSONArray("backup_url");
        for (int i = 0; i < jSONArray.length(); ++i) {
            String string2 = jSONArray.getString(i);
            if (!this.util.checkValid(string2, hashMap, null)) continue;
            return string2;
        }
        return null;
    }

    JSONObject findMediaByPriList(List<JSONObject> list, int[] nArray, int n) {
        for (int n2 : nArray) {
            JSONObject jSONObject = this.findMediaByPri(list, n2, n);
            if (jSONObject == null) continue;
            return jSONObject;
        }
        return list.get(0);
    }

    JSONObject findMediaByPri(List<JSONObject> list, int n, int n2) {
        for (JSONObject jSONObject : list) {
            if (-1 != n && (n2 != 0 || jSONObject.getInt("codecid") != n) && (n2 != 1 || jSONObject.getInt("id") != n)) continue;
            return jSONObject;
        }
        return null;
    }

    protected String parseType1(JSONObject jSONObject, int n, HashMap<String, String> hashMap) {
        Object object;
        JSONObject jSONObject2;
        Iterable<JSONObject> iterable;
        Iterable<Object> iterable2;
        JSONObject jSONObject3 = jSONObject.getJSONObject("dash");
        StringBuilder stringBuilder = new StringBuilder();
        if (Global.downloadMode == DownloadModeEnum.AudioOnly) {
            stringBuilder.append("#");
        } else {
            Object object2;
            iterable2 = jSONObject3.getJSONArray("video");
            iterable = new ArrayList(3);
            for (int i = 0; i < ((JSONArray)iterable2).length(); ++i) {
                object2 = ((JSONArray)iterable2).getJSONObject(i);
                if (((JSONObject)object2).getInt("id") != n) continue;
                iterable.add((JSONObject)object2);
            }
            if (iterable.size() == 0) {
                JSONObject jSONObject4 = ((JSONArray)iterable2).getJSONObject(0);
                this.paramSetter.setRealQN(jSONObject4.getInt("id"));
                System.out.println("API\u8fd4\u56de\u8d28\u91cf\u4e3a:" + n + "\u7684\u94fe\u63a5, \u5b9e\u9645\u4e0a\u53ea\u6709\u8d28\u91cf\u4e3a:" + this.paramSetter.getRealQN() + "\u7684\u94fe\u63a5");
                iterable.add((JSONObject)jSONObject4);
            }
            Integer n2 = this.paramSetter.getRealQN();
            object2 = Global.videoCodecPriorityMap.getOrDefault(n2, Global.videoCodecPriority);
            jSONObject2 = this.findMediaByPriList((List<JSONObject>)iterable, (int[])object2, 0);
            object = this.getUrlOfMedia(jSONObject2, Global.checkDashUrl, hashMap);
            stringBuilder.append((String)object).append("#");
        }
        if (Global.downloadMode != DownloadModeEnum.VideoOnly) {
            JSONObject jSONObject5;
            JSONObject jSONObject6;
            iterable2 = new ArrayList(5);
            iterable = jSONObject3.optJSONArray("audio");
            if (iterable != null) {
                for (int i = 0; i < ((JSONArray)iterable).length(); ++i) {
                    iterable2.add((JSONObject)((JSONArray)iterable).getJSONObject(i));
                }
            }
            if ((jSONObject6 = jSONObject3.optJSONObject("dolby")) != null && n == 126 && (iterable = jSONObject6.optJSONArray("audio")) != null) {
                for (int i = 0; i < ((JSONArray)iterable).length(); ++i) {
                    iterable2.add((JSONObject)((JSONArray)iterable).getJSONObject(i));
                }
            }
            JSONObject jSONObject7 = jSONObject2 = (jSONObject5 = jSONObject3.optJSONObject("flac")) == null ? null : jSONObject5.optJSONObject("audio");
            if (jSONObject2 != null) {
                iterable2.add((JSONObject)jSONObject2);
            }
            if (iterable2.size() > 0) {
                object = this.findMediaByPriList((List<JSONObject>)iterable2, Global.audioQualityPriority, 1);
                String string = this.getUrlOfMedia((JSONObject)object, Global.checkDashUrl, hashMap);
                stringBuilder.append(string);
            }
        }
        return stringBuilder.toString();
    }

    protected String parseType2(JSONObject jSONObject) {
        JSONArray jSONArray = jSONObject.getJSONArray("durl");
        if (jSONArray.length() == 1) {
            return jSONArray.getJSONObject(0).getString("url");
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject2 = jSONArray.getJSONObject(i);
            stringBuilder.append(jSONObject2.getInt("order"));
            stringBuilder.append(jSONObject2.getString("url"));
            stringBuilder.append("#");
        }
        System.out.println(stringBuilder.substring(0, stringBuilder.length() - 1));
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    @Override
    public int getVideoLinkQN() {
        return this.paramSetter.getRealQN();
    }

    private LinkedHashMap<Long, ClipInfo> storyList2Map(String string, int n, boolean bl, VideoInfo videoInfo, List<List<StoryClipInfo>> list) {
        LinkedHashMap<Long, ClipInfo> linkedHashMap = new LinkedHashMap<Long, ClipInfo>();
        for (int i = 0; i < list.size(); ++i) {
            List<StoryClipInfo> list2 = list.get(i);
            for (int j = 0; j < list2.size(); ++j) {
                ClipInfo clipInfo;
                StoryClipInfo storyClipInfo = list2.get(j);
                long l = storyClipInfo.getCid();
                ClipInfo clipInfo2 = linkedHashMap.get(l);
                if (clipInfo2 == null) {
                    clipInfo = new ClipInfo();
                    clipInfo.setAvTitle(videoInfo.getVideoName());
                    clipInfo.setAvId(string);
                    clipInfo.setcId(l);
                    clipInfo.setPage(linkedHashMap.size());
                    clipInfo.setTitle(String.format("%d.%d-%s", i, j, storyClipInfo.getOption()));
                    clipInfo.setPicPreview(videoInfo.getVideoPreview());
                    clipInfo.setUpName(videoInfo.getAuthor());
                    clipInfo.setUpId(videoInfo.getAuthorId());
                    LinkedHashMap<Integer, String> linkedHashMap2 = new LinkedHashMap<Integer, String>();
                    try {
                        int[] nArray;
                        for (int n2 : nArray = this.getVideoQNList(string, String.valueOf(clipInfo.getcId()))) {
                            if (bl) {
                                String string2 = this.getVideoLink(string, String.valueOf(clipInfo.getcId()), n2, n);
                                linkedHashMap2.put(n2, string2);
                                continue;
                            }
                            linkedHashMap2.put(n2, "");
                        }
                        clipInfo.setLinks(linkedHashMap2);
                    }
                    catch (Exception exception) {
                        clipInfo.setLinks(linkedHashMap2);
                    }
                    linkedHashMap.put(clipInfo.getcId(), clipInfo);
                    continue;
                }
                clipInfo = clipInfo2;
                if (i == 0) {
                    clipInfo.setTitle(String.format("%s_%d.%d-%s", clipInfo.getTitle(), i, j, storyClipInfo.getOption()));
                } else {
                    clipInfo.setTitle(String.format("%s_%d.%d", clipInfo.getTitle(), i, j));
                }
                if (j != 0) continue;
                clipInfo.setTitle("\u8d77\u59cb");
            }
        }
        return linkedHashMap;
    }
}

