/*
 * Decompiled with CFR 0.152.
 */
package nicelee.bilibili;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import nicelee.bilibili.util.ConfigUtil;
import nicelee.bilibili.util.Encrypt;
import nicelee.bilibili.util.HttpCookies;
import nicelee.bilibili.util.HttpHeaders;
import nicelee.bilibili.util.HttpRequestUtil;
import nicelee.bilibili.util.Logger;
import nicelee.bilibili.util.ResourcesUtil;
import nicelee.bilibili.util.convert.ConvertUtil;
import nicelee.bilibili.util.custom.System;
import nicelee.ui.Global;
import org.json.JSONObject;

public class API {
    static int[] MixinArray = new int[]{46, 47, 18, 2, 53, 8, 23, 32, 15, 50, 10, 31, 58, 3, 45, 35, 27, 43, 5, 49, 33, 9, 42, 19, 29, 28, 14, 39, 12, 38, 41, 13, 37, 48, 7, 16, 24, 55, 40, 61, 26, 17, 0, 1, 60, 51, 30, 4, 22, 25, 54, 21, 56, 59, 6, 63, 57, 62, 11, 36, 20, 34, 44, 52};
    static String wbiImg = null;
    static final long SECONDS_OF_ONE_YEAR = 31536000L;
    static Random random = new Random();
    static Pattern pWebglVersion = Pattern.compile("\"webgl version:([^\"]+)\"");
    static Pattern pResolution = Pattern.compile("\"6e7c\":\"(\\d+)x(\\d+)\"");
    static Pattern pWebglUnRenderer = Pattern.compile("\"webgl unmasked renderer:([^\"]+)\"");
    static Pattern pWebglUnVendor = Pattern.compile("\"webgl unmasked vendor:([^\"]+)\"");

    public static void main(String[] stringArray) {
        ConfigUtil.initConfigs();
        API.uploadFingerprint();
    }

    public static boolean like(String string) {
        long l = ConvertUtil.Bv2Av(string);
        return API.like(l);
    }

    public static boolean like(long l) {
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        String string = "https://api.bilibili.com/x/web-interface/archive/has/like?aid=" + l;
        HashMap<String, String> hashMap = new HttpHeaders().getActionHeaders("av" + l);
        String string2 = httpRequestUtil.getContent(string, hashMap, HttpCookies.getGlobalCookies());
        Logger.println(string2);
        if (string2.startsWith("{\"code\":0,\"message\":\"0\",\"ttl\":1,\"data\":0}")) {
            String string3 = "https://api.bilibili.com/x/web-interface/archive/like";
            String string4 = String.format("aid=%d&like=1&csrf=%s", l, HttpCookies.getCsrf());
            String string5 = httpRequestUtil.postContent(string3, hashMap, string4, HttpCookies.getGlobalCookies());
            Logger.println(string5);
            if (string5.startsWith("{\"code\":0")) {
                return true;
            }
        }
        return false;
    }

    public static void logout() {
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        String string = "https://passport.bilibili.com/login/exit/v2";
        String string2 = String.format("biliCSRF=%s", HttpCookies.getCsrf());
        String string3 = httpRequestUtil.postContent(string, new HttpHeaders().getLogoutHeaders(), string2, HttpCookies.getGlobalCookies());
        Logger.println(string3);
    }

    private static String getMixinKey(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 32; ++i) {
            stringBuilder.append(string.charAt(MixinArray[i]));
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void getWbiUrl() {
        if (wbiImg != null) return;
        Class<API> clazz = API.class;
        synchronized (API.class) {
            if (wbiImg != null) return;
            HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
            String string = httpRequestUtil.getContent("https://api.bilibili.com/x/web-interface/nav", new HttpHeaders().getCommonHeaders(), HttpCookies.getGlobalCookies());
            JSONObject jSONObject = new JSONObject(string).getJSONObject("data").getJSONObject("wbi_img");
            String string2 = jSONObject.getString("img_url");
            int n = string2.lastIndexOf("/");
            int n2 = string2.indexOf(".", n);
            Logger.println(string2);
            String string3 = jSONObject.getString("sub_url");
            int n3 = string3.lastIndexOf("/");
            int n4 = string3.indexOf(".", n3);
            Logger.println(string3);
            wbiImg = string2.substring(n + 1, n2) + string3.substring(n3 + 1, n4);
            Logger.println(wbiImg);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static String encodeURL(String string) {
        String string2 = string;
        if (!string2.contains("%")) {
            try {
                string2 = URLEncoder.encode(string2, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return string2.replace("+", "%20");
    }

    public static String encWbi(String string2) {
        String string3;
        Object object;
        String string4;
        String string5;
        API.getWbiUrl();
        String string6 = API.getMixinKey(wbiImg);
        String string7 = "wts=" + System.currentTimeMillis() / 1000L;
        int n = string2.indexOf("?");
        if (n >= 0) {
            string5 = string2.substring(n + 1);
            string4 = string5.isEmpty() ? "" : "&";
            string5 = string5 + string4 + string7;
            object = string5.split("&");
            List list = Arrays.stream(object).map(string -> {
                try {
                    String[] stringArray = string.split("=", 2);
                    String string2 = URLEncoder.encode(stringArray[0], "UTF-8");
                    String string3 = stringArray.length >= 2 ? API.encodeURL(stringArray[1]) : "";
                    return string2 + "=" + string3;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    return string;
                }
            }).collect(Collectors.toList());
            Collections.sort(list);
            string3 = String.join((CharSequence)"&", list);
        } else {
            string4 = "?";
            string3 = string7;
        }
        string5 = Encrypt.MD5(string3 + string6);
        object = String.format("%s%sw_rid=%s&%s", string2, string4, string5, string7);
        return object;
    }

    public static synchronized String getFingerprint() {
        String string = null;
        File file = ResourcesUtil.sourceOf("./config/fingerprint.config");
        if (file.exists()) {
            string = ResourcesUtil.readAll(file);
            Pattern pattern = Pattern.compile("b_nut=([^;]+)");
            Matcher matcher = pattern.matcher(string);
            matcher.find();
            long l = Long.parseLong(matcher.group(1));
            long l2 = System.currentTimeMillis() / 1000L;
            if (!string.contains("i-wanna-go-back") || l2 - l > 31536000L) {
                file.delete();
                string = null;
            } else {
                pattern = Pattern.compile("b_lsid=([^;]+)");
                matcher = pattern.matcher(string);
                matcher.find();
                String string2 = matcher.group(1).split("_")[1];
                long l3 = Long.parseLong(string2, 16);
                if (l3 + 5400000L < l2) {
                    String string3 = ResourcesUtil.randomHex(8) + "_" + Long.toHexString(l2).toUpperCase();
                    string = matcher.replaceFirst("b_lsid=" + string3);
                    ResourcesUtil.write(file, string);
                }
            }
        }
        if (string == null) {
            string = API.genNewFingerprint();
            ResourcesUtil.write(file, string);
        }
        Logger.println(string);
        return string;
    }

    public static void uploadFingerprint() {
        String string;
        Object object;
        long l = System.currentTimeMillis();
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        HttpHeaders httpHeaders = new HttpHeaders();
        String string2 = HttpCookies.get("b_lsid").split("_")[1];
        long l2 = Long.parseLong(string2, 16);
        if (l2 + 5400000L < l) {
            object = ResourcesUtil.randomHex(8) + "_" + Long.toHexString(l).toUpperCase();
            HttpCookies.set("b_lsid", (String)object);
        }
        if (((Matcher)(object = pResolution.matcher(Global.userAgentPayload))).find()) {
            string = String.format("%s-%s", ((Matcher)object).group(1), ((Matcher)object).group(2));
            HttpCookies.set("browser_resolution", string);
        }
        string = Global.userAgentPayload;
        string = string.replaceFirst("\"5062\":\"[^\"]+\"", "\"5062\":\"" + l + "\"");
        string = string.replaceFirst("\"b8ce\":\"[^\"]+\"", "\"b8ce\":\"" + Global.userAgent + "\"");
        string = string.replaceFirst("\"df35\":\"[^\"]+\"", "\"df35\":\"" + HttpCookies.get("_uuid") + "\"");
        String string3 = "https://api.bilibili.com/x/internal/gaia-gateway/ExClimbWuzhi";
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("payload", string);
        String string4 = jSONObject.toString();
        Logger.println(string);
        Logger.println(string4);
        HashMap<String, String> hashMap = httpHeaders.getCommonHeaders();
        hashMap.put("Content-type", "application/json;charset=UTF-8");
        String string5 = httpRequestUtil.postContent(string3, hashMap, string4, HttpCookies.globalCookiesWithFingerprint());
        Logger.println(string5);
    }

    public static String genNewFingerprint() {
        try {
            Object object;
            String string2;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            long l = System.currentTimeMillis();
            HttpURLConnection httpURLConnection = (HttpURLConnection)new URL("https://www.bilibili.com/").openConnection();
            httpURLConnection.setRequestProperty("User-Agent", Global.userAgent);
            httpURLConnection.connect();
            List<String> list = httpURLConnection.getHeaderFields().get("Set-Cookie");
            list = list != null ? list : httpURLConnection.getHeaderFields().get("set-cookie");
            for (String string2 : list) {
                object = string2.split(";", 2)[0].split("=", 2);
                hashMap.put(object[0].trim(), object[1].trim());
            }
            hashMap.put("i-wanna-go-back", "-1");
            String string3 = ResourcesUtil.randomHex(8) + "_" + Long.toHexString(l).toUpperCase();
            hashMap.put("b_lsid", string3);
            string2 = ResourcesUtil.randomHex(8) + "-" + ResourcesUtil.randomHex(4) + "-" + ResourcesUtil.randomHex(4) + "-" + ResourcesUtil.randomHex(4) + "-" + ResourcesUtil.randomHex(18) + "infoc";
            hashMap.put("_uuid", string2);
            object = new HttpRequestUtil();
            HttpHeaders httpHeaders = new HttpHeaders();
            String string4 = HttpCookies.map2CookieStr(hashMap);
            Logger.println(string4);
            String string5 = ((HttpRequestUtil)object).getContent("https://api.bilibili.com/x/frontend/finger/spi", httpHeaders.getCommonHeaders(), HttpCookies.convertCookies(string4));
            Logger.print(string5);
            String string6 = new JSONObject(string5).getJSONObject("data").getString("b_4");
            hashMap.put("buvid4", string6);
            String string7 = Global.userAgentFingerprint;
            hashMap.put("buvid_fp", string7);
            hashMap.put("fingerprint", string7);
            Matcher matcher = pResolution.matcher(Global.userAgentPayload);
            matcher.find();
            String string8 = String.format("%s-%s", matcher.group(1), matcher.group(2));
            hashMap.put("browser_resolution", string8);
            return HttpCookies.map2CookieStr(hashMap);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return "";
        }
    }

    static String b64Sub2(String string) {
        try {
            String string2 = new String(Base64.getEncoder().encode(string.getBytes("UTF-8")), "UTF-8");
            string2 = string2.substring(0, string2.length() - 2);
            return string2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    static String f114(int n, int n2) {
        int n3 = random.nextInt(114);
        return String.format("[%d,%d,%d]", 2 * n + 2 * n2 + 3 * n3, 4 * n - n2 + n3, n3);
    }

    static String f514(int n, int n2) {
        int n3 = random.nextInt(514);
        return String.format("[%d,%d,%d]", 3 * n + 2 * n2 + n3, 4 * n - 4 * n2 + 2 * n3, n3);
    }

    public static String genDmImgParams() {
        String string = "[]";
        Matcher matcher = pWebglVersion.matcher(Global.userAgentPayload);
        matcher.find();
        String string2 = API.b64Sub2(matcher.group(1).trim());
        Matcher matcher2 = pResolution.matcher(Global.userAgentPayload);
        matcher2.find();
        String string3 = API.f114(Integer.parseInt(matcher2.group(1)), Integer.parseInt(matcher2.group(2)));
        String string4 = API.f514(0, 0);
        String string5 = String.format("{\"ds\":[],\"wh\":%s,\"of\":%s}", string3, string4);
        Matcher matcher3 = pWebglUnRenderer.matcher(Global.userAgentPayload);
        matcher3.find();
        Matcher matcher4 = pWebglUnVendor.matcher(Global.userAgentPayload);
        matcher4.find();
        String string6 = matcher3.group(1).trim() + matcher4.group(1).trim();
        string6 = API.b64Sub2(string6);
        return String.format("&dm_img_list=%s&dm_img_str=%s&dm_img_inter=%s&dm_cover_img_str=%s", string, string2, string5, string6);
    }
}

