dofile(sui:info('uipath') .. 'lunar.lua')

p = print

local function get_month_day(year, mon)
  local days = {31,28,31,30,31,30,31,31,30,31,30,31}
  if mon == 2 and year % 4 == 0 then
    return 29
  else
    return days[mon]
  end
end

local function fillnum(num, c)
    if c == nil then c = '0' end
    return string.sub(c .. num, -2, -1)
end

function draw_cal(year, mon)
  -- draw title
  nav_mon.text = year .. '-' .. fillnum(mon)
  -- draw days
  local mdate_1 = os.time{year=year, month=mon, day=1, hour=0}
  local week = os.date('%w', mdate_1) -- type(week) => string
  local i, j
  week = math.tointeger(week) -- convert to integer
  suilib.print('week' .. week)
  for i = 1,week do
    d['1' .. i].text = ''
  end


  if last_day_elem ~= nil then
     --last_day_elem.style = 'day'
    last_day_elem.textcolor = normal_textcolor
    last_day_elem.bkimage = normal_bk
     last_day_elem = nil
  end

  local day_elem = nil
  i = week + 1;j = 1
  local md = get_month_day(year, mon)
  for k = 1,42 - week do
    if k <= md then
      d[j .. i].text = get_day_text(year, mon, k) -- fillnum(k, ' ')
      if k == cur_day then
        p("today:" .. k)
        day_elem = d[j .. i]
      end
    else
      d[j .. i].text = ''
    end
    i = i + 1
    if i > 7 then i = 1;j = j + 1 end
  end


  if year == cur_year and mon == cur_mon then
    --day_elem.style = 'today'
    day_elem.textcolor = today_textcolor
    day_elem.bkimage = today_bk
    last_day_elem = day_elem
  end

end

d = {}
local function get_elems()
  for i=1,6 do
    for j=1,7 do
      d[i ..j] = sui:find('d' .. i .. j)
    end
  end
  nav_mon = sui:find('nav_mon')
  now_year = sui:find('now_year')
  now_info = sui:find('now_info')
  now_time = sui:find('now_time')
  month_days_area = sui:find('month_days_area')
  local today_attr = sui:find('today_attr')
  today_textcolor = today_attr.textcolor
  p(today_textcolor)
  today_bk = today_attr.bkimage
  normal_textcolor = d['11'].textcolor
  normal_bk = d['11'].bkimage
end

local function update_now_var()
  today = os.time()
  cur_year = math.tointeger(os.date('%Y', today))
  cur_mon = math.tointeger(os.date('%m', today))
  cur_day = math.tointeger(os.date('%d', today))
  str_today = cur_year .. cur_mon .. cur_day
end

local function draw_now_info()
  update_now_var()
  now_info.text = string.format('%d-%d-%d, %%{info_w%s}',
    cur_year, cur_mon, cur_day, os.date('%w', today))
  now_time.text = os.date('%H:%M:%S', today)
end

function UIWindow.OnLoad()
  get_elems()
  draw_now_info()
  lunar_init()
  view_year = cur_year
  view_mon = cur_mon
  last_day_elem = nil -- mark today
  draw_cal(cur_year, cur_mon)
  UI.UpdateText('datetime_settings')
  UI:SetTimer('clocktick_per_second', 1000)
  UIWindow.Inited = 1
end

function UIWindow.OnShow()
  draw_now_info()
  UI:KillTimer('clocktick_per_second')
  UI:SetTimer('clocktick_per_second', 1000)
end

function UIWindow.OnHide()
  UI:KillTimer('clocktick_per_second')
end

UI.OnTimer['clocktick_per_second'] = function(tid)
  draw_now_info()
end

UI.OnClick['pre_mon'] = function()
  view_mon = view_mon - 1
  if view_mon == 0 then
    view_year = view_year - 1
    view_mon = 12
  end
  draw_cal(view_year, view_mon)
end

UI.OnClick['next_mon'] = function()
  view_mon = view_mon + 1
  if view_mon == 13 then
    view_year = view_year + 1
    view_mon = 1
  end
  draw_cal(view_year, view_mon)
end

UI.OnClick['datetime_settings'] = function()
  App:Run("timedate.cpl")
end
