

-- Windows Definition
MB_ICONASTERISK = 64 -- Type for MessageBeep()
SW_SHOWNORMAL = 1

-- Timer
BEEP_TIMER_ID = 1000

nobeep_mode = 0

local last_vol_state_img = ''
local last_ismuted = 1

local function vol_btn_icon(ismuted, init)
  local vol_state_img = "file='snd_mute.ico'"

  if init then
    vol_btn.selected = ismuted
    last_ismuted = ismuted
  end

  if ismuted == 0 then
    local i = math.modf(vol_level / 33)
    i = i + 1
    if i > 3 then i = 3 end
    vol_state_img = "file='snd_" .. i .. ".ico'"
  end

  if vol_state_img ~= last_vol_state_img then
    vol_state.bkimage = vol_state_img
    last_vol_state_img = vol_state_img
  end
end

local function init_elem()
  vol_level = Volume:GetLevel()
  local mute = Volume:IsMuted()
  App:Print(volume_slider)
  volume_slider.value = vol_level
  vol_value.text = vol_level
  vol_level = tonumber(vol_level)

  vol_btn_icon(mute, 1)

  need_beep = 0
  suilib.call('KillTimer', BEEP_TIMER_ID)
  suilib.call('SetTimer', BEEP_TIMER_ID, 500)
end

function onload()
  sui:find('vol_name').text = Volume:GetName()
  vol_value = sui:find('vol_value')
  volume_slider = sui:find('volume_slider')
  App:Print(volume_slider)
  vol_btn = sui:find('vol_btn')
  vol_state = sui:find('vol_state')
  sui:find('sndvol_settings').text = sui:find('sndvol_settings').text

  if App:HasOption('-nobeep') then
    nobeep_mode = 1
  end

  ui_path = sui:jcfg('res_path')
  -- local sd = os.getenv("SystemDrive")
  -- if not File.exists(sd ..'\\Windows\\media\\Windows Background.wav') then
  --   App:Run('xcopy', '"' .. ui_path .. 'Windows Background.wav" "' .. sd ..'\\Windows\\media\\"', 0)
  -- end
  LOADED = 1
  init_elem()
end

function onshow()
  if not LOADED then return end
  init_elem()
end

function onchanged(ctrl, val)
  local ismuted = 1;
  if not LOADED then return end
  if ctrl == 'volume_slider' then
    vol_value.text = val
    vol_level = val
    vol_changed = 1
    if val > 0 then ismuted = 0 end

    if ismuted ~= last_ismuted then
      vol_btn.selected = ismuted
      last_ismuted = ismuted
      Volume:Mute(ismuted)
    end
  elseif ctrl == 'vol_btn' then
    ismuted = vol_btn.selected
    last_ismuted = ismuted
    Volume:Mute(ismuted)
  end
  vol_btn_icon(ismuted)
end

UISTATE_CAPTURED = 64 -- Drag & Drop - ing

function ontimer(id)
  if id == BEEP_TIMER_ID then
    if sui:ishidden() == 1 then -- no need watch the slider change
      suilib.call('KillTimer', BEEP_TIMER_ID)
    end
    if vol_changed == 1 then
      Volume:SetLevel(volume_slider.value)
      if nobeep_mode == 0 and math.band(volume_slider.state, UISTATE_CAPTURED) == 0 then
        -- App:Call('Beep', MB_ICONASTERISK) -- Beep can't work in PE
        App:Call('Play', ui_path .. 'Windows Background.wav', 0)
        vol_changed = 0
      end
    end
  end
end

local function hideme()
  sui:hide()
  suilib.call('KillTimer', BEEP_TIMER_ID)
end

function onclick(ctrl)
  if ctrl == 'sndvol_settings' or ctrl == 'vol_value' then
    hideme()
    App:Run('sndvol.exe', '-m 268439552', SW_SHOWNORMAL)
  elseif ctrl == 'closebtn' then
    hideme()
  end
end
