local shadow = sui:jcfg('shadow') or 'Administrator:admin;\nSYSTEM:;'
local logon_user = sui:jcfg('logon_user') or 'SYSTEM'
local auto_logon_second = sui:jcfg('auto_logon_second') or 5
local logon_blur = sui:jcfg('logon_blur') or '10.0'

CLOCK_TIMER_ID = 1000
AUTO_USER_TIMER_ID = 1001
PASS_TIMER_ID = 1002
LOGON_TIMER_ID = 1003
DOLOGON_TIMER_ID = 1004

UIUPDATE_TIMER_ID = 8000
EXIT_TIMER_ID = 9000

-- local functions
local on_user_click

-- internal variable(s)
local autologon_countdown = auto_logon_second

-- "startup_win":"max"
local function full_screen()
    --sui:moveto(0, 0, Screen:GetX(), Screen:GetY())
end

local function draw_background()
    wallpaper = ''
    local blur = App:GetOption('-blur')
    if blur == nil then blur = '0.0' end

    wallpaper = App:GetOption('-bk')
    if wallpaper == nil then
        wallpaper = Desktop:GetWallpaper()
    end

    local win = sui:find('full_win')
    win.bkimage = "file='" .. wallpaper .. "' blur='" .. blur .. "'"
end

local function draw_now_info()
    local now = os.time()
    now_time.text = os.date('%H:%M:%S', now)
    now_info.text = string.format('%s, %%{info_w%s}', os.date("%Y-%m-%d", now), os.date('%w', now))

end

local function blur_background()
  local win = sui:find('full_win')
  -- blur trick
  win.bkimage = "file='" .. wallpaper .. " ' blur='" .. logon_blur .. "'"
end


local function draw_autologon_info()
    if autologon_countdown < 0 then
        return
    elseif autologon_countdown > 0 then
        local msg = string.gsub(autologon_info_message, '$user', logon_user)
        msg = string.gsub(msg, '$countdown', autologon_countdown)
        progress_text.text = msg
        autologon_countdown = autologon_countdown - 1
    elseif autologon_countdown == 0 then
      progress_text.text = ''
      autologon_countdown = autologon_countdown - 1
    end
end

local function show_pass_input_frame(internal)
    text_username.text = logon_user
    userlist_frame.visible = 0
    pass_input_frame.visible = 1
    if internal == nil then internal = 500 end
    suilib.call('SetTimer', PASS_TIMER_ID, internal)
end

function onload()
    App:Call('UserLogonInit')
    full_screen()
    draw_background()
    autologon_info_message = sui:i18n('will autologon with the $user account in $countdown second(s)')

    if App:GetOption('-user') then
        logon_user = App:GetOption('-user')
        auto_logon_second = 0
    end
    text_username = sui:find('username')
    text_password = sui:find('password')
    userlist_frame = sui:find('userlist_frame')
    pass_input_frame = sui:find('pass_input_frame')
    progress_text = sui:find('progress_text')

    now_time = sui:find('now_time')
    now_info = sui:find('now_info')
    draw_now_info()
    suilib.call('SetTimer',CLOCK_TIMER_ID, 1000)

    _G.progress_text = progress_text

    if logon_user ~= '' and auto_logon_second == 0 then
      autologon_countdown = -1
      on_user_click(logon_user, 2000)
    else
      userlist_frame.visible = 1
      if logon_user ~= '' and auto_logon_second > 0 then
        draw_autologon_info()
        suilib.call('SetTimer', AUTO_USER_TIMER_ID, auto_logon_second * 1000)
      end
    end
end

local function checkpass()
  local u = text_username.text
  local p = text_password.text
  if string.find(shadow, u .. ':' .. p .. ';') then return 0 end
  return 1
end

local function hide_others_logo(username)
  local other = 'SYSTEM'
  if other == username then other = 'Administrator' end
  local user_logo = sui:find('User_' .. other)
  if user_logo then user_logo.visible = 0 end
end

local function call_logon_lua()
  local logon_script = os.getenv('logon_script')
  _G.caller = 'UI_Logon'
  _G.logon_user = logon_user
  dofile(logon_script)
end

local function regist_logon_coroutine()
  cor_logon_lua = coroutine.create(call_logon_lua)
  suilib.call('SetTimer', DOLOGON_TIMER_ID, 500)
  suilib.call('SetTimer', UIUPDATE_TIMER_ID, 200)
end

local function do_logon()
  pass_input_frame.visible = 0
  userlist_frame.visible = 1
  hide_others_logo(logon_user)
  local user_logo = sui:find('User_' .. logon_user)
  if user_logo then
    user_logo.mouse = 'false'
  end

  if logon_user == 'SYSTEM' then
    App:Call('exitcode', 1)
  else
    App:Call('exitcode', 2)
  end

  suilib.call('KillTimer', CLOCK_TIMER_ID)
  now_time.visible = 0
  now_info.visible = 0

  progress_text.text = '%{Welcome to Windows ...}'

  if os.getenv('logon_script') ~= nil then
    regist_logon_coroutine()
  else
    suilib.call('SetTimer', EXIT_TIMER_ID, 1000)
  end
end

function on_user_click(username, internal)
  suilib.call('KillTimer', AUTO_USER_TIMER_ID)
  autologon_countdown = -1
  logon_user = username

  -- hide logon info label
  sui:find('logoninfo').visible = 0

  blur_background()
  -- skip 'show_pass_input_frame' if empty password
  if string.find(shadow, username .. ':;') then
    suilib.call('SetTimer', LOGON_TIMER_ID, 500)
  else
    show_pass_input_frame(internal)
  end
end

local function on_logon_click()
  if (checkpass() == 0) then
      suilib.call('SetTimer', LOGON_TIMER_ID, 100)
  end
end


local function power_helper(wu_param, sd_param)
  local sd = os.getenv("SystemDrive")
  if File.Exists(sd ..'\\Windows\\System32\\Wpeutil.exe') then
    App:Run('wpeutil.exe', wu_param, 0) -- SW_HIDE(0)
    sui:close()
    return 0
  elseif File.Exists(sd ..'\\Windows\\System32\\shutdown.exe') then
    App:Run('shutdown.exe', sd_param .. ' -t 0')
    sui:close()
    return 0
  end
  return 1
end

local function reboot()
    return power_helper('Reboot', '-r')
end

local function shutdown()
    return power_helper('Shutdown', '-s')
end

function onclick(ctrl)
  if ctrl == 'User_SYSTEM' then
    on_user_click('SYSTEM')
  elseif ctrl == 'User_Administrator' then
    on_user_click('Administrator')
  elseif ctrl == 'logon' then
    on_logon_click()
  elseif ctrl == 'restart' then
    reboot()
  elseif ctrl == 'shutdown' then
    shutdown()
  end
end

function onreturn(ctrl)
  if ctrl == 'username' or ctrl == 'password' then
    sui:focus('logon')
    sui:click('logon')
  end
end

function ontimer(id)
  if id == AUTO_USER_TIMER_ID then
    on_user_click(logon_user)
  elseif id == PASS_TIMER_ID then
    sui:focus('password')
    suilib.call('KillTimer', PASS_TIMER_ID)
  elseif  id == LOGON_TIMER_ID then
    suilib.call('KillTimer', LOGON_TIMER_ID)
    do_logon()
  elseif id == DOLOGON_TIMER_ID then
    suilib.call('KillTimer', DOLOGON_TIMER_ID)
    coroutine.resume(cor_logon_lua)
  elseif id == UIUPDATE_TIMER_ID then
    if coroutine.status(cor_logon_lua) == 'dead' then
      sui:close()
    end
    coroutine.resume(cor_logon_lua)
  elseif id == CLOCK_TIMER_ID then
    draw_now_info()
    draw_autologon_info()
  elseif id == EXIT_TIMER_ID then
    sui:close()
  end
end

function onmessage(msg, wparam, lparam)
  if msg == 0x7E then -- WM_DISPLAYCHANGE
    full_screen()
    return 1
  end
  return 0
end
