TOGGLE = false

binded_app = {}

local function update_date_cell()
  local today = os.time()
  label_weekname.text = string.format('%%{info_w%s}', os.date('%w', today))
  label_date.text = string.format('%d', os.date('%d', today))
end

function onload()
  label_weekname = sui:find('label_weekname')
  label_date = sui:find('label_date')
  update_date_cell() -- update in onshow() event only, maybe good if updating with a TIMER
  local param = App.CmdLine
  suilib.print(param)
  if param and string.find(param, '-custom') then
    local sd = os.getenv("SystemDrive")
    bind_app('app11', 'MS Paint', sd .. '\\Windows\\System32\\mspaint.exe', '', '<APP>,0', 100, 100)
    bind_app('app12', 'MS Explorer', sd .. [[\Windows\explorer.exe]], '', '<APP>', 100, 100)
    bind_app('app13', 'Control', 'control.exe', '', sd .. '\\Windows\\System32\\shell32.dll,-22', 100, 100)
    bind_app('app21', 'Command Prompt', sd .. [[\Windows\System32\cmd.exe]], '', '<APP>', 200 + 10, 100)
    bind_app('app22', 'Regedit', 'regedit.exe', '', sd .. '\\Windows\\System32\\shell32.dll,-167', 100, 100)
    hide_cell('app23')
    local area = sui:find('custom_app_area')
    suilib.print(area.visible)
    area.visible = 1
  end
end

function onshow()
  if TOGGLE then
    sui:hide()
    TOGGLE = false
    return
  else
    TOGGLE = true
  end
  if label_weekname == nil then return end
  update_date_cell()
end

function onclick(ctrl)
  if ctrl == "firefox" then
    App:Run("C:\\Program Files (x86)\\Mozilla Firefox\\firefox.exe")
  elseif ctrl == "calc" then
    App:Run("calc.exe")
  elseif ctrl == "notepad" then
    App:Run("notepad.exe")
  elseif ctrl == "notepad_paramter" then
    App:Run("notepad.exe", "C:\\setup.log")
  elseif binded_app[ctrl] ~= nil then
    local app_info = binded_app[ctrl]
    App:Run(app_info[1], app_info[2])
  end
end

-- ===================================================================================================
-- bind_app('app11', 'MS Paint', 'C:\\Windows\\System32\\mspaint.exe', '', '<APP>,0', 100, 100)
function bind_app(name, text, cmd, param, icon, width, height)
  local app_info = {cmd, param} -- app_info[1] - command, app_info[2] --- paramaters
  binded_app[name] = app_info -- insert to binded_app table
  local app_cell = sui:find(name)
  if not app_cell then return end
  app_cell.width = width
  app_cell.height = height
  app_cell.text = text
  icon = icon:gsub('<APP>', cmd)
  app_cell.bkimage = string.format('file=\'%s\' dest=\'%d,%d,32,32\'', icon, ((width - 32) / 2), ((height - 32) / 2))
end

function  hide_cell(name)
  local cell = sui:find(name)
  if cell then cell.visible = 0 end
end