dofile(sui:info('uipath') .. 'lunar.lua')

local function get_month_day(year, mon)
  local days = {31,28,31,30,31,30,31,31,30,31,30,31}
  if mon == 2 and year % 4 == 0 then
    return 29
  else
    return days[mon]
  end
end

local function fillnum(num, c)
    if c == nil then c = '0' end
    return string.sub(c .. num, -2, -1)
end

function draw_cal(year, mon)
  -- draw title
  nav_mon.text = year .. '-' .. fillnum(mon)
  -- draw days
  local mdate_1 = os.time{year=year, month=mon, day=1, hour=0}
  local week = os.date('%w', mdate_1) -- type(week) => string
  local i, j
  week = math.tointeger(week) -- convert to integer
  suilib.print('week' .. week)
  for i = 1,week do
    d['1' .. i].text = ''
  end


  if last_day_elem ~= nil then
     --last_day_elem.style = 'day'
    last_day_elem.textcolor = normal_textcolor
    last_day_elem.bkimage = normal_bk
     last_day_elem = nil
  end

  local day_elem = nil
  i = week + 1;j = 1
  local md = get_month_day(year, mon)
  for k = 1,42 - week do
    if k <= md then
      d[j .. i].text = get_day_text(year, mon, k) -- fillnum(k, ' ')
      if k == cur_day then
        p("today:" .. k)
        day_elem = d[j .. i]
      end
    else
      d[j .. i].text = ''
    end
    i = i + 1
    if i > 7 then i = 1;j = j + 1 end
  end


  if year == cur_year and mon == cur_mon then
    --day_elem.style = 'today'
    day_elem.textcolor = today_textcolor
    day_elem.bkimage = today_bk
    last_day_elem = day_elem
  end

end

d = {}
local function get_elems()
  for i=1,6 do
    for j=1,7 do
      d[i ..j] = sui:find('d' .. i .. j)
    end
  end
  nav_mon = sui:find('nav_mon')
  now_year = sui:find('now_year')
  now_info = sui:find('now_info')
  now_time = sui:find('now_time')
  month_days_area = sui:find('month_days_area')
  local today_attr = sui:find('today_attr')
  today_textcolor = today_attr.textcolor
  p(today_textcolor)
  today_bk = today_attr.bkimage
  normal_textcolor = d['11'].textcolor
  normal_bk = d['11'].bkimage
end

local function var_init()
  today = os.time()
  cur_year = math.tointeger(os.date('%Y', today))
  cur_mon = math.tointeger(os.date('%m', today))
  cur_day = math.tointeger(os.date('%d', today))
  str_today = cur_year .. cur_mon .. cur_day
end

local function draw_now_info()
    now_info.text = string.format('%d-%d-%d, %%{info_w%s}',
        cur_year, cur_mon, cur_day, os.date('%w', today))
    now_time.text = os.date('%H:%M:%S', today)
end

local function set_res(name, id, file)
  file = file or 'systemcpl.dll'
  sui:find(name).text = str.format('#{@%s,%s}', file, id)
end

local function set_text(name, text)
  sui:find(name).text = text
end

local function systeminfo_init()


  -- hostname
  local computername = Reg:Read([[HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ComputerName\ComputerName]]
        , 'ComputerName')

  set_text('host_text', '<b>' .. computername .. '</b>')

  -- CPU
  local cpu_t = os.info('CPU')

  if cpu_t then -- need Administrator's right privilege to read the HKLM items
    set_text('cpu_text', cpu_t['name'])
  end

  -- RAM
  -- local mem_format = mui_str('systemcpl.dll', 45)
  local mem_format = suilib.call('resstr', '#{@systemcpl.dll,45}')

  local mem_t = os.info('MEM')
  local total_phys = str.format("%.2f GB", mem_t['total_gb'])
  
  local avail_phys = mem_t['total'] / 0x40000000 -- 1024*1024*1024
  avail_phys = str.format("%.2f GB", avail_phys)

  local now_avail = str.format("#{@shell32.dll,9307} %.2f GB", mem_t['avail_gb'])
  local mem_s = str.format(mem_format, total_phys, avail_phys)
  set_text('mem_text', mem_s .. '    ' .. now_avail)

  -- BIOS
  local bios_mf = Reg:Read([[HKEY_LOCAL_MACHINE\HARDWARE\DESCRIPTION\System\BIOS]], "SystemManufacturer")
  local bios_pn = Reg:Read([[HKEY_LOCAL_MACHINE\HARDWARE\DESCRIPTION\System\BIOS]], "SystemProductName")
  if bios_mf == nil then bios_mf = 'N/A' end
  if bios_pn == nil then bios_pn = 'N/A' end
  set_text('bios_text', bios_mf .. " - " .. bios_pn)

  -- FirmwareType
  set_text('firmwaretype_text', os.info('FirmwareType'))

end

local function elem_init()
  systeminfo_init()
end

function UIWindow.OnLoad()
  get_elems()
  var_init()
  elem_init()
  lunar_init()
  view_year = cur_year
  view_mon = cur_mon
  draw_now_info()
  last_day_elem = nil -- mark today
  draw_cal(cur_year, cur_mon)
  UI:KillTimer('clocktick_per_second')
  UI:SetTimer('clocktick_per_second', 1000)
  UIWindow.Inited = 1
end

function UIWindow.OnShow()
  UI:SetTimer('adjust_win_position', 200)
  UI:KillTimer('clocktick_per_second')
  UI:SetTimer('clocktick_per_second', 1000)
  brightness_slider = sui:find('brightness_slider')
  brightness_val = Screen:Get('brightness')
  brightness_slider.value = brightness_val
end

function UIWindow.OnHide()
  UI:KillTimer('clocktick_per_second')
end

UI.OnTimer['clocktick_per_second'] = function(tid)
  var_init()
  draw_now_info()
end

UI.OnTimer['adjust_win_position'] = function(tid)
  UI:KillTimer('adjust_win_position')
  local w, h = sui:info('wh')
  sui:moveto(Screen:GetDpiX() - w - 1, 0, w, Screen:GetDpiY())
  print("adjust_win_position")
end

UI.OnClick['pre_mon'] = function()
  view_mon = view_mon - 1
  if view_mon == 0 then
    view_year = view_year - 1
    view_mon = 12
  end
  draw_cal(view_year, view_mon)
end

UI.OnClick['next_mon'] = function()
  view_mon = view_mon + 1
  if view_mon == 13 then
    view_year = view_year + 1
    view_mon = 1
  end
  draw_cal(view_year, view_mon)
end

UI.OnClick['now_time'] = function()
  App:Run("timedate.cpl")
end

UI.OnChanged['brightness_slider'] = function(val, ctrl)
  App:Print(ctrl .. ':' .. val)
  brightness_val = val
  UI:SetTimer('set_brightness_timer', 200)
end

UI.OnTimer['set_brightness_timer'] = function(tid)
  UI:KillTimer('set_brightness_timer')
  local val = math.floor(brightness_val / 10 + 0.5) * 10;
  Screen:Set('brightness', val)
end

