"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SessionDetachReason = exports.Session = void 0;
const portal_membership_1 = require("./portal_membership");
const script_1 = require("./script");
const signals_1 = require("./signals");
const util_1 = require("util");
class Session {
    constructor(impl) {
        this.impl = impl;
        const { signals } = impl;
        this.detached = new signals_1.Signal(signals, "detached");
    }
    get pid() {
        return this.impl.pid;
    }
    get persistTimeout() {
        return this.impl.persistTimeout;
    }
    get isDetached() {
        return this.impl.isDetached;
    }
    detach(cancellable) {
        return this.impl.detach(cancellable);
    }
    resume(cancellable) {
        return this.impl.resume(cancellable);
    }
    enableChildGating(cancellable) {
        return this.impl.enableChildGating(cancellable);
    }
    disableChildGating(cancellable) {
        return this.impl.disableChildGating(cancellable);
    }
    async createScript(source, options = {}, cancellable) {
        const { name = null, snapshot = null, runtime = null } = options;
        return new script_1.Script(await this.impl.createScript(source, name, snapshot, runtime, cancellable));
    }
    async createScriptFromBytes(bytes, options = {}, cancellable) {
        const { name = null, snapshot = null, runtime = null } = options;
        return new script_1.Script(await this.impl.createScriptFromBytes(bytes, name, snapshot, runtime, cancellable));
    }
    compileScript(source, options = {}, cancellable) {
        const { name = null, runtime = null } = options;
        return this.impl.compileScript(source, name, runtime, cancellable);
    }
    snapshotScript(embedScript, options = {}, cancellable) {
        const { warmupScript = null, runtime = null } = options;
        return this.impl.snapshotScript(embedScript, warmupScript, runtime, cancellable);
    }
    setupPeerConnection(options = {}, cancellable) {
        const { stunServer = null, relays = [], } = options;
        return this.impl.setupPeerConnection(stunServer, relays, cancellable);
    }
    async joinPortal(address, options = {}, cancellable) {
        const { certificate = null, token = null, acl = null, } = options;
        return new portal_membership_1.PortalMembership(await this.impl.joinPortal(address, certificate, token, acl, cancellable));
    }
    [util_1.inspect.custom](depth, options) {
        return "Session " + (0, util_1.inspect)({
            pid: this.pid
        }, options);
    }
}
exports.Session = Session;
var SessionDetachReason;
(function (SessionDetachReason) {
    SessionDetachReason["ApplicationRequested"] = "application-requested";
    SessionDetachReason["ProcessReplaced"] = "process-replaced";
    SessionDetachReason["ProcessTerminated"] = "process-terminated";
    SessionDetachReason["ConnectionTerminated"] = "connection-terminated";
    SessionDetachReason["DeviceLost"] = "device-lost";
})(SessionDetachReason = exports.SessionDetachReason || (exports.SessionDetachReason = {}));
