/// <reference types="node" />
/// <reference types="node" />
import { Cancellable } from "./cancellable";
import { Signal } from "./signals";
import { inspect } from "util";
export declare class Script {
    private impl;
    destroyed: Signal<ScriptDestroyedHandler>;
    message: Signal<ScriptMessageHandler>;
    private exportsProxy;
    private logHandlerImpl;
    constructor(impl: any);
    get isDestroyed(): boolean;
    get exports(): ScriptExports;
    get logHandler(): ScriptLogHandler;
    set logHandler(handler: ScriptLogHandler);
    get defaultLogHandler(): ScriptLogHandler;
    load(cancellable?: Cancellable): Promise<void>;
    unload(cancellable?: Cancellable): Promise<void>;
    eternalize(cancellable?: Cancellable): Promise<void>;
    post(message: any, data?: Buffer | null): void;
    enableDebugger(options?: EnableDebuggerOptions, cancellable?: Cancellable): Promise<void>;
    disableDebugger(cancellable?: Cancellable): Promise<void>;
    [inspect.custom](depth: any, options: any): string;
}
export interface ScriptOptions {
    name?: string;
    snapshot?: Buffer;
    runtime?: ScriptRuntime;
}
export interface SnapshotOptions {
    warmupScript?: string;
    runtime?: ScriptRuntime;
}
export declare enum ScriptRuntime {
    Default = "default",
    QJS = "qjs",
    V8 = "v8"
}
export declare type ScriptDestroyedHandler = () => void;
export declare type ScriptMessageHandler = (message: Message, data: Buffer | null) => void;
export declare type ScriptLogHandler = (level: LogLevel, text: string) => void;
export declare type Message = SendMessage | ErrorMessage;
export declare enum MessageType {
    Send = "send",
    Error = "error"
}
export interface SendMessage {
    type: MessageType.Send;
    payload: any;
}
export interface ErrorMessage {
    type: MessageType.Error;
    description: string;
    stack?: string;
    fileName?: string;
    lineNumber?: number;
    columnNumber?: number;
}
export interface ScriptExports {
    [name: string]: (...args: any[]) => Promise<any>;
}
export declare enum LogLevel {
    Info = "info",
    Warning = "warning",
    Error = "error"
}
export interface EnableDebuggerOptions {
    port?: number;
}
