"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RelayKind = exports.Relay = void 0;
const native_1 = require("./native");
const util_1 = require("util");
class Relay {
    constructor({ address, username, password, kind }) {
        this.impl = new native_1.binding.Relay(address, username, password, kind);
    }
    get address() {
        return this.impl.address;
    }
    get username() {
        return this.impl.username;
    }
    get password() {
        return this.impl.password;
    }
    get kind() {
        return this.impl.kind;
    }
    [util_1.inspect.custom](depth, options) {
        return (0, util_1.inspect)(this.impl, Object.assign(Object.assign({}, options), { depth }));
    }
}
exports.Relay = Relay;
var RelayKind;
(function (RelayKind) {
    RelayKind["TurnUDP"] = "turn-udp";
    RelayKind["TurnTCP"] = "turn-tcp";
    RelayKind["TurnTLS"] = "turn-tls";
})(RelayKind = exports.RelayKind || (exports.RelayKind = {}));
