/// <reference types="node" />
import { inspect } from "util";
export declare class Relay {
    private impl;
    constructor({ address, username, password, kind }: RelayProperties);
    get address(): string;
    get username(): string;
    get password(): string;
    get kind(): RelayKind;
    [inspect.custom](depth: any, options: any): string;
}
export interface RelayProperties {
    address: string;
    username: string;
    password: string;
    kind: RelayKind;
}
export declare enum RelayKind {
    TurnUDP = "turn-udp",
    TurnTCP = "turn-tcp",
    TurnTLS = "turn-tls"
}
