/// <reference types="node" />
import * as applicationModule from "./application";
import * as authenticationModule from "./authentication";
import * as busModule from "./bus";
import * as cancellableModule from "./cancellable";
import * as childModule from "./child";
import * as crashModule from "./crash";
import * as deviceManagerModule from "./device_manager";
import * as deviceModule from "./device";
import * as endpointParametersModule from "./endpoint_parameters";
import * as iconModule from "./icon";
import * as iostreamModule from "./iostream";
import * as portalMembershipModule from "./portal_membership";
import * as portalServiceModule from "./portal_service";
import * as processModule from "./process";
import * as relayModule from "./relay";
import * as scriptModule from "./script";
import * as sessionModule from "./session";
import * as socketAddressModule from "./socket_address";
import * as spawnModule from "./spawn";
import * as systemParametersModule from "./system_parameters";
export declare type DeviceManager = deviceManagerModule.DeviceManager;
export declare const DeviceManager: typeof deviceManagerModule.DeviceManager;
export declare type RemoteDeviceOptions = deviceManagerModule.RemoteDeviceOptions;
export declare type DeviceAddedHandler = deviceManagerModule.DeviceAddedHandler;
export declare type DeviceRemovedHandler = deviceManagerModule.DeviceRemovedHandler;
export declare type DevicesChangedHandler = deviceManagerModule.DevicesChangedHandler;
export declare type Device = deviceModule.Device;
export declare const Device: typeof deviceModule.Device;
export declare type ProcessID = deviceModule.ProcessID;
export declare type ProcessName = deviceModule.ProcessName;
export declare type InjecteeID = deviceModule.InjecteeID;
export declare type FileDescriptor = deviceModule.FileDescriptor;
export declare type SpawnAddedHandler = deviceModule.SpawnAddedHandler;
export declare type SpawnRemovedHandler = deviceModule.SpawnRemovedHandler;
export declare type ChildAddedHandler = deviceModule.ChildAddedHandler;
export declare type ChildRemovedHandler = deviceModule.ChildRemovedHandler;
export declare type OutputHandler = deviceModule.OutputHandler;
export declare type UninjectedHandler = deviceModule.UninjectedHandler;
export declare type DeviceLostHandler = deviceModule.DeviceLostHandler;
export declare type DeviceType = deviceModule.DeviceType;
export declare const DeviceType: typeof deviceModule.DeviceType;
export declare type FrontmostQueryOptions = deviceModule.FrontmostQueryOptions;
export declare type ApplicationQueryOptions = deviceModule.ApplicationQueryOptions;
export declare type ProcessQueryOptions = deviceModule.ProcessQueryOptions;
export declare type ProcessMatchOptions = deviceModule.ProcessMatchOptions;
export declare type Scope = deviceModule.Scope;
export declare const Scope: typeof deviceModule.Scope;
export declare type SpawnOptions = deviceModule.SpawnOptions;
export declare type Stdio = deviceModule.Stdio;
export declare const Stdio: typeof deviceModule.Stdio;
export declare type TargetProcess = deviceModule.TargetProcess;
export declare type SessionOptions = deviceModule.SessionOptions;
export declare type Realm = deviceModule.Realm;
export declare const Realm: typeof deviceModule.Realm;
export declare type SystemParameters = systemParametersModule.SystemParameters;
export declare type SystemInterface = systemParametersModule.SystemInterface;
export declare type NetworkInterface = systemParametersModule.NetworkInterface;
export declare type CellularInterface = systemParametersModule.CellularInterface;
export declare type Session = sessionModule.Session;
export declare const Session: typeof sessionModule.Session;
export declare type SessionDetachedHandler = sessionModule.SessionDetachedHandler;
export declare type SessionDetachReason = sessionModule.SessionDetachReason;
export declare const SessionDetachReason: typeof sessionModule.SessionDetachReason;
export declare type PeerOptions = sessionModule.PeerOptions;
export declare type PortalOptions = sessionModule.PortalOptions;
export declare type Script = scriptModule.Script;
export declare const Script: typeof scriptModule.Script;
export declare type ScriptOptions = scriptModule.ScriptOptions;
export declare type SnapshotOptions = scriptModule.SnapshotOptions;
export declare type ScriptRuntime = scriptModule.ScriptRuntime;
export declare const ScriptRuntime: typeof scriptModule.ScriptRuntime;
export declare type ScriptDestroyedHandler = scriptModule.ScriptDestroyedHandler;
export declare type ScriptMessageHandler = scriptModule.ScriptMessageHandler;
export declare type ScriptLogHandler = scriptModule.ScriptLogHandler;
export declare type Message = scriptModule.Message;
export declare type MessageType = scriptModule.MessageType;
export declare const MessageType: typeof scriptModule.MessageType;
export declare type SendMessage = scriptModule.SendMessage;
export declare type ErrorMessage = scriptModule.ErrorMessage;
export declare type ScriptExports = scriptModule.ScriptExports;
export declare type LogLevel = scriptModule.LogLevel;
export declare const LogLevel: typeof scriptModule.LogLevel;
export declare type EnableDebuggerOptions = scriptModule.EnableDebuggerOptions;
export declare type Relay = relayModule.Relay;
export declare const Relay: typeof relayModule.Relay;
export declare type RelayProperties = relayModule.RelayProperties;
export declare type RelayKind = relayModule.RelayKind;
export declare const RelayKind: typeof relayModule.RelayKind;
export declare type PortalMembership = portalMembershipModule.PortalMembership;
export declare const PortalMembership: typeof portalMembershipModule.PortalMembership;
export declare type PortalService = portalServiceModule.PortalService;
export declare const PortalService: typeof portalServiceModule.PortalService;
export declare type PortalServiceOptions = portalServiceModule.PortalServiceOptions;
export declare type PortalConnectionId = portalServiceModule.PortalConnectionId;
export declare type PortalConnectionTag = portalServiceModule.PortalConnectionTag;
export declare type PortalNodeConnectedHandler = portalServiceModule.PortalNodeConnectedHandler;
export declare type PortalNodeJoinedHandler = portalServiceModule.PortalNodeJoinedHandler;
export declare type PortalNodeLeftHandler = portalServiceModule.PortalNodeLeftHandler;
export declare type PortalNodeDisconnectedHandler = portalServiceModule.PortalNodeDisconnectedHandler;
export declare type PortalControllerConnectedHandler = portalServiceModule.PortalControllerConnectedHandler;
export declare type PortalControllerDisconnectedHandler = portalServiceModule.PortalControllerDisconnectedHandler;
export declare type PortalAuthenticatedHandler = portalServiceModule.PortalAuthenticatedHandler;
export declare type PortalSubscribeHandler = portalServiceModule.PortalSubscribeHandler;
export declare type PortalMessageHandler = portalServiceModule.PortalMessageHandler;
export declare type EndpointParameters = endpointParametersModule.EndpointParameters;
export declare const EndpointParameters: typeof endpointParametersModule.EndpointParameters;
export declare type EndpointParametersSubset = endpointParametersModule.EndpointParametersSubset;
export declare type AuthenticationScheme = endpointParametersModule.AuthenticationScheme;
export declare type TokenAuthenticationScheme = endpointParametersModule.TokenAuthenticationScheme;
export declare type CallbackAuthenticationScheme = endpointParametersModule.CallbackAuthenticationScheme;
export declare type AuthenticationCallback = endpointParametersModule.AuthenticationCallback;
export declare type AuthenticatedSessionInfo = authenticationModule.AuthenticatedSessionInfo;
export declare type IOStream = iostreamModule.IOStream;
export declare const IOStream: typeof iostreamModule.IOStream;
export declare type Cancellable = cancellableModule.Cancellable;
export declare const Cancellable: typeof cancellableModule.Cancellable;
export declare type Application = applicationModule.Application;
export declare type ApplicationParameters = applicationModule.ApplicationParameters;
export declare type Process = processModule.Process;
export declare type ProcessParameters = processModule.ProcessParameters;
export declare type Spawn = spawnModule.Spawn;
export declare type Child = childModule.Child;
export declare type ChildOrigin = childModule.ChildOrigin;
export declare const ChildOrigin: typeof childModule.ChildOrigin;
export declare type Crash = crashModule.Crash;
export declare type CrashParameters = crashModule.CrashParameters;
export declare type Icon = iconModule.Icon;
export declare type RGBAIcon = iconModule.RGBAIcon;
export declare type PNGIcon = iconModule.PNGIcon;
export declare type Bus = busModule.Bus;
export declare const Bus: typeof busModule.Bus;
export declare type BusDetachedHandler = busModule.BusDetachedHandler;
export declare type BusMessageHandler = busModule.BusMessageHandler;
export declare type SocketAddress = socketAddressModule.SocketAddress;
export declare type IPV4SocketAddress = socketAddressModule.IPV4SocketAddress;
export declare type IPV6SocketAddress = socketAddressModule.IPV6SocketAddress;
export declare type AnonymousUnixSocketAddress = socketAddressModule.AnonymousUnixSocketAddress;
export declare type PathUnixSocketAddress = socketAddressModule.PathUnixSocketAddress;
export declare type AbstractUnixSocketAddress = socketAddressModule.AbstractUnixSocketAddress;
export declare function querySystemParameters(cancellable?: Cancellable): Promise<SystemParameters>;
export declare function spawn(program: string | string[], options?: SpawnOptions, cancellable?: Cancellable): Promise<number>;
export declare function resume(target: number | string, cancellable?: Cancellable): Promise<void>;
export declare function kill(target: number | string, cancellable?: Cancellable): Promise<void>;
export declare function attach(target: TargetProcess, options?: SessionOptions, cancellable?: Cancellable): Promise<Session>;
export declare function injectLibraryFile(target: number | string, path: string, entrypoint: string, data: string, cancellable?: Cancellable): Promise<number>;
export declare function injectLibraryBlob(target: number | string, blob: Buffer, entrypoint: string, data: string, cancellable?: Cancellable): Promise<number>;
export declare function enumerateDevices(cancellable?: Cancellable): Promise<Device[]>;
export declare function getDeviceManager(): DeviceManager;
export declare function getLocalDevice(cancellable?: Cancellable): Promise<Device>;
export declare function getRemoteDevice(cancellable?: Cancellable): Promise<Device>;
export declare function getUsbDevice(options?: GetDeviceOptions, cancellable?: Cancellable): Promise<Device>;
export declare function getDevice(id: string, options?: GetDeviceOptions, cancellable?: Cancellable): Promise<Device>;
export interface GetDeviceOptions {
    timeout?: number | null;
}
