/// <reference types="node" />
import { Cancellable } from "./cancellable";
import { Device } from "./device";
import { Signal } from "./signals";
import { inspect } from "util";
export declare class DeviceManager {
    private impl;
    added: Signal<DeviceAddedHandler>;
    removed: Signal<DeviceRemovedHandler>;
    changed: Signal<DevicesChangedHandler>;
    constructor();
    enumerateDevices(cancellable?: Cancellable): Promise<Device[]>;
    addRemoteDevice(address: string, options?: RemoteDeviceOptions, cancellable?: Cancellable): Promise<Device>;
    removeRemoteDevice(address: string, cancellable?: Cancellable): Promise<void>;
    [inspect.custom](): string;
}
export interface RemoteDeviceOptions {
    certificate?: string;
    origin?: string;
    token?: string;
    keepaliveInterval?: number;
}
export declare type DeviceAddedHandler = (device: Device) => void;
export declare type DeviceRemovedHandler = (device: Device) => void;
export declare type DevicesChangedHandler = () => void;
