/// <reference types="node" />
/// <reference types="node" />
import { Application } from "./application";
import { Bus } from "./bus";
import { Cancellable } from "./cancellable";
import { Child } from "./child";
import { Crash } from "./crash";
import { Icon } from "./icon";
import { IOStream } from "./iostream";
import { Process } from "./process";
import { Session } from "./session";
import { Signal } from "./signals";
import { Spawn } from "./spawn";
import { SystemParameters } from "./system_parameters";
import { inspect } from "util";
export declare class Device {
    private impl;
    spawnAdded: Signal<SpawnAddedHandler>;
    spawnRemoved: Signal<SpawnRemovedHandler>;
    childAdded: Signal<ChildAddedHandler>;
    childRemoved: Signal<ChildRemovedHandler>;
    processCrashed: Signal<ProcessCrashedHandler>;
    output: Signal<OutputHandler>;
    uninjected: Signal<UninjectedHandler>;
    lost: Signal<DeviceLostHandler>;
    bus: Bus;
    constructor(impl: any);
    get id(): string;
    get name(): string;
    get icon(): Icon | null;
    get type(): DeviceType;
    get isLost(): boolean;
    querySystemParameters(cancellable?: Cancellable): Promise<SystemParameters>;
    getFrontmostApplication(options?: FrontmostQueryOptions, cancellable?: Cancellable): Promise<Application | null>;
    enumerateApplications(options?: ApplicationQueryOptions, cancellable?: Cancellable): Promise<Application[]>;
    enumerateProcesses(options?: ProcessQueryOptions, cancellable?: Cancellable): Promise<Process[]>;
    getProcess(name: string, options?: ProcessMatchOptions, cancellable?: Cancellable): Promise<Process>;
    enableSpawnGating(cancellable?: Cancellable): Promise<void>;
    disableSpawnGating(cancellable?: Cancellable): Promise<void>;
    enumeratePendingSpawn(cancellable?: Cancellable): Promise<Spawn[]>;
    enumeratePendingChildren(cancellable?: Cancellable): Promise<Child[]>;
    spawn(program: string | string[], options?: SpawnOptions, cancellable?: Cancellable): Promise<ProcessID>;
    input(target: TargetProcess, data: Buffer, cancellable?: Cancellable): Promise<void>;
    resume(target: TargetProcess, cancellable?: Cancellable): Promise<void>;
    kill(target: TargetProcess, cancellable?: Cancellable): Promise<void>;
    attach(target: TargetProcess, options?: SessionOptions, cancellable?: Cancellable): Promise<Session>;
    injectLibraryFile(target: TargetProcess, path: string, entrypoint: string, data: string, cancellable?: Cancellable): Promise<InjecteeID>;
    injectLibraryBlob(target: TargetProcess, blob: Buffer, entrypoint: string, data: string, cancellable?: Cancellable): Promise<InjecteeID>;
    openChannel(address: string, cancellable?: Cancellable): Promise<IOStream>;
    private getPid;
    [inspect.custom](depth: any, options: any): string;
}
export declare type ProcessID = number;
export declare type ProcessName = string;
export declare type InjecteeID = number;
export declare type FileDescriptor = number;
export declare type SpawnAddedHandler = (spawn: Spawn) => void;
export declare type SpawnRemovedHandler = (spawn: Spawn) => void;
export declare type ChildAddedHandler = (child: Child) => void;
export declare type ChildRemovedHandler = (child: Child) => void;
export declare type ProcessCrashedHandler = (crash: Crash) => void;
export declare type OutputHandler = (pid: ProcessID, fd: FileDescriptor, data: Buffer) => void;
export declare type UninjectedHandler = (id: InjecteeID) => void;
export declare type DeviceLostHandler = () => void;
export declare enum DeviceType {
    Local = "local",
    Remote = "remote",
    Usb = "usb"
}
export interface FrontmostQueryOptions {
    /**
     * How much data to collect about the frontmost application. The default is `Scope.Minimal`,
     * which means no parameters will be collected. Specify `Scope.Metadata` to collect all
     * parameters except icons, which can be included by specifying `Scope.Full`.
     */
    scope?: Scope;
}
export interface ApplicationQueryOptions {
    /**
     * Limit enumeration to one or more application IDs only. Typically used to fetch additional
     * details about a subset, e.g. based on user interaction.
     */
    identifiers?: string[];
    /**
     * How much data to collect about each application. The default is `Scope.Minimal`, which
     * means no parameters will be collected. Specify `Scope.Metadata` to collect all parameters
     * except icons, which can be included by specifying `Scope.Full`.
     */
    scope?: Scope;
}
export interface ProcessQueryOptions {
    /**
     * Limit enumeration to one or more process IDs only. Typically used to fetch additional
     * details about a subset, e.g. based on user interaction.
     */
    pids?: number[];
    /**
     * How much data to collect about each process. The default is `Scope.Minimal`, which
     * means no parameters will be collected. Specify `Scope.Metadata` to collect all
     * parameters except icons, which can be included by specifying `Scope.Full`.
     */
    scope?: Scope;
}
export interface ProcessMatchOptions {
    /**
     * How much data to collect about the matching process. The default is `Scope.Minimal`,
     * which means no parameters will be collected. Specify `Scope.Metadata` to collect all
     * parameters except icons, which can be included by specifying `Scope.Full`.
     */
    scope?: Scope;
}
/**
 * How much data to collect about a given application or process.
 */
export declare enum Scope {
    /**
     * Don't collect any parameters. This is the default.
     */
    Minimal = "minimal",
    /**
     * Collect all parameters except icons.
     */
    Metadata = "metadata",
    /**
     * Collect all parameters, including icons.
     */
    Full = "full"
}
export interface SpawnOptions {
    argv?: string[];
    envp?: {
        [name: string]: string;
    };
    env?: {
        [name: string]: string;
    };
    cwd?: string;
    stdio?: Stdio;
    [name: string]: any;
}
export declare enum Stdio {
    Inherit = "inherit",
    Pipe = "pipe"
}
export declare type TargetProcess = ProcessID | ProcessName;
export interface SessionOptions {
    realm?: Realm;
    persistTimeout?: number;
}
export declare enum Realm {
    Native = "native",
    Emulated = "emulated"
}
