"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Bus = void 0;
const signals_1 = require("./signals");
const util_1 = require("util");
class Bus {
    constructor(impl) {
        this.impl = impl;
        const signals = impl.signals;
        this.detached = new signals_1.Signal(signals, "detached");
        this.message = new signals_1.Signal(signals, "message");
    }
    attach(cancellable) {
        return this.impl.attach(cancellable);
    }
    post(message, data = null) {
        this.impl.post(message, data);
    }
    [util_1.inspect.custom](depth, options) {
        return "Bus {}";
    }
}
exports.Bus = Bus;
