/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.wmi.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jkiss.wmi.service.WMIException;
import org.jkiss.wmi.service.WMIObject;
import org.jkiss.wmi.service.WMIObjectAttribute;
import org.jkiss.wmi.service.WMIObjectSink;
import org.jkiss.wmi.service.WMIObjectSinkStatus;
import org.jkiss.wmi.service.WMIService;

public class TestService {
    private WMIService service;
    private boolean finished = false;
    private WMIService nsService;

    public static void main(String[] args) {
        new TestService().test();
    }

    void test() {
        block5: {
            try {
                try {
                    Thread testThread = new Thread(){

                        @Override
                        public void run() {
                            try {
                                TestService.this.service = WMIService.connect(null, "localhost", null, null, null, "root");
                                ObjectCollectorSink classesSink = new ObjectCollectorSink();
                                TestService.this.service.enumClasses(null, classesSink, 0L);
                                classesSink.waitForFinish();
                                Thread.sleep(10000L);
                            }
                            catch (WMIException e) {
                                e.printStackTrace();
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    };
                    testThread.start();
                    Thread.sleep(1000L);
                    Thread testThread2 = new Thread(){

                        @Override
                        public void run() {
                            try {
                                TestService.this.testNamespace();
                            }
                            catch (WMIException e) {
                                e.printStackTrace();
                            }
                        }
                    };
                    testThread2.start();
                    testThread2.join();
                }
                catch (InterruptedException interruptedException) {
                    this.service.close();
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.service.close();
                throw throwable;
            }
            this.service.close();
        }
        System.gc();
        System.out.println("DONE");
        System.exit(0);
    }

    private void testNamespace() throws WMIException {
        this.nsService = this.service.openNamespace("cimv2");
        ObjectCollectorSink tmpSink = new ObjectCollectorSink();
        this.nsService.executeQuery("SELECT * FROM Win32_Process", tmpSink, 128L);
        tmpSink.waitForFinish();
        for (WMIObject o : tmpSink.objectList) {
            System.out.println("=============");
            System.out.println("Caption=" + String.valueOf(o.getValue("Caption")));
            System.out.println("CommandLine=" + String.valueOf(o.getValue("CommandLine")));
            System.out.println("CreationClassName=" + String.valueOf(o.getValue("CreationClassName")));
            System.out.println("CreationDate=" + String.valueOf(o.getValue("CreationDate")));
        }
    }

    private static void printObject(WMIObject object) {
        try {
            System.out.println("====== " + object.getObjectText());
        }
        catch (WMIException e) {
            e.printStackTrace();
        }
    }

    private static void examineObject(WMIObject object) throws WMIException {
        object.getObjectText();
        for (WMIObjectAttribute prop : object.getAttributes(0L)) {
            Object propValue = prop.getValue();
            if (propValue instanceof Object[]) {
                Object[] array = (Object[])propValue;
                int i = 0;
                while (i < array.length) {
                    ++i;
                }
                continue;
            }
            boolean cfr_ignored_0 = propValue instanceof byte[];
        }
    }

    private class ObjectCollectorSink
    implements WMIObjectSink {
        private final List<WMIObject> objectList = new ArrayList<WMIObject>();
        private boolean finished = false;

        @Override
        public void indicate(WMIObject[] objects) {
            Collections.addAll(this.objectList, objects);
        }

        @Override
        public void setStatus(WMIObjectSinkStatus status, int result, String param, WMIObject errorObject) {
            if (status == WMIObjectSinkStatus.complete) {
                this.finished = true;
            }
        }

        public void waitForFinish() {
            try {
                while (!this.finished) {
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

