/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.wmi.views;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.ext.wmi.Activator;
import org.jkiss.dbeaver.ext.wmi.WMIMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageWithAuth;
import org.jkiss.utils.CommonUtils;

public class WMIConnectionPage
extends ConnectionPageWithAuth {
    private static final String DEFAULT_HOST = "localhost";
    private static final String DEFAULT_NAMESPACE = "root/cimv2";
    private Text domainText;
    private Text hostText;
    private Combo namespaceCombo;
    private Combo localeCombo;
    private static ImageDescriptor logoImage = Activator.getImageDescriptor("icons/wmi_icon_big.png");

    public void dispose() {
        super.dispose();
    }

    public void createControl(Composite composite) {
        this.setImageDescriptor(logoImage);
        ModifyListener textListener = e -> this.evaluateURL();
        Composite addrGroup = new Composite(composite, 0);
        GridLayout gl = new GridLayout(1, false);
        addrGroup.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        addrGroup.setLayoutData((Object)gd);
        Composite hostGroup = UIUtils.createTitledComposite((Composite)addrGroup, (String)"Server", (int)4, (int)768, (int)0);
        Label hostLabel = UIUtils.createControlLabel((Composite)hostGroup, (String)WMIMessages.wmi_connection_page_label_host);
        hostLabel.setLayoutData((Object)new GridData(128));
        this.hostText = new Text(hostGroup, 2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.hostText.setLayoutData((Object)gd);
        this.hostText.addModifyListener(textListener);
        Label domainLabel = UIUtils.createControlLabel((Composite)hostGroup, (String)WMIMessages.wmi_connection_page_label_domain);
        domainLabel.setLayoutData((Object)new GridData(128));
        this.domainText = new Text(hostGroup, 2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.domainText.setLayoutData((Object)gd);
        this.domainText.addModifyListener(textListener);
        Label namespaceLabel = UIUtils.createControlLabel((Composite)hostGroup, (String)WMIMessages.wmi_connection_page_label_namespace);
        namespaceLabel.setLayoutData((Object)new GridData(128));
        this.namespaceCombo = new Combo(hostGroup, 2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 3;
        this.namespaceCombo.setLayoutData((Object)gd);
        this.namespaceCombo.addModifyListener(textListener);
        this.createAuthPanel(addrGroup, 1);
        this.createDriverPanel(addrGroup);
        this.setControl((Control)addrGroup);
    }

    public boolean isComplete() {
        return super.isComplete() && this.hostText != null && this.namespaceCombo != null && !CommonUtils.isEmpty((String)this.hostText.getText()) && !CommonUtils.isEmpty((String)this.namespaceCombo.getText());
    }

    public void loadSettings() {
        DBPDataSourceContainer activeDataSource = this.site.getActiveDataSource();
        DBPConnectionConfiguration connectionInfo = activeDataSource.getConnectionConfiguration();
        if (connectionInfo.getHostName() == null) {
            connectionInfo.setHostName(DEFAULT_HOST);
        }
        if (connectionInfo.getDatabaseName() == null) {
            connectionInfo.setDatabaseName(DEFAULT_NAMESPACE);
        }
        if (this.hostText != null) {
            this.hostText.setText(CommonUtils.notEmpty((String)connectionInfo.getHostName()));
        }
        if (this.domainText != null) {
            this.domainText.setText(CommonUtils.notEmpty((String)connectionInfo.getServerName()));
        }
        if (this.namespaceCombo != null) {
            this.namespaceCombo.setText(CommonUtils.notEmpty((String)connectionInfo.getDatabaseName()));
        }
        super.loadSettings();
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.hostText != null) {
            connectionInfo.setHostName(this.hostText.getText().trim());
        }
        if (this.domainText != null) {
            connectionInfo.setServerName(this.domainText.getText().trim());
        }
        if (this.namespaceCombo != null) {
            connectionInfo.setDatabaseName(this.namespaceCombo.getText().trim());
        }
        super.saveSettings(dataSource);
    }

    private void evaluateURL() {
        this.site.updateButtons();
    }
}

