// Shaders should NOT be modified
/* eslint-disable no-useless-escape */

// Post Processing Manager
const pPM = {};
pPM.isInitOnce = false;
/* istanbul ignore next */
pPM.init = (gl) => {
  pPM.gl = gl;

  if (pPM.isInitOnce) return;
  pPM.isInitOnce = true;

  pPM.programs = {};

  // pPM.programs.hdr = pPM.createProgram(pPM.shaderCode.hdr.vert, pPM.shaderCode.hdr.frag);
  // pPM.programs.hdr = pPM.setupHdr(gl, pPM.programs.hdr);

  // pPM.programs.fxaa = pPM.createProgram(pPM.shaderCode.fxaa.vert, pPM.shaderCode.fxaa.frag);
  // pPM.programs.fxaa = pPM.setupFxaa(gl, pPM.programs.fxaa);

  // pPM.programs.smaaEdges = pPM.createProgram(pPM.shaderCode.smaaEdges.vert, pPM.shaderCode.smaaEdges.frag);
  // pPM.programs.smaaEdges = pPM.setupSmaaEdges(gl, pPM.programs.smaaEdges);

  // pPM.programs.smaaWeights = pPM.createProgram(pPM.shaderCode.smaaWeights.vert, pPM.shaderCode.smaaWeights.frag);
  // pPM.programs.smaaWeights = pPM.setupSmaaWeights(gl, pPM.programs.smaaWeights);

  // pPM.programs.smaaBlend = pPM.createProgram(pPM.shaderCode.smaaBlend.vert, pPM.shaderCode.smaaBlend.frag);
  // pPM.programs.smaaBlend = pPM.setupSmaaBlend(gl, pPM.programs.smaaBlend);

  pPM.programs.occlusion = pPM.createProgram(pPM.shaderCode.occlusion.vert, pPM.shaderCode.occlusion.frag);
  pPM.programs.occlusion = pPM.setupOcclusion(gl, pPM.programs.occlusion);

  // pPM.programs.gaussian = pPM.createProgram(pPM.shaderCode.gaussian.vert, pPM.shaderCode.gaussian.frag);
  // pPM.programs.gaussian = pPM.setupGaussian(gl, pPM.programs.gaussian);

  pPM.frameBufferInfos = {};
  // pPM.frameBufferInfos.one = pPM.createFrameBufferInfo(gl.drawingBufferWidth, gl.drawingBufferHeight);
  // pPM.frameBufferInfos.two = pPM.createFrameBufferInfo(gl.drawingBufferWidth, gl.drawingBufferHeight);

  // pPM.curBuffer = pPM.frameBufferInfos.one.frameBuffer;
  pPM.curBuffer = null;
};

/* istanbul ignore next */
pPM.createProgram = (vertCode, fragCode) => {
  const gl = pPM.gl;
  const program = gl.createProgram();
  program.vertShader = gl.createShader(gl.VERTEX_SHADER);
  gl.shaderSource(program.vertShader, vertCode);
  gl.compileShader(program.vertShader);

  program.fragShader = gl.createShader(gl.FRAGMENT_SHADER);
  gl.shaderSource(program.fragShader, fragCode);
  gl.compileShader(program.fragShader);

  gl.attachShader(program, program.vertShader);
  gl.attachShader(program, program.fragShader);
  gl.linkProgram(program);

  if (!gl.getProgramParameter(program, gl.LINK_STATUS)) {
    var info = gl.getProgramInfoLog(program);
    throw new Error('Could not compile WebGL program. \n\n' + info);
  }
  return program;
};

/* istanbul ignore next */
pPM.setupHdr = (gl, program) => {
  program.attr = {
    position: gl.getAttribLocation(program, 'a_position'),
    texCoord: gl.getAttribLocation(program, 'a_texCoord'),
  };
  program.uniform = {
    resolution: gl.getUniformLocation(program, 'u_resolution'),
    canvas: gl.getUniformLocation(program, 'u_canvas'),
  };
  program.uniformSetup = () => null;
  return program;
};

/* istanbul ignore next */
pPM.setupFxaa = (gl, program) => {
  program.attr = {
    position: gl.getAttribLocation(program, 'a_position'),
    texCoord: gl.getAttribLocation(program, 'a_texCoord'),
  };
  program.uniform = {
    resolution: gl.getUniformLocation(program, 'u_resolution'),
    canvas: gl.getUniformLocation(program, 'u_canvas'),
  };
  program.uniformSetup = () => null;
  return program;
};

/* istanbul ignore next */
pPM.setupSmaaBlend = (gl, program) => {
  program.attr = {
    position: gl.getAttribLocation(program, 'a_position'),
    texCoord: gl.getAttribLocation(program, 'a_texCoord'),
  };
  program.uniform = {
    resolution: gl.getUniformLocation(program, 'u_resolution'),
    canvas: gl.getUniformLocation(program, 'u_canvas'),
    color: gl.getUniformLocation(program, 'u_color'),
  };
  program.uniformSetup = () => null;
  return program;
};

/* istanbul ignore next */
pPM.setupSmaaEdges = (gl, program) => {
  program.attr = {
    position: gl.getAttribLocation(program, 'a_position'),
    texCoord: gl.getAttribLocation(program, 'a_texCoord'),
  };
  program.uniform = {
    resolution: gl.getUniformLocation(program, 'u_resolution'),
    canvas: gl.getUniformLocation(program, 'u_canvas'),
  };
  program.uniformSetup = () => null;
  return program;
};

/* istanbul ignore next */
pPM.setupSmaaWeights = (gl, program) => {
  program.attr = {
    position: gl.getAttribLocation(program, 'a_position'),
    texCoord: gl.getAttribLocation(program, 'a_texCoord'),
  };
  program.uniform = {
    resolution: gl.getUniformLocation(program, 'u_resolution'),
    canvas: gl.getUniformLocation(program, 'u_canvas'),
    area: gl.getUniformLocation(program, 'u_area'),
    search: gl.getUniformLocation(program, 'u_search'),
  };
  program.uniformSetup = () => null;
  program.textures = {};

  program.getAreaTexture = () =>
    // eslint-disable-next-line implicit-arrow-linebreak
    'data:image/png;base64,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';

  program.getSearchTexture = () =>
    // eslint-disable-next-line implicit-arrow-linebreak
    'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEAAAAAQCAYAAACm53kpAAAAeElEQVRYR+2XSwqAMAxEJ168ePEqwRSKhIIiuHjJqiU0gWE+1CQdApcVAMUAuARaMGCX1MIL/Ow13++9lW2s3mW9MWvsnWc/2fvGygwPAN4E8QzAA4CXAB6AHjG4JTHYI1ey3pcx6FHnEfhLDOIBKAmUBK6/ANUDTlROXAHd9EC1AAAAAElFTkSuQmCC';

  const areaTextureImage = new Image();
  areaTextureImage.src = program.getAreaTexture();
  areaTextureImage.onload = function () {
    program.textures.area = gl.createTexture();
    gl.bindTexture(gl.TEXTURE_2D, program.textures.area);
    gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, gl.LINEAR);
    gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_S, gl.CLAMP_TO_EDGE); // makes clearing work
    gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_T, gl.CLAMP_TO_EDGE);
    gl.texImage2D(gl.TEXTURE_2D, 0, gl.RGB, gl.RGB, gl.UNSIGNED_BYTE, areaTextureImage);
  };

  const searchTextureImage = new Image();
  searchTextureImage.src = program.getSearchTexture();
  searchTextureImage.onload = function () {
    program.textures.search = gl.createTexture();
    gl.bindTexture(gl.TEXTURE_2D, program.textures.search);
    gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MAG_FILTER, gl.NEAREST);
    gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, gl.NEAREST);
    gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_S, gl.CLAMP_TO_EDGE); // makes clearing work
    gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_T, gl.CLAMP_TO_EDGE);
    gl.texImage2D(gl.TEXTURE_2D, 0, gl.RGBA, gl.RGBA, gl.UNSIGNED_BYTE, searchTextureImage);
  };

  return program;
};

/* istanbul ignore next */
pPM.setupGaussian = (gl, program) => {
  program.attr = {
    position: gl.getAttribLocation(program, 'a_position'),
    texCoord: gl.getAttribLocation(program, 'a_texCoord'),
  };
  program.uniform = {
    resolution: gl.getUniformLocation(program, 'u_resolution'),
    canvas: gl.getUniformLocation(program, 'u_canvas'),
    radius: gl.getUniformLocation(program, 'u_radius'),
    dir: gl.getUniformLocation(program, 'u_dir'),
  };
  program.uniformValues = {
    radius: 10,
    dir: {
      x: 1.0,
      y: 0.0,
    },
  };
  program.uniformSetup = (program) => {
    gl.uniform1f(program.uniform.radius, program.uniformValues.radius);
    gl.uniform2f(program.uniform.dir, program.uniformValues.dir.x, program.uniformValues.dir.y);
  };
  return program;
};

/* istanbul ignore next */
pPM.setupOcclusion = (gl, program) => {
  program.attr = {
    position: gl.getAttribLocation(program, 'a_position'),
  };
  program.uniform = {
    uPMatrix: gl.getUniformLocation(program, 'uPMatrix'),
    uCamMatrix: gl.getUniformLocation(program, 'uCamMatrix'),
    uMvMatrix: gl.getUniformLocation(program, 'uMvMatrix'),
  };
  program.attrSetup = (program, vertPosBuf, stride) => {
    stride = stride || 0;
    gl.bindBuffer(gl.ARRAY_BUFFER, vertPosBuf);
    gl.enableVertexAttribArray(program.attr.position);
    gl.vertexAttribPointer(program.attr.position, 3, gl.FLOAT, false, stride, 0);
  };
  program.attrOff = (program) => {
    gl.disableVertexAttribArray(program.attr.position);
  };
  program.uniformSetup = (program, mvMatrix, pMatrix, camMatrix) => {
    gl.uniformMatrix4fv(program.uniform.uMvMatrix, false, mvMatrix);
    gl.uniformMatrix4fv(program.uniform.uPMatrix, false, pMatrix);
    gl.uniformMatrix4fv(program.uniform.uCamMatrix, false, camMatrix);
  };
  return program;
};

/* istanbul ignore next */
pPM.setupAdditionalUniforms = (program) => {
  program.uniformSetup(program);
};

/* istanbul ignore next */
pPM.createFrameBufferInfo = (width, height) => {
  const gl = pPM.gl;
  const frameBufferInfo = {};
  frameBufferInfo.width = width;
  frameBufferInfo.height = height;

  frameBufferInfo.buffers = {};
  frameBufferInfo.buffers.position = gl.createBuffer();
  gl.bindBuffer(gl.ARRAY_BUFFER, frameBufferInfo.buffers.position);
  let x1 = 0;
  let x2 = 0 + width;
  let y1 = 0;
  let y2 = 0 + height;
  gl.bufferData(gl.ARRAY_BUFFER, new Float32Array([x1, y1, x2, y1, x1, y2, x1, y2, x2, y1, x2, y2]), gl.STATIC_DRAW);

  // provide texture coordinates for the rectangle.
  frameBufferInfo.buffers.texCoord = gl.createBuffer();
  gl.bindBuffer(gl.ARRAY_BUFFER, frameBufferInfo.buffers.texCoord);
  gl.bufferData(gl.ARRAY_BUFFER, new Float32Array([0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 1.0]), gl.STATIC_DRAW);

  frameBufferInfo.texture = gl.createTexture();
  gl.bindTexture(gl.TEXTURE_2D, frameBufferInfo.texture);
  gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MAG_FILTER, gl.NEAREST);
  gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, gl.NEAREST);
  gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_S, gl.CLAMP_TO_EDGE); // makes clearing work
  gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_T, gl.CLAMP_TO_EDGE);
  gl.texImage2D(gl.TEXTURE_2D, 0, gl.RGBA, width, height, 0, gl.RGBA, gl.UNSIGNED_BYTE, null);

  frameBufferInfo.frameBuffer = gl.createFramebuffer();
  gl.bindFramebuffer(gl.FRAMEBUFFER, frameBufferInfo.frameBuffer);

  frameBufferInfo.renderBuffer = gl.createRenderbuffer(); // create RB to store the depth buffer
  gl.bindRenderbuffer(gl.RENDERBUFFER, frameBufferInfo.renderBuffer);
  gl.renderbufferStorage(gl.RENDERBUFFER, gl.DEPTH_COMPONENT16, width, height);

  gl.framebufferTexture2D(gl.FRAMEBUFFER, gl.COLOR_ATTACHMENT0, gl.TEXTURE_2D, frameBufferInfo.texture, 0);
  gl.framebufferRenderbuffer(gl.FRAMEBUFFER, gl.DEPTH_ATTACHMENT, gl.RENDERBUFFER, frameBufferInfo.renderBuffer);
  return frameBufferInfo;
};

/* istanbul ignore next */
pPM.switchFrameBuffer = () => {
  pPM.curBuffer = pPM.curBuffer == pPM.frameBufferInfos.one.frameBuffer ? pPM.frameBufferInfos.two.frameBuffer : pPM.frameBufferInfos.one.frameBuffer;
  pPM.secBuffer = pPM.curBuffer == pPM.frameBufferInfos.one.frameBuffer ? pPM.frameBufferInfos.two.frameBuffer : pPM.frameBufferInfos.one.frameBuffer;
};

/* istanbul ignore next */
pPM.getFrameBufferInfo = (curBuffer) => {
  if (curBuffer == pPM.frameBufferInfos.one.frameBuffer || curBuffer == pPM.frameBufferInfos.two.frameBuffer) {
    const frameBufferInfo = curBuffer == pPM.frameBufferInfos.one.frameBuffer ? pPM.frameBufferInfos.one : pPM.frameBufferInfos.two;
    return frameBufferInfo;
  } else {
    // Parse godrays buffer -- TEMPORARY SOLUTION
    return {
      buffers: {
        position: curBuffer.positionBuffer,
        texCoord: curBuffer.texcoordBuffer,
      },
      texture: curBuffer.godraysTexture,
    };
  }
};

/* istanbul ignore next */
pPM.clearAll = () => {
  const gl = pPM.gl;
  gl.bindFramebuffer(gl.FRAMEBUFFER, pPM.frameBufferInfos.one.frameBuffer);
  gl.clearColor(0.0, 0.0, 0.0, 0.0);
  gl.clear(gl.COLOR_BUFFER_BIT | gl.DEPTH_BUFFER_BIT);
  gl.bindFramebuffer(gl.FRAMEBUFFER, pPM.frameBufferInfos.two.frameBuffer);
  // gl.clearColor(0.0, 0.0, 0.0, 0.0);
  gl.clear(gl.COLOR_BUFFER_BIT | gl.DEPTH_BUFFER_BIT);
};

/* istanbul ignore next */
pPM.doPostProcessing = (gl, program, curBuffer, tgtBuffer, secBuffer) => {
  gl.useProgram(program);
  // Make sure pPM texture doesn't prevent the rest of the scene from rendering
  gl.depthMask(false);

  pPM.curFbi = pPM.getFrameBufferInfo(curBuffer);

  // Turn on the position attribute
  gl.enableVertexAttribArray(program.attr.position);
  // Bind the position buffer.
  gl.bindBuffer(gl.ARRAY_BUFFER, pPM.curFbi.buffers.position);
  // Tell the position attribute how to get data out of positionBuffer (ARRAY_BUFFER)
  gl.vertexAttribPointer(program.attr.position, 2, gl.FLOAT, false, 0, 0);

  // Turn on the texcoord attribute
  gl.enableVertexAttribArray(program.attr.texCoord);
  // bind the texcoord buffer.
  gl.bindBuffer(gl.ARRAY_BUFFER, pPM.curFbi.buffers.texCoord);
  // Tell the texcoord attribute how to get data out of texcoordBuffer (ARRAY_BUFFER)
  gl.vertexAttribPointer(program.attr.texCoord, 2, gl.FLOAT, false, 0, 0);

  // Load the original image
  gl.activeTexture(gl.TEXTURE0);
  gl.bindTexture(gl.TEXTURE_2D, pPM.curFbi.texture);
  gl.uniform1i(program.uniform.canvas, 0);
  if (program == pPM.programs.smaaWeights) {
    gl.activeTexture(gl.TEXTURE1);
    gl.bindTexture(gl.TEXTURE_2D, program.textures.area);
    gl.uniform1i(program.uniform.area, 1);

    gl.activeTexture(gl.TEXTURE2);
    gl.bindTexture(gl.TEXTURE_2D, program.textures.search);
    gl.uniform1i(program.uniform.search, 2);
  }
  if (program == pPM.programs.smaaBlend) {
    pPM.secFbi = pPM.getFrameBufferInfo(secBuffer);
    gl.activeTexture(gl.TEXTURE1);
    gl.bindTexture(gl.TEXTURE_2D, pPM.secFbi.texture);
    gl.uniform1i(program.uniform.color, 1);
  }
  // set the resolution
  gl.uniform2f(program.uniform.resolution, gl.canvas.width, gl.canvas.height);

  pPM.setupAdditionalUniforms(program);

  // Draw the new version to the screen
  gl.bindFramebuffer(gl.FRAMEBUFFER, tgtBuffer);
  gl.drawArrays(gl.TRIANGLES, 0, 6);

  // Future writing needs to have a depth test
  gl.depthMask(true);
};

pPM.shaderCode = {
  hdr: {
    frag: `#version 300 es
    precision mediump float;

    // our texture
    uniform sampler2D u_canvas;

    // the texCoords passed in from the vertex shader.
    in vec2 v_texCoord;

    out vec4 fragColor;
    
    void main() {
      fragColor = texture(u_canvas, v_texCoord);
    }
  `,
    vert: `#version 300 es
    in vec2 a_position;
    in vec2 a_texCoord;

    uniform vec2 u_resolution;
    
    out vec2 v_texCoord;
    
    void main() {
      // convert the rectangle from pixels to 0.0 to 1.0
      vec2 zeroToOne = a_position / u_resolution;
    
      // convert from 0->1 to 0->2
      vec2 zeroToTwo = zeroToOne * 2.0;
    
      // convert from 0->2 to -1->+1 (clipspace)
      vec2 clipSpace = zeroToTwo - 1.0;
    
      gl_Position = vec4(clipSpace, 0, 1);
    
      // pass the texCoord to the fragment shader
      // The GPU will interpolate pPM value between points.
      v_texCoord = a_texCoord;
    }
  `,
  },
  gaussian: {
    frag: `#version 300 es
    precision highp float;

    // our texture
    uniform sampler2D u_canvas;
    uniform vec2 u_resolution;
    uniform float u_radius;
    uniform vec2 u_dir;

    // the texCoords passed in from the vertex shader.
    in vec2 v_texCoord;

    out vec4 fragColor;
    
    void main() {
      //this will be our RGBA sum
      vec4 sum = vec4(0.0);
      
      //our original texcoord for this fragment
      vec2 tc = v_texCoord;
      
      //the amount to blur, i.e. how far off center to sample from 
      //1.0 -> blur by one pixel
      //2.0 -> blur by two pixels, etc.
      float blur = u_radius / u_resolution[0];
        
      //the direction of our blur
      //(1.0, 0.0) -> x-axis blur
      //(0.0, 1.0) -> y-axis blur
      float hstep = u_dir[0];
      float vstep = u_dir[1];
        
      //apply blurring, using a 9-tap filter with predefined gaussian weights
        
      sum += texture(u_canvas, vec2(tc.x - 4.0*blur*hstep, tc.y - 4.0*blur*vstep)) * 0.0162162162;
      sum += texture(u_canvas, vec2(tc.x - 3.0*blur*hstep, tc.y - 3.0*blur*vstep)) * 0.0540540541;
      sum += texture(u_canvas, vec2(tc.x - 2.0*blur*hstep, tc.y - 2.0*blur*vstep)) * 0.1216216216;
      sum += texture(u_canvas, vec2(tc.x - 1.0*blur*hstep, tc.y - 1.0*blur*vstep)) * 0.1945945946;
      
      sum += texture(u_canvas, vec2(tc.x, tc.y)) * 0.2270270270;
      
      sum += texture(u_canvas, vec2(tc.x + 1.0*blur*hstep, tc.y + 1.0*blur*vstep)) * 0.1945945946;
      sum += texture(u_canvas, vec2(tc.x + 2.0*blur*hstep, tc.y + 2.0*blur*vstep)) * 0.1216216216;
      sum += texture(u_canvas, vec2(tc.x + 3.0*blur*hstep, tc.y + 3.0*blur*vstep)) * 0.0540540541;
      sum += texture(u_canvas, vec2(tc.x + 4.0*blur*hstep, tc.y + 4.0*blur*vstep)) * 0.0162162162;
    
      //discard alpha for our simple demo, multiply by vertex color and return
      fragColor = vec4(sum.rgb, 1.0);
    }
  `,
    vert: `#version 300 es
    precision highp float;

    in vec2 a_position;
    in vec2 a_texCoord;

    uniform vec2 u_resolution;
    
    out vec2 v_texCoord;
    
    void main() {
      // convert the rectangle from pixels to 0.0 to 1.0
      vec2 zeroToOne = a_position / u_resolution;
    
      // convert from 0->1 to 0->2
      vec2 zeroToTwo = zeroToOne * 2.0;
    
      // convert from 0->2 to -1->+1 (clipspace)
      vec2 clipSpace = zeroToTwo - 1.0;
    
      gl_Position = vec4(clipSpace, 0, 1);
    
      // pass the texCoord to the fragment shader
      // The GPU will interpolate pPM value between points.
      v_texCoord = a_texCoord;
    }
  `,
  },
  occlusion: {
    vert: `#version 300 es
              in vec3 a_position;
      
              uniform mat4 uCamMatrix;
              uniform mat4 uMvMatrix;
              uniform mat4 uPMatrix;
      
              void main(void) {
              vec4 position = uPMatrix * uCamMatrix *  uMvMatrix * vec4(a_position, 1.0);
              gl_Position = position;
              }
          `,
    frag: `#version 300 es
              precision mediump float;

              out vec4 fragColor;
      
              void main(void) {
                  fragColor = vec4(0.0, 0.0, 0.0, 1.0);
              }
          `,
  },
  fxaa: {
    vert: `#version 300 es          
          in vec2 a_position;
          in vec2 a_texCoord;

          uniform vec2 u_resolution;
          
          out vec2 v_texCoord;
          
          void main() {
            // convert the rectangle from pixels to 0.0 to 1.0
            vec2 zeroToOne = a_position / u_resolution;
          
            // convert from 0->1 to 0->2
            vec2 zeroToTwo = zeroToOne * 2.0;
          
            // convert from 0->2 to -1->+1 (clipspace)
            vec2 clipSpace = zeroToTwo - 1.0;
          
            gl_Position = vec4(clipSpace, 0, 1);
          
            // pass the texCoord to the fragment shader
            // The GPU will interpolate pPM value between points.
            v_texCoord = a_texCoord;
          }            
          `,
    frag: `#version 300 es    
            precision highp float;    

            #ifndef FXAA_REDUCE_MIN
                #define FXAA_REDUCE_MIN   (1.0/ 128.0)
            #endif
            #ifndef FXAA_REDUCE_MUL
                #define FXAA_REDUCE_MUL   (1.0 / 8.0)
            #endif
            #ifndef FXAA_SPAN_MAX
                #define FXAA_SPAN_MAX     8.0
            #endif

            // optimized version for mobile, where dependent 
            // texture reads can be a bottleneck
            vec4 fxaa(sampler2D tex, vec2 fragCoord, vec2 resolution,
                        vec2 v_rgbNW, vec2 v_rgbNE, 
                        vec2 v_rgbSW, vec2 v_rgbSE, 
                        vec2 v_rgbM) {
                vec4 color;
                vec2 inverseVP = vec2(1.0 / resolution.x, 1.0 / resolution.y);
                vec3 rgbNW = texture(tex, v_rgbNW).xyz;
                vec3 rgbNE = texture(tex, v_rgbNE).xyz;
                vec3 rgbSW = texture(tex, v_rgbSW).xyz;
                vec3 rgbSE = texture(tex, v_rgbSE).xyz;
                vec4 texColor = texture(tex, v_rgbM);
                vec3 rgbM  = texColor.xyz;
                vec3 luma = vec3(0.299, 0.587, 0.114);
                float lumaNW = dot(rgbNW, luma);
                float lumaNE = dot(rgbNE, luma);
                float lumaSW = dot(rgbSW, luma);
                float lumaSE = dot(rgbSE, luma);
                float lumaM  = dot(rgbM,  luma);
                float lumaMin = min(lumaM, min(min(lumaNW, lumaNE), min(lumaSW, lumaSE)));
                float lumaMax = max(lumaM, max(max(lumaNW, lumaNE), max(lumaSW, lumaSE)));
                
                vec2 dir;
                dir.x = -((lumaNW + lumaNE) - (lumaSW + lumaSE));
                dir.y =  ((lumaNW + lumaSW) - (lumaNE + lumaSE));
                
                float dirReduce = max((lumaNW + lumaNE + lumaSW + lumaSE) *
                                      (0.25 * FXAA_REDUCE_MUL), FXAA_REDUCE_MIN);
                
                float rcpDirMin = 1.0 / (min(abs(dir.x), abs(dir.y)) + dirReduce);
                dir = min(vec2(FXAA_SPAN_MAX, FXAA_SPAN_MAX),
                          max(vec2(-FXAA_SPAN_MAX, -FXAA_SPAN_MAX),
                          dir * rcpDirMin)) * inverseVP;
                
                vec3 rgbA = 0.5 * (
                    texture(tex, fragCoord * inverseVP + dir * (1.0 / 3.0 - 0.5)).xyz +
                    texture(tex, fragCoord * inverseVP + dir * (2.0 / 3.0 - 0.5)).xyz);
                vec3 rgbB = rgbA * 0.5 + 0.25 * (
                    texture(tex, fragCoord * inverseVP + dir * -0.5).xyz +
                    texture(tex, fragCoord * inverseVP + dir * 0.5).xyz);

                float lumaB = dot(rgbB, luma);
                if ((lumaB < lumaMin) || (lumaB > lumaMax))
                    color = vec4(rgbA, texColor.a);
                else
                    color = vec4(rgbB, texColor.a);
                return color;
            }

            void texcoords(vec2 fragCoord, vec2 resolution,
                        out vec2 v_rgbNW, out vec2 v_rgbNE,
                        out vec2 v_rgbSW, out vec2 v_rgbSE,
                        out vec2 v_rgbM) {
                vec2 inverseVP = 1.0 / resolution.xy;
                v_rgbNW = (fragCoord + vec2(-1.0, -1.0)) * inverseVP;
                v_rgbNE = (fragCoord + vec2(1.0, -1.0)) * inverseVP;
                v_rgbSW = (fragCoord + vec2(-1.0, 1.0)) * inverseVP;
                v_rgbSE = (fragCoord + vec2(1.0, 1.0)) * inverseVP;
                v_rgbM = vec2(fragCoord * inverseVP);
            }

            vec4 apply(sampler2D tex, vec2 fragCoord, vec2 resolution) {
                vec2 v_rgbNW;
                vec2 v_rgbNE;
                vec2 v_rgbSW;
                vec2 v_rgbSE;
                vec2 v_rgbM;

                // compute the texture coords
                texcoords(fragCoord, resolution, 
                          v_rgbNW, v_rgbNE, v_rgbSW, v_rgbSE, v_rgbM);
                
                // compute FXAA
                return fxaa(tex, fragCoord, resolution, 
                            v_rgbNW, v_rgbNE, v_rgbSW, v_rgbSE, v_rgbM);
            }

            uniform vec2 u_resolution;
            uniform sampler2D u_canvas;            

            in vec2 v_texCoord;

            out vec4 fragColor;

            void main() {
                vec2 fragCoord = v_texCoord * u_resolution;
                fragColor = apply(u_canvas, fragCoord, u_resolution);
            }
          `,
  },
  fxaaNvidia: {
    vert: `#version 300 es          
          in vec2 a_position;
          in vec2 a_texCoord;

          uniform vec2 u_resolution;
          
          out vec2 v_texCoord;
          
          void main() {
            // convert the rectangle from pixels to 0.0 to 1.0
            vec2 zeroToOne = a_position / u_resolution;
          
            // convert from 0->1 to 0->2
            vec2 zeroToTwo = zeroToOne * 2.0;
          
            // convert from 0->2 to -1->+1 (clipspace)
            vec2 clipSpace = zeroToTwo - 1.0;
          
            gl_Position = vec4(clipSpace, 0, 1);
          
            // pass the texCoord to the fragment shader
            // The GPU will interpolate pPM value between points.
            v_texCoord = a_texCoord;
          }            
          `,
    frag: `#version 300 es      
          // FXAA 3.11 implementation by NVIDIA, ported to WebGL by Agost Biro (biro@archilogic.com)

          //----------------------------------------------------------------------------------
          // File:        es3-kepler\FXAA\assets\shaders/FXAA_DefaultES.frag
          // SDK Version: v3.00
          // Email:       gameworks@nvidia.com
          // Site:        http://developer.nvidia.com/
          //
          // Copyright (c) 2014-2015, NVIDIA CORPORATION. All rights reserved.
          //
          // Redistribution and use in source and binary forms, with or without
          // modification, are permitted provided that the following conditions
          // are met:
          //  * Redistributions of source code must retain the above copyright
          //    notice, this list of conditions and the following disclaimer.
          //  * Redistributions in binary form must reproduce the above copyright
          //    notice, this list of conditions and the following disclaimer in the
          //    documentation and/or other materials provided with the distribution.
          //  * Neither the name of NVIDIA CORPORATION nor the names of its
          //    contributors may be used to endorse or promote products derived
          //    from this software without specific prior written permission.
          //
          // THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AS IS AND ANY
          // EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
          // IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
          // PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
          // CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
          // EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
          // PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
          // PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
          // OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
          // (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
          // OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
          //
          //----------------------------------------------------------------------------------
  
          precision highp float;
      
          uniform sampler2D u_canvas;
      
          uniform vec2 u_resolution;
      
          in vec2 v_texCoord;

          out vec4 fragColor;
      
          #define FXAA_PC 1
          #define FXAA_GLSL_100 1
          #define FXAA_QUALITY_PRESET 12
      
          #define FXAA_GREEN_AS_LUMA 1
      
          /*--------------------------------------------------------------------------*/
          #ifndef FXAA_PC_CONSOLE
              //
              // The console algorithm for PC is included
              // for developers targeting really low spec machines.
              // Likely better to just run FXAA_PC, and use a really low preset.
              //
              #define FXAA_PC_CONSOLE 0
          #endif
          /*--------------------------------------------------------------------------*/
          #ifndef FXAA_GLSL_120
              #define FXAA_GLSL_120 0
          #endif
          /*--------------------------------------------------------------------------*/
          #ifndef FXAA_GLSL_130
              #define FXAA_GLSL_130 0
          #endif
          /*--------------------------------------------------------------------------*/
          #ifndef FXAA_HLSL_3
              #define FXAA_HLSL_3 0
          #endif
          /*--------------------------------------------------------------------------*/
          #ifndef FXAA_HLSL_4
              #define FXAA_HLSL_4 0
          #endif
          /*--------------------------------------------------------------------------*/
          #ifndef FXAA_HLSL_5
              #define FXAA_HLSL_5 0
          #endif
          /*==========================================================================*/
          #ifndef FXAA_GREEN_AS_LUMA
              //
              // For those using non-linear color,
              // and either not able to get luma in alpha, or not wanting to,
              // this enables FXAA to run using green as a proxy for luma.
              // So with this enabled, no need to pack luma in alpha.
              //
              // This will turn off AA on anything which lacks some amount of green.
              // Pure red and blue or combination of only R and B, will get no AA.
              //
              // Might want to lower the settings for both,
              //    fxaaConsoleEdgeThresholdMin
              //    fxaaQualityEdgeThresholdMin
              // In order to insure AA does not get turned off on colors
              // which contain a minor amount of green.
              //
              // 1 = On.
              // 0 = Off.
              //
              #define FXAA_GREEN_AS_LUMA 0
          #endif
          /*--------------------------------------------------------------------------*/
          #ifndef FXAA_EARLY_EXIT
              //
              // Controls algorithm\'s early exit path.
              // On PS3 turning this ON adds 2 cycles to the shader.
              // On 360 turning this OFF adds 10ths of a millisecond to the shader.
              // Turning this off on console will result in a more blurry image.
              // So this defaults to on.
              //
              // 1 = On.
              // 0 = Off.
              //
              #define FXAA_EARLY_EXIT 1
          #endif
          /*--------------------------------------------------------------------------*/
          #ifndef FXAA_DISCARD
              //
              // Only valid for PC OpenGL currently.
              // Probably will not work when FXAA_GREEN_AS_LUMA = 1.
              //
              // 1 = Use discard on pixels which don\'t need AA.
              //     For APIs which enable concurrent TEX+ROP from same surface.
              // 0 = Return unchanged color on pixels which don\'t need AA.
              //
              #define FXAA_DISCARD 0
          #endif
          /*--------------------------------------------------------------------------*/
          #ifndef FXAA_FAST_PIXEL_OFFSET
              //
              // Used for GLSL 120 only.
              //
              // 1 = GL API supports fast pixel offsets
              // 0 = do not use fast pixel offsets
              //
              #ifdef GL_EXT_gpu_shader4
                  #define FXAA_FAST_PIXEL_OFFSET 1
              #endif
              #ifdef GL_NV_gpu_shader5
                  #define FXAA_FAST_PIXEL_OFFSET 1
              #endif
              #ifdef GL_ARB_gpu_shader5
                  #define FXAA_FAST_PIXEL_OFFSET 1
              #endif
              #ifndef FXAA_FAST_PIXEL_OFFSET
                  #define FXAA_FAST_PIXEL_OFFSET 0
              #endif
          #endif
          /*--------------------------------------------------------------------------*/
          #ifndef FXAA_GATHER4_ALPHA
              //
              // 1 = API supports gather4 on alpha channel.
              // 0 = API does not support gather4 on alpha channel.
              //
              #if (FXAA_HLSL_5 == 1)
                  #define FXAA_GATHER4_ALPHA 1
              #endif
              #ifdef GL_ARB_gpu_shader5
                  #define FXAA_GATHER4_ALPHA 1
              #endif
              #ifdef GL_NV_gpu_shader5
                  #define FXAA_GATHER4_ALPHA 1
              #endif
              #ifndef FXAA_GATHER4_ALPHA
                  #define FXAA_GATHER4_ALPHA 0
              #endif
          #endif
      
      
          /*============================================================================
                                  FXAA QUALITY - TUNING KNOBS
          ------------------------------------------------------------------------------
          NOTE the other tuning knobs are now in the shader function inputs!
          ============================================================================*/
          #ifndef FXAA_QUALITY_PRESET
              //
              // Choose the quality preset.
              // This needs to be compiled into the shader as it effects code.
              // Best option to include multiple presets is to
              // in each shader define the preset, then include this file.
              //
              // OPTIONS
              // -----------------------------------------------------------------------
              // 10 to 15 - default medium dither (10=fastest, 15=highest quality)
              // 20 to 29 - less dither, more expensive (20=fastest, 29=highest quality)
              // 39       - no dither, very expensive
              //
              // NOTES
              // -----------------------------------------------------------------------
              // 12 = slightly faster then FXAA 3.9 and higher edge quality (default)
              // 13 = about same speed as FXAA 3.9 and better than 12
              // 23 = closest to FXAA 3.9 visually and performance wise
              //  _ = the lowest digit is directly related to performance
              // _  = the highest digit is directly related to style
              //
              #define FXAA_QUALITY_PRESET 12
          #endif
      
      
          /*============================================================================
      
                                    FXAA QUALITY - PRESETS
      
          ============================================================================*/
      
          /*============================================================================
                              FXAA QUALITY - MEDIUM DITHER PRESETS
          ============================================================================*/
          #if (FXAA_QUALITY_PRESET == 10)
              #define FXAA_QUALITY_PS 3
              #define FXAA_QUALITY_P0 1.5
              #define FXAA_QUALITY_P1 3.0
              #define FXAA_QUALITY_P2 12.0
          #endif
          /*--------------------------------------------------------------------------*/
          #if (FXAA_QUALITY_PRESET == 11)
              #define FXAA_QUALITY_PS 4
              #define FXAA_QUALITY_P0 1.0
              #define FXAA_QUALITY_P1 1.5
              #define FXAA_QUALITY_P2 3.0
              #define FXAA_QUALITY_P3 12.0
          #endif
          /*--------------------------------------------------------------------------*/
          #if (FXAA_QUALITY_PRESET == 12)
              #define FXAA_QUALITY_PS 5
              #define FXAA_QUALITY_P0 1.0
              #define FXAA_QUALITY_P1 1.5
              #define FXAA_QUALITY_P2 2.0
              #define FXAA_QUALITY_P3 4.0
              #define FXAA_QUALITY_P4 12.0
          #endif
          /*--------------------------------------------------------------------------*/
          #if (FXAA_QUALITY_PRESET == 13)
              #define FXAA_QUALITY_PS 6
              #define FXAA_QUALITY_P0 1.0
              #define FXAA_QUALITY_P1 1.5
              #define FXAA_QUALITY_P2 2.0
              #define FXAA_QUALITY_P3 2.0
              #define FXAA_QUALITY_P4 4.0
              #define FXAA_QUALITY_P5 12.0
          #endif
          /*--------------------------------------------------------------------------*/
          #if (FXAA_QUALITY_PRESET == 14)
              #define FXAA_QUALITY_PS 7
              #define FXAA_QUALITY_P0 1.0
              #define FXAA_QUALITY_P1 1.5
              #define FXAA_QUALITY_P2 2.0
              #define FXAA_QUALITY_P3 2.0
              #define FXAA_QUALITY_P4 2.0
              #define FXAA_QUALITY_P5 4.0
              #define FXAA_QUALITY_P6 12.0
          #endif
          /*--------------------------------------------------------------------------*/
          #if (FXAA_QUALITY_PRESET == 15)
              #define FXAA_QUALITY_PS 8
              #define FXAA_QUALITY_P0 1.0
              #define FXAA_QUALITY_P1 1.5
              #define FXAA_QUALITY_P2 2.0
              #define FXAA_QUALITY_P3 2.0
              #define FXAA_QUALITY_P4 2.0
              #define FXAA_QUALITY_P5 2.0
              #define FXAA_QUALITY_P6 4.0
              #define FXAA_QUALITY_P7 12.0
          #endif
      
          /*============================================================================
                              FXAA QUALITY - LOW DITHER PRESETS
          ============================================================================*/
          #if (FXAA_QUALITY_PRESET == 20)
              #define FXAA_QUALITY_PS 3
              #define FXAA_QUALITY_P0 1.5
              #define FXAA_QUALITY_P1 2.0
              #define FXAA_QUALITY_P2 8.0
          #endif
          /*--------------------------------------------------------------------------*/
          #if (FXAA_QUALITY_PRESET == 21)
              #define FXAA_QUALITY_PS 4
              #define FXAA_QUALITY_P0 1.0
              #define FXAA_QUALITY_P1 1.5
              #define FXAA_QUALITY_P2 2.0
              #define FXAA_QUALITY_P3 8.0
          #endif
          /*--------------------------------------------------------------------------*/
          #if (FXAA_QUALITY_PRESET == 22)
              #define FXAA_QUALITY_PS 5
              #define FXAA_QUALITY_P0 1.0
              #define FXAA_QUALITY_P1 1.5
              #define FXAA_QUALITY_P2 2.0
              #define FXAA_QUALITY_P3 2.0
              #define FXAA_QUALITY_P4 8.0
          #endif
          /*--------------------------------------------------------------------------*/
          #if (FXAA_QUALITY_PRESET == 23)
              #define FXAA_QUALITY_PS 6
              #define FXAA_QUALITY_P0 1.0
              #define FXAA_QUALITY_P1 1.5
              #define FXAA_QUALITY_P2 2.0
              #define FXAA_QUALITY_P3 2.0
              #define FXAA_QUALITY_P4 2.0
              #define FXAA_QUALITY_P5 8.0
          #endif
          /*--------------------------------------------------------------------------*/
          #if (FXAA_QUALITY_PRESET == 24)
              #define FXAA_QUALITY_PS 7
              #define FXAA_QUALITY_P0 1.0
              #define FXAA_QUALITY_P1 1.5
              #define FXAA_QUALITY_P2 2.0
              #define FXAA_QUALITY_P3 2.0
              #define FXAA_QUALITY_P4 2.0
              #define FXAA_QUALITY_P5 3.0
              #define FXAA_QUALITY_P6 8.0
          #endif
          /*--------------------------------------------------------------------------*/
          #if (FXAA_QUALITY_PRESET == 25)
              #define FXAA_QUALITY_PS 8
              #define FXAA_QUALITY_P0 1.0
              #define FXAA_QUALITY_P1 1.5
              #define FXAA_QUALITY_P2 2.0
              #define FXAA_QUALITY_P3 2.0
              #define FXAA_QUALITY_P4 2.0
              #define FXAA_QUALITY_P5 2.0
              #define FXAA_QUALITY_P6 4.0
              #define FXAA_QUALITY_P7 8.0
          #endif
          /*--------------------------------------------------------------------------*/
          #if (FXAA_QUALITY_PRESET == 26)
              #define FXAA_QUALITY_PS 9
              #define FXAA_QUALITY_P0 1.0
              #define FXAA_QUALITY_P1 1.5
              #define FXAA_QUALITY_P2 2.0
              #define FXAA_QUALITY_P3 2.0
              #define FXAA_QUALITY_P4 2.0
              #define FXAA_QUALITY_P5 2.0
              #define FXAA_QUALITY_P6 2.0
              #define FXAA_QUALITY_P7 4.0
              #define FXAA_QUALITY_P8 8.0
          #endif
          /*--------------------------------------------------------------------------*/
          #if (FXAA_QUALITY_PRESET == 27)
              #define FXAA_QUALITY_PS 10
              #define FXAA_QUALITY_P0 1.0
              #define FXAA_QUALITY_P1 1.5
              #define FXAA_QUALITY_P2 2.0
              #define FXAA_QUALITY_P3 2.0
              #define FXAA_QUALITY_P4 2.0
              #define FXAA_QUALITY_P5 2.0
              #define FXAA_QUALITY_P6 2.0
              #define FXAA_QUALITY_P7 2.0
              #define FXAA_QUALITY_P8 4.0
              #define FXAA_QUALITY_P9 8.0
          #endif
          /*--------------------------------------------------------------------------*/
          #if (FXAA_QUALITY_PRESET == 28)
              #define FXAA_QUALITY_PS 11
              #define FXAA_QUALITY_P0 1.0
              #define FXAA_QUALITY_P1 1.5
              #define FXAA_QUALITY_P2 2.0
              #define FXAA_QUALITY_P3 2.0
              #define FXAA_QUALITY_P4 2.0
              #define FXAA_QUALITY_P5 2.0
              #define FXAA_QUALITY_P6 2.0
              #define FXAA_QUALITY_P7 2.0
              #define FXAA_QUALITY_P8 2.0
              #define FXAA_QUALITY_P9 4.0
              #define FXAA_QUALITY_P10 8.0
          #endif
          /*--------------------------------------------------------------------------*/
          #if (FXAA_QUALITY_PRESET == 29)
              #define FXAA_QUALITY_PS 12
              #define FXAA_QUALITY_P0 1.0
              #define FXAA_QUALITY_P1 1.5
              #define FXAA_QUALITY_P2 2.0
              #define FXAA_QUALITY_P3 2.0
              #define FXAA_QUALITY_P4 2.0
              #define FXAA_QUALITY_P5 2.0
              #define FXAA_QUALITY_P6 2.0
              #define FXAA_QUALITY_P7 2.0
              #define FXAA_QUALITY_P8 2.0
              #define FXAA_QUALITY_P9 2.0
              #define FXAA_QUALITY_P10 4.0
              #define FXAA_QUALITY_P11 8.0
          #endif
      
          /*============================================================================
                              FXAA QUALITY - EXTREME QUALITY
          ============================================================================*/
          #if (FXAA_QUALITY_PRESET == 39)
              #define FXAA_QUALITY_PS 12
              #define FXAA_QUALITY_P0 1.0
              #define FXAA_QUALITY_P1 1.0
              #define FXAA_QUALITY_P2 1.0
              #define FXAA_QUALITY_P3 1.0
              #define FXAA_QUALITY_P4 1.0
              #define FXAA_QUALITY_P5 1.5
              #define FXAA_QUALITY_P6 2.0
              #define FXAA_QUALITY_P7 2.0
              #define FXAA_QUALITY_P8 2.0
              #define FXAA_QUALITY_P9 2.0
              #define FXAA_QUALITY_P10 4.0
              #define FXAA_QUALITY_P11 8.0
          #endif
      
      
      
          /*============================================================================
      
                                          API PORTING
      
          ============================================================================*/
          #if (FXAA_GLSL_100 == 1) || (FXAA_GLSL_120 == 1) || (FXAA_GLSL_130 == 1)
              #define FxaaBool bool
              #define FxaaDiscard discard
              #define FxaaFloat float
              #define FxaaFloat2 vec2
              #define FxaaFloat3 vec3
              #define FxaaFloat4 vec4
              #define FxaaHalf float
              #define FxaaHalf2 vec2
              #define FxaaHalf3 vec3
              #define FxaaHalf4 vec4
              #define FxaaInt2 ivec2
              #define FxaaSat(x) clamp(x, 0.0, 1.0)
              #define FxaaTex sampler2D
          #else
              #define FxaaBool bool
              #define FxaaDiscard clip(-1)
              #define FxaaFloat float
              #define FxaaFloat2 float2
              #define FxaaFloat3 float3
              #define FxaaFloat4 float4
              #define FxaaHalf half
              #define FxaaHalf2 half2
              #define FxaaHalf3 half3
              #define FxaaHalf4 half4
              #define FxaaSat(x) saturate(x)
          #endif
          /*--------------------------------------------------------------------------*/
          #if (FXAA_GLSL_100 == 1)
            #define FxaaTexTop(t, p) texture(t, p, 0.0)
            #define FxaaTexOff(t, p, o, r) texture(t, p + (o * r), 0.0)
          #endif
          /*--------------------------------------------------------------------------*/
          #if (FXAA_GLSL_120 == 1)
              // Requires,
              //  #version 120
              // And at least,
              //  #extension GL_EXT_gpu_shader4 : enable
              //  (or set FXAA_FAST_PIXEL_OFFSET 1 to work like DX9)
              #define FxaaTexTop(t, p) textureLod(t, p, 0.0)
              #if (FXAA_FAST_PIXEL_OFFSET == 1)
                  #define FxaaTexOff(t, p, o, r) textureLodOffset(t, p, 0.0, o)
              #else
                  #define FxaaTexOff(t, p, o, r) textureLod(t, p + (o * r), 0.0)
              #endif
              #if (FXAA_GATHER4_ALPHA == 1)
                  // use #extension GL_ARB_gpu_shader5 : enable
                  #define FxaaTexAlpha4(t, p) textureGather(t, p, 3)
                  #define FxaaTexOffAlpha4(t, p, o) textureGatherOffset(t, p, o, 3)
                  #define FxaaTexGreen4(t, p) textureGather(t, p, 1)
                  #define FxaaTexOffGreen4(t, p, o) textureGatherOffset(t, p, o, 1)
              #endif
          #endif
          /*--------------------------------------------------------------------------*/
          #if (FXAA_GLSL_130 == 1)
              // Requires "#version 130" or better
              #define FxaaTexTop(t, p) textureLod(t, p, 0.0)
              #define FxaaTexOff(t, p, o, r) textureLodOffset(t, p, 0.0, o)
              #if (FXAA_GATHER4_ALPHA == 1)
                  // use #extension GL_ARB_gpu_shader5 : enable
                  #define FxaaTexAlpha4(t, p) textureGather(t, p, 3)
                  #define FxaaTexOffAlpha4(t, p, o) textureGatherOffset(t, p, o, 3)
                  #define FxaaTexGreen4(t, p) textureGather(t, p, 1)
                  #define FxaaTexOffGreen4(t, p, o) textureGatherOffset(t, p, o, 1)
              #endif
          #endif
          /*--------------------------------------------------------------------------*/
          #if (FXAA_HLSL_3 == 1)
              #define FxaaInt2 float2
              #define FxaaTex sampler2D
              #define FxaaTexTop(t, p) tex2Dlod(t, float4(p, 0.0, 0.0))
              #define FxaaTexOff(t, p, o, r) tex2Dlod(t, float4(p + (o * r), 0, 0))
          #endif
          /*--------------------------------------------------------------------------*/
          #if (FXAA_HLSL_4 == 1)
              #define FxaaInt2 int2
              struct FxaaTex { SamplerState smpl; texture tex; };
              #define FxaaTexTop(t, p) t.tex.SampleLevel(t.smpl, p, 0.0)
              #define FxaaTexOff(t, p, o, r) t.tex.SampleLevel(t.smpl, p, 0.0, o)
          #endif
          /*--------------------------------------------------------------------------*/
          #if (FXAA_HLSL_5 == 1)
              #define FxaaInt2 int2
              struct FxaaTex { SamplerState smpl; texture tex; };
              #define FxaaTexTop(t, p) t.tex.SampleLevel(t.smpl, p, 0.0)
              #define FxaaTexOff(t, p, o, r) t.tex.SampleLevel(t.smpl, p, 0.0, o)
              #define FxaaTexAlpha4(t, p) t.tex.GatherAlpha(t.smpl, p)
              #define FxaaTexOffAlpha4(t, p, o) t.tex.GatherAlpha(t.smpl, p, o)
              #define FxaaTexGreen4(t, p) t.tex.GatherGreen(t.smpl, p)
              #define FxaaTexOffGreen4(t, p, o) t.tex.GatherGreen(t.smpl, p, o)
          #endif
      
      
          /*============================================================================
                            GREEN AS LUMA OPTION SUPPORT FUNCTION
          ============================================================================*/
          #if (FXAA_GREEN_AS_LUMA == 0)
              FxaaFloat FxaaLuma(FxaaFloat4 rgba) { return rgba.w; }
          #else
              FxaaFloat FxaaLuma(FxaaFloat4 rgba) { return rgba.y; }
          #endif
      
      
      
      
          /*============================================================================
      
                                      FXAA3 QUALITY - PC
      
          ============================================================================*/
          #if (FXAA_PC == 1)
          /*--------------------------------------------------------------------------*/
          FxaaFloat4 FxaaPixelShader(
              //
              // Use noperspective interpolation here (turn off perspective interpolation).
              // {xy} = center of pixel
              FxaaFloat2 pos,
              //
              // Used only for FXAA Console, and not used on the 360 version.
              // Use noperspective interpolation here (turn off perspective interpolation).
              // {xy_} = upper left of pixel
              // {_zw} = lower right of pixel
              FxaaFloat4 fxaaConsolePosPos,
              //
              // Input color texture.
              // {rgb_} = color in linear or perceptual color space
              // if (FXAA_GREEN_AS_LUMA == 0)
              //     {__a} = luma in perceptual color space (not linear)
              FxaaTex tex,
              //
              // Only used on the optimized 360 version of FXAA Console.
              // For everything but 360, just use the same input here as for "tex".
              // For 360, same texture, just alias with a 2nd sampler.
              // This sampler needs to have an exponent bias of -1.
              FxaaTex fxaaConsole360TexExpBiasNegOne,
              //
              // Only used on the optimized 360 version of FXAA Console.
              // For everything but 360, just use the same input here as for "tex".
              // For 360, same texture, just alias with a 3nd sampler.
              // This sampler needs to have an exponent bias of -2.
              FxaaTex fxaaConsole360TexExpBiasNegTwo,
              //
              // Only used on FXAA Quality.
              // This must be from a constant/uniform.
              // {x_} = 1.0/screenWidthInPixels
              // {_y} = 1.0/screenHeightInPixels
              FxaaFloat2 fxaaQualityRcpFrame,
              //
              // Only used on FXAA Console.
              // This must be from a constant/uniform.
              // This effects sub-pixel AA quality and inversely sharpness.
              //   Where N ranges between,
              //     N = 0.50 (default)
              //     N = 0.33 (sharper)
              // {x__} = -N/screenWidthInPixels
              // {_y_} = -N/screenHeightInPixels
              // {_z_} =  N/screenWidthInPixels
              // {__w} =  N/screenHeightInPixels
              FxaaFloat4 fxaaConsoleRcpFrameOpt,
              //
              // Only used on FXAA Console.
              // Not used on 360, but used on PS3 and PC.
              // This must be from a constant/uniform.
              // {x__} = -2.0/screenWidthInPixels
              // {_y_} = -2.0/screenHeightInPixels
              // {_z_} =  2.0/screenWidthInPixels
              // {__w} =  2.0/screenHeightInPixels
              FxaaFloat4 fxaaConsoleRcpFrameOpt2,
              //
              // Only used on FXAA Console.
              // Only used on 360 in place of fxaaConsoleRcpFrameOpt2.
              // This must be from a constant/uniform.
              // {x__} =  8.0/screenWidthInPixels
              // {_y_} =  8.0/screenHeightInPixels
              // {_z_} = -4.0/screenWidthInPixels
              // {__w} = -4.0/screenHeightInPixels
              FxaaFloat4 fxaaConsole360RcpFrameOpt2,
              //
              // Only used on FXAA Quality.
              // This used to be the FXAA_QUALITY_SUBPIX define.
              // It is here now to allow easier tuning.
              // Choose the amount of sub-pixel aliasing removal.
              // This can effect sharpness.
              //   1.00 - upper limit (softer)
              //   0.75 - default amount of filtering
              //   0.50 - lower limit (sharper, less sub-pixel aliasing removal)
              //   0.25 - almost off
              //   0.00 - completely off
              FxaaFloat fxaaQualitySubpix,
              //
              // Only used on FXAA Quality.
              // This used to be the FXAA_QUALITY_EDGE_THRESHOLD define.
              // It is here now to allow easier tuning.
              // The minimum amount of local contrast required to apply algorithm.
              //   0.333 - too little (faster)
              //   0.250 - low quality
              //   0.166 - default
              //   0.125 - high quality
              //   0.063 - overkill (slower)
              FxaaFloat fxaaQualityEdgeThreshold,
              //
              // Only used on FXAA Quality.
              // This used to be the FXAA_QUALITY_EDGE_THRESHOLD_MIN define.
              // It is here now to allow easier tuning.
              // Trims the algorithm from processing darks.
              //   0.0833 - upper limit (default, the start of visible unfiltered edges)
              //   0.0625 - high quality (faster)
              //   0.0312 - visible limit (slower)
              // Special notes when using FXAA_GREEN_AS_LUMA,
              //   Likely want to set this to zero.
              //   As colors that are mostly not-green
              //   will appear very dark in the green channel!
              //   Tune by looking at mostly non-green content,
              //   then start at zero and increase until aliasing is a problem.
              FxaaFloat fxaaQualityEdgeThresholdMin,
              //
              // Only used on FXAA Console.
              // This used to be the FXAA_CONSOLE_EDGE_SHARPNESS define.
              // It is here now to allow easier tuning.
              // This does not effect PS3, as this needs to be compiled in.
              //   Use FXAA_CONSOLE_PS3_EDGE_SHARPNESS for PS3.
              //   Due to the PS3 being ALU bound,
              //   there are only three safe values here: 2 and 4 and 8.
              //   These options use the shaders ability to a free *|/ by 2|4|8.
              // For all other platforms can be a non-power of two.
              //   8.0 is sharper (default!!!)
              //   4.0 is softer
              //   2.0 is really soft (good only for vector graphics inputs)
              FxaaFloat fxaaConsoleEdgeSharpness,
              //
              // Only used on FXAA Console.
              // This used to be the FXAA_CONSOLE_EDGE_THRESHOLD define.
              // It is here now to allow easier tuning.
              // This does not effect PS3, as this needs to be compiled in.
              //   Use FXAA_CONSOLE_PS3_EDGE_THRESHOLD for PS3.
              //   Due to the PS3 being ALU bound,
              //   there are only two safe values here: 1/4 and 1/8.
              //   These options use the shaders ability to a free *|/ by 2|4|8.
              // The console setting has a different mapping than the quality setting.
              // Other platforms can use other values.
              //   0.125 leaves less aliasing, but is softer (default!!!)
              //   0.25 leaves more aliasing, and is sharper
              FxaaFloat fxaaConsoleEdgeThreshold,
              //
              // Only used on FXAA Console.
              // This used to be the FXAA_CONSOLE_EDGE_THRESHOLD_MIN define.
              // It is here now to allow easier tuning.
              // Trims the algorithm from processing darks.
              // The console setting has a different mapping than the quality setting.
              // This only applies when FXAA_EARLY_EXIT is 1.
              // This does not apply to PS3,
              // PS3 was simplified to avoid more shader instructions.
              //   0.06 - faster but more aliasing in darks
              //   0.05 - default
              //   0.04 - slower and less aliasing in darks
              // Special notes when using FXAA_GREEN_AS_LUMA,
              //   Likely want to set this to zero.
              //   As colors that are mostly not-green
              //   will appear very dark in the green channel!
              //   Tune by looking at mostly non-green content,
              //   then start at zero and increase until aliasing is a problem.
              FxaaFloat fxaaConsoleEdgeThresholdMin,
              //
              // Extra constants for 360 FXAA Console only.
              // Use zeros or anything else for other platforms.
              // These must be in physical constant registers and NOT immediates.
              // Immediates will result in compiler un-optimizing.
              // {xyzw} = float4(1.0, -1.0, 0.25, -0.25)
              FxaaFloat4 fxaaConsole360ConstDir
          ) {
          /*--------------------------------------------------------------------------*/
              FxaaFloat2 posM;
              posM.x = pos.x;
              posM.y = pos.y;
              #if (FXAA_GATHER4_ALPHA == 1)
                  #if (FXAA_DISCARD == 0)
                      FxaaFloat4 rgbyM = FxaaTexTop(tex, posM);
                      #if (FXAA_GREEN_AS_LUMA == 0)
                          #define lumaM rgbyM.w
                      #else
                          #define lumaM rgbyM.y
                      #endif
                  #endif
                  #if (FXAA_GREEN_AS_LUMA == 0)
                      FxaaFloat4 luma4A = FxaaTexAlpha4(tex, posM);
                      FxaaFloat4 luma4B = FxaaTexOffAlpha4(tex, posM, FxaaInt2(-1, -1));
                  #else
                      FxaaFloat4 luma4A = FxaaTexGreen4(tex, posM);
                      FxaaFloat4 luma4B = FxaaTexOffGreen4(tex, posM, FxaaInt2(-1, -1));
                  #endif
                  #if (FXAA_DISCARD == 1)
                      #define lumaM luma4A.w
                  #endif
                  #define lumaE luma4A.z
                  #define lumaS luma4A.x
                  #define lumaSE luma4A.y
                  #define lumaNW luma4B.w
                  #define lumaN luma4B.z
                  #define lumaW luma4B.x
              #else
                  FxaaFloat4 rgbyM = FxaaTexTop(tex, posM);
                  #if (FXAA_GREEN_AS_LUMA == 0)
                      #define lumaM rgbyM.w
                  #else
                      #define lumaM rgbyM.y
                  #endif
                  #if (FXAA_GLSL_100 == 1)
                    FxaaFloat lumaS = FxaaLuma(FxaaTexOff(tex, posM, FxaaFloat2( 0.0, 1.0), fxaaQualityRcpFrame.xy));
                    FxaaFloat lumaE = FxaaLuma(FxaaTexOff(tex, posM, FxaaFloat2( 1.0, 0.0), fxaaQualityRcpFrame.xy));
                    FxaaFloat lumaN = FxaaLuma(FxaaTexOff(tex, posM, FxaaFloat2( 0.0,-1.0), fxaaQualityRcpFrame.xy));
                    FxaaFloat lumaW = FxaaLuma(FxaaTexOff(tex, posM, FxaaFloat2(-1.0, 0.0), fxaaQualityRcpFrame.xy));
                  #else
                    FxaaFloat lumaS = FxaaLuma(FxaaTexOff(tex, posM, FxaaInt2( 0, 1), fxaaQualityRcpFrame.xy));
                    FxaaFloat lumaE = FxaaLuma(FxaaTexOff(tex, posM, FxaaInt2( 1, 0), fxaaQualityRcpFrame.xy));
                    FxaaFloat lumaN = FxaaLuma(FxaaTexOff(tex, posM, FxaaInt2( 0,-1), fxaaQualityRcpFrame.xy));
                    FxaaFloat lumaW = FxaaLuma(FxaaTexOff(tex, posM, FxaaInt2(-1, 0), fxaaQualityRcpFrame.xy));
                  #endif
              #endif
          /*--------------------------------------------------------------------------*/
              FxaaFloat maxSM = max(lumaS, lumaM);
              FxaaFloat minSM = min(lumaS, lumaM);
              FxaaFloat maxESM = max(lumaE, maxSM);
              FxaaFloat minESM = min(lumaE, minSM);
              FxaaFloat maxWN = max(lumaN, lumaW);
              FxaaFloat minWN = min(lumaN, lumaW);
              FxaaFloat rangeMax = max(maxWN, maxESM);
              FxaaFloat rangeMin = min(minWN, minESM);
              FxaaFloat rangeMaxScaled = rangeMax * fxaaQualityEdgeThreshold;
              FxaaFloat range = rangeMax - rangeMin;
              FxaaFloat rangeMaxClamped = max(fxaaQualityEdgeThresholdMin, rangeMaxScaled);
              FxaaBool earlyExit = range < rangeMaxClamped;
          /*--------------------------------------------------------------------------*/
              if(earlyExit)
                  #if (FXAA_DISCARD == 1)
                      FxaaDiscard;
                  #else
                      return rgbyM;
                  #endif
          /*--------------------------------------------------------------------------*/
              #if (FXAA_GATHER4_ALPHA == 0)
                  #if (FXAA_GLSL_100 == 1)
                    FxaaFloat lumaNW = FxaaLuma(FxaaTexOff(tex, posM, FxaaFloat2(-1.0,-1.0), fxaaQualityRcpFrame.xy));
                    FxaaFloat lumaSE = FxaaLuma(FxaaTexOff(tex, posM, FxaaFloat2( 1.0, 1.0), fxaaQualityRcpFrame.xy));
                    FxaaFloat lumaNE = FxaaLuma(FxaaTexOff(tex, posM, FxaaFloat2( 1.0,-1.0), fxaaQualityRcpFrame.xy));
                    FxaaFloat lumaSW = FxaaLuma(FxaaTexOff(tex, posM, FxaaFloat2(-1.0, 1.0), fxaaQualityRcpFrame.xy));
                  #else
                    FxaaFloat lumaNW = FxaaLuma(FxaaTexOff(tex, posM, FxaaInt2(-1,-1), fxaaQualityRcpFrame.xy));
                    FxaaFloat lumaSE = FxaaLuma(FxaaTexOff(tex, posM, FxaaInt2( 1, 1), fxaaQualityRcpFrame.xy));
                    FxaaFloat lumaNE = FxaaLuma(FxaaTexOff(tex, posM, FxaaInt2( 1,-1), fxaaQualityRcpFrame.xy));
                    FxaaFloat lumaSW = FxaaLuma(FxaaTexOff(tex, posM, FxaaInt2(-1, 1), fxaaQualityRcpFrame.xy));
                  #endif
              #else
                  FxaaFloat lumaNE = FxaaLuma(FxaaTexOff(tex, posM, FxaaInt2(1, -1), fxaaQualityRcpFrame.xy));
                  FxaaFloat lumaSW = FxaaLuma(FxaaTexOff(tex, posM, FxaaInt2(-1, 1), fxaaQualityRcpFrame.xy));
              #endif
          /*--------------------------------------------------------------------------*/
              FxaaFloat lumaNS = lumaN + lumaS;
              FxaaFloat lumaWE = lumaW + lumaE;
              FxaaFloat subpixRcpRange = 1.0/range;
              FxaaFloat subpixNSWE = lumaNS + lumaWE;
              FxaaFloat edgeHorz1 = (-2.0 * lumaM) + lumaNS;
              FxaaFloat edgeVert1 = (-2.0 * lumaM) + lumaWE;
          /*--------------------------------------------------------------------------*/
              FxaaFloat lumaNESE = lumaNE + lumaSE;
              FxaaFloat lumaNWNE = lumaNW + lumaNE;
              FxaaFloat edgeHorz2 = (-2.0 * lumaE) + lumaNESE;
              FxaaFloat edgeVert2 = (-2.0 * lumaN) + lumaNWNE;
          /*--------------------------------------------------------------------------*/
              FxaaFloat lumaNWSW = lumaNW + lumaSW;
              FxaaFloat lumaSWSE = lumaSW + lumaSE;
              FxaaFloat edgeHorz4 = (abs(edgeHorz1) * 2.0) + abs(edgeHorz2);
              FxaaFloat edgeVert4 = (abs(edgeVert1) * 2.0) + abs(edgeVert2);
              FxaaFloat edgeHorz3 = (-2.0 * lumaW) + lumaNWSW;
              FxaaFloat edgeVert3 = (-2.0 * lumaS) + lumaSWSE;
              FxaaFloat edgeHorz = abs(edgeHorz3) + edgeHorz4;
              FxaaFloat edgeVert = abs(edgeVert3) + edgeVert4;
          /*--------------------------------------------------------------------------*/
              FxaaFloat subpixNWSWNESE = lumaNWSW + lumaNESE;
              FxaaFloat lengthSign = fxaaQualityRcpFrame.x;
              FxaaBool horzSpan = edgeHorz >= edgeVert;
              FxaaFloat subpixA = subpixNSWE * 2.0 + subpixNWSWNESE;
          /*--------------------------------------------------------------------------*/
              if(!horzSpan) lumaN = lumaW;
              if(!horzSpan) lumaS = lumaE;
              if(horzSpan) lengthSign = fxaaQualityRcpFrame.y;
              FxaaFloat subpixB = (subpixA * (1.0/12.0)) - lumaM;
          /*--------------------------------------------------------------------------*/
              FxaaFloat gradientN = lumaN - lumaM;
              FxaaFloat gradientS = lumaS - lumaM;
              FxaaFloat lumaNN = lumaN + lumaM;
              FxaaFloat lumaSS = lumaS + lumaM;
              FxaaBool pairN = abs(gradientN) >= abs(gradientS);
              FxaaFloat gradient = max(abs(gradientN), abs(gradientS));
              if(pairN) lengthSign = -lengthSign;
              FxaaFloat subpixC = FxaaSat(abs(subpixB) * subpixRcpRange);
          /*--------------------------------------------------------------------------*/
              FxaaFloat2 posB;
              posB.x = posM.x;
              posB.y = posM.y;
              FxaaFloat2 offNP;
              offNP.x = (!horzSpan) ? 0.0 : fxaaQualityRcpFrame.x;
              offNP.y = ( horzSpan) ? 0.0 : fxaaQualityRcpFrame.y;
              if(!horzSpan) posB.x += lengthSign * 0.5;
              if( horzSpan) posB.y += lengthSign * 0.5;
          /*--------------------------------------------------------------------------*/
              FxaaFloat2 posN;
              posN.x = posB.x - offNP.x * FXAA_QUALITY_P0;
              posN.y = posB.y - offNP.y * FXAA_QUALITY_P0;
              FxaaFloat2 posP;
              posP.x = posB.x + offNP.x * FXAA_QUALITY_P0;
              posP.y = posB.y + offNP.y * FXAA_QUALITY_P0;
              FxaaFloat subpixD = ((-2.0)*subpixC) + 3.0;
              FxaaFloat lumaEndN = FxaaLuma(FxaaTexTop(tex, posN));
              FxaaFloat subpixE = subpixC * subpixC;
              FxaaFloat lumaEndP = FxaaLuma(FxaaTexTop(tex, posP));
          /*--------------------------------------------------------------------------*/
              if(!pairN) lumaNN = lumaSS;
              FxaaFloat gradientScaled = gradient * 1.0/4.0;
              FxaaFloat lumaMM = lumaM - lumaNN * 0.5;
              FxaaFloat subpixF = subpixD * subpixE;
              FxaaBool lumaMLTZero = lumaMM < 0.0;
          /*--------------------------------------------------------------------------*/
              lumaEndN -= lumaNN * 0.5;
              lumaEndP -= lumaNN * 0.5;
              FxaaBool doneN = abs(lumaEndN) >= gradientScaled;
              FxaaBool doneP = abs(lumaEndP) >= gradientScaled;
              if(!doneN) posN.x -= offNP.x * FXAA_QUALITY_P1;
              if(!doneN) posN.y -= offNP.y * FXAA_QUALITY_P1;
              FxaaBool doneNP = (!doneN) || (!doneP);
              if(!doneP) posP.x += offNP.x * FXAA_QUALITY_P1;
              if(!doneP) posP.y += offNP.y * FXAA_QUALITY_P1;
          /*--------------------------------------------------------------------------*/
              if(doneNP) {
                  if(!doneN) lumaEndN = FxaaLuma(FxaaTexTop(tex, posN.xy));
                  if(!doneP) lumaEndP = FxaaLuma(FxaaTexTop(tex, posP.xy));
                  if(!doneN) lumaEndN = lumaEndN - lumaNN * 0.5;
                  if(!doneP) lumaEndP = lumaEndP - lumaNN * 0.5;
                  doneN = abs(lumaEndN) >= gradientScaled;
                  doneP = abs(lumaEndP) >= gradientScaled;
                  if(!doneN) posN.x -= offNP.x * FXAA_QUALITY_P2;
                  if(!doneN) posN.y -= offNP.y * FXAA_QUALITY_P2;
                  doneNP = (!doneN) || (!doneP);
                  if(!doneP) posP.x += offNP.x * FXAA_QUALITY_P2;
                  if(!doneP) posP.y += offNP.y * FXAA_QUALITY_P2;
          /*--------------------------------------------------------------------------*/
                  #if (FXAA_QUALITY_PS > 3)
                  if(doneNP) {
                      if(!doneN) lumaEndN = FxaaLuma(FxaaTexTop(tex, posN.xy));
                      if(!doneP) lumaEndP = FxaaLuma(FxaaTexTop(tex, posP.xy));
                      if(!doneN) lumaEndN = lumaEndN - lumaNN * 0.5;
                      if(!doneP) lumaEndP = lumaEndP - lumaNN * 0.5;
                      doneN = abs(lumaEndN) >= gradientScaled;
                      doneP = abs(lumaEndP) >= gradientScaled;
                      if(!doneN) posN.x -= offNP.x * FXAA_QUALITY_P3;
                      if(!doneN) posN.y -= offNP.y * FXAA_QUALITY_P3;
                      doneNP = (!doneN) || (!doneP);
                      if(!doneP) posP.x += offNP.x * FXAA_QUALITY_P3;
                      if(!doneP) posP.y += offNP.y * FXAA_QUALITY_P3;
          /*--------------------------------------------------------------------------*/
                      #if (FXAA_QUALITY_PS > 4)
                      if(doneNP) {
                          if(!doneN) lumaEndN = FxaaLuma(FxaaTexTop(tex, posN.xy));
                          if(!doneP) lumaEndP = FxaaLuma(FxaaTexTop(tex, posP.xy));
                          if(!doneN) lumaEndN = lumaEndN - lumaNN * 0.5;
                          if(!doneP) lumaEndP = lumaEndP - lumaNN * 0.5;
                          doneN = abs(lumaEndN) >= gradientScaled;
                          doneP = abs(lumaEndP) >= gradientScaled;
                          if(!doneN) posN.x -= offNP.x * FXAA_QUALITY_P4;
                          if(!doneN) posN.y -= offNP.y * FXAA_QUALITY_P4;
                          doneNP = (!doneN) || (!doneP);
                          if(!doneP) posP.x += offNP.x * FXAA_QUALITY_P4;
                          if(!doneP) posP.y += offNP.y * FXAA_QUALITY_P4;
          /*--------------------------------------------------------------------------*/
                          #if (FXAA_QUALITY_PS > 5)
                          if(doneNP) {
                              if(!doneN) lumaEndN = FxaaLuma(FxaaTexTop(tex, posN.xy));
                              if(!doneP) lumaEndP = FxaaLuma(FxaaTexTop(tex, posP.xy));
                              if(!doneN) lumaEndN = lumaEndN - lumaNN * 0.5;
                              if(!doneP) lumaEndP = lumaEndP - lumaNN * 0.5;
                              doneN = abs(lumaEndN) >= gradientScaled;
                              doneP = abs(lumaEndP) >= gradientScaled;
                              if(!doneN) posN.x -= offNP.x * FXAA_QUALITY_P5;
                              if(!doneN) posN.y -= offNP.y * FXAA_QUALITY_P5;
                              doneNP = (!doneN) || (!doneP);
                              if(!doneP) posP.x += offNP.x * FXAA_QUALITY_P5;
                              if(!doneP) posP.y += offNP.y * FXAA_QUALITY_P5;
          /*--------------------------------------------------------------------------*/
                              #if (FXAA_QUALITY_PS > 6)
                              if(doneNP) {
                                  if(!doneN) lumaEndN = FxaaLuma(FxaaTexTop(tex, posN.xy));
                                  if(!doneP) lumaEndP = FxaaLuma(FxaaTexTop(tex, posP.xy));
                                  if(!doneN) lumaEndN = lumaEndN - lumaNN * 0.5;
                                  if(!doneP) lumaEndP = lumaEndP - lumaNN * 0.5;
                                  doneN = abs(lumaEndN) >= gradientScaled;
                                  doneP = abs(lumaEndP) >= gradientScaled;
                                  if(!doneN) posN.x -= offNP.x * FXAA_QUALITY_P6;
                                  if(!doneN) posN.y -= offNP.y * FXAA_QUALITY_P6;
                                  doneNP = (!doneN) || (!doneP);
                                  if(!doneP) posP.x += offNP.x * FXAA_QUALITY_P6;
                                  if(!doneP) posP.y += offNP.y * FXAA_QUALITY_P6;
          /*--------------------------------------------------------------------------*/
                                  #if (FXAA_QUALITY_PS > 7)
                                  if(doneNP) {
                                      if(!doneN) lumaEndN = FxaaLuma(FxaaTexTop(tex, posN.xy));
                                      if(!doneP) lumaEndP = FxaaLuma(FxaaTexTop(tex, posP.xy));
                                      if(!doneN) lumaEndN = lumaEndN - lumaNN * 0.5;
                                      if(!doneP) lumaEndP = lumaEndP - lumaNN * 0.5;
                                      doneN = abs(lumaEndN) >= gradientScaled;
                                      doneP = abs(lumaEndP) >= gradientScaled;
                                      if(!doneN) posN.x -= offNP.x * FXAA_QUALITY_P7;
                                      if(!doneN) posN.y -= offNP.y * FXAA_QUALITY_P7;
                                      doneNP = (!doneN) || (!doneP);
                                      if(!doneP) posP.x += offNP.x * FXAA_QUALITY_P7;
                                      if(!doneP) posP.y += offNP.y * FXAA_QUALITY_P7;
          /*--------------------------------------------------------------------------*/
              #if (FXAA_QUALITY_PS > 8)
              if(doneNP) {
                  if(!doneN) lumaEndN = FxaaLuma(FxaaTexTop(tex, posN.xy));
                  if(!doneP) lumaEndP = FxaaLuma(FxaaTexTop(tex, posP.xy));
                  if(!doneN) lumaEndN = lumaEndN - lumaNN * 0.5;
                  if(!doneP) lumaEndP = lumaEndP - lumaNN * 0.5;
                  doneN = abs(lumaEndN) >= gradientScaled;
                  doneP = abs(lumaEndP) >= gradientScaled;
                  if(!doneN) posN.x -= offNP.x * FXAA_QUALITY_P8;
                  if(!doneN) posN.y -= offNP.y * FXAA_QUALITY_P8;
                  doneNP = (!doneN) || (!doneP);
                  if(!doneP) posP.x += offNP.x * FXAA_QUALITY_P8;
                  if(!doneP) posP.y += offNP.y * FXAA_QUALITY_P8;
          /*--------------------------------------------------------------------------*/
                  #if (FXAA_QUALITY_PS > 9)
                  if(doneNP) {
                      if(!doneN) lumaEndN = FxaaLuma(FxaaTexTop(tex, posN.xy));
                      if(!doneP) lumaEndP = FxaaLuma(FxaaTexTop(tex, posP.xy));
                      if(!doneN) lumaEndN = lumaEndN - lumaNN * 0.5;
                      if(!doneP) lumaEndP = lumaEndP - lumaNN * 0.5;
                      doneN = abs(lumaEndN) >= gradientScaled;
                      doneP = abs(lumaEndP) >= gradientScaled;
                      if(!doneN) posN.x -= offNP.x * FXAA_QUALITY_P9;
                      if(!doneN) posN.y -= offNP.y * FXAA_QUALITY_P9;
                      doneNP = (!doneN) || (!doneP);
                      if(!doneP) posP.x += offNP.x * FXAA_QUALITY_P9;
                      if(!doneP) posP.y += offNP.y * FXAA_QUALITY_P9;
          /*--------------------------------------------------------------------------*/
                      #if (FXAA_QUALITY_PS > 10)
                      if(doneNP) {
                          if(!doneN) lumaEndN = FxaaLuma(FxaaTexTop(tex, posN.xy));
                          if(!doneP) lumaEndP = FxaaLuma(FxaaTexTop(tex, posP.xy));
                          if(!doneN) lumaEndN = lumaEndN - lumaNN * 0.5;
                          if(!doneP) lumaEndP = lumaEndP - lumaNN * 0.5;
                          doneN = abs(lumaEndN) >= gradientScaled;
                          doneP = abs(lumaEndP) >= gradientScaled;
                          if(!doneN) posN.x -= offNP.x * FXAA_QUALITY_P10;
                          if(!doneN) posN.y -= offNP.y * FXAA_QUALITY_P10;
                          doneNP = (!doneN) || (!doneP);
                          if(!doneP) posP.x += offNP.x * FXAA_QUALITY_P10;
                          if(!doneP) posP.y += offNP.y * FXAA_QUALITY_P10;
          /*--------------------------------------------------------------------------*/
                          #if (FXAA_QUALITY_PS > 11)
                          if(doneNP) {
                              if(!doneN) lumaEndN = FxaaLuma(FxaaTexTop(tex, posN.xy));
                              if(!doneP) lumaEndP = FxaaLuma(FxaaTexTop(tex, posP.xy));
                              if(!doneN) lumaEndN = lumaEndN - lumaNN * 0.5;
                              if(!doneP) lumaEndP = lumaEndP - lumaNN * 0.5;
                              doneN = abs(lumaEndN) >= gradientScaled;
                              doneP = abs(lumaEndP) >= gradientScaled;
                              if(!doneN) posN.x -= offNP.x * FXAA_QUALITY_P11;
                              if(!doneN) posN.y -= offNP.y * FXAA_QUALITY_P11;
                              doneNP = (!doneN) || (!doneP);
                              if(!doneP) posP.x += offNP.x * FXAA_QUALITY_P11;
                              if(!doneP) posP.y += offNP.y * FXAA_QUALITY_P11;
          /*--------------------------------------------------------------------------*/
                              #if (FXAA_QUALITY_PS > 12)
                              if(doneNP) {
                                  if(!doneN) lumaEndN = FxaaLuma(FxaaTexTop(tex, posN.xy));
                                  if(!doneP) lumaEndP = FxaaLuma(FxaaTexTop(tex, posP.xy));
                                  if(!doneN) lumaEndN = lumaEndN - lumaNN * 0.5;
                                  if(!doneP) lumaEndP = lumaEndP - lumaNN * 0.5;
                                  doneN = abs(lumaEndN) >= gradientScaled;
                                  doneP = abs(lumaEndP) >= gradientScaled;
                                  if(!doneN) posN.x -= offNP.x * FXAA_QUALITY_P12;
                                  if(!doneN) posN.y -= offNP.y * FXAA_QUALITY_P12;
                                  doneNP = (!doneN) || (!doneP);
                                  if(!doneP) posP.x += offNP.x * FXAA_QUALITY_P12;
                                  if(!doneP) posP.y += offNP.y * FXAA_QUALITY_P12;
          /*--------------------------------------------------------------------------*/
                              }
                              #endif
          /*--------------------------------------------------------------------------*/
                          }
                          #endif
          /*--------------------------------------------------------------------------*/
                      }
                      #endif
          /*--------------------------------------------------------------------------*/
                  }
                  #endif
          /*--------------------------------------------------------------------------*/
              }
              #endif
          /*--------------------------------------------------------------------------*/
                                  }
                                  #endif
          /*--------------------------------------------------------------------------*/
                              }
                              #endif
          /*--------------------------------------------------------------------------*/
                          }
                          #endif
          /*--------------------------------------------------------------------------*/
                      }
                      #endif
          /*--------------------------------------------------------------------------*/
                  }
                  #endif
          /*--------------------------------------------------------------------------*/
              }
          /*--------------------------------------------------------------------------*/
              FxaaFloat dstN = posM.x - posN.x;
              FxaaFloat dstP = posP.x - posM.x;
              if(!horzSpan) dstN = posM.y - posN.y;
              if(!horzSpan) dstP = posP.y - posM.y;
          /*--------------------------------------------------------------------------*/
              FxaaBool goodSpanN = (lumaEndN < 0.0) != lumaMLTZero;
              FxaaFloat spanLength = (dstP + dstN);
              FxaaBool goodSpanP = (lumaEndP < 0.0) != lumaMLTZero;
              FxaaFloat spanLengthRcp = 1.0/spanLength;
          /*--------------------------------------------------------------------------*/
              FxaaBool directionN = dstN < dstP;
              FxaaFloat dst = min(dstN, dstP);
              FxaaBool goodSpan = directionN ? goodSpanN : goodSpanP;
              FxaaFloat subpixG = subpixF * subpixF;
              FxaaFloat pixelOffset = (dst * (-spanLengthRcp)) + 0.5;
              FxaaFloat subpixH = subpixG * fxaaQualitySubpix;
          /*--------------------------------------------------------------------------*/
              FxaaFloat pixelOffsetGood = goodSpan ? pixelOffset : 0.0;
              FxaaFloat pixelOffsetSubpix = max(pixelOffsetGood, subpixH);
              if(!horzSpan) posM.x += pixelOffsetSubpix * lengthSign;
              if( horzSpan) posM.y += pixelOffsetSubpix * lengthSign;
              #if (FXAA_DISCARD == 1)
                  return FxaaTexTop(tex, posM);
              #else
                  return FxaaFloat4(FxaaTexTop(tex, posM).xyz, lumaM);
              #endif
          }
          /*==========================================================================*/
          #endif
      
          void main() {
            fragColor = FxaaPixelShader(
              v_texCoord,
              vec4(0.0),
              u_canvas,
              u_canvas,
              u_canvas,
              u_resolution,
              vec4(0.0),
              vec4(0.0),
              vec4(0.0),
              0.75,
              0.166,
              0.0833,
              0.0,
              0.0,
              0.0,
              vec4(0.0)
            );
      
            // TODO avoid querying texture twice for same texel
            fragColor.a = texture(u_canvas, v_texCoord).a;
          }
          `,
  },
  smaaEdges: {
    vert: `#version 300 es          
          in vec2 a_position;
          in vec2 a_texCoord;

          uniform vec2 u_resolution;
          
          out vec2 v_texCoord;
          out vec4 v_offset[ 3 ];

          void SMAAEdgeDetectionVS( vec2 texcoord ) {
            v_offset[ 0 ] = texcoord.xyxy + u_resolution.xyxy * vec4( -1.0, 0.0, 0.0,  1.0 ); // WebGL port note: Changed sign in W component
            v_offset[ 1 ] = texcoord.xyxy + u_resolution.xyxy * vec4(  1.0, 0.0, 0.0, -1.0 ); // WebGL port note: Changed sign in W component
            v_offset[ 2 ] = texcoord.xyxy + u_resolution.xyxy * vec4( -2.0, 0.0, 0.0,  2.0 ); // WebGL port note: Changed sign in W component
          }
          
          void main() {
            // convert the rectangle from pixels to 0.0 to 1.0
            vec2 zeroToOne = a_position / u_resolution;
          
            // convert from 0->1 to 0->2
            vec2 zeroToTwo = zeroToOne * 2.0;
          
            // convert from 0->2 to -1->+1 (clipspace)
            vec2 clipSpace = zeroToTwo - 1.0;
          
            gl_Position = vec4(clipSpace, 0, 1);
          
            // pass the texCoord to the fragment shader
            // The GPU will interpolate pPM value between points.
            v_texCoord = a_texCoord;
            SMAAEdgeDetectionVS( v_texCoord );
          }            
          `,
    frag: `#version 300 es      
            precision highp float;

            #ifndef SMAA_THRESHOLD
            #define SMAA_THRESHOLD 0.1
            #endif

            #ifndef SMAA_LOCAL_CONTRAST_ADAPTATION_FACTOR
            #define SMAA_LOCAL_CONTRAST_ADAPTATION_FACTOR 2.0
            #endif

            uniform sampler2D u_canvas;

            in vec2 v_texCoord;
            in vec4 v_offset[ 3 ];

            out vec4 fragColor;

            void main() {
              // Calculate the threshold:
              vec2 threshold = vec2(SMAA_THRESHOLD);

              // Calculate color deltas:
              vec4 delta;
              vec3 c = texture(u_canvas, v_texCoord).rgb;

              vec3 cLeft = texture(u_canvas, v_offset[0].xy).rgb;
              vec3 t = abs(c - cLeft);
              delta.x = max(max(t.r, t.g), t.b);

              vec3 cTop  = texture(u_canvas, v_offset[0].zw).rgb;
              t = abs(c - cTop);
              delta.y = max(max(t.r, t.g), t.b);

              // We do the usual threshold:
              vec2 edges = step(threshold, delta.xy);

              // Then discard if there is no edge:
              if (dot(edges, vec2(1.0, 1.0)) == 0.0)
                  discard;

              // Calculate right and bottom deltas:
              vec3 cRight = texture(u_canvas, v_offset[1].xy).rgb;
              t = abs(c - cRight);
              delta.z = max(max(t.r, t.g), t.b);

              vec3 cBottom  = texture(u_canvas, v_offset[1].zw).rgb;
              t = abs(c - cBottom);
              delta.w = max(max(t.r, t.g), t.b);

              // Calculate the maximum delta in the direct neighborhood:
              vec2 maxDelta = max(delta.xy, delta.zw);

              // Calculate left-left and top-top deltas:
              vec3 cLeftLeft  = texture(u_canvas, v_offset[2].xy).rgb;
              t = abs(c - cLeftLeft);
              delta.z = max(max(t.r, t.g), t.b);

              vec3 cTopTop = texture(u_canvas, v_offset[2].zw).rgb;
              t = abs(c - cTopTop);
              delta.w = max(max(t.r, t.g), t.b);

              // Calculate the final maximum delta:
              maxDelta = max(maxDelta.xy, delta.zw);
              float finalDelta = max(maxDelta.x, maxDelta.y);

              // Local contrast adaptation:
              edges.xy *= step(finalDelta, SMAA_LOCAL_CONTRAST_ADAPTATION_FACTOR * delta.xy);

              fragColor = vec4(edges, 0.0, 1.0);
            }
          `,
  },
  smaaWeights: {
    vert: `#version 300 es          
          in vec2 a_position;
          in vec2 a_texCoord;

          uniform vec2 u_resolution;
          
          out vec2 v_texCoord;
          out vec4 v_offset[ 3 ];
          out vec2 v_pixcoord;

          #ifndef SMAA_MAX_SEARCH_STEPS 
            #define SMAA_MAX_SEARCH_STEPS 8
          #endif

          void SMAABlendingWeightCalculationVS( vec2 texcoord ) {
            v_pixcoord = texcoord / u_resolution;
            // We will use these offsets for the searches later on (see @PSEUDO_GATHER4):
            v_offset[ 0 ] = texcoord.xyxy + u_resolution.xyxy * vec4( -0.25, 0.125, 1.25, 0.125 ); // WebGL port note: Changed sign in Y and W components
            v_offset[ 1 ] = texcoord.xyxy + u_resolution.xyxy * vec4( -0.125, 0.25, -0.125, -1.25 ); // WebGL port note: Changed sign in Y and W components
            // And these for the searches, they indicate the ends of the loops:
            v_offset[ 2 ] = vec4( v_offset[ 0 ].xz, v_offset[ 1 ].yw ) + vec4( -2.0, 2.0, -2.0, 2.0 ) * u_resolution.xxyy * float( SMAA_MAX_SEARCH_STEPS );
          }
          
          void main() {
            // convert the rectangle from pixels to 0.0 to 1.0
            vec2 zeroToOne = a_position / u_resolution;
          
            // convert from 0->1 to 0->2
            vec2 zeroToTwo = zeroToOne * 2.0;
          
            // convert from 0->2 to -1->+1 (clipspace)
            vec2 clipSpace = zeroToTwo - 1.0;
          
            gl_Position = vec4(clipSpace, 0, 1);
          
            // pass the texCoord to the fragment shader
            // The GPU will interpolate pPM value between points.
            v_texCoord = a_texCoord;
            SMAABlendingWeightCalculationVS( v_texCoord );
          }            
          `,
    frag: `#version 300 es      
            precision highp float;
            precision highp int;

            // Defaults
            #ifndef SMAA_THRESHOLD
            #define SMAA_THRESHOLD 0.1
            #endif
            #ifndef SMAA_MAX_SEARCH_STEPS
            #define SMAA_MAX_SEARCH_STEPS 16
            #endif
            #ifndef SMAA_MAX_SEARCH_STEPS_DIAG
            #define SMAA_MAX_SEARCH_STEPS_DIAG 8
            #endif
            #ifndef SMAA_CORNER_ROUNDING
            #define SMAA_CORNER_ROUNDING 25
            #endif

            // Non-Configurable Defines
            #define SMAA_AREATEX_MAX_DISTANCE 16
            #define SMAA_AREATEX_MAX_DISTANCE_DIAG 20
            #define SMAA_AREATEX_PIXEL_SIZE (1.0 / vec2(160.0, 560.0))
            #define SMAA_AREATEX_SUBTEX_SIZE (1.0 / 7.0)
            #define SMAA_SEARCHTEX_SIZE vec2(66.0, 33.0)
            #define SMAA_SEARCHTEX_PACKED_SIZE vec2(64.0, 16.0)
            #define SMAA_CORNER_ROUNDING_NORM (float(SMAA_CORNER_ROUNDING) / 100.0)

            // Texture Access Defines
            #ifndef SMAA_AREATEX_SELECT
            #define SMAA_AREATEX_SELECT(sample) sample.rg
            #endif

            #ifndef SMAA_SEARCHTEX_SELECT
            #define SMAA_SEARCHTEX_SELECT(sample) sample.r
            #endif

            uniform vec2 u_resolution;

            uniform sampler2D u_canvas;
            uniform sampler2D u_area;
            uniform sampler2D u_search;

            in vec2 v_texCoord;
            in vec4 v_offset[3];
            in vec2 v_pixcoord;

            out vec4 fragColor;

            vec4 SMAA_RT_METRICS = vec4(1.0 / u_resolution.x, 1.0 / u_resolution.y, u_resolution.x, u_resolution.y);

            #define mad(a, b, c) (a * b + c)
            #define saturate(a) clamp(a, 0.0, 1.0)
            #define round(v) floor(v + 0.5)
            #define SMAASampleLevelZeroOffset(tex, coord, offset) texture(tex, coord + offset * SMAA_RT_METRICS.xy)

            /**
             * Conditional move:
             */
            void SMAAMovc(bvec2 cond, inout vec2 variable, vec2 value) {
              if (cond.x) variable.x = value.x;
              if (cond.y) variable.y = value.y;
            }

            void SMAAMovc(bvec4 cond, inout vec4 variable, vec4 value) {
              SMAAMovc(cond.xy, variable.xy, value.xy);
              SMAAMovc(cond.zw, variable.zw, value.zw);
            }

            /**
             * Allows to decode two binary values from a bilinear-filtered access.
             */
            vec2 SMAADecodeDiagBilinearAccess(vec2 e) {
              // Bilinear access for fetching 'e' have a 0.25 offset, and we are
              // interested in the R and G edges:
              //
              // +---G---+-------+
              // |   x o R   x   |
              // +-------+-------+
              //
              // Then, if one of these edge is enabled:
              //   Red:   (0.75 * X + 0.25 * 1) => 0.25 or 1.0
              //   Green: (0.75 * 1 + 0.25 * X) => 0.75 or 1.0
              //
              // This function will unpack the values (mad + mul + round):
              // wolframalpha.com: round(x * abs(5 * x - 5 * 0.75)) plot 0 to 1
              e.r = e.r * abs(5.0 * e.r - 5.0 * 0.75);
              return round(e);
            }

            vec4 SMAADecodeDiagBilinearAccess(vec4 e) {
              e.rb = e.rb * abs(5.0 * e.rb - 5.0 * 0.75);
              return round(e);
            }

            /**
             * These functions allows to perform diagonal pattern searches.
             */
            vec2 SMAASearchDiag1(sampler2D u_canvas, vec2 texcoord, vec2 dir, out vec2 e) {
              vec4 coord = vec4(texcoord, -1.0, 1.0);
              vec3 t = vec3(SMAA_RT_METRICS.xy, 1.0);

              for (int i = 0; i < SMAA_MAX_SEARCH_STEPS; i++) {
                if (!(coord.z < float(SMAA_MAX_SEARCH_STEPS_DIAG - 1) && coord.w > 0.9)) break;
                coord.xyz = mad(t, vec3(dir, 1.0), coord.xyz);
                e = texture(u_canvas, coord.xy).rg; // LinearSampler
                coord.w = dot(e, vec2(0.5, 0.5));
              }
              return coord.zw;
            }

            vec2 SMAASearchDiag2(sampler2D u_canvas, vec2 texcoord, vec2 dir, out vec2 e) {
              vec4 coord = vec4(texcoord, -1.0, 1.0);
              coord.x += 0.25 * SMAA_RT_METRICS.x; // See @SearchDiag2Optimization
              vec3 t = vec3(SMAA_RT_METRICS.xy, 1.0);

              for (int i = 0; i < SMAA_MAX_SEARCH_STEPS; i++) {
                if (!(coord.z < float(SMAA_MAX_SEARCH_STEPS_DIAG - 1) && coord.w > 0.9)) break;
                coord.xyz = mad(t, vec3(dir, 1.0), coord.xyz);

                // @SearchDiag2Optimization
                // Fetch both edges at once using bilinear filtering:
                e = texture(u_canvas, coord.xy).rg; // LinearSampler
                e = SMAADecodeDiagBilinearAccess(e);

                // Non-optimized version:
                // e.g = texture(u_canvas, coord.xy).g; // LinearSampler
                // e.r = SMAASampleLevelZeroOffset(u_canvas, coord.xy, vec2(1, 0)).r;

                coord.w = dot(e, vec2(0.5, 0.5));
              }
              return coord.zw;
            }

            /**
             * Similar to SMAAArea, this calculates the area corresponding to a certain
             * diagonal distance and crossing edges 'e'.
             */
            vec2 SMAAAreaDiag(sampler2D u_area, vec2 dist, vec2 e, float offset) {
              vec2 texcoord = mad(vec2(SMAA_AREATEX_MAX_DISTANCE_DIAG, SMAA_AREATEX_MAX_DISTANCE_DIAG), e, dist);

              // We do a scale and bias for mapping to texel space:
              texcoord = mad(SMAA_AREATEX_PIXEL_SIZE, texcoord, 0.5 * SMAA_AREATEX_PIXEL_SIZE);

              // Diagonal areas are on the second half of the texture:
              texcoord.x += 0.5;

              // Move to proper place, according to the subpixel offset:
              texcoord.y += SMAA_AREATEX_SUBTEX_SIZE * offset;

              // Do it!
              return SMAA_AREATEX_SELECT(texture(u_area, texcoord)); // LinearSampler
            }

            /**
             * This searches for diagonal patterns and returns the corresponding weights.
             */
            vec2 SMAACalculateDiagWeights(sampler2D u_canvas, sampler2D u_area, vec2 texcoord, vec2 e, vec4 subsampleIndices) {
              vec2 weights = vec2(0.0, 0.0);

              // Search for the line ends:
              vec4 d;
              vec2 end;
              if (e.r > 0.0) {
                  d.xz = SMAASearchDiag1(u_canvas, texcoord, vec2(-1.0,  1.0), end);
                  d.x += float(end.y > 0.9);
              } else
                  d.xz = vec2(0.0, 0.0);
              d.yw = SMAASearchDiag1(u_canvas, texcoord, vec2(1.0, -1.0), end);

              if (d.x + d.y > 2.0) { // d.x + d.y + 1 > 3
                // Fetch the crossing edges:
                vec4 coords = mad(vec4(-d.x + 0.25, d.x, d.y, -d.y - 0.25), SMAA_RT_METRICS.xyxy, texcoord.xyxy);
                vec4 c;
                c.xy = SMAASampleLevelZeroOffset(u_canvas, coords.xy, vec2(-1,  0)).rg;
                c.zw = SMAASampleLevelZeroOffset(u_canvas, coords.zw, vec2( 1,  0)).rg;
                c.yxwz = SMAADecodeDiagBilinearAccess(c.xyzw);

                // Non-optimized version:
                // vec4 coords = mad(vec4(-d.x, d.x, d.y, -d.y), SMAA_RT_METRICS.xyxy, texcoord.xyxy);
                // vec4 c;
                // c.x = SMAASampleLevelZeroOffset(u_canvas, coords.xy, vec2(-1,  0)).g;
                // c.y = SMAASampleLevelZeroOffset(u_canvas, coords.xy, vec2( 0,  0)).r;
                // c.z = SMAASampleLevelZeroOffset(u_canvas, coords.zw, vec2( 1,  0)).g;
                // c.w = SMAASampleLevelZeroOffset(u_canvas, coords.zw, vec2( 1, -1)).r;

                // Merge crossing edges at each side into a single value:
                vec2 cc = mad(vec2(2.0, 2.0), c.xz, c.yw);

                // Remove the crossing edge if we didn't found the end of the line:
                SMAAMovc(bvec2(step(0.9, d.zw)), cc, vec2(0.0, 0.0));

                // Fetch the areas for this line:
                weights += SMAAAreaDiag(u_area, d.xy, cc, subsampleIndices.z);
              }

              // Search for the line ends:
              d.xz = SMAASearchDiag2(u_canvas, texcoord, vec2(-1.0, -1.0), end);
              if (SMAASampleLevelZeroOffset(u_canvas, texcoord, vec2(1, 0)).r > 0.0) {
                d.yw = SMAASearchDiag2(u_canvas, texcoord, vec2(1.0, 1.0), end);
                d.y += float(end.y > 0.9);
              } else {
                d.yw = vec2(0.0, 0.0);
              }

              if (d.x + d.y > 2.0) { // d.x + d.y + 1 > 3
                // Fetch the crossing edges:
                vec4 coords = mad(vec4(-d.x, -d.x, d.y, d.y), SMAA_RT_METRICS.xyxy, texcoord.xyxy);
                vec4 c;
                c.x  = SMAASampleLevelZeroOffset(u_canvas, coords.xy, vec2(-1,  0)).g;
                c.y  = SMAASampleLevelZeroOffset(u_canvas, coords.xy, vec2( 0, -1)).r;
                c.zw = SMAASampleLevelZeroOffset(u_canvas, coords.zw, vec2( 1,  0)).gr;
                vec2 cc = mad(vec2(2.0, 2.0), c.xz, c.yw);

                // Remove the crossing edge if we didn't found the end of the line:
                SMAAMovc(bvec2(step(0.9, d.zw)), cc, vec2(0.0, 0.0));

                // Fetch the areas for this line:
                weights += SMAAAreaDiag(u_area, d.xy, cc, subsampleIndices.w).gr;
              }

              return weights;
            }

            /**
             * This allows to determine how much length should we add in the last step
             * of the searches. It takes the bilinearly interpolated edge (see
             * @PSEUDO_GATHER4), and adds 0, 1 or 2, depending on which edges and
             * crossing edges are active.
             */
            float SMAASearchLength(sampler2D u_search, vec2 e, float offset) {
              // The texture is flipped vertically, with left and right cases taking half
              // of the space horizontally:
              vec2 scale = SMAA_SEARCHTEX_SIZE * vec2(0.5, -1.0);
              vec2 bias = SMAA_SEARCHTEX_SIZE * vec2(offset, 1.0);

              // Scale and bias to access texel centers:
              scale += vec2(-1.0,  1.0);
              bias  += vec2( 0.5, -0.5);

              // Convert from pixel coordinates to texcoords:
              // (We use SMAA_SEARCHTEX_PACKED_SIZE because the texture is cropped)
              scale *= 1.0 / SMAA_SEARCHTEX_PACKED_SIZE;
              bias *= 1.0 / SMAA_SEARCHTEX_PACKED_SIZE;

              // Lookup the search texture:
              return SMAA_SEARCHTEX_SELECT(texture(u_search, mad(scale, e, bias))); // LinearSampler
            }

            /**
             * Horizontal/vertical search functions for the 2nd pass.
             */
            float SMAASearchXLeft(sampler2D u_canvas, sampler2D u_search, vec2 texcoord, float end) {
              /**
                * @PSEUDO_GATHER4
                * This texcoord has been offset by (-0.25, -0.125) in the vertex shader to
                * sample between edge, thus fetching four edges in a row.
                * Sampling with different offsets in each direction allows to disambiguate
                * which edges are active from the four fetched ones.
                */
              vec2 e = vec2(0.0, 1.0);
              for (int i = 0; i < SMAA_MAX_SEARCH_STEPS; i++) {
                if (!(texcoord.x > end && e.g > 0.8281 && e.r == 0.0)) break;
                e = texture(u_canvas, texcoord).rg; // LinearSampler
                texcoord = mad(-vec2(2.0, 0.0), SMAA_RT_METRICS.xy, texcoord);
              }

              float offset = mad(-(255.0 / 127.0), SMAASearchLength(u_search, e, 0.0), 3.25);
              return mad(SMAA_RT_METRICS.x, offset, texcoord.x);

              // Non-optimized version:
              // We correct the previous (-0.25, -0.125) offset we applied:
              // texcoord.x += 0.25 * SMAA_RT_METRICS.x;

              // The searches are bias by 1, so adjust the coords accordingly:
              // texcoord.x += SMAA_RT_METRICS.x;

              // Disambiguate the length added by the last step:
              // texcoord.x += 2.0 * SMAA_RT_METRICS.x; // Undo last step
              // texcoord.x -= SMAA_RT_METRICS.x * (255.0 / 127.0) * SMAASearchLength(u_search, e, 0.0);
              // return mad(SMAA_RT_METRICS.x, offset, texcoord.x);
            }

            float SMAASearchXRight(sampler2D u_canvas, sampler2D u_search, vec2 texcoord, float end) {
              vec2 e = vec2(0.0, 1.0);
              for (int i = 0; i < SMAA_MAX_SEARCH_STEPS; i++) { if (!(texcoord.x < end && e.g > 0.8281 && e.r == 0.0)) break;
                e = texture(u_canvas, texcoord).rg; // LinearSampler
                texcoord = mad(vec2(2.0, 0.0), SMAA_RT_METRICS.xy, texcoord);
              }
              float offset = mad(-(255.0 / 127.0), SMAASearchLength(u_search, e, 0.5), 3.25);
              return mad(-SMAA_RT_METRICS.x, offset, texcoord.x);
            }

            float SMAASearchYUp(sampler2D u_canvas, sampler2D u_search, vec2 texcoord, float end) {
              vec2 e = vec2(1.0, 0.0);
              for (int i = 0; i < SMAA_MAX_SEARCH_STEPS; i++) { if (!(texcoord.y > end && e.r > 0.8281 && e.g == 0.0)) break;
                e = texture(u_canvas, texcoord).rg; // LinearSampler
                texcoord = mad(-vec2(0.0, 2.0), SMAA_RT_METRICS.xy, texcoord);
              }
              float offset = mad(-(255.0 / 127.0), SMAASearchLength(u_search, e.gr, 0.0), 3.25);
              return mad(SMAA_RT_METRICS.y, offset, texcoord.y);
            }

            float SMAASearchYDown(sampler2D u_canvas, sampler2D u_search, vec2 texcoord, float end) {
              vec2 e = vec2(1.0, 0.0);
              for (int i = 0; i < SMAA_MAX_SEARCH_STEPS; i++) { if (!(texcoord.y < end && e.r > 0.8281 && e.g == 0.0)) break;
                e = texture(u_canvas, texcoord).rg; // LinearSampler
                texcoord = mad(vec2(0.0, 2.0), SMAA_RT_METRICS.xy, texcoord);
              }
              float offset = mad(-(255.0 / 127.0), SMAASearchLength(u_search, e.gr, 0.5), 3.25);
              return mad(-SMAA_RT_METRICS.y, offset, texcoord.y);
            }

            /**
             * Ok, we have the distance and both crossing edges. So, what are the areas
             * at each side of current edge?
             */
            vec2 SMAAArea(sampler2D u_area, vec2 dist, float e1, float e2, float offset) {
              // Rounding prevents precision errors of bilinear filtering:
              vec2 texcoord = mad(vec2(SMAA_AREATEX_MAX_DISTANCE, SMAA_AREATEX_MAX_DISTANCE), round(4.0 * vec2(e1, e2)), dist);

              // We do a scale and bias for mapping to texel space:
              texcoord = mad(SMAA_AREATEX_PIXEL_SIZE, texcoord, 0.5 * SMAA_AREATEX_PIXEL_SIZE);

              // Move to proper place, according to the subpixel offset:
              texcoord.y = mad(SMAA_AREATEX_SUBTEX_SIZE, offset, texcoord.y);

              // Do it!
              return SMAA_AREATEX_SELECT(texture(u_area, texcoord)); // LinearSampler
            }

            // Corner Detection Functions
            void SMAADetectHorizontalCornerPattern(sampler2D u_canvas, inout vec2 weights, vec4 texcoord, vec2 d) {
              #if !defined(SMAA_DISABLE_CORNER_DETECTION)
              vec2 leftRight = step(d.xy, d.yx);
              vec2 rounding = (1.0 - SMAA_CORNER_ROUNDING_NORM) * leftRight;

              rounding /= leftRight.x + leftRight.y; // Reduce blending for pixels in the center of a line.

              vec2 factor = vec2(1.0, 1.0);
              factor.x -= rounding.x * SMAASampleLevelZeroOffset(u_canvas, texcoord.xy, vec2(0,  1)).r;
              factor.x -= rounding.y * SMAASampleLevelZeroOffset(u_canvas, texcoord.zw, vec2(1,  1)).r;
              factor.y -= rounding.x * SMAASampleLevelZeroOffset(u_canvas, texcoord.xy, vec2(0, -2)).r;
              factor.y -= rounding.y * SMAASampleLevelZeroOffset(u_canvas, texcoord.zw, vec2(1, -2)).r;

              weights *= saturate(factor);
              #endif
            }

            void SMAADetectVerticalCornerPattern(sampler2D u_canvas, inout vec2 weights, vec4 texcoord, vec2 d) {
              #if !defined(SMAA_DISABLE_CORNER_DETECTION)
              vec2 leftRight = step(d.xy, d.yx);
              vec2 rounding = (1.0 - SMAA_CORNER_ROUNDING_NORM) * leftRight;

              rounding /= leftRight.x + leftRight.y;

              vec2 factor = vec2(1.0, 1.0);
              factor.x -= rounding.x * SMAASampleLevelZeroOffset(u_canvas, texcoord.xy, vec2( 1, 0)).g;
              factor.x -= rounding.y * SMAASampleLevelZeroOffset(u_canvas, texcoord.zw, vec2( 1, 1)).g;
              factor.y -= rounding.x * SMAASampleLevelZeroOffset(u_canvas, texcoord.xy, vec2(-2, 0)).g;
              factor.y -= rounding.y * SMAASampleLevelZeroOffset(u_canvas, texcoord.zw, vec2(-2, 1)).g;

              weights *= saturate(factor);
              #endif
            }

            void main() {
              vec4 subsampleIndices = vec4(0.0); // Just pass zero for SMAA 1x, see @SUBSAMPLE_INDICES.
              // subsampleIndices = vec4(1.0, 1.0, 1.0, 0.0);
              vec4 weights = vec4(0.0, 0.0, 0.0, 0.0);
              vec2 e = texture(u_canvas, v_texCoord).rg;

              if (e.g > 0.0) { // Edge at north

                #if !defined(SMAA_DISABLE_DIAG_DETECTION)
                // Diagonals have both north and west edges, so searching for them in
                // one of the boundaries is enough.
                weights.rg = SMAACalculateDiagWeights(u_canvas, u_area, v_texCoord, e, subsampleIndices);

                // We give priority to diagonals, so if we find a diagonal we skip
                // horizontal/vertical processing.
                if (weights.r == -weights.g) { // weights.r + weights.g == 0.0
                #endif

                vec2 d;

                // Find the distance to the left:
                vec3 coords;
                coords.x = SMAASearchXLeft(u_canvas, u_search, v_offset[0].xy, v_offset[2].x);
                coords.y = v_offset[1].y; // v_offset[1].y = v_texCoord.y - 0.25 * SMAA_RT_METRICS.y (@CROSSING_OFFSET)
                d.x = coords.x;

                // Now fetch the left crossing edges, two at a time using bilinear
                // filtering. Sampling at -0.25 (see @CROSSING_OFFSET) enables to
                // discern what value each edge has:
                float e1 = texture(u_canvas, coords.xy).r; // LinearSampler

                // Find the distance to the right:
                coords.z = SMAASearchXRight(u_canvas, u_search, v_offset[0].zw, v_offset[2].y);
                d.y = coords.z;

                // We want the distances to be in pixel units (doing this here allow to
                // better interleave arithmetic and memory accesses):
                d = abs(round(mad(SMAA_RT_METRICS.zz, d, -v_pixcoord.xx)));

                // SMAAArea below needs a sqrt, as the areas texture is compressed
                // quadratically:
                vec2 sqrt_d = sqrt(d);

                // Fetch the right crossing edges:
                float e2 = SMAASampleLevelZeroOffset(u_canvas, coords.zy, vec2(1, 0)).r;

                // Ok, we know how this pattern looks like, now it is time for getting
                // the actual area:
                weights.rg = SMAAArea(u_area, sqrt_d, e1, e2, subsampleIndices.y);

                // Fix corners:
                coords.y = v_texCoord.y;
                SMAADetectHorizontalCornerPattern(u_canvas, weights.rg, coords.xyzy, d);

                #if !defined(SMAA_DISABLE_DIAG_DETECTION)
                } else
                e.r = 0.0; // Skip vertical processing.
                #endif
              }

              if (e.r > 0.0) { // Edge at west
                vec2 d;

                // Find the distance to the top:
                vec3 coords;
                coords.y = SMAASearchYUp(u_canvas, u_search, v_offset[1].xy, v_offset[2].z);
                coords.x = v_offset[0].x; // v_offset[1].x = v_texCoord.x - 0.25 * SMAA_RT_METRICS.x;
                d.x = coords.y;

                // Fetch the top crossing edges:
                float e1 = texture(u_canvas, coords.xy).g; // LinearSampler

                // Find the distance to the bottom:
                coords.z = SMAASearchYDown(u_canvas, u_search, v_offset[1].zw, v_offset[2].w);
                d.y = coords.z;

                // We want the distances to be in pixel units:
                d = abs(round(mad(SMAA_RT_METRICS.ww, d, -v_pixcoord.yy)));

                // SMAAArea below needs a sqrt, as the areas texture is compressed
                // quadratically:
                vec2 sqrt_d = sqrt(d);

                // Fetch the bottom crossing edges:
                float e2 = SMAASampleLevelZeroOffset(u_canvas, coords.xz, vec2(0, 1)).g;

                // Get the area for this direction:
                weights.ba = SMAAArea(u_area, sqrt_d, e1, e2, subsampleIndices.x);

                // Fix corners:
                coords.x = v_texCoord.x;
                SMAADetectVerticalCornerPattern(u_canvas, weights.ba, coords.xyxz, d);
              }

              fragColor = weights;
            }
    `,
  },
  smaaBlend: {
    vert: `#version 300 es       
          #define mad(a, b, c) (a * b + c)   
          in vec2 a_position;
          in vec2 a_texCoord;

          uniform vec2 u_resolution;
          
          out vec2 v_texCoord;
          out vec4 v_offset;
                        
          void main() {
            // convert the rectangle from pixels to 0.0 to 1.0
            vec2 zeroToOne = a_position / u_resolution;
          
            // convert from 0->1 to 0->2
            vec2 zeroToTwo = zeroToOne * 2.0;
          
            // convert from 0->2 to -1->+1 (clipspace)
            vec2 clipSpace = zeroToTwo - 1.0;
          
            gl_Position = vec4(clipSpace, 0, 1);
          
            // pass the texCoord to the fragment shader
            // The GPU will interpolate pPM value between points.
            v_texCoord = a_texCoord;
            
            vec4 SMAA_RT_METRICS = vec4(1.0 / u_resolution.x, 1.0 / u_resolution.y, u_resolution.x, u_resolution.y);
            
            v_offset = mad(SMAA_RT_METRICS.xyxy, vec4(1.0, 0.0, 0.0,  1.0), v_texCoord.xyxy);
          }            
          `,
    frag: `#version 300 es      
          precision highp float;

          #define mad(a, b, c) (a * b + c)

          uniform sampler2D u_color;
          uniform sampler2D u_canvas;

          uniform vec2 u_resolution;

          in vec2 v_texCoord;
          in vec4 v_offset;

          out vec4 fragColor;

          vec4 SMAA_RT_METRICS = vec4(1.0 / u_resolution.x, 1.0 / u_resolution.y, u_resolution.x, u_resolution.y);

          /**
           * Conditional move:
           */
          void SMAAMovc(bvec2 cond, inout vec2 variable, vec2 value) {
            if (cond.x) variable.x = value.x;
            if (cond.y) variable.y = value.y;
          }

          void SMAAMovc(bvec4 cond, inout vec4 variable, vec4 value) {
            SMAAMovc(cond.xy, variable.xy, value.xy);
            SMAAMovc(cond.zw, variable.zw, value.zw);
          }

          void main() {
            vec4 color;

            // Fetch the blending weights for current pixel:
            vec4 a;
            a.x = texture(u_canvas, v_offset.xy).a; // Right
            a.y = texture(u_canvas, v_offset.zw).g; // Top
            a.wz = texture(u_canvas, v_texCoord).xz; // Bottom / Left

            // Is there any blending weight with a value greater than 0.0?
            if (dot(a, vec4(1.0, 1.0, 1.0, 1.0)) <= 1e-5) {
              color = texture(u_color, v_texCoord); // LinearSampler
            } else {
              bool h = max(a.x, a.z) > max(a.y, a.w); // max(horizontal) > max(vertical)

              // Calculate the blending offsets:
              vec4 blendingOffset = vec4(0.0, a.y, 0.0, a.w);
              vec2 blendingWeight = a.yw;
              SMAAMovc(bvec4(h, h, h, h), blendingOffset, vec4(a.x, 0.0, a.z, 0.0));
              SMAAMovc(bvec2(h, h), blendingWeight, a.xz);
              blendingWeight /= dot(blendingWeight, vec2(1.0, 1.0));

              // Calculate the texture coordinates:
              vec4 blendingCoord = mad(blendingOffset, vec4(SMAA_RT_METRICS.xy, -SMAA_RT_METRICS.xy), v_texCoord.xyxy);

              // We exploit bilinear filtering to mix current pixel with the chosen
              // neighbor:
              color = blendingWeight.x * texture(u_color, blendingCoord.xy); // LinearSampler
              color += blendingWeight.y * texture(u_color, blendingCoord.zw); // LinearSampler
            }

            fragColor = color;
          }
    `,
  },
};

export { pPM };
