# Data Models

This directory contains Pydantic models for ComfyUI Manager, providing type safety, validation, and serialization for the API and internal data structures.

## Overview

- `generated_models.py` - All models auto-generated from OpenAPI spec
- `__init__.py` - Package exports for all models

**Note**: All models are now auto-generated from the OpenAPI specification. Manual model files (`task_queue.py`, `state_management.py`) have been deprecated in favor of a single source of truth.

## Generating Types from OpenAPI

The state management models are automatically generated from the OpenAPI specification using `datamodel-codegen`. This ensures type safety and consistency between the API specification and the Python code.

### Prerequisites

Install the code generator:
```bash
pipx install datamodel-code-generator
```

### Generation Command

To regenerate all models after updating the OpenAPI spec:

```bash
datamodel-codegen \
  --use-subclass-enum \
  --field-constraints \
  --strict-types bytes \
  --use-double-quotes \
  --input openapi.yaml \
  --output comfyui_manager/data_models/generated_models.py \
  --output-model-type pydantic_v2.BaseModel
```

### When to Regenerate

You should regenerate the models when:

1. **Adding new API endpoints** that return new data structures
2. **Modifying existing schemas** in the OpenAPI specification  
3. **Adding new state management features** that require new models

### Important Notes

- **Single source of truth**: All models are now generated from `openapi.yaml`
- **No manual models**: All previously manual models have been migrated to the OpenAPI spec
- **OpenAPI requirements**: New schemas must be referenced in API paths to be generated by datamodel-codegen
- **Validation**: Always validate the OpenAPI spec before generation:
  ```bash
  python3 -c "import yaml; yaml.safe_load(open('openapi.yaml'))"
  ```

### Example: Adding New State Models

1. Add your schema to `openapi.yaml` under `components/schemas/`
2. Reference the schema in an API endpoint response
3. Run the generation command above
4. Update `__init__.py` to export the new models
5. Import and use the models in your code

### Troubleshooting

- **Models not generated**: Ensure schemas are under `components/schemas/` (not `parameters/`)
- **Missing models**: Verify schemas are referenced in at least one API path
- **Import errors**: Check that new models are added to `__init__.py` exports