#include <machine.h>
#include <time.h>

#define N 200

static int a[N]= {18361,25784,6605,26590,22618,15285,27647,23843,16362,10047,16750,10588,27793,20888,27352,6613,6426,9475,1198,17530,23329,31946,17543,42,21700,8569,15002,4705,12988,27549,19075,24352,19489,17567,12310,5363,30347,17034,31029,8821,27399,14673,5216,15979,26439,29891,25161,14524,18559,13036,9790,18401,2223,16069,7917,4284,10022,26104,14827,2867,18285,1073,26236,24110,10506,24816,24846,6813,21026,27498,1618,9173,3264,20262,28522,9796,22268,23679,21324,14882,19599,21158,12181,5101,25414,6808,8534,9282,10802,27835,28598,10331,4015,19630,20789,32664,22681,11411,29913,25229,6165,3426,17535,31632,19593,30505,15223,2318,14036,20900,7556,25432,16015,8758,4713,26187,19900,5130,16473,19631,32670,24508,20314,7631,13785,16126,20449,28518,9821,15831,3234,30579,19535,22706,4768,1923,18616,13435,32295,28430,543,30101,4202,15992,28713,20597,14893,27908,20386,9488,27977,27549,9303,24865,25073,19337,11325,5301,12619,24167,23461,21817,8405,4121,29052,6111,24844,24437,31551,3907,9170,16647,27220,15102,9530,2249,24399,18465,5493,17119,20611,20390,19773,28,18161,6403,12863,1593,10843,22910,4724,11134,4153,5452,18690,16416,1906,24535,16446,23820};

static int a_ref[N]= {28,42,543,1073,1198,1593,1618,1906,1923,2223,2249,2318,2867,3234,3264,3426,3907,4015,4121,4153,4202,4284,4705,4713,4724,4768,5101,5130,5216,5301,5363,5452,5493,6111,6165,6403,6426,6605,6613,6808,6813,7556,7631,7917,8405,8534,8569,8758,8821,9170,9173,9282,9303,9475,9488,9530,9790,9796,9821,10022,10047,10331,10506,10588,10802,10843,11134,11325,11411,12181,12310,12619,12863,12988,13036,13435,13785,14036,14524,14673,14827,14882,14893,15002,15102,15223,15285,15831,15979,15992,16015,16069,16126,16362,16416,16446,16473,16647,16750,17034,17119,17530,17535,17543,17567,18161,18285,18361,18401,18465,18559,18616,18690,19075,19337,19489,19535,19593,19599,19630,19631,19773,19900,20262,20314,20386,20390,20449,20597,20611,20789,20888,20900,21026,21158,21324,21700,21817,22268,22618,22681,22706,22910,23329,23461,23679,23820,23843,24110,24167,24352,24399,24437,24508,24535,24816,24844,24846,24865,25073,25161,25229,25414,25432,25784,26104,26187,26236,26439,26590,27220,27352,27399,27498,27549,27549,27647,27793,27835,27908,27977,28430,28518,28522,28598,28713,29052,29891,29913,30101,30347,30505,30579,31029,31551,31632,31946,32295,32664,32670};

void shell2(void)
{
    unsigned long start_count = 0;
    unsigned long stop_count = 0;
    unsigned long total_count = 0;

    unsigned long start_count_my = 0;
    unsigned long stop_count_my  = 0;
    unsigned long total_count_my = 0;


    int i,j, err;
    int *result;

    //clear count
    SOC_TIMER = 0;
    asm volatile("mtc0 $0, $9");

    err=0;
    printf("bubble sort test begin.\n");
    start_count = get_count();
    start_count_my = get_count_my();
    if(SIMU_FLAG){
        result = bubble_sort(a, N);
        for(j = 0; j < N; j++) {
	        if (result[j] != a_ref[j]) {
                err += 1;
                break;
            }
        }
    }else{
        for(i=0;i<LOOPTIMES;i++) {
            result = bubble_sort(a, N);
            for(j = 0; j < N; j++) {
	            if (result[j] != a_ref[j]) {
                    err += 1;
                    break;
                }
            }
        }
    }
    stop_count_my  = get_count_my();
    stop_count     = get_count();
    total_count    = stop_count - start_count;
    total_count_my = stop_count_my - start_count_my;

	if (err==0) {
        printf("bubble sort PASS!\n");
	    *((int *)LED_RG1_ADDR) = 1;  
	    *((int *)LED_RG0_ADDR) = 1;  
        *((int *)LED_ADDR)     = 0xffff;  
    }
	else {
        printf("bubble sort ERROR!!!\n");
	    *((int *)LED_RG1_ADDR) = 1;  
	    *((int *)LED_RG0_ADDR) = 2;  
        *((int *)LED_ADDR)     = 0;  
    }
    SOC_NUM = total_count_my;  
    *((volatile unsigned *)CONFREG_CR0) = total_count_my;  
    *((volatile unsigned *)CONFREG_CR1) = total_count;  
    printf("bubble sort: Total Count(SoC count) = 0x%x\n", total_count);
    printf("bubble sort: Total Count(CPU count) = 0x%x\n", total_count_my);

    return;
}
