--[[
    openSAM: open source SAM emulator for X Plane

    Copyright (C) 2024  Holger Teutsch

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
    USA

]]

function openSAM_post_dock()
    logMsg("openSAM_post_dock called")

    -- for ToLiss open door 1 + ext power on + chocks
    if PLANE_ICAO == "A319" or PLANE_ICAO == "A321" or PLANE_ICAO == "A346" then
        set_array("AirbusFBW/PaxDoorModeArray", 0, 2)
        set("AirbusFBW/EnableExternalPower", 1)
        set("AirbusFBW/Chocks", 1)
    end

    if SGES_Author == nil then dataref("SGES_Author","sim/aircraft/view/acf_author","readonly",0) end --[[important]]

    if PLANE_ICAO == "A321"     and SGES_Author == "Gliding Kiwi" then 				set_array("AirbusFBW/PaxDoorModeArray",0,2)
    elseif PLANE_ICAO == "A21N"     and SGES_Author == "Gliding Kiwi" then 			set_array("AirbusFBW/PaxDoorModeArray",0,2)
    elseif PLANE_ICAO == "A20N" and SGES_Author == "Gliding Kiwi" then 				set_array("AirbusFBW/PaxDoorModeArray",0,2)
    elseif PLANE_ICAO == "A319" and SGES_Author == "Gliding Kiwi" then 				set_array("AirbusFBW/PaxDoorModeArray",0,2)
    elseif PLANE_ICAO == "A346" and SGES_Author == "GlidingKiwi" then 				set_array("AirbusFBW/PaxDoorModeArray",0,2)
    elseif PLANE_ICAO == "B732" and SGES_Author == "" then 							set_array("FJS/732/DoorSta/Door1",0,1)  --  (FlyJSim)
    elseif PLANE_ICAO == "B748" and string.find(SGES_Author,"Supercritical") then 	set_array("sim/cockpit2/switches/custom_slider_on",0,1)  -- SSG 747-8i
    elseif PLANE_ICAO == "B752" and string.find(SGES_Author,"FlightFactor") then 	set_array("sim/cockpit2/switches/custom_slider_on",0,1)  -- FF/STS 757
    elseif PLANE_ICAO == "B753" and string.find(SGES_Author,"FlightFactor") then 	set_array("sim/cockpit2/switches/custom_slider_on",0,1)  -- FF/STS 757
    elseif PLANE_ICAO == "B762" and string.find(SGES_Author,"FlightFactor") then 	set_array("sim/cockpit2/switches/custom_slider_on",0,1)  -- FF/STS 767
    elseif PLANE_ICAO == "B762F" and string.find(SGES_Author,"FlightFactor") then 	set_array("sim/cockpit2/switches/custom_slider_on",0,1) -- FF/STS 767
    elseif PLANE_ICAO == "B764" and string.find(SGES_Author,"FlightFactor") then 	set_array("sim/cockpit2/switches/custom_slider_on",0,1)   -- FF/STS 767
    elseif PLANE_ICAO == "B763" and string.find(SGES_Author,"FlightFactor") then 	set_array("sim/cockpit2/switches/custom_slider_on",0,1)   -- FF/STS 767
    elseif PLANE_ICAO == "B788" and SGES_Author == "Magknight" then 				set_array("aero787/doors/door_open_ratio",0,1)   -- Magknight
    elseif PLANE_ICAO == "B789" and SGES_Author == "Magknight" then 				set_array("aero787/doors/door_open_ratio",0,1)   -- Magknight
    elseif PLANE_ICAO == "A306" and string.find(SGES_Author,"iniSim") then			set_array("A300/GND/doors_target",1,1) -- IniSimulations A300
    elseif PLANE_ICAO == "A310" and string.find(SGES_Author,"iniSim") then			set_array("A300/GND/doors_target",1,1) -- IniSimulations  A310
    elseif PLANE_ICAO == "A3ST" and string.find(SGES_Author,"iniSim") then			set_array("A300/GND/doors_target",1,1) -- IniSimulations Beluga
    elseif PLANE_ICAO == "CONC" and SGES_Author == "COLIMATA" then 					set_array("Colimata/CON_SW_TO_DOORS_passenger_vi",0,1) -- colimata concorde GUI
    elseif PLANE_ICAO == "E170" and SGES_Author == "Supercritical Simulations Group" then set_array("sim/cockpit2/switches/custom_slider_on",0,1) -- SSG Embraer
    elseif PLANE_ICAO == "E195" and SGES_Author == "Supercritical Simulations Group" then set_array("sim/cockpit2/switches/custom_slider_on",0,1) -- SSG Embraer
    elseif string.match(AIRCRAFT_PATH,"146") and string.find(SGES_Author,"Thranda") then  set_array("sim/cockpit2/switches/door_open",1,1) -- Just Flight BAe 146
    elseif PLANE_ICAO == "B742" and SGES_Author == "Felis Leopard" then 			set_array("B742/anim/pax_door_1_left" ,0,1) -- Felis 742
	elseif PLANE_ICAO == "E170" and SGES_Author == "Marko Mamula" then 				set_array("XCrafts/doors/front_main",0,1) -- X-Crafts Embraer
	elseif PLANE_ICAO == "E175" and SGES_Author == "Marko Mamula" then 				set_array("XCrafts/doors/front_main",0,1) -- X-Crafts Embraer
	elseif PLANE_ICAO == "E190" and SGES_Author == "Marko Mamula" then 				set_array("XCrafts/doors/front_main",0,1) -- X-Crafts Embraer
	elseif PLANE_ICAO == "E195" and SGES_Author == "Marko Mamula" then 				set_array("XCrafts/doors/front_main",0,1) -- X-Crafts Embraer
    elseif string.find(SGES_Author,"Unruh") and (PLANE_ICAO == "A339") then			set_array("sim/cockpit2/switches/door_open",0,1)
    elseif string.find(SGES_Author,"Unruh") and (PLANE_ICAO == "A333") then 		set_array("sim/cockpit2/switches/door_open",0,1)
    elseif string.find(SGES_Author,"Austin Meyer") and (PLANE_ICAO == "MD82") then 	set_array("sim/cockpit2/switches/custom_slider_on" ,0,1)
    elseif PLANE_ICAO=="B736" or PLANE_ICAO == "B737" or PLANE_ICAO == "B738" or PLANE_ICAO == "B739" then			-- ZIBO / LevelUp
		command_once("laminar/B738/door/fwd_L_toggle")
	elseif PLANE_ICAO == "MD11" and string.find(SGES_Author,"Juan Alcon") then 	command_once("Rotate/aircraft/controls/fwd_l_ckt_door_ctrl") -- ROTATE
	elseif PLANE_ICAO == "MD88" and string.find(SGES_Author,"Juan Alcon") then 	command_once("Rotate/md80/doors/main_cabin_door_open") -- ROTATE
	end

	local l_newval  = true
	show_Cones = l_newval
	Cones_chg = true
	show_BeltLoader = l_newval
	BeltLoader_chg = true
	show_People1 = l_newval
	People1_chg = true
	show_People2 = l_newval
	People2_chg = true
	return

end

function openSAM_pre_undock()
    logMsg("openSAM_pre_undock")

    -- for ToLiss ensure doors are closed
    if PLANE_ICAO == "A319" or PLANE_ICAO == "A321" or PLANE_ICAO == "A346" then
        set_array("AirbusFBW/PaxDoorModeArray", 0, 0)
        set_array("AirbusFBW/PaxDoorModeArray", 1, 0)
    end

    if PLANE_ICAO == "A321"     and SGES_Author == "Gliding Kiwi" then 				set_array("AirbusFBW/PaxDoorModeArray",0,0)
    elseif PLANE_ICAO == "A21N"     and SGES_Author == "Gliding Kiwi" then 			set_array("AirbusFBW/PaxDoorModeArray",0,0)
    elseif PLANE_ICAO == "A20N" and SGES_Author == "Gliding Kiwi" then 				set_array("AirbusFBW/PaxDoorModeArray",0,0)
    elseif PLANE_ICAO == "A319" and SGES_Author == "Gliding Kiwi" then 				set_array("AirbusFBW/PaxDoorModeArray",0,0)
    elseif PLANE_ICAO == "A346" and SGES_Author == "GlidingKiwi" then 				set_array("AirbusFBW/PaxDoorModeArray",0,0)
    elseif PLANE_ICAO == "B732" and SGES_Author == "" then 							set_array("FJS/732/DoorSta/Door1",0,0)  --  (FlyJSim)
    elseif PLANE_ICAO == "B748" and string.find(SGES_Author,"Supercritical") then 	set_array("sim/cockpit2/switches/custom_slider_on",0,0)  -- SSG 747-8i
    elseif PLANE_ICAO == "B752" and string.find(SGES_Author,"FlightFactor") then 	set_array("sim/cockpit2/switches/custom_slider_on",0,0)  -- FF/STS 757
    elseif PLANE_ICAO == "B753" and string.find(SGES_Author,"FlightFactor") then 	set_array("sim/cockpit2/switches/custom_slider_on",0,0)  -- FF/STS 757
    elseif PLANE_ICAO == "B762" and string.find(SGES_Author,"FlightFactor") then 	set_array("sim/cockpit2/switches/custom_slider_on",0,0)  -- FF/STS 767
    elseif PLANE_ICAO == "B762F" and string.find(SGES_Author,"FlightFactor") then 	set_array("sim/cockpit2/switches/custom_slider_on",0,0) -- FF/STS 767
    elseif PLANE_ICAO == "B764" and string.find(SGES_Author,"FlightFactor") then 	set_array("sim/cockpit2/switches/custom_slider_on",0,0)   -- FF/STS 767
    elseif PLANE_ICAO == "B763" and string.find(SGES_Author,"FlightFactor") then 	set_array("sim/cockpit2/switches/custom_slider_on",0,0)   -- FF/STS 767
    elseif PLANE_ICAO == "B788" and SGES_Author == "Magknight" then 				set_array("aero787/doors/door_open_ratio",0,0)   -- Magknight
    elseif PLANE_ICAO == "B789" and SGES_Author == "Magknight" then 				set_array("aero787/doors/door_open_ratio",0,0)   -- Magknight
    elseif PLANE_ICAO == "A306" and string.find(SGES_Author,"iniSim") then			set_array("A300/GND/doors_target",1,0) -- IniSimulations A300
    elseif PLANE_ICAO == "A310" and string.find(SGES_Author,"iniSim") then			set_array("A300/GND/doors_target",1,0) -- IniSimulations  A310
    elseif PLANE_ICAO == "A3ST" and string.find(SGES_Author,"iniSim") then			set_array("A300/GND/doors_target",1,0) -- IniSimulations Beluga
    elseif PLANE_ICAO == "CONC" and SGES_Author == "COLIMATA" then 					set_array("Colimata/CON_SW_TO_DOORS_passenger_vi",0,0) -- colimata concorde GUI
    elseif PLANE_ICAO == "E170" and SGES_Author == "Supercritical Simulations Group" then set_array("sim/cockpit2/switches/custom_slider_on",0,0) -- SSG Embraer
    elseif PLANE_ICAO == "E195" and SGES_Author == "Supercritical Simulations Group" then set_array("sim/cockpit2/switches/custom_slider_on",0,0) -- SSG Embraer
    elseif string.match(AIRCRAFT_PATH,"146") and string.find(SGES_Author,"Thranda") then  set_array("sim/cockpit2/switches/door_open",1,0) -- Just Flight BAe 146
    elseif PLANE_ICAO == "B742" and SGES_Author == "Felis Leopard" then 			set_array("B742/anim/pax_door_1_left" ,0,0) -- Felis 742
	elseif PLANE_ICAO == "E170" and SGES_Author == "Marko Mamula" then 				set_array("XCrafts/doors/front_main",0,0) -- X-Crafts Embraer
	elseif PLANE_ICAO == "E175" and SGES_Author == "Marko Mamula" then 				set_array("XCrafts/doors/front_main",0,0) -- X-Crafts Embraer
	elseif PLANE_ICAO == "E190" and SGES_Author == "Marko Mamula" then 				set_array("XCrafts/doors/front_main",0,0) -- X-Crafts Embraer
	elseif PLANE_ICAO == "E195" and SGES_Author == "Marko Mamula" then 				set_array("XCrafts/doors/front_main",0,0) -- X-Crafts Embraer
    elseif string.find(SGES_Author,"Unruh") and (PLANE_ICAO == "A339") then			set_array("sim/cockpit2/switches/door_open",0,0)
    elseif string.find(SGES_Author,"Unruh") and (PLANE_ICAO == "A333") then 		set_array("sim/cockpit2/switches/door_open",0,0)
    elseif string.find(SGES_Author,"Austin Meyer") and (PLANE_ICAO == "MD82") then 	set_array("sim/cockpit2/switches/custom_slider_on" ,0,0)
    elseif PLANE_ICAO=="B736" or PLANE_ICAO == "B737" or PLANE_ICAO == "B738" or PLANE_ICAO == "B739" then			-- ZIBO / LevelUp
		command_once("laminar/B738/door/fwd_L_toggle")
	elseif PLANE_ICAO == "MD11" and string.find(SGES_Author,"Juan Alcon") then 	command_once("Rotate/aircraft/controls/fwd_l_ckt_door_ctrl") -- ROTATE
	elseif PLANE_ICAO == "MD88" and string.find(SGES_Author,"Juan Alcon") then 	command_once("Rotate/md80/doors/main_cabin_door_close") -- ROTATE
	end
	local l_newval = false
	show_FireVehicle = l_newval
	FireVehicle_chg = true
	if IsToLiss == false then
		show_GPU = l_newval
		GPU_chg = true
	end
	show_RearBeltLoader = l_newval
	RearBeltLoader_chg = true
	show_FUEL = l_newval
	FUEL_chg = true
	show_Cleaning = l_newval
	Cleaning_chg = true
	show_PRM = l_newval
	PRM_chg = true
	show_BeltLoader = l_newval
	BeltLoader_chg = true
	show_Cart = l_newval
	Cart_chg = true
	show_ULDLoader = l_newval
	ULDLoader_chg = true
	show_Stairs = l_newval
	Stairs_chg = true
	show_StairsH = l_newval
	StairsH_chg = true
	show_Catering = l_newval
	Catering_chg = true
	show_Cones = l_newval
	Cones_chg = true
	show_People1 = l_newval
	People1_chg = true
	show_People2 = l_newval
	People2_chg = true
	show_People3 = l_newval
	People3_chg = true
	show_People4 = l_newval
	People4_chg = true
	show_Bus = l_newval
	Bus_chg = true
	show_Pax = l_newval
	Pax_chg = true
	initial_pax_start = true
	terminate_passenger_action = false
	show_Deice = l_newval
	Deice_chg = true
	show_Light = l_newval
	Light_chg = true
	show_StairsXPJ = l_newval
	StairsXPJ_chg = true
	show_StairsXPJ2 = l_newval
	StairsXPJ2_chg = true
		show_ASU = l_newval
	show_ACU = l_newval
	ASU_chg = true
	show_Forklift = l_newval
	Forklift_chg = true
	show_Baggage = l_newval
	Baggage_chg = true
	Baggage_pass = 0

	return
end


-- create the commands
create_command( "openSAM/post_dock", "openSAM_post_dock",
                "",
                "",
                "openSAM_post_dock()")

add_macro("openSAM_post_dock", "openSAM_post_dock()")

create_command( "openSAM/pre_undock", "openSAM_pre_undock",
                "",
                "",
                "openSAM_pre_undock()")

add_macro("openSAM_pre_undock", "openSAM_pre_undock()")
	-- |||| Define the dataref to open the aircraft left front and rear doors for passengers |||||
	-- we also work the dataref regarding the X-Plane aircraft model author
