/*
 * Decompiled with CFR 0.152.
 */
package julianh06.wynnextras.utils.render;

import java.awt.Color;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import julianh06.wynnextras.event.RenderWorldEvent;
import julianh06.wynnextras.utils.MinecraftUtils;
import julianh06.wynnextras.utils.Pair;
import julianh06.wynnextras.utils.WEVec;
import julianh06.wynnextras.utils.render.LineDrawer;
import julianh06.wynnextras.utils.render.RenderLayers;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_746;
import net.minecraft.class_9974;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class WorldRenderUtils {
    public static WEVec getViewerPos() {
        return WorldRenderUtils.exactLocation(class_310.method_1551().field_1773.method_19418());
    }

    public static WEVec exactLocation(class_1297 entity, float partialTicks) {
        if (!entity.method_5805()) {
            return new WEVec(entity.method_19538());
        }
        WEVec prev = new WEVec(entity.field_6014, entity.field_6036, entity.field_5969);
        return prev.add(new WEVec(entity.method_19538()).subtract(prev).multiply(partialTicks));
    }

    public static WEVec exactLocation(class_4184 camera) {
        return new WEVec(camera.method_19326());
    }

    public static WEVec exactPlayerEyeLocation(RenderWorldEvent event) {
        class_746 player = MinecraftUtils.localPlayer();
        double eyeHeight = player.method_18381(player.method_18376());
        return WorldRenderUtils.exactLocation((class_1297)player, event.partialTicks).add(0.0, eyeHeight, 0.0);
    }

    public static Set<Pair<WEVec, WEVec>> calculateEdges(class_238 box) {
        WEVec bottomLeftFront = new WEVec(box.field_1323, box.field_1322, box.field_1321);
        WEVec bottomLeftBack = new WEVec(box.field_1323, box.field_1322, box.field_1324);
        WEVec topLeftFront = new WEVec(box.field_1323, box.field_1325, box.field_1321);
        WEVec topLeftBack = new WEVec(box.field_1323, box.field_1325, box.field_1324);
        WEVec bottomRightFront = new WEVec(box.field_1320, box.field_1322, box.field_1321);
        WEVec bottomRightBack = new WEVec(box.field_1320, box.field_1322, box.field_1324);
        WEVec topRightFront = new WEVec(box.field_1320, box.field_1325, box.field_1321);
        WEVec topRightBack = new WEVec(box.field_1320, box.field_1325, box.field_1324);
        return Set.of(new Pair<WEVec, WEVec>(bottomLeftFront, bottomLeftBack), new Pair<WEVec, WEVec>(bottomLeftBack, bottomRightBack), new Pair<WEVec, WEVec>(bottomRightBack, bottomRightFront), new Pair<WEVec, WEVec>(bottomRightFront, bottomLeftFront), new Pair<WEVec, WEVec>(topLeftFront, topLeftBack), new Pair<WEVec, WEVec>(topLeftBack, topRightBack), new Pair<WEVec, WEVec>(topRightBack, topRightFront), new Pair<WEVec, WEVec>(topRightFront, topLeftFront), new Pair<WEVec, WEVec>(bottomLeftFront, topLeftFront), new Pair<WEVec, WEVec>(bottomLeftBack, topLeftBack), new Pair<WEVec, WEVec>(bottomRightBack, topRightBack), new Pair<WEVec, WEVec>(bottomRightFront, topRightFront));
    }

    public static void drawFilledBoundingBox(RenderWorldEvent event, class_238 box, Color color, float alphaMultiplier, boolean depth) {
        WEVec viewerPos = WorldRenderUtils.getViewerPos();
        class_238 adjustedBox = new class_238(box.field_1323 - viewerPos.x(), box.field_1322 - viewerPos.y(), box.field_1321 - viewerPos.z(), box.field_1320 - viewerPos.x(), box.field_1325 - viewerPos.y(), box.field_1324 - viewerPos.z());
        class_1921.class_4687 layer = RenderLayers.getFilled(!depth);
        class_4588 buffer = event.vertexConsumerProvider.getBuffer((class_1921)layer);
        event.matrices.method_22903();
        class_9974.method_62300((class_4587)event.matrices, (class_4588)buffer, (double)adjustedBox.field_1323, (double)adjustedBox.field_1322, (double)adjustedBox.field_1321, (double)adjustedBox.field_1320, (double)adjustedBox.field_1325, (double)adjustedBox.field_1324, (float)((float)color.getRed() / 255.0f * 0.9f), (float)((float)color.getGreen() / 255.0f * 0.9f), (float)((float)color.getBlue() / 255.0f * 0.9f), (float)((float)color.getAlpha() / 255.0f * alphaMultiplier));
        event.matrices.method_22909();
    }

    public static void drawEdges(RenderWorldEvent event, class_238 box, Color color, int lineWidth, boolean depth) {
        LineDrawer.draw3D(event, lineWidth, depth, lineDrawer -> lineDrawer.drawEdges(box, color));
    }

    public static void drawEdges(RenderWorldEvent event, WEVec location, Color color, int lineWidth, boolean depth) {
        LineDrawer.draw3D(event, lineWidth, depth, lineDrawer -> lineDrawer.drawEdges(location, color));
    }

    public static void draw3DLine(RenderWorldEvent event, WEVec p1, WEVec p2, Color color, int lineWidth, boolean depth) {
        LineDrawer.draw3D(event, lineWidth, depth, lineDrawer -> lineDrawer.draw3DLine(p1, p2, color));
    }

    public static void drawLineToEye(RenderWorldEvent event, WEVec location, Color color, int lineWidth, boolean depth) {
        WEVec rotationVec = new WEVec(MinecraftUtils.localPlayer().method_5828(event.partialTicks));
        WorldRenderUtils.draw3DLine(event, WorldRenderUtils.exactPlayerEyeLocation(event).add(rotationVec.multiply(2)), location, color, lineWidth, depth);
    }

    public static void draw3DCircle(RenderWorldEvent event, WEVec location, double radius, Color color, int lineWidth, boolean depth) {
        LineDrawer.draw3D(event, lineWidth, depth, lineDrawer -> {
            WEVec lastPoint = location.add(radius, 0.0, 0.0);
            for (int i = 1; i <= 360; ++i) {
                double rad = Math.toRadians(i);
                WEVec newPoint = location.add(Math.cos(rad) * radius, 0.0, Math.sin(rad) * radius);
                lineDrawer.draw3DLine(lastPoint, newPoint, color);
                lastPoint = newPoint;
            }
        });
    }

    public static void drawText(RenderWorldEvent event, WEVec location, class_2561 text, float scale, boolean depth) {
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        Matrix4f matrix = new Matrix4f();
        WEVec viewerPos = WorldRenderUtils.getViewerPos();
        class_327 textRenderer = class_310.method_1551().field_1772;
        float adjustedScale = scale * 0.05f;
        matrix.translate((float)(location.x() - viewerPos.x()), (float)(location.y() - viewerPos.y()), (float)(location.z() - viewerPos.z())).rotate((Quaternionfc)camera.method_23767()).scale(adjustedScale, -adjustedScale, adjustedScale);
        List textLines = textRenderer.method_1728((class_5348)text, 1000000);
        for (int i = 0; i < textLines.size(); ++i) {
            class_5481 line = (class_5481)textLines.get(i);
            Objects.requireNonNull(textRenderer);
            float yOffset = (float)(i * 9) * 1.3f;
            float xOffset = (float)(-textRenderer.method_30880(line)) / 2.0f;
            textRenderer.method_22942(line, xOffset, yOffset, 0xFFFFFF, false, matrix, (class_4597)event.vertexConsumerProvider, depth ? class_327.class_6415.field_33993 : class_327.class_6415.field_33994, 0, 0xF000F0);
        }
    }
}

