/*
 * Decompiled with CFR 0.152.
 */
package julianh06.wynnextras.utils.overlays;

import com.wynntils.core.text.StyledText;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicLong;
import julianh06.wynnextras.event.CharInputEvent;
import julianh06.wynnextras.event.KeyInputEvent;
import julianh06.wynnextras.features.inventory.BankOverlay;
import julianh06.wynnextras.features.inventory.BankOverlayType;
import julianh06.wynnextras.utils.overlays.EasyElement;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public class EasyTextInput
extends EasyElement {
    protected boolean isActive = false;
    protected CustomColor color = CustomColor.fromHexString((String)"FFFFFF");
    protected String input = "";
    protected String searchText = "Search...";
    protected int DEBOUNCE_DELAY_MS = 100;
    protected HashMap<Long, Long> lastCharTime = new HashMap();
    protected HashMap<Integer, Integer> cooldowns = new HashMap();
    protected int cursorPos = 0;
    protected long lastBlink = 0L;
    protected boolean blinkToggle = true;
    int scaleFactor;

    public EasyTextInput() {
        super(-1, -1, 0, 0);
    }

    public EasyTextInput(int x, int y, int height, int width) {
        super(x, y, height, width);
    }

    @Override
    public void draw(class_332 context) {
        long now = System.currentTimeMillis();
        RenderUtils.drawRect((class_4587)context.method_51448(), (CustomColor)this.color, (float)this.x, (float)this.y, (float)0.0f, (float)this.width, (float)this.height);
        if (this.input.isEmpty() && !this.isActive) {
            context.method_51433(class_310.method_1551().field_1772, this.searchText, this.x + 1, this.y + 3, CustomColor.fromHexString((String)"000000").asInt(), false);
        } else {
            if (this.cursorPos > this.input.length()) {
                this.cursorPos = this.input.length();
            }
            context.method_51433(class_310.method_1551().field_1772, this.input, this.x + 1, this.y + 3, CustomColor.fromHexString((String)"000000").asInt(), false);
            if (now - this.lastBlink > 500L) {
                this.blinkToggle = !this.blinkToggle;
                this.lastBlink = now;
            }
            if (this.blinkToggle && this.isActive) {
                RenderUtils.drawLine((class_4587)context.method_51448(), (CustomColor)CustomColor.fromHexString((String)"000000"), (float)(this.x + 1 + class_310.method_1551().field_1772.method_1727(this.input.substring(0, this.cursorPos))), (float)(this.y + 2), (float)(this.x + 1 + class_310.method_1551().field_1772.method_1727(this.input.substring(0, this.cursorPos))), (float)(this.y + 11), (float)0.0f, (float)1.0f);
            }
        }
    }

    public void drawWithoutBackground(class_332 context, CustomColor color) {
        if (this.input == null) {
            return;
        }
        long now = System.currentTimeMillis();
        if (!this.input.isEmpty() || this.isActive) {
            if (this.cursorPos > this.input.length()) {
                this.cursorPos = this.input.length();
            }
            context.method_25303(class_310.method_1551().field_1772, this.input, this.x + 3, this.y + 1, color.asInt());
            if (now - this.lastBlink > 500L) {
                this.blinkToggle = !this.blinkToggle;
                this.lastBlink = now;
            }
            if (this.blinkToggle && this.isActive) {
                RenderUtils.drawLine((class_4587)context.method_51448(), (CustomColor)CustomColor.fromHexString((String)"FFFFFF"), (float)(this.x + 3 + class_310.method_1551().field_1772.method_1727(this.input.substring(0, this.cursorPos))), (float)this.y, (float)(this.x + 3 + class_310.method_1551().field_1772.method_1727(this.input.substring(0, this.cursorPos))), (float)(this.y + 9), (float)0.0f, (float)1.0f);
            }
        }
    }

    public void drawWithoutBackgroundButWithSearchtext(class_332 context, CustomColor color) {
        if (this.input == null) {
            return;
        }
        this.scaleFactor = (int)class_310.method_1551().method_22683().method_4495();
        long now = System.currentTimeMillis();
        if (this.input.isEmpty() && !this.isActive) {
            FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromComponent((class_2561)class_2561.method_30163((String)this.searchText)), (float)this.x + 9.0f / (float)this.scaleFactor, (float)this.y + 3.0f / (float)this.scaleFactor, CustomColor.fromHexString((String)"FFFFFF"), HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NORMAL, 3.0f / (float)this.scaleFactor);
        } else {
            if (this.cursorPos > this.input.length()) {
                this.cursorPos = this.input.length();
            }
            FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromComponent((class_2561)class_2561.method_30163((String)this.input)), (float)this.x + 9.0f / (float)this.scaleFactor, (float)this.y + 6.0f / (float)this.scaleFactor, CustomColor.fromHexString((String)"FFFFFF"), HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NORMAL, 3.0f / (float)this.scaleFactor);
            if (now - this.lastBlink > 500L) {
                this.blinkToggle = !this.blinkToggle;
                this.lastBlink = now;
            }
            if (this.blinkToggle && this.isActive) {
                RenderUtils.drawLine((class_4587)context.method_51448(), (CustomColor)CustomColor.fromHexString((String)"FFFFFF"), (float)((float)this.x + 12.0f / (float)this.scaleFactor + (float)(class_310.method_1551().field_1772.method_1727(this.input.substring(0, this.cursorPos)) * 3) / (float)this.scaleFactor), (float)((float)this.y + 3.0f / (float)this.scaleFactor), (float)((float)this.x + 12.0f / (float)this.scaleFactor + (float)(class_310.method_1551().field_1772.method_1727(this.input.substring(0, this.cursorPos)) * 3) / (float)this.scaleFactor), (float)((float)this.y + 30.0f / (float)this.scaleFactor), (float)0.0f, (float)(3.0f / (float)this.scaleFactor));
            }
        }
    }

    public void drawWithTexture(class_332 context, class_2960 texture) {
        long now = System.currentTimeMillis();
        RenderUtils.drawTexturedRect((class_4587)context.method_51448(), (class_2960)texture, (float)this.x, (float)this.y, (float)0.0f, (float)this.width, (float)this.height, (int)((int)this.width), (int)((int)this.height));
        if (this.input.isEmpty() && !this.isActive) {
            context.method_25303(class_310.method_1551().field_1772, this.searchText, this.x + 2, this.y + 3, CustomColor.fromHexString((String)"FFFFFF").asInt());
        } else {
            if (this.cursorPos > this.input.length()) {
                this.cursorPos = this.input.length();
            }
            context.method_25303(class_310.method_1551().field_1772, this.input, this.x + 2, this.y + 3, CustomColor.fromHexString((String)"FFFFFF").asInt());
            if (now - this.lastBlink > 500L) {
                this.blinkToggle = !this.blinkToggle;
                this.lastBlink = now;
            }
            if (this.blinkToggle && this.isActive) {
                RenderUtils.drawLine((class_4587)context.method_51448(), (CustomColor)CustomColor.fromHexString((String)"FFFFFF"), (float)(this.x + 2 + class_310.method_1551().field_1772.method_1727(this.input.substring(0, this.cursorPos))), (float)(this.y + 2), (float)(this.x + 2 + class_310.method_1551().field_1772.method_1727(this.input.substring(0, this.cursorPos))), (float)(this.y + 11), (float)0.0f, (float)1.0f);
            }
        }
    }

    @Override
    public void click() {
        if (!this.isActive) {
            this.isActive = true;
            BankOverlay.activeTextInput = this;
            this.cursorPos = this.input.length();
            this.color = CustomColor.fromHexString((String)"FFEA00");
            return;
        }
        this.isActive = false;
        this.color = CustomColor.fromHexString((String)"FFFFFF");
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean newValue) {
        this.isActive = newValue;
    }

    public String getInput() {
        return this.input;
    }

    public void setInput(String value) {
        this.input = value;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    public void setHeight(int value) {
        this.height = value;
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    public void setWidth(int value) {
        this.width = value;
    }

    public void clearInput() {
        this.input = "";
        this.cursorPos = 0;
    }

    public void onInput(KeyInputEvent event) {
        if (!this.isActive || BankOverlay.currentOverlayType == BankOverlayType.NONE) {
            return;
        }
        AtomicLong now = new AtomicLong();
        int action = event.getAction();
        int key = event.getKey();
        int scancode = event.getScanCode();
        now.set(System.currentTimeMillis());
        if (action == 0) {
            this.cooldowns.remove(key);
        } else if (key == 259 && this.cursorPos > 0) {
            this.input = this.removeAt(this.cursorPos, this.input);
            --this.cursorPos;
        } else if (key == 261 && this.cursorPos < this.input.length()) {
            this.input = this.removeAt(this.cursorPos + 1, this.input);
        } else if (key == 263 && this.cursorPos > 0) {
            --this.cursorPos;
        } else if (key == 262 && this.cursorPos < this.input.length()) {
            ++this.cursorPos;
        }
    }

    public void onCharInput(CharInputEvent event) {
        char c;
        if (this.isActive() && !Character.isISOControl(c = event.getCharacter())) {
            this.insertCharAtCursor(c);
        }
    }

    protected boolean isValidKey(int key) {
        if (key == 32) {
            return true;
        }
        if (key == 39) {
            return true;
        }
        if (key >= 44 && key <= 57) {
            return true;
        }
        if (key == 59) {
            return true;
        }
        if (key == 61) {
            return true;
        }
        return key >= 65 && key <= 93;
    }

    protected String insertAt(int i, String value, String src) {
        if (i < 0) {
            return null;
        }
        if (i >= ((String)src).length()) {
            src = (String)src + value;
            return src;
        }
        String leftSub = ((String)src).substring(0, i);
        String rightSub = ((String)src).substring(i);
        return leftSub + value + rightSub;
    }

    public void insertCharAtCursor(char c) {
        this.input = this.insertAt(this.cursorPos, String.valueOf(c), this.input);
        ++this.cursorPos;
    }

    protected String removeAt(int i, String src) {
        if (i < 0 || i > src.length() || src.isEmpty()) {
            return src;
        }
        String leftSub = src.substring(0, i - 1);
        String rightSub = src.substring(i);
        return leftSub + rightSub;
    }
}

