/*
 * Decompiled with CFR 0.152.
 */
package julianh06.wynnextras.utils.overlays;

import com.wynntils.core.text.StyledText;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.function.Consumer;
import julianh06.wynnextras.features.waypoints.WaypointScreen;
import julianh06.wynnextras.utils.overlays.EasyElement;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public class EasySlider
extends EasyElement {
    private final float min;
    private final float max;
    private float value = 50.0f;
    public boolean dragging = false;
    private boolean useFloatInsteadOfInt;
    private final int handleWidth = 30;
    private final Consumer<Float> onValueChanged;
    class_2960 sliderButtonTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/waypoints/sliderbutton.png");
    class_2960 sliderTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/waypoints/sliderbackground.png");

    public EasySlider(int x, int y, int height, int width, float min, float max, float defaultValue, boolean useFloatInsteadOfInt, Consumer<Float> onValueChanged) {
        super(x, y, height, width);
        this.min = min;
        this.max = max;
        this.value = defaultValue;
        this.useFloatInsteadOfInt = useFloatInsteadOfInt;
        this.onValueChanged = onValueChanged;
    }

    @Override
    public void draw(class_332 context) {
        RenderUtils.drawTexturedRect((class_4587)context.method_51448(), (class_2960)this.sliderTexture, (float)this.x, (float)((float)this.y + this.height / 2.0f - 6.0f / (float)WaypointScreen.scaleFactor), (float)this.width, (float)(12.0f / (float)WaypointScreen.scaleFactor), (int)((int)this.width), (int)(12 / WaypointScreen.scaleFactor));
        int handleX = this.x + (int)((this.value - this.min) / (this.max - this.min) * (this.width - 30.0f / (float)WaypointScreen.scaleFactor));
        RenderUtils.drawTexturedRect((class_4587)context.method_51448(), (class_2960)this.sliderButtonTexture, (float)handleX, (float)this.y, (float)(30.0f / (float)WaypointScreen.scaleFactor), (float)this.height, (int)(30 / WaypointScreen.scaleFactor), (int)((int)this.height));
        FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromComponent((class_2561)class_2561.method_30163((String)String.format("%.2f", Float.valueOf(this.value)))), (float)this.x + this.width + 24.0f / (float)WaypointScreen.scaleFactor, (float)this.y + this.height / 2.0f, CustomColor.fromHexString((String)"FFFFFF"), HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 3.0f / (float)WaypointScreen.scaleFactor);
    }

    @Override
    public void click() {
        if (this.isClickInBounds(WaypointScreen.mouseX, WaypointScreen.mouseY)) {
            this.dragging = true;
            this.updateValueFromMouse(WaypointScreen.mouseX);
        }
    }

    public void updateValueFromMouse(int mouseX) {
        float ratio = Math.max(0.0f, Math.min(1.0f, ((float)(mouseX - this.x) - 15.0f / (float)WaypointScreen.scaleFactor) / (this.width - 30.0f / (float)WaypointScreen.scaleFactor)));
        this.value = this.min + ratio * (this.max - this.min);
        this.onValueChanged.accept(Float.valueOf(this.value));
    }
}

