/*
 * Decompiled with CFR 0.152.
 */
package julianh06.wynnextras.utils.UI;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import julianh06.wynnextras.utils.UI.UIUtils;
import net.minecraft.class_332;

public abstract class Widget {
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected boolean visible = true;
    protected boolean enabled = true;
    protected boolean hovered = false;
    protected boolean focused = false;
    protected Widget parent = null;
    protected final List<Widget> children = new ArrayList<Widget>();
    protected Consumer<Widget> onClickCallback = null;
    protected Consumer<Widget> onFocusCallback = null;
    protected Consumer<Widget> onBlurCallback = null;
    protected UIUtils ui;

    public Widget(int x, int y, int width, int height) {
        this.setBounds(x, y, width, height);
    }

    public final void setBounds(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = Math.max(0, width);
        this.height = Math.max(0, height);
        this.onResize(width, height);
    }

    protected void onResize(int newWidth, int newHeight) {
    }

    public void setPosition(int x, int y) {
        this.setBounds(x, y, this.width, this.height);
    }

    public void setSize(int width, int height) {
        this.setBounds(this.x, this.y, width, height);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isHovered() {
        return this.hovered;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public void addChild(Widget child) {
        if (child == null) {
            return;
        }
        child.parent = this;
        this.children.add(child);
    }

    public void addAllChildren(List<Widget> children) {
        if (children == null || children.isEmpty()) {
            return;
        }
        for (Widget child : children) {
            child.parent = this;
            this.children.add(child);
        }
    }

    public void removeChild(Widget child) {
        if (child == null) {
            return;
        }
        this.children.remove(child);
        child.parent = null;
    }

    public void clearChildren() {
        for (Widget c : this.children) {
            c.parent = null;
        }
        this.children.clear();
    }

    public final void draw(class_332 ctx, int mouseX, int mouseY, float tickDelta, UIUtils ui) {
        this.ui = ui;
        if (!this.visible || this.ui == null) {
            return;
        }
        this.hovered = this.contains(mouseX, mouseY);
        this.updateValues();
        this.drawBackground(ctx, mouseX, mouseY, tickDelta);
        this.drawContent(ctx, mouseX, mouseY, tickDelta);
        for (Widget child : this.children) {
            child.draw(ctx, mouseX, mouseY, tickDelta, ui);
        }
        this.drawForeground(ctx, mouseX, mouseY, tickDelta);
    }

    protected void updateValues() {
    }

    protected void drawBackground(class_332 ctx, int mouseX, int mouseY, float tickDelta) {
    }

    protected abstract void drawContent(class_332 var1, int var2, int var3, float var4);

    protected void drawForeground(class_332 ctx, int mouseX, int mouseY, float tickDelta) {
    }

    public boolean mouseClicked(double mx, double my, int button) {
        if (!this.visible || !this.enabled) {
            return false;
        }
        for (int i = this.children.size() - 1; i >= 0; --i) {
            Widget child = this.children.get(i);
            if (!child.mouseClicked(mx, my, button)) continue;
            return true;
        }
        if (this.contains((int)mx, (int)my)) {
            this.setFocused(true);
            if (this.onClickCallback != null) {
                this.onClickCallback.accept(this);
            }
            return this.onClick(button);
        }
        if (this.focused) {
            this.setFocused(false);
        }
        return false;
    }

    protected boolean onClick(int button) {
        return false;
    }

    public boolean mouseReleased(double mx, double my, int button) {
        if (!this.visible) {
            return false;
        }
        for (int i = this.children.size() - 1; i >= 0; --i) {
            if (!this.children.get(i).mouseReleased(mx, my, button)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return false;
    }

    public boolean mouseScrolled(double mx, double my, double delta) {
        if (!this.visible) {
            return false;
        }
        for (int i = this.children.size() - 1; i >= 0; --i) {
            if (!this.children.get(i).mouseScrolled(mx, my, delta)) continue;
            return true;
        }
        return this.onScroll(delta);
    }

    protected boolean onScroll(double delta) {
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (!this.visible || !this.enabled) {
            return false;
        }
        for (Widget child : this.children) {
            if (!child.keyPressed(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return this.onKeyPressed(keyCode, scanCode, modifiers);
    }

    protected boolean onKeyPressed(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    public boolean charTyped(char chr, int modifiers) {
        if (!this.visible || !this.enabled) {
            return false;
        }
        for (Widget child : this.children) {
            if (!child.charTyped(chr, modifiers)) continue;
            return true;
        }
        return this.onCharTyped(chr, modifiers);
    }

    protected boolean onCharTyped(char chr, int modifiers) {
        return false;
    }

    public void setFocused(boolean focused) {
        if (this.focused == focused) {
            return;
        }
        this.focused = focused;
        if (focused) {
            if (this.onFocusCallback != null) {
                this.onFocusCallback.accept(this);
            }
        } else if (this.onBlurCallback != null) {
            this.onBlurCallback.accept(this);
        }
    }

    public void setOnClick(Consumer<Widget> callback) {
        this.onClickCallback = callback;
    }

    public void setOnFocus(Consumer<Widget> callback) {
        this.onFocusCallback = callback;
    }

    public void setOnBlur(Consumer<Widget> callback) {
        this.onBlurCallback = callback;
    }

    public boolean contains(int mx, int my) {
        if (this.ui == null) {
            return false;
        }
        return (float)mx >= this.ui.sx(this.x) && (float)my >= this.ui.sy(this.y) && (float)mx < this.ui.sx(this.x) + (float)this.ui.sw(this.width) && (float)my < this.ui.sy(this.y) + (float)this.ui.sh(this.height);
    }

    public void translate(int dx, int dy) {
        this.x += dx;
        this.y += dy;
        for (Widget c : this.children) {
            c.translate(dx, dy);
        }
    }

    public void tick() {
        for (Widget c : this.children) {
            c.tick();
        }
    }

    public void setUi(UIUtils ui) {
        this.ui = ui;
    }
}

