/*
 * Decompiled with CFR 0.152.
 */
package julianh06.wynnextras.utils.UI;

import java.util.ArrayList;
import java.util.List;
import julianh06.wynnextras.utils.UI.UIUtils;
import julianh06.wynnextras.utils.UI.WEElement;
import julianh06.wynnextras.utils.UI.Widget;
import net.minecraft.class_1041;
import net.minecraft.class_310;
import net.minecraft.class_332;

public abstract class WEHandledScreen {
    protected class_332 drawContext;
    protected double scaleFactor;
    protected int xStart;
    protected int yStart;
    protected int screenWidth;
    protected int screenHeight;
    protected UIUtils ui;
    protected final List<Widget> rootWidgets = new ArrayList<Widget>();
    protected final List<WEElement<?>> listElements = new ArrayList();
    protected Widget focusedWidget = null;
    protected WEElement<?> focusedElement = null;
    protected float listX;
    protected float listY;
    protected float listWidth;
    protected float listHeight;
    protected float listItemHeight;
    protected float listSpacing;
    protected float listScrollOffset = 0.0f;
    protected int firstVisibleIndex = 0;
    protected int lastVisibleIndex = -1;
    private static long lastScrollTime = 0L;
    private static final long scrollCooldown = 0L;

    public void render(class_332 ctx, int mouseX, int mouseY, float delta) {
        this.drawContext = ctx;
        this.computeScale();
        if (this.ui == null) {
            this.ui = new UIUtils(ctx, this.scaleFactor, this.xStart, this.yStart);
        } else {
            this.ui.updateContext(ctx, this.scaleFactor, this.xStart, this.yStart);
        }
        this.drawBackground(ctx, mouseX, mouseY, delta);
        this.drawContent(ctx, mouseX, mouseY, delta);
        for (Widget w : this.rootWidgets) {
            w.draw(ctx, mouseX, mouseY, delta, this.ui);
        }
        this.updateVisibleListRange();
        this.layoutListElements();
        for (int i = this.firstVisibleIndex; i <= this.lastVisibleIndex; ++i) {
            this.listElements.get(i).draw(ctx, mouseX, mouseY, delta, this.ui);
        }
        this.drawForeground(ctx, mouseX, mouseY, delta);
    }

    protected void scrollList(float delta) {
        float contentHeight = (float)this.listElements.size() * (this.listItemHeight + this.listSpacing) - this.listSpacing;
        this.listScrollOffset -= delta;
        float maxScroll = Math.max(0.0f, contentHeight - this.listHeight);
        this.listScrollOffset = Math.max(0.0f, Math.min(this.listScrollOffset, maxScroll));
    }

    protected void layoutListElements() {
        float yy = this.listY - this.listScrollOffset;
        for (WEElement<?> e : this.listElements) {
            e.setBounds((int)this.listX, (int)yy, (int)this.listWidth, (int)this.listItemHeight);
            yy += this.listItemHeight + this.listSpacing;
        }
    }

    protected void updateVisibleListRange() {
        if (this.listElements.isEmpty() || this.listItemHeight <= 0.0f) {
            this.firstVisibleIndex = 0;
            this.lastVisibleIndex = -1;
            return;
        }
        float slot = this.listItemHeight + this.listSpacing;
        int start = (int)Math.floor(this.listScrollOffset / slot);
        int visibleCount = (int)Math.ceil(this.listHeight / slot) + 1;
        this.firstVisibleIndex = Math.max(0, start);
        this.lastVisibleIndex = Math.min(this.listElements.size() - 1, start + visibleCount);
    }

    public boolean mouseClicked(double x, double y, int button) {
        int i;
        for (i = this.rootWidgets.size() - 1; i >= 0; --i) {
            if (!this.rootWidgets.get(i).mouseClicked(x, y, button)) continue;
            this.setFocusedWidget(this.rootWidgets.get(i));
            this.setFocusedElement(null);
            return true;
        }
        for (i = this.lastVisibleIndex; i >= this.firstVisibleIndex; --i) {
            WEElement<?> e = this.listElements.get(i);
            if (!e.mouseClicked(x, y, button)) continue;
            this.setFocusedElement(e);
            this.setFocusedWidget(null);
            return true;
        }
        this.setFocusedElement(null);
        this.setFocusedWidget(null);
        return false;
    }

    public boolean mouseReleased(double x, double y, int button) {
        for (Widget w : this.rootWidgets) {
            if (!w.mouseReleased(x, y, button)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseDragged(double x, double y, int button, double dx, double dy) {
        for (Widget w : this.rootWidgets) {
            if (!w.mouseDragged(x, y, button, dx, dy)) continue;
            return true;
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.focusedWidget != null && this.focusedWidget.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        for (Widget w : this.rootWidgets) {
            if (!w.keyPressed(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    public boolean charTyped(char chr, int mods) {
        if (this.focusedWidget != null && this.focusedWidget.charTyped(chr, mods)) {
            return true;
        }
        for (Widget w : this.rootWidgets) {
            if (!w.charTyped(chr, mods)) continue;
            return true;
        }
        return false;
    }

    protected void setFocusedElement(WEElement<?> e) {
        if (this.focusedElement != null) {
            this.focusedElement.setFocused(false);
        }
        this.focusedElement = e;
        if (e != null) {
            e.setFocused(true);
        }
    }

    protected void setFocusedWidget(Widget w) {
        if (this.focusedWidget != null) {
            this.focusedWidget.setFocused(false);
        }
        this.focusedWidget = w;
        if (w != null) {
            w.setFocused(true);
        }
    }

    public void computeScale() {
        class_1041 w = class_310.method_1551().method_22683();
        this.scaleFactor = Math.max(1.0, w.method_4495());
        this.screenWidth = w.method_4486();
        this.screenHeight = w.method_4502();
    }

    protected abstract void drawBackground(class_332 var1, int var2, int var3, float var4);

    protected abstract void drawContent(class_332 var1, int var2, int var3, float var4);

    protected abstract void drawForeground(class_332 var1, int var2, int var3, float var4);
}

