/*
 * Decompiled with CFR 0.152.
 */
package julianh06.wynnextras.utils.UI;

import com.wynntils.utils.colors.CustomColor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import julianh06.wynnextras.features.profileviewer.WynncraftApiHandler;
import julianh06.wynnextras.features.profileviewer.data.AbilityMapData;
import julianh06.wynnextras.features.profileviewer.data.AbilityTreeCache;
import julianh06.wynnextras.features.profileviewer.data.AbilityTreeData;
import julianh06.wynnextras.utils.Pair;
import julianh06.wynnextras.utils.UI.Widget;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class AbilityTreeWidget
extends Widget {
    static class_2960 backgroundTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/treetabbackground.png");
    static class_2960 backgroundTextureDark = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/treetabbackground_dark.png");
    static class_2960 borderTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/treetabbackgroundborders.png");
    static class_2960 borderTextureDark = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/treetabbackgroundborders_dark.png");
    public static class_2960 pageLineTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/pageline.png");
    public static class_2960 strengthTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/skillpoints/strength.png");
    public static class_2960 dexterityTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/skillpoints/dexterity.png");
    public static class_2960 intelligenceTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/skillpoints/intelligence.png");
    public static class_2960 defenceTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/skillpoints/defence.png");
    public static class_2960 agilityTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/skillpoints/agility.png");
    public static class_2960 warrior = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/node/warrior.png");
    public static class_2960 warriorActive = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/node/warrior_active.png");
    public static class_2960 shaman = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/node/shaman.png");
    public static class_2960 shamanActive = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/node/shaman_active.png");
    public static class_2960 archer = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/node/archer.png");
    public static class_2960 archerActive = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/node/archer_active.png");
    public static class_2960 mage = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/node/mage.png");
    public static class_2960 mageActive = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/node/mage_active.png");
    public static class_2960 assassin = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/node/assassin.png");
    public static class_2960 assassinActive = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/node/assassin_active.png");
    public static class_2960 white = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/node/white.png");
    public static class_2960 whiteActive = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/node/white_active.png");
    public static class_2960 yellow = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/node/yellow.png");
    public static class_2960 yellowActive = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/node/yellow_active.png");
    public static class_2960 blue = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/node/blue.png");
    public static class_2960 blueActive = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/node/blue_active.png");
    public static class_2960 purple = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/node/purple.png");
    public static class_2960 purpleActive = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/node/purple_active.png");
    public static class_2960 red = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/node/red.png");
    public static class_2960 redActive = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/node/red_active.png");
    public static class_2960 vertical = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/connector/vertical.png");
    public static class_2960 verticalActive = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/connector/vertical_active.png");
    public static class_2960 horizontal = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/connector/horizontal.png");
    public static class_2960 horizontalActive = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/connector/horizontal_active.png");
    public static class_2960 down_left = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/connector/down_left.png");
    public static class_2960 down_leftActive = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/connector/down_left_active.png");
    public static class_2960 right_down = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/connector/right_down.png");
    public static class_2960 right_downActive = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/connector/right_down_active.png");
    public static class_2960 right_down_left = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/connector/right_down_left.png");
    public static class_2960 RIGHT_DOWN_LEFT = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/connector/right_down_left_active.png");
    public static class_2960 right_DOWN_LEFT = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/connector/right_down_left_active1.png");
    public static class_2960 RIGHT_DOWN_left = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/connector/right_down_left_active2.png");
    public static class_2960 RIGHT_down_LEFT = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/connector/right_down_left_active3.png");
    public static class_2960 up_right_down = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/connector/up_right_down.png");
    public static class_2960 UP_RIGHT_DOWN = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/connector/up_right_down_active.png");
    public static class_2960 UP_RIGHT_down = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/connector/up_right_down_active1.png");
    public static class_2960 up_RIGHT_DOWN = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/connector/up_right_down_active2.png");
    public static class_2960 UP_right_DOWN = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/connector/up_right_down_active3.png");
    public static class_2960 up_down_left = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/connector/up_down_left.png");
    public static class_2960 UP_DOWN_LEFT = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/connector/up_down_left_active.png");
    public static class_2960 UP_down_LEFT = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/connector/up_down_left_active1.png");
    public static class_2960 up_DOWN_LEFT = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/connector/up_down_left_active2.png");
    public static class_2960 UP_DOWN_left = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/connector/up_down_left_active3.png");
    public static class_2960 up_right_left = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/connector/up_right_left.png");
    public static class_2960 UP_RIGHT_LEFT = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/connector/up_right_left_active.png");
    public static class_2960 UP_right_LEFT = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/connector/up_right_left_active1.png");
    public static class_2960 UP_RIGHT_left = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/connector/up_right_left_active2.png");
    public static class_2960 up_RIGHT_LEFT = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/connector/up_right_left_active3.png");
    public static class_2960 up_right_down_left = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/connector/up_right_down_left.png");
    public static class_2960 UP_RIGHT_DOWN_LEFT = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/connector/up_right_down_left_active.png");
    public static class_2960 UP_RIGHT_down_LEFT = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/connector/up_right_down_left_active1.png");
    public static class_2960 UP_RIGHT_DOWN_left = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/connector/up_right_down_left_active2.png");
    public static class_2960 up_RIGHT_DOWN_LEFT = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/connector/up_right_down_left_active3.png");
    public static class_2960 UP_right_DOWN_LEFT = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/connector/up_right_down_left_active4.png");
    public static class_2960 UP_right_down_LEFT = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/connector/up_right_down_left_active5.png");
    public static class_2960 UP_RIGHT_down_left = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/connector/up_right_down_left_active6.png");
    public static class_2960 up_RIGHT_DOWN_left = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/connector/up_right_down_left_active7.png");
    public static class_2960 up_right_DOWN_LEFT = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/connector/up_right_down_left_active8.png");
    public static class_2960 UP_right_DOWN_left = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/connector/up_right_down_left_active9.png");
    public static class_2960 up_RIGHT_down_LEFT = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/connector/up_right_down_left_active10.png");
    public final String className;
    private int scrollOffset;
    public static AbilityMapData.Node currentHoveredNode = null;
    public static boolean loaded = false;
    public AbilityMapData classTree;
    public AbilityMapData playerTree;
    private final AbilityTreeState state = new AbilityTreeState();
    private final List<NodeWidget> nodeWidgets = new ArrayList<NodeWidget>();
    private String searchInput = "";
    int botLimit;

    public AbilityTreeWidget(String className, int x, int y, int width, int height, int botLimit) {
        super(x, y, width, height);
        this.className = className == null ? "" : className;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.botLimit = botLimit;
    }

    public void setClassTree(AbilityMapData classTree) {
        this.classTree = classTree;
        this.refreshState();
    }

    public void setPlayerTree(AbilityMapData playerTree) {
        this.playerTree = playerTree;
        this.refreshState();
    }

    public void clearTrees() {
        this.classTree = null;
        this.playerTree = null;
        this.refreshState();
    }

    public void setScrollOffset(int scrollOffset) {
        this.scrollOffset = scrollOffset;
    }

    public void refreshState() {
        AbilityMapData loadedClass;
        this.state.reset();
        if (!this.nodeWidgets.isEmpty()) {
            this.children.removeAll(this.nodeWidgets);
            this.nodeWidgets.clear();
        }
        currentHoveredNode = null;
        if (this.classTree == null && (loadedClass = AbilityTreeCache.getClassMap(this.className)) != null) {
            this.classTree = loadedClass;
        }
        if (this.classTree == null || this.playerTree == null) {
            loaded = false;
            return;
        }
        this.state.prepare(this.classTree, this.playerTree);
        for (AbilityMapData.Node n : this.state.abilities) {
            NodeWidget w = new NodeWidget(this.x, this.y, n, this.botLimit, this.scrollOffset);
            w.parent = this;
            this.nodeWidgets.add(w);
            this.children.add(w);
        }
        loaded = true;
    }

    public AbilityMapData.Node getNodeAt(int pageId, int coordX, int coordY) {
        if (this.state.classTree == null || this.state.classTree.pages == null) {
            return null;
        }
        List<AbilityMapData.Node> nodes = this.state.classTree.pages.get(pageId);
        if (nodes == null) {
            return null;
        }
        for (AbilityMapData.Node n : nodes) {
            if (n.coordinates.x != coordX || n.coordinates.y != coordY) continue;
            return n;
        }
        return null;
    }

    public void setSearchInput(String input) {
        this.searchInput = input == null ? "" : input;
    }

    public AbilityMapData.Node getCurrentHoveredNode() {
        return currentHoveredNode;
    }

    @Override
    protected void drawContent(class_332 ctx, int mouseX, int mouseY, float tickDelta) {
        if (!loaded || this.state.classTree == null) {
            return;
        }
        for (AbilityMapData.Node node : this.state.connectors) {
            int yStart = this.y + 75 + node.coordinates.y * 75 - this.scrollOffset;
            class_2960 tex = this.connectorTextureFor(node);
            if (tex == null || yStart - 25 <= this.y || yStart - 25 >= this.y + this.botLimit) continue;
            this.ui.drawImage(tex, this.x + node.coordinates.x * 75 + 917, yStart - 34, 145.0f, 145.0f);
        }
        if (this.nodeWidgets.isEmpty() && !this.state.abilities.isEmpty()) {
            for (AbilityMapData.Node node : this.state.abilities) {
                NodeWidget w = new NodeWidget(this.x, this.y, node, this.botLimit, this.scrollOffset);
                w.parent = this;
                this.nodeWidgets.add(w);
                this.children.add(w);
            }
        }
    }

    @Override
    protected void drawForeground(class_332 ctx, int mouseX, int mouseY, float tickDelta) {
        if (!loaded) {
            return;
        }
        AbilityTreeData treeData = AbilityTreeCache.getClassTree(this.className);
        if (treeData != null && treeData.pages != null && this.searchInput != null && !this.searchInput.isEmpty()) {
            String search = this.searchInput.toLowerCase();
            for (Map<String, AbilityTreeData.Ability> page : treeData.pages.values()) {
                for (AbilityTreeData.Ability ability : page.values()) {
                    int yStart;
                    if (ability.name == null || !ability.name.toLowerCase().contains(search) || (yStart = this.y + 75 + ability.coordinates.y * 75 - this.scrollOffset + 450 * (ability.page - 1)) - 25 <= this.y || yStart - 25 >= this.y + this.botLimit) continue;
                    this.ui.drawRectBorders(this.x + ability.coordinates.x * 75 + 943, yStart - 7, this.x + ability.coordinates.x * 75 + 943 + 90, yStart - 7 + 90, CustomColor.fromHexString((String)"FFFF00"));
                }
            }
        }
    }

    public void drawNodeTooltip(class_332 ctx, int mouseX, int mouseY) {
        AbilityTreeData.Ability ability;
        Map<String, AbilityTreeData.Ability> page;
        if (!loaded) {
            return;
        }
        AbilityTreeData treeData = AbilityTreeCache.getClassTree(this.className.toLowerCase());
        if (currentHoveredNode != null && treeData != null && (page = treeData.pages.get(AbilityTreeWidget.currentHoveredNode.meta.page)) != null && (ability = this.findAbilityMatchForHovered(page, currentHoveredNode)) != null && ability.description != null && ability.name != null) {
            ArrayList<String> description = new ArrayList<String>(ability.description);
            description.add(0, ability.name);
            ctx.method_51434(class_310.method_1551().field_1772, WynncraftApiHandler.parseStyledHtml(description), mouseX, mouseY);
        }
    }

    private class_2960 connectorTextureFor(AbilityMapData.Node node) {
        if (node.meta == null) {
            return null;
        }
        return switch ((String)node.meta.icon) {
            case "connector_up_down" -> {
                if (node.unlocked) {
                    yield verticalActive;
                }
                yield vertical;
            }
            case "connector_right_left" -> {
                if (node.unlocked) {
                    yield horizontalActive;
                }
                yield horizontal;
            }
            case "connector_down_left" -> {
                if (node.unlocked) {
                    yield down_leftActive;
                }
                yield down_left;
            }
            case "connector_right_down" -> {
                if (node.unlocked) {
                    yield right_downActive;
                }
                yield right_down;
            }
            case "connector_right_down_left" -> {
                if (!node.unlocked) {
                    yield right_down_left;
                }
                AbilityMapData.Node leftNeighbour = this.getNodeAt(node.meta.page, node.coordinates.x - 1, node.coordinates.y);
                AbilityMapData.Node rightNeighbour = this.getNodeAt(node.meta.page, node.coordinates.x + 1, node.coordinates.y);
                AbilityMapData.Node downNeighbour = node.coordinates.y % 6 == 0 ? this.getNodeAt(node.meta.page + 1, node.coordinates.x, node.coordinates.y + 1) : this.getNodeAt(node.meta.page, node.coordinates.x, node.coordinates.y + 1);
                if (leftNeighbour == null || rightNeighbour == null || downNeighbour == null) {
                    yield RIGHT_DOWN_LEFT;
                }
                if (leftNeighbour.unlocked && rightNeighbour.unlocked && downNeighbour.unlocked) {
                    yield RIGHT_DOWN_LEFT;
                }
                if (leftNeighbour.unlocked && rightNeighbour.unlocked) {
                    yield RIGHT_down_LEFT;
                }
                if (leftNeighbour.unlocked && downNeighbour.unlocked) {
                    yield right_DOWN_LEFT;
                }
                if (rightNeighbour.unlocked && downNeighbour.unlocked) {
                    yield RIGHT_DOWN_left;
                }
                yield RIGHT_DOWN_LEFT;
            }
            case "connector_up_right_down" -> {
                if (!node.unlocked) {
                    yield up_right_down;
                }
                AbilityMapData.Node upNeighbour = this.getNodeAt(node.meta.page, node.coordinates.x, node.coordinates.y - 1);
                AbilityMapData.Node rightNeighbour = this.getNodeAt(node.meta.page, node.coordinates.x + 1, node.coordinates.y);
                AbilityMapData.Node downNeighbour = node.coordinates.y % 6 == 0 ? this.getNodeAt(node.meta.page + 1, node.coordinates.x, node.coordinates.y + 1) : this.getNodeAt(node.meta.page, node.coordinates.x, node.coordinates.y + 1);
                if (upNeighbour == null || rightNeighbour == null || downNeighbour == null) {
                    yield UP_RIGHT_DOWN;
                }
                if (upNeighbour.unlocked && rightNeighbour.unlocked && downNeighbour.unlocked) {
                    yield UP_RIGHT_DOWN;
                }
                if (upNeighbour.unlocked && rightNeighbour.unlocked) {
                    yield UP_RIGHT_down;
                }
                if (upNeighbour.unlocked && downNeighbour.unlocked) {
                    yield UP_right_DOWN;
                }
                if (rightNeighbour.unlocked && downNeighbour.unlocked) {
                    yield up_RIGHT_DOWN;
                }
                yield UP_RIGHT_DOWN;
            }
            case "connector_up_down_left" -> {
                if (!node.unlocked) {
                    yield up_down_left;
                }
                AbilityMapData.Node upNeighbour = this.getNodeAt(node.meta.page, node.coordinates.x, node.coordinates.y - 1);
                AbilityMapData.Node leftNeighbour = this.getNodeAt(node.meta.page, node.coordinates.x - 1, node.coordinates.y);
                AbilityMapData.Node downNeighbour = node.coordinates.y % 6 == 0 ? this.getNodeAt(node.meta.page + 1, node.coordinates.x, node.coordinates.y + 1) : this.getNodeAt(node.meta.page, node.coordinates.x, node.coordinates.y + 1);
                if (upNeighbour == null || leftNeighbour == null || downNeighbour == null) {
                    yield UP_DOWN_LEFT;
                }
                if (upNeighbour.unlocked && leftNeighbour.unlocked && downNeighbour.unlocked) {
                    yield UP_DOWN_LEFT;
                }
                if (upNeighbour.unlocked && leftNeighbour.unlocked) {
                    yield UP_down_LEFT;
                }
                if (upNeighbour.unlocked && downNeighbour.unlocked) {
                    yield UP_DOWN_left;
                }
                if (leftNeighbour.unlocked && downNeighbour.unlocked) {
                    yield up_DOWN_LEFT;
                }
                yield UP_DOWN_LEFT;
            }
            case "connector_up_right_left" -> {
                if (!node.unlocked) {
                    yield up_right_left;
                }
                AbilityMapData.Node upNeighbour = this.getNodeAt(node.meta.page, node.coordinates.x, node.coordinates.y - 1);
                AbilityMapData.Node leftNeighbour = this.getNodeAt(node.meta.page, node.coordinates.x - 1, node.coordinates.y);
                AbilityMapData.Node rightNeighbour = this.getNodeAt(node.meta.page, node.coordinates.x + 1, node.coordinates.y);
                if (upNeighbour == null || leftNeighbour == null || rightNeighbour == null) {
                    yield UP_RIGHT_LEFT;
                }
                if (upNeighbour.unlocked && leftNeighbour.unlocked && rightNeighbour.unlocked) {
                    yield UP_RIGHT_LEFT;
                }
                if (upNeighbour.unlocked && leftNeighbour.unlocked) {
                    yield UP_right_LEFT;
                }
                if (upNeighbour.unlocked && rightNeighbour.unlocked) {
                    yield UP_RIGHT_left;
                }
                if (leftNeighbour.unlocked && rightNeighbour.unlocked) {
                    yield up_RIGHT_LEFT;
                }
                yield UP_RIGHT_LEFT;
            }
            case "connector_up_right_down_left" -> {
                if (!node.unlocked) {
                    yield up_right_down_left;
                }
                AbilityMapData.Node upNeighbour = this.getNodeAt(node.meta.page, node.coordinates.x, node.coordinates.y - 1);
                AbilityMapData.Node leftNeighbour = this.getNodeAt(node.meta.page, node.coordinates.x - 1, node.coordinates.y);
                AbilityMapData.Node rightNeighbour = this.getNodeAt(node.meta.page, node.coordinates.x + 1, node.coordinates.y);
                AbilityMapData.Node downNeighbour = node.coordinates.y % 6 == 0 ? this.getNodeAt(node.meta.page + 1, node.coordinates.x, node.coordinates.y + 1) : this.getNodeAt(node.meta.page, node.coordinates.x, node.coordinates.y + 1);
                if (upNeighbour == null || leftNeighbour == null || rightNeighbour == null || downNeighbour == null) {
                    yield UP_RIGHT_DOWN_LEFT;
                }
                if (upNeighbour.unlocked && leftNeighbour.unlocked && rightNeighbour.unlocked && downNeighbour.unlocked) {
                    yield UP_RIGHT_DOWN_LEFT;
                }
                if (upNeighbour.unlocked && leftNeighbour.unlocked && rightNeighbour.unlocked) {
                    yield UP_RIGHT_down_LEFT;
                }
                if (upNeighbour.unlocked && downNeighbour.unlocked && rightNeighbour.unlocked) {
                    yield UP_RIGHT_DOWN_left;
                }
                if (leftNeighbour.unlocked && downNeighbour.unlocked && rightNeighbour.unlocked) {
                    yield up_RIGHT_DOWN_LEFT;
                }
                if (leftNeighbour.unlocked && downNeighbour.unlocked && upNeighbour.unlocked) {
                    yield UP_right_DOWN_LEFT;
                }
                if (leftNeighbour.unlocked && upNeighbour.unlocked) {
                    yield UP_right_down_LEFT;
                }
                if (rightNeighbour.unlocked && upNeighbour.unlocked) {
                    yield UP_RIGHT_down_left;
                }
                if (rightNeighbour.unlocked && downNeighbour.unlocked) {
                    yield up_RIGHT_DOWN_left;
                }
                if (leftNeighbour.unlocked && downNeighbour.unlocked) {
                    yield up_right_DOWN_LEFT;
                }
                if (upNeighbour.unlocked && downNeighbour.unlocked) {
                    yield UP_right_DOWN_left;
                }
                if (leftNeighbour.unlocked && rightNeighbour.unlocked) {
                    yield up_RIGHT_down_LEFT;
                }
                yield UP_RIGHT_DOWN_LEFT;
            }
            default -> null;
        };
    }

    private AbilityTreeData.Ability findAbilityMatchForHovered(Map<String, AbilityTreeData.Ability> page, AbilityMapData.Node node) {
        for (AbilityTreeData.Ability a : page.values()) {
            if (a.coordinates.x != node.coordinates.x || a.coordinates.y != node.coordinates.y % 6 && (node.coordinates.y % 6 != 0 || a.coordinates.y % 6 != 0)) continue;
            return a;
        }
        return null;
    }

    private class AbilityTreeState {
        AbilityMapData classTree;
        AbilityMapData playerTree;
        final Set<String> unlockedIds = new HashSet<String>();
        final Set<Pair<Integer, Integer>> connectorCoordinates = new HashSet<Pair<Integer, Integer>>();
        final List<AbilityMapData.Node> abilities = new ArrayList<AbilityMapData.Node>();
        final List<AbilityMapData.Node> connectors = new ArrayList<AbilityMapData.Node>();

        private AbilityTreeState() {
        }

        void reset() {
            this.classTree = null;
            this.playerTree = null;
            this.unlockedIds.clear();
            this.connectorCoordinates.clear();
            this.abilities.clear();
            this.connectors.clear();
        }

        void prepare(AbilityMapData classTree, AbilityMapData playerTree) {
            this.classTree = classTree;
            this.playerTree = playerTree;
            for (List<AbilityMapData.Node> nodes : this.playerTree.pages.values()) {
                for (AbilityMapData.Node node : nodes) {
                    if (node.meta == null) continue;
                    if ("ability".equals(node.type) && node.meta.id != null) {
                        this.unlockedIds.add(node.meta.id);
                        continue;
                    }
                    if (!"connector".equals(node.type)) continue;
                    this.connectorCoordinates.add(new Pair<Integer, Integer>(node.coordinates.x, node.coordinates.y));
                }
            }
            int i = 0;
            for (List<AbilityMapData.Node> nodes : this.classTree.pages.values()) {
                int yStart = 0;
                for (AbilityMapData.Node node : nodes) {
                    yStart = AbilityTreeWidget.this.y + 75 + node.coordinates.y * 75 - AbilityTreeWidget.this.scrollOffset;
                    if (node.meta != null) {
                        if ("ability".equals(node.type) && node.meta.id != null) {
                            node.unlocked = this.unlockedIds.contains(node.meta.id);
                        } else {
                            Pair<Integer, Integer> coords = new Pair<Integer, Integer>(node.coordinates.x, node.coordinates.y);
                            node.unlocked = this.connectorCoordinates.contains(coords);
                        }
                    }
                    if ("ability".equals(node.type)) {
                        this.abilities.add(node);
                        continue;
                    }
                    this.connectors.add(node);
                }
                ++i;
                if (AbilityTreeWidget.this.ui == null) {
                    return;
                }
                if (i == 7 || yStart + 75 <= AbilityTreeWidget.this.y || yStart + 75 >= AbilityTreeWidget.this.y + AbilityTreeWidget.this.botLimit) continue;
                AbilityTreeWidget.this.ui.drawImage(pageLineTexture, AbilityTreeWidget.this.x + 1000, yStart + 75, 730.0f, 32.0f);
                if (i == 1 && yStart - 400 > AbilityTreeWidget.this.y && yStart - 400 < AbilityTreeWidget.this.y + AbilityTreeWidget.this.botLimit) {
                    AbilityTreeWidget.this.ui.drawText(String.valueOf(i), AbilityTreeWidget.this.x + 1000, yStart - 400, CustomColor.fromHexString((String)"434654"));
                }
                AbilityTreeWidget.this.ui.drawText(String.valueOf(i + 1), AbilityTreeWidget.this.x + 1000, yStart + 110, CustomColor.fromHexString((String)"434654"));
            }
        }
    }

    public static class NodeWidget
    extends Widget {
        AbilityMapData.Node node;
        int x;
        int y;
        int botLimit;
        int scrollOffset;

        public NodeWidget(int x, int y, AbilityMapData.Node node, int botLimit, int scrollOffset) {
            super(0, 0, 75, 75);
            this.node = node;
            this.x = x;
            this.y = y;
            this.botLimit = botLimit;
            this.scrollOffset = scrollOffset;
        }

        @Override
        protected void drawContent(class_332 ctx, int mouseX, int mouseY, float tickDelta) {
            int xStart = this.x + this.node.coordinates.x * 75 + 925;
            int yStart = this.y + 75 + this.node.coordinates.y * 75 - this.scrollOffset;
            this.setBounds(xStart + 25, yStart, 75, 75);
            class_2960 texture = null;
            switch (((AbilityMapData.Icon.IconValue)((AbilityMapData.Icon)this.node.meta.icon).value).name) {
                case "abilityTree.nodeWarrior": {
                    texture = this.node.unlocked ? warriorActive : warrior;
                    break;
                }
                case "abilityTree.nodeShaman": {
                    texture = this.node.unlocked ? shamanActive : shaman;
                    break;
                }
                case "abilityTree.nodeArcher": {
                    texture = this.node.unlocked ? archerActive : archer;
                    break;
                }
                case "abilityTree.nodeMage": {
                    texture = this.node.unlocked ? mageActive : mage;
                    break;
                }
                case "abilityTree.nodeAssassin": {
                    texture = this.node.unlocked ? assassinActive : assassin;
                    break;
                }
                case "abilityTree.nodeWhite": {
                    texture = this.node.unlocked ? whiteActive : white;
                    break;
                }
                case "abilityTree.nodeYellow": {
                    texture = this.node.unlocked ? yellowActive : yellow;
                    break;
                }
                case "abilityTree.nodeBlue": {
                    texture = this.node.unlocked ? blueActive : blue;
                    break;
                }
                case "abilityTree.nodePurple": {
                    texture = this.node.unlocked ? purpleActive : purple;
                    break;
                }
                case "abilityTree.nodeRed": {
                    class_2960 class_29602 = texture = this.node.unlocked ? redActive : red;
                }
            }
            if (texture != null && yStart - 25 > this.y && yStart - 25 < this.y + this.botLimit) {
                this.ui.drawImage(texture, xStart, yStart - 25, 125.0f, 125.0f);
                if (this.contains(mouseX, mouseY) && (float)mouseY < this.ui.sy(this.y + this.botLimit + 25) && (float)mouseY > this.ui.sy(this.y + 100)) {
                    currentHoveredNode = this.node;
                }
            }
        }
    }
}

