/*
 * Decompiled with CFR 0.152.
 */
package julianh06.wynnextras.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1068;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class SkinManager {
    private static final Map<UUID, class_2960> skinCache = new ConcurrentHashMap<UUID, class_2960>();
    private static final ExecutorService executor = Executors.newCachedThreadPool();
    private static final Map<String, UUID> uuidCache = new HashMap<String, UUID>();

    public static UUID getUUIDFromUsernameCached(String username) throws IOException {
        if (uuidCache.containsKey(username)) {
            return uuidCache.get(username);
        }
        UUID uuid = SkinManager.getUUIDFromUsername(username);
        uuidCache.put(username, uuid);
        return uuid;
    }

    public static class_2960 getSkin(UUID uuid) {
        return skinCache.getOrDefault(uuid, class_1068.method_4649());
    }

    public static class_2960 getSkin(String name) {
        try {
            UUID uuid = SkinManager.getUUIDFromUsername(name);
            if (skinCache.containsKey(uuid)) {
                return skinCache.get(uuid);
            }
            String skinUrl = SkinManager.getSkinURL(uuid);
            class_1011 image = SkinManager.downloadSkin(skinUrl);
            class_2960 id = SkinManager.registerSkin(image, uuid);
            skinCache.put(uuid, id);
            return id;
        }
        catch (IOException e) {
            System.err.println("SkinManager: Error loading skin for " + name + ": " + e.getMessage());
            return class_1068.method_4649();
        }
    }

    public static void loadSkinAsync(UUID uuid, String username, Runnable callback) {
        if (skinCache.containsKey(uuid)) {
            if (callback != null) {
                callback.run();
            }
            return;
        }
        executor.submit(() -> {
            try {
                String skinUrl = SkinManager.getSkinURL(uuid);
                class_1011 image = SkinManager.downloadSkin(skinUrl);
                class_2960 id = SkinManager.registerSkin(image, uuid);
                skinCache.put(uuid, id);
            }
            catch (Exception e) {
                System.err.println("SkinManager: Error loading skin for " + username + ": " + e.getMessage());
            }
            if (callback != null) {
                callback.run();
            }
        });
    }

    private static String getSkinURL(UUID uuid) throws IOException {
        String url = "https://sessionserver.mojang.com/session/minecraft/profile/" + uuid.toString().replace("-", "");
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setRequestMethod("GET");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            JsonArray properties = json.getAsJsonArray("properties");
            for (JsonElement element : properties) {
                JsonObject property = element.getAsJsonObject();
                if (!property.get("name").getAsString().equals("textures")) continue;
                String value = property.get("value").getAsString();
                String decoded = new String(Base64.getDecoder().decode(value), StandardCharsets.UTF_8);
                JsonObject textureJson = JsonParser.parseString((String)decoded).getAsJsonObject();
                String string = textureJson.getAsJsonObject("textures").getAsJsonObject("SKIN").get("url").getAsString();
                return string;
            }
        }
        throw new IOException("Skin-URL not found");
    }

    private static class_1011 downloadSkin(String skinUrl) throws IOException {
        try (InputStream inputStream = new URL(skinUrl).openStream();){
            class_1011 class_10112 = class_1011.method_4309((InputStream)inputStream);
            return class_10112;
        }
    }

    private static class_2960 registerSkin(class_1011 image, UUID uuid) {
        class_2960 id = class_2960.method_60655((String)"customskin", (String)uuid.toString());
        class_310.method_1551().method_1531().method_4616(id, (class_1044)new class_1043(image));
        return id;
    }

    public static UUID getUUIDFromUsername(String username) throws IOException {
        String url = "https://api.mojang.com/users/profiles/minecraft/" + username;
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setRequestMethod("GET");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            String uuidStr = json.get("id").getAsString();
            UUID uUID = UUID.fromString(uuidStr.replaceFirst("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})", "$1-$2-$3-$4-$5"));
            return uUID;
        }
    }
}

