/*
 * Decompiled with CFR 0.152.
 */
package julianh06.wynnextras.mixin;

import com.wynntils.core.components.Models;
import com.wynntils.models.territories.TerritoryInfo;
import com.wynntils.models.territories.type.GuildResource;
import com.wynntils.models.territories.type.GuildResourceValues;
import com.wynntils.utils.type.CappedValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import julianh06.wynnextras.duckInterfaces.Estimation;
import julianh06.wynnextras.duckInterfaces.TerritoryInfoMixinDuck;
import net.minecraft.class_124;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={TerritoryInfo.class}, remap=false)
public class TerritoryInfoMixin
implements TerritoryInfoMixinDuck {
    @Unique
    private static int ThisIsStupid = 60;
    @Shadow
    private String guildPrefix;
    @Shadow
    private GuildResourceValues defences;
    @Final
    @Shadow
    private boolean headquarters;
    @Shadow
    private final HashMap<GuildResource, Integer> generators = new HashMap();
    @Shadow
    private final HashMap<GuildResource, CappedValue> storage = new HashMap();

    @Unique
    private int getUniqueConnections(Integer depth) {
        HashSet<TerritoryInfo> connections = new HashSet<TerritoryInfo>();
        HashSet<TerritoryInfo> friendlyConnections = new HashSet<TerritoryInfo>();
        connections.add((TerritoryInfo)this);
        friendlyConnections.add((TerritoryInfo)this);
        for (int i = 0; i < depth; ++i) {
            for (TerritoryInfo territoryInfo : connections.toArray(new TerritoryInfo[0])) {
                for (String route : territoryInfo.getTradingRoutes()) {
                    TerritoryInfo routeInfo = Models.Territory.getTerritoryPoisFromAdvancement().stream().filter(territoryPoi -> territoryPoi.getName().equals(route)).findFirst().orElseThrow().getTerritoryInfo();
                    connections.add(routeInfo);
                    if (!routeInfo.getGuildPrefix().equals(this.guildPrefix)) continue;
                    friendlyConnections.add(routeInfo);
                }
            }
        }
        return friendlyConnections.size() - 1;
    }

    @Unique
    private Map<GuildResource, Integer> estimateUsedResources(Integer producedEmeralds) {
        HashMap<Integer, Integer> storageToCost = new HashMap<Integer, Integer>();
        storageToCost.put(300, 0);
        storageToCost.put(600, 200);
        storageToCost.put(1200, 400);
        storageToCost.put(2400, 1000);
        storageToCost.put(4500, 2500);
        storageToCost.put(10200, 8000);
        storageToCost.put(24000, 24000);
        int ore = 0;
        int crops = 0;
        int wood = 0;
        int fish = 0;
        int emeralds = 0;
        if (this.defences.getLevel() >= GuildResourceValues.MEDIUM.getLevel()) {
            crops += 800;
            ore += 200;
            if (this.defences.getLevel() >= GuildResourceValues.HIGH.getLevel()) {
                ore += 200;
                wood += 400;
                if (this.defences.getLevel() >= GuildResourceValues.VERY_HIGH.getLevel()) {
                    fish += 4800;
                }
            }
        }
        if (producedEmeralds > 140000) {
            crops += 32000;
            ore += 32000;
        } else if (producedEmeralds > 70000) {
            int storedCrops = this.storage.getOrDefault(GuildResource.CROPS, CappedValue.EMPTY).current();
            int storedOres = this.storage.getOrDefault(GuildResource.ORE, CappedValue.EMPTY).current();
            if (storedOres >= storedCrops) {
                crops += 8000;
                ore += 32000;
            } else {
                crops += 32000;
                ore += 8000;
            }
        } else if (producedEmeralds > 30000) {
            crops += 8000;
            ore += 8000;
        }
        int resourceCap = 0;
        int emeraldCap = this.storage.getOrDefault(GuildResource.EMERALDS, CappedValue.EMPTY).max();
        for (GuildResource resource : GuildResource.values()) {
            if (resource == GuildResource.EMERALDS) continue;
            resourceCap = Math.max(this.storage.getOrDefault(resource, CappedValue.EMPTY).max(), resourceCap);
        }
        if (this.headquarters) {
            resourceCap /= 5;
        }
        if (storageToCost.get(resourceCap) == null) {
            return null;
        }
        emeralds += (Integer)storageToCost.get(resourceCap) * 2;
        wood += storageToCost.getOrDefault(emeraldCap / 10, 0).intValue();
        HashMap<GuildResource, Integer> result = new HashMap<GuildResource, Integer>();
        result.put(GuildResource.ORE, ore);
        result.put(GuildResource.CROPS, crops);
        result.put(GuildResource.WOOD, wood);
        result.put(GuildResource.FISH, fish);
        result.put(GuildResource.EMERALDS, emeralds);
        return result;
    }

    @Unique
    private Map<GuildResource, Estimation> estimateTowerStats(Map<GuildResource, Integer> usedResources, Integer predictedResourceTime) {
        double[] damageBonuses = new double[]{1.4, 1.8, 2.2, 2.6, 3.0, 3.4, 3.8, 4.2, 4.6, 5.0, 5.4};
        double[] healthBonuses = new double[]{1.5, 2.0, 2.5, 3.2, 4.0, 5.0, 6.2, 7.4, 8.6, 9.8, 11.0};
        double[] speedBonuses = new double[]{1.5, 2.0, 2.5, 3.2, 4.0, 5.0, 6.0, 7.2, 7.6, 8.4, 9.4};
        double[] defenceBonuses = new double[]{4.0, 5.5, 6.25, 7.0, 7.5, 7.9, 8.2, 8.4, 8.6, 8.8, 9.0};
        int[] costs = new int[]{100, 300, 600, 1200, 2400, 4800, 8400, 12000, 15600, 19200, 22800};
        HashMap<GuildResource, double[]> resourceToDefence = new HashMap<GuildResource, double[]>();
        resourceToDefence.put(GuildResource.ORE, damageBonuses);
        resourceToDefence.put(GuildResource.WOOD, healthBonuses);
        resourceToDefence.put(GuildResource.CROPS, speedBonuses);
        resourceToDefence.put(GuildResource.FISH, defenceBonuses);
        HashMap<GuildResource, Estimation> result = new HashMap<GuildResource, Estimation>();
        result.put(GuildResource.ORE, new Estimation(1000.0, 0));
        result.put(GuildResource.WOOD, new Estimation(300000.0, 0));
        result.put(GuildResource.CROPS, new Estimation(0.5, 0));
        result.put(GuildResource.FISH, new Estimation(10.0, 0));
        int secondsPassed = 60 - predictedResourceTime;
        double multiplication = 60.0 / (double)secondsPassed;
        for (GuildResource resource : result.keySet()) {
            double stored = this.storage.getOrDefault(resource, CappedValue.EMPTY).current();
            int produced = this.generators.getOrDefault(resource, 0);
            if (produced > 0 && this.defences.getLevel() <= GuildResourceValues.MEDIUM.getLevel() || produced > 24000 && !this.headquarters) {
                result.put(resource, new Estimation(-1.0, -1));
                continue;
            }
            if ((stored -= (double)produced / 3600.0 * (double)secondsPassed) <= 0.0) {
                result.put(resource, new Estimation(-1.0, -1));
                continue;
            }
            double storageAtStart = stored * multiplication;
            storageAtStart -= (double)usedResources.get(resource).intValue() / 60.0;
            int bestPrediction = 0;
            int i = 0;
            while (i < costs.length) {
                double costPerMinute = (double)costs[i] / 60.0;
                if (costPerMinute > storageAtStart) {
                    if (i <= 0 || !(Math.abs(storageAtStart - costPerMinute) < Math.abs(storageAtStart - (double)costs[i - 1] / 60.0))) break;
                    bestPrediction = i;
                    break;
                }
                bestPrediction = i++;
            }
            result.put(resource, new Estimation(((Estimation)result.get(resource)).value() * ((double[])resourceToDefence.get(resource))[bestPrediction], bestPrediction + 1));
        }
        return result;
    }

    @Override
    @Unique
    public List<String> wynnextras$getEstimatedDefences() {
        Map<GuildResource, Integer> usedResources;
        if (this.defences.getLevel() <= GuildResourceValues.VERY_LOW.getLevel()) {
            return null;
        }
        if (this.generators.size() > 3) {
            return List.of(new String[]{String.valueOf(class_124.field_1061) + "Unknown " + String.valueOf(class_124.field_1080) + "(Rainbow territory)"});
        }
        Integer producedEmeralds = this.generators.get(GuildResource.EMERALDS);
        if (producedEmeralds == null) {
            return List.of(new String[]{String.valueOf(class_124.field_1061) + "Unknown " + String.valueOf(class_124.field_1080) + "(Missing generation info)"});
        }
        int currentEmeralds = this.storage.getOrDefault(GuildResource.EMERALDS, CappedValue.EMPTY).current();
        int predictedResourceTime = Math.clamp(Math.round((double)currentEmeralds / ((double)producedEmeralds.intValue() / 60.0) * 60.0), 0, 60);
        boolean usingFallbackTime = false;
        if (predictedResourceTime == 60) {
            predictedResourceTime = ThisIsStupid;
            usingFallbackTime = true;
        }
        ThisIsStupid = predictedResourceTime;
        double connectionBoost = 1.0 + 0.3 * (double)this.getUniqueConnections(1);
        if (this.headquarters) {
            connectionBoost *= 1.5 + 0.25 * (double)this.getUniqueConnections(3);
        }
        if ((usedResources = this.estimateUsedResources(producedEmeralds)) == null) {
            return List.of(new String[]{String.valueOf(class_124.field_1061) + "Unknown " + String.valueOf(class_124.field_1080) + "(Invalid storage info)"});
        }
        Map<GuildResource, Estimation> estimatedStats = this.estimateTowerStats(usedResources, predictedResourceTime);
        ArrayList<String> result = new ArrayList<String>();
        if (usingFallbackTime) {
            result.add(String.valueOf(class_124.field_1054) + "Warning: using fallback time");
        }
        Estimation hp = estimatedStats.get(GuildResource.WOOD);
        Estimation dmg = estimatedStats.get(GuildResource.ORE);
        Estimation speed = estimatedStats.get(GuildResource.CROPS);
        Estimation defence = estimatedStats.get(GuildResource.FISH);
        double dmgv = dmg.value() * connectionBoost;
        BiFunction<String, Double, String> format = (fmt, n) -> n < 0.0 ? "(???)" : String.format(fmt, n);
        Function<Estimation, String> tier = est -> est.tier() < 0 ? "" : String.valueOf(class_124.field_1080) + " (" + est.tier() + ")";
        String connectionText = String.valueOf(class_124.field_1063) + " (x" + String.format("%.2f", connectionBoost) + ")";
        result.add(String.valueOf(class_124.field_1068) + "\u24b7 " + format.apply("%.0f", dmgv) + "-" + format.apply("%.0f", dmgv * 1.5) + " Damage" + tier.apply(dmg) + connectionText);
        result.add(String.valueOf(class_124.field_1054) + "\u24bf " + format.apply("%.2f", speed.value()) + " Attacks/s" + tier.apply(speed));
        result.add(String.valueOf(class_124.field_1065) + "\u24b8 " + format.apply("%.0f", hp.value() * connectionBoost / 1000.0) + "k HP" + tier.apply(hp) + connectionText);
        result.add(String.valueOf(class_124.field_1075) + "\u24c0 " + format.apply("%.0f", defence.value()) + "% Defence" + tier.apply(defence));
        result.add(String.valueOf(class_124.field_1063) + "Next resource move prediction: " + (60 - predictedResourceTime) + "s");
        return result;
    }
}

