/*
 * Decompiled with CFR 0.152.
 */
package julianh06.wynnextras.features.waypoints;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.wynntils.utils.mc.McUtils;
import java.util.List;
import julianh06.wynnextras.annotations.WEModule;
import julianh06.wynnextras.core.WynnExtras;
import julianh06.wynnextras.core.command.Command;
import julianh06.wynnextras.core.command.SubCommand;
import julianh06.wynnextras.event.ClickEvent;
import julianh06.wynnextras.event.KeyInputEvent;
import julianh06.wynnextras.event.TickEvent;
import julianh06.wynnextras.features.waypoints.Waypoint;
import julianh06.wynnextras.features.waypoints.WaypointData;
import julianh06.wynnextras.features.waypoints.WaypointPackage;
import julianh06.wynnextras.features.waypoints.WaypointScreen;
import julianh06.wynnextras.utils.WEVec;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.neoforged.bus.api.SubscribeEvent;

@WEModule
public class Waypoints {
    static boolean commandsInitialized = false;
    private static SubCommand addCmd;
    private static SubCommand addCmdNoArgs;
    private static SubCommand removeCmd;
    private static Command waypointsCmd;
    public static boolean inScreen;

    public static void register() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (commandsInitialized) {
                return;
            }
            addCmd = new SubCommand("add", "", context -> {
                if (class_310.method_1551().field_1724 == null || WaypointData.INSTANCE.packages.getFirst() == null) {
                    return 1;
                }
                int x = IntegerArgumentType.getInteger((CommandContext)context, (String)"x");
                int y = IntegerArgumentType.getInteger((CommandContext)context, (String)"y");
                int z = IntegerArgumentType.getInteger((CommandContext)context, (String)"z");
                McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix(class_2561.method_30163((String)("Waypoint added at " + x + " " + y + " " + z + " in Package " + WaypointData.INSTANCE.packages.getFirst().name))));
                WaypointData.INSTANCE.packages.getFirst().waypoints.add(new Waypoint(x, y, z));
                WaypointData.save();
                return 1;
            }, null, List.of(ClientCommandManager.argument((String)"x", (ArgumentType)IntegerArgumentType.integer()), ClientCommandManager.argument((String)"y", (ArgumentType)IntegerArgumentType.integer()), ClientCommandManager.argument((String)"z", (ArgumentType)IntegerArgumentType.integer())));
            addCmdNoArgs = new SubCommand("add", "", context -> {
                if (class_310.method_1551().field_1724 == null || WaypointData.INSTANCE.packages.getFirst() == null) {
                    return 1;
                }
                int x = (int)Math.floor(class_310.method_1551().field_1724.method_23317());
                int y = (int)Math.floor(class_310.method_1551().field_1724.method_23318()) - 1;
                int z = (int)Math.floor(class_310.method_1551().field_1724.method_23321());
                McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix(class_2561.method_30163((String)("Waypoint added at " + x + " " + y + " " + z + " in Package " + WaypointData.INSTANCE.packages.getFirst().name))));
                WaypointData.INSTANCE.packages.getFirst().waypoints.add(new Waypoint(x, y, z));
                WaypointData.save();
                return 1;
            }, null, null);
            removeCmd = new SubCommand("remove", "removes the closest waypoint", context -> {
                Waypoint closest = null;
                WaypointPackage nearestPackage = null;
                double smallestDistance = -1.0;
                for (WaypointPackage waypointPackage : WaypointData.INSTANCE.packages) {
                    for (Waypoint waypoint : waypointPackage.waypoints) {
                        if (class_310.method_1551().field_1724 == null) {
                            return 1;
                        }
                        WEVec pos = new WEVec((float)waypoint.x + 0.5f, (float)waypoint.y + 1.5f, (float)waypoint.z + 0.5f);
                        WEVec playerPos = new WEVec(class_310.method_1551().field_1724.method_19538());
                        double distance = pos.distanceTo(playerPos);
                        if (closest != null && !(distance < smallestDistance)) continue;
                        closest = waypoint;
                        nearestPackage = waypointPackage;
                        smallestDistance = distance;
                    }
                }
                if (closest != null) {
                    nearestPackage.waypoints.remove(closest);
                    McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix(class_2561.method_30163((String)("Waypoint removed at " + closest.x + " " + closest.y + " " + closest.z + " in package " + nearestPackage.name))));
                    WaypointData.save();
                } else {
                    McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix(class_2561.method_30163((String)"There are no waypoints left to remove.")));
                }
                return 1;
            }, null, null);
            waypointsCmd = new Command("waypoints", "", context -> {
                class_310 mcClient = class_310.method_1551();
                mcClient.method_63588(() -> mcClient.method_1507(null));
                inScreen = true;
                return 1;
            }, List.of(addCmd, addCmdNoArgs, removeCmd), null);
            commandsInitialized = true;
        });
    }

    @SubscribeEvent
    void onTick(TickEvent event) {
        if (inScreen) {
            class_310.method_1551().method_63588(() -> class_310.method_1551().method_1507((class_437)new WaypointScreen()));
            inScreen = false;
        }
    }

    @SubscribeEvent
    void onClick(ClickEvent event) {
        WaypointScreen.onClick();
    }

    @SubscribeEvent
    public void onInput(KeyInputEvent event) {
        if (event.getKey() == 265 && event.getAction() == 1) {
            if (WaypointScreen.scaleFactor == 0) {
                return;
            }
            if ((WaypointScreen.scrollOffset -= 30 / WaypointScreen.scaleFactor) < 0) {
                WaypointScreen.scrollOffset = 0;
            }
        }
        if (event.getKey() == 264 && event.getAction() == 1) {
            if (WaypointScreen.scaleFactor == 0) {
                return;
            }
            WaypointScreen.scrollOffset += 30 / WaypointScreen.scaleFactor;
        }
    }

    static {
        inScreen = false;
    }
}

