/*
 * Decompiled with CFR 0.152.
 */
package julianh06.wynnextras.features.waypoints;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import julianh06.wynnextras.features.waypoints.Waypoint;
import julianh06.wynnextras.features.waypoints.WaypointCategory;
import julianh06.wynnextras.features.waypoints.WaypointData;

public class WaypointPackage {
    public String name;
    public boolean enabled;
    public List<WaypointCategory> categories = new ArrayList<WaypointCategory>();
    public List<Waypoint> waypoints = new ArrayList<Waypoint>();

    public WaypointPackage(String name) {
        this.name = name;
        this.enabled = true;
    }

    public void saveToFile(Path folder) {
        Path path = folder.resolve(this.name + ".json");
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            WaypointData.gson.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            System.err.println("[WynnExtras] Couldn't save package: " + this.name);
            e.printStackTrace();
        }
    }

    public static WaypointPackage loadFromFile(Path file) {
        WaypointPackage waypointPackage;
        block10: {
            BufferedReader reader = Files.newBufferedReader(file);
            try {
                WaypointPackage pkg = (WaypointPackage)WaypointData.gson.fromJson((Reader)reader, WaypointPackage.class);
                block7: for (Waypoint waypoint : pkg.waypoints) {
                    if (waypoint.categoryName == null) continue;
                    for (WaypointCategory cat : pkg.categories) {
                        if (!cat.name.equals(waypoint.categoryName)) continue;
                        waypoint.setCategory(cat);
                        continue block7;
                    }
                }
                waypointPackage = pkg;
                if (reader == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    System.err.println("[WynnExtras] Couldn't load package: " + String.valueOf(file.getFileName()));
                    e.printStackTrace();
                    return null;
                }
            }
            ((Reader)reader).close();
        }
        return waypointPackage;
    }
}

