/*
 * Decompiled with CFR 0.152.
 */
package julianh06.wynnextras.features.waypoints;

import com.wynntils.core.text.StyledText;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import julianh06.wynnextras.features.waypoints.Waypoint;
import julianh06.wynnextras.features.waypoints.WaypointCategory;
import julianh06.wynnextras.features.waypoints.WaypointData;
import julianh06.wynnextras.features.waypoints.WaypointInput;
import julianh06.wynnextras.features.waypoints.WaypointScreen;
import julianh06.wynnextras.utils.overlays.EasyButton;
import julianh06.wynnextras.utils.overlays.EasyDropdown;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public class WaypointElement {
    public Waypoint waypoint;
    public int x;
    public int y;
    public int width;
    public int height;
    public WaypointInput xInput;
    public WaypointInput yInput;
    public WaypointInput zInput;
    public WaypointInput nameInput;
    public EasyButton deleteButton;
    public EasyButton showButton;
    public EasyButton showNameButton;
    public EasyButton showDistanceButton;
    public EasyButton seeThroughButton;
    public EasyDropdown categoryDropdown;
    class_2960 deleteTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/waypoints/deletebutton.png");
    class_2960 inavtiveTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/waypoints/checkboxinactive.png");
    class_2960 activeTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/waypoints/checkboxactive.png");
    class_2960 backgroundTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/waypoints/waypointbackground.png");
    class_2960 coordsBackgroundTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/waypoints/coordinateinput.png");
    class_2960 nameBackgroundTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/waypoints/categoryboxsingle.png");

    public WaypointElement(int x, int y, int width, int height, final Waypoint waypoint) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.waypoint = waypoint;
        this.deleteButton = new EasyButton(this, -1, -1, -1, -1){

            @Override
            public void click() {
                WaypointData.INSTANCE.activePackage.waypoints.remove(waypoint);
            }
        };
        this.showButton = new EasyButton(this, -1, -1, -1, -1){
            public boolean isActive;
            {
                super(x, y, height, width);
                this.isActive = false;
            }

            @Override
            public void click() {
                this.isActive = waypoint.show = !waypoint.show;
            }
        };
        this.showNameButton = new EasyButton(this, -1, -1, -1, -1){
            public boolean isActive;
            {
                super(x, y, height, width);
                this.isActive = false;
            }

            @Override
            public void click() {
                this.isActive = waypoint.showName = !waypoint.showName;
            }
        };
        this.showDistanceButton = new EasyButton(this, -1, -1, -1, -1){
            public boolean isActive;
            {
                super(x, y, height, width);
                this.isActive = false;
            }

            @Override
            public void click() {
                this.isActive = waypoint.showDistance = !waypoint.showDistance;
            }
        };
        this.seeThroughButton = new EasyButton(this, -1, -1, -1, -1){
            public boolean isActive;
            {
                super(x, y, height, width);
                this.isActive = false;
            }

            @Override
            public void click() {
                this.isActive = waypoint.seeThrough = !waypoint.seeThrough;
            }
        };
        this.categoryDropdown = new EasyDropdown(-1, -1, -1, -1);
        this.nameInput = new WaypointInput(x, y, 10, width);
        this.nameInput.setInput(waypoint.name);
        this.xInput = new WaypointInput(x, y, 10, width);
        this.xInput.setInput(String.valueOf(waypoint.x));
        this.yInput = new WaypointInput(x, y, 10, width);
        this.yInput.setInput(String.valueOf(waypoint.y));
        this.zInput = new WaypointInput(x, y, 10, width);
        this.zInput.setInput(String.valueOf(waypoint.z));
    }

    public WaypointElement(Waypoint waypoint) {
        this(-1, -1, -1, -1, waypoint);
    }

    public void draw(int x, int y, int width, int height, class_332 context) {
        this.width = width;
        this.height = height;
        RenderUtils.drawTexturedRect((class_4587)context.method_51448(), (class_2960)this.backgroundTexture, (float)x, (float)y, (float)(width + 1), (float)(height + 2), (int)(width + 1), (int)(height + 2));
        RenderUtils.drawTexturedRect((class_4587)context.method_51448(), (class_2960)this.nameBackgroundTexture, (float)((float)x + 9.0f / (float)WaypointScreen.scaleFactor), (float)((float)y + 7.5f / (float)WaypointScreen.scaleFactor), (float)(270.0f / (float)WaypointScreen.scaleFactor), (float)(39.0f / (float)WaypointScreen.scaleFactor), (int)(270 / WaypointScreen.scaleFactor), (int)(39 / WaypointScreen.scaleFactor));
        this.nameInput.setX(x + 9 / WaypointScreen.scaleFactor);
        this.nameInput.setY(y + 12 / WaypointScreen.scaleFactor);
        this.nameInput.setWidth(267 / WaypointScreen.scaleFactor);
        this.nameInput.setHeight(36 / WaypointScreen.scaleFactor);
        this.nameInput.drawWithoutBackgroundButWithSearchtext(context, CustomColor.fromHexString((String)"FFFFFF"));
        RenderUtils.drawTexturedRect((class_4587)context.method_51448(), (class_2960)this.nameBackgroundTexture, (float)((float)x + 280.5f / (float)WaypointScreen.scaleFactor), (float)((float)y + 7.5f / (float)WaypointScreen.scaleFactor), (float)(270.0f / (float)WaypointScreen.scaleFactor), (float)(39.0f / (float)WaypointScreen.scaleFactor), (int)(270 / WaypointScreen.scaleFactor), (int)(39 / WaypointScreen.scaleFactor));
        this.categoryDropdown.setX(x + 282 / WaypointScreen.scaleFactor);
        this.categoryDropdown.setY(y + 12 / WaypointScreen.scaleFactor);
        this.categoryDropdown.setWidth(267.0f / (float)WaypointScreen.scaleFactor);
        this.categoryDropdown.setHeight(36.0f / (float)WaypointScreen.scaleFactor);
        if (this.waypoint.getCategory() == null) {
            FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromComponent((class_2561)class_2561.method_30163((String)"Select a category")), (float)x + 291.0f / (float)WaypointScreen.scaleFactor, (float)y + 18.0f / (float)WaypointScreen.scaleFactor, CustomColor.fromHexString((String)"ffffff"), HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NORMAL, 2.75f / (float)WaypointScreen.scaleFactor);
        } else {
            FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromComponent((class_2561)class_2561.method_30163((String)this.waypoint.getCategory().name)), (float)x + 291.0f / (float)WaypointScreen.scaleFactor, (float)y + 18.0f / (float)WaypointScreen.scaleFactor, this.waypoint.getCategory().color, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NORMAL, 2.75f / (float)WaypointScreen.scaleFactor);
        }
        RenderUtils.drawTexturedRect((class_4587)context.method_51448(), (class_2960)this.coordsBackgroundTexture, (float)((float)x + 9.0f / (float)WaypointScreen.scaleFactor), (float)((float)y + 54.0f / (float)WaypointScreen.scaleFactor), (float)(195.0f / (float)WaypointScreen.scaleFactor), (float)(39.0f / (float)WaypointScreen.scaleFactor), (int)(195 / WaypointScreen.scaleFactor), (int)(39 / WaypointScreen.scaleFactor));
        this.xInput.setX(x + 45 / WaypointScreen.scaleFactor);
        this.xInput.setY(y + 57 / WaypointScreen.scaleFactor);
        this.xInput.setWidth(width / 3 - 39 / WaypointScreen.scaleFactor);
        this.xInput.setHeight(39 / WaypointScreen.scaleFactor);
        this.xInput.drawWithoutBackgroundButWithSearchtext(context, CustomColor.fromHexString((String)"FFFFFF"));
        FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromComponent((class_2561)class_2561.method_30163((String)"x:")), (float)x + 18.0f / (float)WaypointScreen.scaleFactor, (float)y + 75.0f / (float)WaypointScreen.scaleFactor, CustomColor.fromHexString((String)"ffffff"), HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 3.0f / (float)WaypointScreen.scaleFactor);
        RenderUtils.drawTexturedRect((class_4587)context.method_51448(), (class_2960)this.coordsBackgroundTexture, (float)((float)(x + 2) + (float)width / 3.0f), (float)((float)y + 54.0f / (float)WaypointScreen.scaleFactor), (float)(195.0f / (float)WaypointScreen.scaleFactor), (float)(39.0f / (float)WaypointScreen.scaleFactor), (int)(195 / WaypointScreen.scaleFactor), (int)(39 / WaypointScreen.scaleFactor));
        this.yInput.setX(x + width / 3 + 42 / WaypointScreen.scaleFactor);
        this.yInput.setY(y + 57 / WaypointScreen.scaleFactor);
        this.yInput.setWidth(width / 3 - 39 / WaypointScreen.scaleFactor);
        this.yInput.setHeight(39 / WaypointScreen.scaleFactor);
        this.yInput.drawWithoutBackgroundButWithSearchtext(context, CustomColor.fromHexString((String)"FFFFFF"));
        FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromComponent((class_2561)class_2561.method_30163((String)"y:")), (float)x + (float)width / 3.0f + 12.0f / (float)WaypointScreen.scaleFactor, (float)y + 72.0f / (float)WaypointScreen.scaleFactor, CustomColor.fromHexString((String)"ffffff"), HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 3.0f / (float)WaypointScreen.scaleFactor);
        RenderUtils.drawTexturedRect((class_4587)context.method_51448(), (class_2960)this.coordsBackgroundTexture, (float)((float)(x + 1) + 2.0f * (float)width / 3.0f), (float)((float)y + 54.0f / (float)WaypointScreen.scaleFactor), (float)(195.0f / (float)WaypointScreen.scaleFactor), (float)(39.0f / (float)WaypointScreen.scaleFactor), (int)(195 / WaypointScreen.scaleFactor), (int)(39 / WaypointScreen.scaleFactor));
        this.zInput.setX(x + 2 * width / 3 + 39 / WaypointScreen.scaleFactor);
        this.zInput.setY(y + 57 / WaypointScreen.scaleFactor);
        this.zInput.setWidth(width / 3 - 39 / WaypointScreen.scaleFactor);
        this.zInput.setHeight(39 / WaypointScreen.scaleFactor);
        this.zInput.drawWithoutBackgroundButWithSearchtext(context, CustomColor.fromHexString((String)"FFFFFF"));
        FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromComponent((class_2561)class_2561.method_30163((String)"z:")), (float)x + 2.0f * (float)width / 3.0f + 10.5f / (float)WaypointScreen.scaleFactor, (float)y + 72.0f / (float)WaypointScreen.scaleFactor, CustomColor.fromHexString((String)"ffffff"), HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 3.0f / (float)WaypointScreen.scaleFactor);
        this.deleteButton.setX(x + width - 48 / WaypointScreen.scaleFactor);
        this.deleteButton.setY(y + 6 / WaypointScreen.scaleFactor);
        this.deleteButton.setWidth(45.0f / (float)WaypointScreen.scaleFactor);
        this.deleteButton.setHeight(45.0f / (float)WaypointScreen.scaleFactor);
        this.deleteButton.drawWithTexture(context, this.deleteTexture);
        this.showButton.setX(x + 9 / WaypointScreen.scaleFactor);
        this.showButton.setY(y + 99 / WaypointScreen.scaleFactor);
        this.showButton.setWidth(45.0f / (float)WaypointScreen.scaleFactor);
        this.showButton.setHeight(45.0f / (float)WaypointScreen.scaleFactor);
        if (this.waypoint.show) {
            this.showButton.drawWithTexture(context, this.activeTexture);
        } else {
            this.showButton.drawWithTexture(context, this.inavtiveTexture);
        }
        FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromComponent((class_2561)class_2561.method_30163((String)"Highlight")), (float)x + 60.0f / (float)WaypointScreen.scaleFactor, (float)y + 111.0f / (float)WaypointScreen.scaleFactor, CustomColor.fromHexString((String)"ffffff"), HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 2.5f / (float)WaypointScreen.scaleFactor);
        FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromComponent((class_2561)class_2561.method_30163((String)"Block")), (float)x + 60.0f / (float)WaypointScreen.scaleFactor, (float)y + 136.5f / (float)WaypointScreen.scaleFactor, CustomColor.fromHexString((String)"ffffff"), HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 2.75f / (float)WaypointScreen.scaleFactor);
        this.showNameButton.setX(x + 9 / WaypointScreen.scaleFactor + width / 4);
        this.showNameButton.setY(y + 99 / WaypointScreen.scaleFactor);
        this.showNameButton.setWidth(45.0f / (float)WaypointScreen.scaleFactor);
        this.showNameButton.setHeight(45.0f / (float)WaypointScreen.scaleFactor);
        if (this.waypoint.showName) {
            this.showNameButton.drawWithTexture(context, this.activeTexture);
        } else {
            this.showNameButton.drawWithTexture(context, this.inavtiveTexture);
        }
        FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromComponent((class_2561)class_2561.method_30163((String)"Show")), (float)x + 60.0f / (float)WaypointScreen.scaleFactor + (float)width / 4.0f, (float)y + 111.0f / (float)WaypointScreen.scaleFactor, CustomColor.fromHexString((String)"ffffff"), HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 2.75f / (float)WaypointScreen.scaleFactor);
        FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromComponent((class_2561)class_2561.method_30163((String)"Name")), (float)x + 60.0f / (float)WaypointScreen.scaleFactor + (float)width / 4.0f, (float)y + 136.5f / (float)WaypointScreen.scaleFactor, CustomColor.fromHexString((String)"ffffff"), HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 2.75f / (float)WaypointScreen.scaleFactor);
        this.showDistanceButton.setX(x + 6 / WaypointScreen.scaleFactor + 2 * width / 4);
        this.showDistanceButton.setY(y + 99 / WaypointScreen.scaleFactor);
        this.showDistanceButton.setWidth(45.0f / (float)WaypointScreen.scaleFactor);
        this.showDistanceButton.setHeight(45.0f / (float)WaypointScreen.scaleFactor);
        if (this.waypoint.showDistance) {
            this.showDistanceButton.drawWithTexture(context, this.activeTexture);
        } else {
            this.showDistanceButton.drawWithTexture(context, this.inavtiveTexture);
        }
        FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromComponent((class_2561)class_2561.method_30163((String)"Show")), (float)x + 60.0f / (float)WaypointScreen.scaleFactor + 2.0f * (float)width / 4.0f, (float)y + 111.0f / (float)WaypointScreen.scaleFactor, CustomColor.fromHexString((String)"ffffff"), HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 2.75f / (float)WaypointScreen.scaleFactor);
        FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromComponent((class_2561)class_2561.method_30163((String)"Distance")), (float)x + 60.0f / (float)WaypointScreen.scaleFactor + 2.0f * (float)width / 4.0f, (float)y + 136.5f / (float)WaypointScreen.scaleFactor, CustomColor.fromHexString((String)"ffffff"), HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 2.25f / (float)WaypointScreen.scaleFactor);
        this.seeThroughButton.setX(x + 6 / WaypointScreen.scaleFactor + 3 * width / 4);
        this.seeThroughButton.setY(y + 99 / WaypointScreen.scaleFactor);
        this.seeThroughButton.setWidth(45.0f / (float)WaypointScreen.scaleFactor);
        this.seeThroughButton.setHeight(45.0f / (float)WaypointScreen.scaleFactor);
        if (this.waypoint.seeThrough) {
            this.seeThroughButton.drawWithTexture(context, this.activeTexture);
        } else {
            this.seeThroughButton.drawWithTexture(context, this.inavtiveTexture);
        }
        FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromComponent((class_2561)class_2561.method_30163((String)"See")), (float)x + 60.0f / (float)WaypointScreen.scaleFactor + 3.0f * (float)width / 4.0f, (float)y + 111.0f / (float)WaypointScreen.scaleFactor, CustomColor.fromHexString((String)"ffffff"), HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 2.75f / (float)WaypointScreen.scaleFactor);
        FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromComponent((class_2561)class_2561.method_30163((String)"Through")), (float)x + 60.0f / (float)WaypointScreen.scaleFactor + 3.0f * (float)width / 4.0f, (float)y + 136.5f / (float)WaypointScreen.scaleFactor, CustomColor.fromHexString((String)"ffffff"), HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 2.25f / (float)WaypointScreen.scaleFactor);
    }

    public void click(int mouseX, int mouseY) {
        if (this.categoryDropdown.isClickInBounds(mouseX, mouseY)) {
            WaypointCategory category = this.categoryDropdown.clickAndGetCategory();
            if (category != null) {
                System.out.println(category.name);
                this.waypoint.setCategory(category);
                WaypointData.save();
            }
            this.nameInput.setActive(false);
            this.xInput.setActive(false);
            this.yInput.setActive(false);
            this.zInput.setActive(false);
            return;
        }
        if (this.categoryDropdown.isExpanded) {
            this.categoryDropdown.isExpanded = false;
            this.nameInput.setActive(false);
            this.xInput.setActive(false);
            this.yInput.setActive(false);
            this.zInput.setActive(false);
            return;
        }
        if (this.showButton.isClickInBounds(mouseX, mouseY)) {
            this.showButton.click();
        }
        if (this.showNameButton.isClickInBounds(mouseX, mouseY)) {
            this.showNameButton.click();
        }
        if (this.showDistanceButton.isClickInBounds(mouseX, mouseY)) {
            this.showDistanceButton.click();
        }
        if (this.seeThroughButton.isClickInBounds(mouseX, mouseY)) {
            this.seeThroughButton.click();
        }
        if (this.nameInput.isClickInBounds(mouseX, mouseY)) {
            this.nameInput.click();
        } else {
            this.nameInput.setActive(false);
        }
        if (this.xInput.isClickInBounds(mouseX, mouseY)) {
            this.xInput.click();
        } else {
            this.xInput.setActive(false);
        }
        if (this.yInput.isClickInBounds(mouseX, mouseY)) {
            this.yInput.click();
        } else {
            this.yInput.setActive(false);
        }
        if (this.zInput.isClickInBounds(mouseX, mouseY)) {
            this.zInput.click();
        } else {
            this.zInput.setActive(false);
        }
    }
}

