/*
 * Decompiled with CFR 0.152.
 */
package julianh06.wynnextras.features.waypoints;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.wynntils.core.text.StyledText;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import julianh06.wynnextras.features.misc.StyledTextAdapter;
import julianh06.wynnextras.features.waypoints.Waypoint;
import julianh06.wynnextras.features.waypoints.WaypointCategory;
import julianh06.wynnextras.features.waypoints.WaypointPackage;
import net.fabricmc.loader.api.FabricLoader;

public class WaypointData {
    public static WaypointData INSTANCE = new WaypointData();
    public List<WaypointPackage> packages = new ArrayList<WaypointPackage>();
    public WaypointPackage activePackage = null;
    static GsonBuilder builder = new GsonBuilder().registerTypeAdapter(StyledText.class, (Object)new StyledTextAdapter());
    static Gson gson = builder.setPrettyPrinting().create();
    private static final Path PACKAGE_FOLDER = FabricLoader.getInstance().getConfigDir().resolve("wynnextras/packages");

    public static void load() {
        INSTANCE = new WaypointData();
        try {
            if (!Files.exists(PACKAGE_FOLDER, new LinkOption[0])) {
                Files.createDirectories(PACKAGE_FOLDER, new FileAttribute[0]);
            }
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(PACKAGE_FOLDER, "*.json");){
                for (Path file : stream) {
                    WaypointPackage pkg = WaypointPackage.loadFromFile(file);
                    if (pkg == null) continue;
                    WaypointData.INSTANCE.packages.add(pkg);
                }
            }
        }
        catch (IOException e) {
            System.err.println("[WynnExtras] Couldn't load packages:");
            e.printStackTrace();
        }
        if (WaypointData.INSTANCE.packages.isEmpty()) {
            WaypointPackage defaultPkg = new WaypointPackage("Default");
            WaypointData.INSTANCE.packages.add(defaultPkg);
            WaypointData.INSTANCE.activePackage = defaultPkg;
        }
    }

    public static void save() {
        try {
            if (!Files.exists(PACKAGE_FOLDER, new LinkOption[0])) {
                Files.createDirectories(PACKAGE_FOLDER, new FileAttribute[0]);
            }
            for (WaypointPackage pkg : WaypointData.INSTANCE.packages) {
                pkg.saveToFile(PACKAGE_FOLDER);
            }
        }
        catch (IOException e) {
            System.err.println("[WynnExtras] Couldn't save packages:");
            e.printStackTrace();
        }
    }

    public void deletePackage(String name) {
        this.packages.removeIf(pkg -> pkg.name.equals(name));
        try {
            Files.deleteIfExists(PACKAGE_FOLDER.resolve(name + ".json"));
        }
        catch (IOException e) {
            System.err.println("[WynnExtras] Couldn't delete package file: " + name);
            e.printStackTrace();
        }
    }

    public WaypointPackage duplicatePackage(String originalName) {
        WaypointPackage original = this.packages.stream().filter(pkg -> pkg.name.equals(originalName)).findFirst().orElse(null);
        if (original == null) {
            return null;
        }
        WaypointPackage copy = new WaypointPackage(this.generateUniqueName(original.name));
        for (WaypointCategory cat : original.categories) {
            copy.categories.add(new WaypointCategory(cat.name, cat.color));
        }
        for (Waypoint waypoint : original.waypoints) {
            Waypoint newWaypoint = new Waypoint(waypoint.x, waypoint.y, waypoint.z);
            newWaypoint.name = waypoint.name;
            newWaypoint.show = waypoint.show;
            newWaypoint.showName = waypoint.showName;
            newWaypoint.showDistance = waypoint.showDistance;
            newWaypoint.seeThrough = waypoint.seeThrough;
            newWaypoint.categoryName = waypoint.categoryName;
            for (WaypointCategory cat : copy.categories) {
                if (!cat.name.equals(newWaypoint.categoryName)) continue;
                newWaypoint.setCategory(cat);
                break;
            }
            copy.waypoints.add(newWaypoint);
        }
        this.packages.add(copy);
        WaypointData.save();
        return copy;
    }

    public String generateUniqueName(String baseName) {
        int counter = 0;
        while (true) {
            String candidate;
            String checkName = candidate = counter == 0 ? baseName : baseName + " (" + counter + ")";
            boolean exists = this.packages.stream().anyMatch(pkg -> pkg.name != null && pkg.name.equals(checkName));
            if (!exists) {
                return candidate;
            }
            ++counter;
        }
    }
}

