/*
 * Decompiled with CFR 0.152.
 */
package julianh06.wynnextras.features.waypoints;

import com.google.gson.Gson;
import com.wynntils.core.text.StyledText;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.ArrayList;
import julianh06.wynnextras.features.waypoints.CategoryElement;
import julianh06.wynnextras.features.waypoints.Waypoint;
import julianh06.wynnextras.features.waypoints.WaypointCategory;
import julianh06.wynnextras.features.waypoints.WaypointData;
import julianh06.wynnextras.features.waypoints.WaypointElement;
import julianh06.wynnextras.features.waypoints.WaypointInput;
import julianh06.wynnextras.features.waypoints.WaypointPackage;
import julianh06.wynnextras.features.waypoints.WaypointScreen;
import julianh06.wynnextras.utils.overlays.EasyButton;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public class PackageElement {
    public WaypointPackage waypointPackage;
    public int x;
    public int y;
    public int width;
    public int height;
    public WaypointInput nameInput;
    public EasyButton deleteButton;
    public EasyButton enableButton;
    public EasyButton exportButton;
    public EasyButton duplicateButton;
    public EasyButton selectButton;
    class_2960 deleteTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/waypoints/deletebutton.png");
    class_2960 exportButtonTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/waypoints/exportbutton.png");
    class_2960 activeTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/waypoints/checkboxactive.png");
    class_2960 inactiveTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/waypoints/checkboxinactive.png");
    class_2960 backgroundTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/waypoints/categorybackground.png");
    class_2960 nameBackgroundTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/waypoints/nameinputcategory.png");

    public PackageElement(int x, int y, int width, int height, final WaypointPackage waypointPackage) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.waypointPackage = waypointPackage;
        this.deleteButton = new EasyButton(this, -1, -1, -1, -1){

            @Override
            public void click() {
                WaypointData.INSTANCE.deletePackage(waypointPackage.name);
                WaypointScreen.packageElements.clear();
                for (WaypointPackage pkg : WaypointData.INSTANCE.packages) {
                    WaypointScreen.packageElements.add(new PackageElement(-1, -1, -1, -1, pkg));
                }
            }
        };
        this.enableButton = new EasyButton(this, -1, -1, -1, -1){

            @Override
            public void click() {
                if (waypointPackage == null) {
                    return;
                }
                waypointPackage.enabled = !waypointPackage.enabled;
            }
        };
        this.duplicateButton = new EasyButton(this, -1, -1, -1, -1){

            @Override
            public void click() {
                WaypointData.INSTANCE.duplicatePackage(waypointPackage.name);
                WaypointScreen.packageElements.clear();
                for (WaypointPackage pkg : WaypointData.INSTANCE.packages) {
                    WaypointScreen.packageElements.add(new PackageElement(-1, -1, -1, -1, pkg));
                }
            }
        };
        this.exportButton = new EasyButton(this, -1, -1, -1, -1){

            @Override
            public void click() {
                String json = new Gson().toJson((Object)waypointPackage);
                class_310.method_1551().field_1774.method_1455(json);
                WaypointData.save();
            }
        };
        this.selectButton = new EasyButton(this, -1, -1, -1, -1){

            @Override
            public void click() {
                WaypointData.INSTANCE.activePackage = waypointPackage;
                WaypointScreen.elements = new ArrayList<WaypointElement>();
                WaypointScreen.categories = new ArrayList<CategoryElement>();
                for (Waypoint waypoint : WaypointData.INSTANCE.activePackage.waypoints) {
                    WaypointScreen.elements.add(new WaypointElement(waypoint));
                }
                for (WaypointCategory category : WaypointData.INSTANCE.activePackage.categories) {
                    WaypointScreen.categories.add(new CategoryElement(category));
                }
                WaypointScreen.activeCategories.clear();
                WaypointScreen.activeCategories.addAll(WaypointData.INSTANCE.activePackage.categories);
                WaypointScreen.scrollOffset = 0;
            }
        };
        this.nameInput = new WaypointInput(x, y, 10, width);
        String input = waypointPackage.name == null ? WaypointData.INSTANCE.generateUniqueName("Unnamed Package") : waypointPackage.name;
        this.nameInput.setInput(input);
    }

    public void draw(int x, int y, int width, int height, class_332 context) {
        this.width = width;
        this.height = height;
        RenderUtils.drawTexturedRect((class_4587)context.method_51448(), (class_2960)this.backgroundTexture, (float)x, (float)y, (float)(width + 1), (float)(height + 2), (int)(width + 1), (int)(height + 2));
        RenderUtils.drawTexturedRect((class_4587)context.method_51448(), (class_2960)this.nameBackgroundTexture, (float)((float)x + 9.0f / (float)WaypointScreen.scaleFactor), (float)((float)y + 7.5f / (float)WaypointScreen.scaleFactor), (float)(540.0f / (float)WaypointScreen.scaleFactor), (float)(39.0f / (float)WaypointScreen.scaleFactor), (int)(540 / WaypointScreen.scaleFactor), (int)(39 / WaypointScreen.scaleFactor));
        this.nameInput.setX(x + 9 / WaypointScreen.scaleFactor);
        this.nameInput.setY(y + 12 / WaypointScreen.scaleFactor);
        this.nameInput.setWidth(540 / WaypointScreen.scaleFactor);
        this.nameInput.setHeight(36 / WaypointScreen.scaleFactor);
        this.nameInput.drawWithoutBackgroundButWithSearchtext(context, CustomColor.fromHexString((String)"FFFFFF"));
        this.deleteButton.setX(x + width - 48 / WaypointScreen.scaleFactor);
        this.deleteButton.setY(y + 6 / WaypointScreen.scaleFactor);
        this.deleteButton.setWidth(45.0f / (float)WaypointScreen.scaleFactor);
        this.deleteButton.setHeight(45.0f / (float)WaypointScreen.scaleFactor);
        this.deleteButton.drawWithTexture(context, this.deleteTexture);
        this.enableButton.setX(x + 9 / WaypointScreen.scaleFactor);
        this.enableButton.setY(y + 60 / WaypointScreen.scaleFactor);
        this.enableButton.setWidth(45.0f / (float)WaypointScreen.scaleFactor);
        this.enableButton.setHeight(45.0f / (float)WaypointScreen.scaleFactor);
        this.enableButton.drawWithTexture(context, this.waypointPackage.enabled ? this.activeTexture : this.inactiveTexture);
        FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromComponent((class_2561)class_2561.method_30163((String)"Toggle package")), (float)x + 65.0f / (float)WaypointScreen.scaleFactor, (float)y + 72.0f / (float)WaypointScreen.scaleFactor, CustomColor.fromHexString((String)"ffffff"), HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NORMAL, 2.75f / (float)WaypointScreen.scaleFactor);
        this.selectButton.setX(x + width / 2 - 150 / WaypointScreen.scaleFactor);
        this.selectButton.setY(y + 180 / WaypointScreen.scaleFactor);
        this.selectButton.setWidth(300.0f / (float)WaypointScreen.scaleFactor);
        this.selectButton.setHeight(36.0f / (float)WaypointScreen.scaleFactor);
        this.selectButton.drawWithTexture(context, this.exportButtonTexture);
        FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromComponent((class_2561)class_2561.method_30163((String)"Edit package")), (float)x + (float)width / 2.0f, (float)y + 186.0f / (float)WaypointScreen.scaleFactor, CustomColor.fromHexString((String)"ffffff"), HorizontalAlignment.CENTER, VerticalAlignment.TOP, TextShadow.NORMAL, 2.75f / (float)WaypointScreen.scaleFactor);
        this.duplicateButton.setX(x + width / 2 - 150 / WaypointScreen.scaleFactor);
        this.duplicateButton.setY(y + 135 / WaypointScreen.scaleFactor);
        this.duplicateButton.setWidth(300.0f / (float)WaypointScreen.scaleFactor);
        this.duplicateButton.setHeight(36.0f / (float)WaypointScreen.scaleFactor);
        this.duplicateButton.drawWithTexture(context, this.exportButtonTexture);
        FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromComponent((class_2561)class_2561.method_30163((String)"Duplicate Package")), (float)x + (float)width / 2.0f, (float)y + 144.0f / (float)WaypointScreen.scaleFactor, CustomColor.fromHexString((String)"ffffff"), HorizontalAlignment.CENTER, VerticalAlignment.TOP, TextShadow.NORMAL, 2.75f / (float)WaypointScreen.scaleFactor);
        this.exportButton.setX(x + width / 2 - 150 / WaypointScreen.scaleFactor);
        this.exportButton.setY(y + height - 53 / WaypointScreen.scaleFactor);
        this.exportButton.setWidth(300.0f / (float)WaypointScreen.scaleFactor);
        this.exportButton.setHeight(36.0f / (float)WaypointScreen.scaleFactor);
        this.exportButton.drawWithTexture(context, this.exportButtonTexture);
        FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromComponent((class_2561)class_2561.method_30163((String)"Export to clipboard")), (float)x + (float)width / 2.0f, (float)(y + height) - 45.0f / (float)WaypointScreen.scaleFactor, CustomColor.fromHexString((String)"ffffff"), HorizontalAlignment.CENTER, VerticalAlignment.TOP, TextShadow.NORMAL, 2.75f / (float)WaypointScreen.scaleFactor);
    }

    public void click(int mouseX, int mouseY) {
        if (this.enableButton.isClickInBounds(mouseX, mouseY)) {
            this.enableButton.click();
        }
        if (this.duplicateButton.isClickInBounds(mouseX, mouseY)) {
            this.duplicateButton.click();
        }
        if (this.exportButton.isClickInBounds(mouseX, mouseY)) {
            this.exportButton.click();
        }
        if (this.selectButton.isClickInBounds(mouseX, mouseY)) {
            this.selectButton.click();
        }
        if (this.deleteButton.isClickInBounds(mouseX, mouseY)) {
            this.deleteButton.click();
        }
        if (this.nameInput.isClickInBounds(mouseX, mouseY)) {
            this.nameInput.click();
        } else {
            this.nameInput.setActive(false);
        }
    }
}

