/*
 * Decompiled with CFR 0.152.
 */
package julianh06.wynnextras.features.waypoints;

import com.wynntils.core.text.StyledText;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import julianh06.wynnextras.core.WynnExtras;
import julianh06.wynnextras.features.waypoints.WaypointCategory;
import julianh06.wynnextras.features.waypoints.WaypointData;
import julianh06.wynnextras.features.waypoints.WaypointElement;
import julianh06.wynnextras.features.waypoints.WaypointInput;
import julianh06.wynnextras.features.waypoints.WaypointScreen;
import julianh06.wynnextras.utils.overlays.EasyButton;
import julianh06.wynnextras.utils.overlays.EasyColorPicker;
import julianh06.wynnextras.utils.overlays.EasySlider;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import org.lwjgl.glfw.GLFW;

public class CategoryElement {
    public WaypointCategory category;
    public int x;
    public int y;
    public int width;
    public int height;
    public WaypointInput nameInput;
    public EasyButton deleteButton;
    public EasyButton hideAllBlocksButton;
    public EasyButton showAllBlocksButton;
    public EasyButton hideAllNamesButton;
    public EasyButton showAllNamesButton;
    public EasyButton hideAllDistancesButton;
    public EasyButton showAllDistancesButton;
    public EasyButton enableAllSeeTroughButton;
    public EasyButton disableAllSeeTroughButton;
    public EasyColorPicker colorPicker;
    public EasySlider alphaSlider;
    class_2960 deleteTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/waypoints/deletebutton.png");
    class_2960 exportButtonTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/waypoints/exportbutton.png");
    class_2960 activeTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/waypoints/checkboxactive.png");
    class_2960 backgroundTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/waypoints/categorybackground.png");
    class_2960 nameBackgroundTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/waypoints/nameinputcategory.png");
    class_2960 colorPickerBorderTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/waypoints/colorpickerborder.png");

    public CategoryElement(int x, int y, int width, int height, final WaypointCategory category) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.deleteButton = new EasyButton(this, -1, -1, -1, -1){

            @Override
            public void click() {
                WaypointData.INSTANCE.activePackage.categories.remove(category);
            }
        };
        this.hideAllBlocksButton = new EasyButton(this, -1, -1, -1, -1){

            @Override
            public void click() {
                for (WaypointElement element : WaypointScreen.elements) {
                    if (element.waypoint.categoryName == null || element.waypoint.categoryName.isEmpty() || !element.waypoint.categoryName.equals(category.name)) continue;
                    element.waypoint.show = false;
                }
                McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix(class_2561.method_30163((String)("Now hiding block highlights for all waypoints of category " + category.name))));
            }
        };
        this.showAllBlocksButton = new EasyButton(this, -1, -1, -1, -1){

            @Override
            public void click() {
                for (WaypointElement element : WaypointScreen.elements) {
                    if (element.waypoint.categoryName == null || element.waypoint.categoryName.isEmpty() || !element.waypoint.categoryName.equals(category.name)) continue;
                    element.waypoint.show = true;
                }
                McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix(class_2561.method_30163((String)("Now showing block highlights for all waypoints of category " + category.name))));
            }
        };
        this.hideAllNamesButton = new EasyButton(this, -1, -1, -1, -1){

            @Override
            public void click() {
                for (WaypointElement element : WaypointScreen.elements) {
                    if (element.waypoint.categoryName == null || element.waypoint.categoryName.isEmpty() || !element.waypoint.categoryName.equals(category.name)) continue;
                    element.waypoint.showName = false;
                }
                McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix(class_2561.method_30163((String)("Now hiding names of all waypoints of category " + category.name))));
            }
        };
        this.showAllNamesButton = new EasyButton(this, -1, -1, -1, -1){

            @Override
            public void click() {
                for (WaypointElement element : WaypointScreen.elements) {
                    if (element.waypoint.categoryName == null || element.waypoint.categoryName.isEmpty() || !element.waypoint.categoryName.equals(category.name)) continue;
                    element.waypoint.showName = true;
                }
                McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix(class_2561.method_30163((String)("Now showing names of all waypoints of category " + category.name))));
            }
        };
        this.hideAllDistancesButton = new EasyButton(this, -1, -1, -1, -1){

            @Override
            public void click() {
                for (WaypointElement element : WaypointScreen.elements) {
                    if (element.waypoint.categoryName == null || element.waypoint.categoryName.isEmpty() || !element.waypoint.categoryName.equals(category.name)) continue;
                    element.waypoint.showDistance = false;
                }
                McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix(class_2561.method_30163((String)("Now hiding distances to all waypoints of category " + category.name))));
            }
        };
        this.showAllDistancesButton = new EasyButton(this, -1, -1, -1, -1){

            @Override
            public void click() {
                for (WaypointElement element : WaypointScreen.elements) {
                    if (element.waypoint.categoryName == null || element.waypoint.categoryName.isEmpty() || !element.waypoint.categoryName.equals(category.name)) continue;
                    element.waypoint.showDistance = true;
                }
                McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix(class_2561.method_30163((String)("Now showing distances to all waypoints of category " + category.name))));
            }
        };
        this.enableAllSeeTroughButton = new EasyButton(this, -1, -1, -1, -1){

            @Override
            public void click() {
                for (WaypointElement element : WaypointScreen.elements) {
                    if (element.waypoint.categoryName == null || element.waypoint.categoryName.isEmpty() || !element.waypoint.categoryName.equals(category.name)) continue;
                    element.waypoint.seeThrough = true;
                }
                McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix(class_2561.method_30163((String)("All waypoints of category " + category.name + " are now see-through"))));
            }
        };
        this.disableAllSeeTroughButton = new EasyButton(this, -1, -1, -1, -1){

            @Override
            public void click() {
                for (WaypointElement element : WaypointScreen.elements) {
                    if (element.waypoint.categoryName == null || element.waypoint.categoryName.isEmpty() || !element.waypoint.categoryName.equals(category.name)) continue;
                    element.waypoint.seeThrough = false;
                }
                McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix(class_2561.method_30163((String)("All waypoints of category " + category.name + " are now non see-through"))));
            }
        };
        this.colorPicker = new EasyColorPicker(-1, -1, -1, -1);
        this.colorPicker.setSelectedColor(category.color);
        this.nameInput = new WaypointInput(x, y, 10, width);
        this.nameInput.setInput(category.name);
        this.alphaSlider = new EasySlider(-1, -1, -1, -1, 0.0f, 1.0f, category.alpha, false, val -> {
            category.alpha = val.floatValue();
        });
    }

    public CategoryElement(WaypointCategory category) {
        this(-1, -1, -1, -1, category);
    }

    public void draw(int x, int y, int width, int height, class_332 context) {
        if (GLFW.glfwGetMouseButton((long)class_310.method_1551().method_22683().method_4490(), (int)0) == 1 && this.alphaSlider.dragging) {
            this.alphaSlider.updateValueFromMouse(WaypointScreen.mouseX);
        } else {
            this.alphaSlider.dragging = false;
        }
        this.width = width;
        this.height = height;
        RenderUtils.drawTexturedRect((class_4587)context.method_51448(), (class_2960)this.backgroundTexture, (float)x, (float)y, (float)(width + 1), (float)(height + 2), (int)(width + 1), (int)(height + 2));
        RenderUtils.drawTexturedRect((class_4587)context.method_51448(), (class_2960)this.nameBackgroundTexture, (float)((float)x + 9.0f / (float)WaypointScreen.scaleFactor), (float)((float)y + 7.5f / (float)WaypointScreen.scaleFactor), (float)(540.0f / (float)WaypointScreen.scaleFactor), (float)(39.0f / (float)WaypointScreen.scaleFactor), (int)(540 / WaypointScreen.scaleFactor), (int)(39 / WaypointScreen.scaleFactor));
        this.nameInput.setX(x + 9 / WaypointScreen.scaleFactor);
        this.nameInput.setY(y + 12 / WaypointScreen.scaleFactor);
        this.nameInput.setWidth(540 / WaypointScreen.scaleFactor);
        this.nameInput.setHeight(36 / WaypointScreen.scaleFactor);
        this.nameInput.drawWithoutBackgroundButWithSearchtext(context, CustomColor.fromHexString((String)"FFFFFF"));
        this.deleteButton.setX(x + width - 48 / WaypointScreen.scaleFactor);
        this.deleteButton.setY(y + 6 / WaypointScreen.scaleFactor);
        this.deleteButton.setWidth(45.0f / (float)WaypointScreen.scaleFactor);
        this.deleteButton.setHeight(45.0f / (float)WaypointScreen.scaleFactor);
        this.deleteButton.drawWithTexture(context, this.deleteTexture);
        this.showAllBlocksButton.setX(x + 9 / WaypointScreen.scaleFactor);
        this.showAllBlocksButton.setY(y + 60 / WaypointScreen.scaleFactor);
        this.showAllBlocksButton.setWidth(45.0f / (float)WaypointScreen.scaleFactor);
        this.showAllBlocksButton.setHeight(45.0f / (float)WaypointScreen.scaleFactor);
        this.showAllBlocksButton.drawWithTexture(context, this.activeTexture);
        this.hideAllBlocksButton.setX(x + 9 / WaypointScreen.scaleFactor);
        this.hideAllBlocksButton.setY(y + 120 / WaypointScreen.scaleFactor);
        this.hideAllBlocksButton.setWidth(45.0f / (float)WaypointScreen.scaleFactor);
        this.hideAllBlocksButton.setHeight(45.0f / (float)WaypointScreen.scaleFactor);
        this.hideAllBlocksButton.drawWithTexture(context, this.deleteTexture);
        FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromComponent((class_2561)class_2561.method_30163((String)"Enable/")), (float)x + 60.0f / (float)WaypointScreen.scaleFactor, (float)y + 75.0f / (float)WaypointScreen.scaleFactor, CustomColor.fromHexString((String)"ffffff"), HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 2.75f / (float)WaypointScreen.scaleFactor);
        FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromComponent((class_2561)class_2561.method_30163((String)"Disable")), (float)x + 60.0f / (float)WaypointScreen.scaleFactor, (float)y + 102.0f / (float)WaypointScreen.scaleFactor, CustomColor.fromHexString((String)"ffffff"), HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 2.75f / (float)WaypointScreen.scaleFactor);
        FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromComponent((class_2561)class_2561.method_30163((String)"Highlight")), (float)x + 60.0f / (float)WaypointScreen.scaleFactor, (float)y + 129.0f / (float)WaypointScreen.scaleFactor, CustomColor.fromHexString((String)"ffffff"), HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 2.75f / (float)WaypointScreen.scaleFactor);
        FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromComponent((class_2561)class_2561.method_30163((String)"For all")), (float)x + 60.0f / (float)WaypointScreen.scaleFactor, (float)y + 156.0f / (float)WaypointScreen.scaleFactor, CustomColor.fromHexString((String)"ffffff"), HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 2.75f / (float)WaypointScreen.scaleFactor);
        this.showAllNamesButton.setX(x + 192 / WaypointScreen.scaleFactor);
        this.showAllNamesButton.setY(y + 60 / WaypointScreen.scaleFactor);
        this.showAllNamesButton.setWidth(45.0f / (float)WaypointScreen.scaleFactor);
        this.showAllNamesButton.setHeight(45.0f / (float)WaypointScreen.scaleFactor);
        this.showAllNamesButton.drawWithTexture(context, this.activeTexture);
        this.hideAllNamesButton.setX(x + 192 / WaypointScreen.scaleFactor);
        this.hideAllNamesButton.setY(y + 120 / WaypointScreen.scaleFactor);
        this.hideAllNamesButton.setWidth(45.0f / (float)WaypointScreen.scaleFactor);
        this.hideAllNamesButton.setHeight(45.0f / (float)WaypointScreen.scaleFactor);
        this.hideAllNamesButton.drawWithTexture(context, this.deleteTexture);
        FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromComponent((class_2561)class_2561.method_30163((String)"Enable/")), (float)x + 243.0f / (float)WaypointScreen.scaleFactor, (float)y + 75.0f / (float)WaypointScreen.scaleFactor, CustomColor.fromHexString((String)"ffffff"), HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 2.75f / (float)WaypointScreen.scaleFactor);
        FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromComponent((class_2561)class_2561.method_30163((String)"Disable")), (float)x + 243.0f / (float)WaypointScreen.scaleFactor, (float)y + 102.0f / (float)WaypointScreen.scaleFactor, CustomColor.fromHexString((String)"ffffff"), HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 2.75f / (float)WaypointScreen.scaleFactor);
        FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromComponent((class_2561)class_2561.method_30163((String)"Name")), (float)x + 243.0f / (float)WaypointScreen.scaleFactor, (float)y + 129.0f / (float)WaypointScreen.scaleFactor, CustomColor.fromHexString((String)"ffffff"), HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 2.75f / (float)WaypointScreen.scaleFactor);
        FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromComponent((class_2561)class_2561.method_30163((String)"For all")), (float)x + 243.0f / (float)WaypointScreen.scaleFactor, (float)y + 156.0f / (float)WaypointScreen.scaleFactor, CustomColor.fromHexString((String)"ffffff"), HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 2.75f / (float)WaypointScreen.scaleFactor);
        this.showAllDistancesButton.setX(x + 357 / WaypointScreen.scaleFactor);
        this.showAllDistancesButton.setY(y + 60 / WaypointScreen.scaleFactor);
        this.showAllDistancesButton.setWidth(45.0f / (float)WaypointScreen.scaleFactor);
        this.showAllDistancesButton.setHeight(45.0f / (float)WaypointScreen.scaleFactor);
        this.showAllDistancesButton.drawWithTexture(context, this.activeTexture);
        this.hideAllDistancesButton.setX(x + 357 / WaypointScreen.scaleFactor);
        this.hideAllDistancesButton.setY(y + 120 / WaypointScreen.scaleFactor);
        this.hideAllDistancesButton.setWidth(45.0f / (float)WaypointScreen.scaleFactor);
        this.hideAllDistancesButton.setHeight(45.0f / (float)WaypointScreen.scaleFactor);
        this.hideAllDistancesButton.drawWithTexture(context, this.deleteTexture);
        this.enableAllSeeTroughButton.setX(x + 522 / WaypointScreen.scaleFactor);
        this.enableAllSeeTroughButton.setY(y + 60 / WaypointScreen.scaleFactor);
        this.enableAllSeeTroughButton.setWidth(45.0f / (float)WaypointScreen.scaleFactor);
        this.enableAllSeeTroughButton.setHeight(45.0f / (float)WaypointScreen.scaleFactor);
        this.enableAllSeeTroughButton.drawWithTexture(context, this.activeTexture);
        this.disableAllSeeTroughButton.setX(x + 522 / WaypointScreen.scaleFactor);
        this.disableAllSeeTroughButton.setY(y + 120 / WaypointScreen.scaleFactor);
        this.disableAllSeeTroughButton.setWidth(45.0f / (float)WaypointScreen.scaleFactor);
        this.disableAllSeeTroughButton.setHeight(45.0f / (float)WaypointScreen.scaleFactor);
        this.disableAllSeeTroughButton.drawWithTexture(context, this.deleteTexture);
        FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromComponent((class_2561)class_2561.method_30163((String)"Opacity")), (float)x + 24.0f / (float)WaypointScreen.scaleFactor, (float)y + 200.0f / (float)WaypointScreen.scaleFactor, CustomColor.fromHexString((String)"ffffff"), HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 3.0f / (float)WaypointScreen.scaleFactor);
        this.alphaSlider.setX(x + width / 2 - 150 / WaypointScreen.scaleFactor);
        this.alphaSlider.setY(y + 190 / WaypointScreen.scaleFactor);
        this.alphaSlider.setHeight(20.0f / (float)WaypointScreen.scaleFactor);
        this.alphaSlider.setWidth(300.0f / (float)WaypointScreen.scaleFactor);
        this.alphaSlider.draw(context);
        FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromComponent((class_2561)class_2561.method_30163((String)"Enable/")), (float)x + 408.0f / (float)WaypointScreen.scaleFactor, (float)y + 75.0f / (float)WaypointScreen.scaleFactor, CustomColor.fromHexString((String)"ffffff"), HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 2.75f / (float)WaypointScreen.scaleFactor);
        FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromComponent((class_2561)class_2561.method_30163((String)"Disable")), (float)x + 408.0f / (float)WaypointScreen.scaleFactor, (float)y + 102.0f / (float)WaypointScreen.scaleFactor, CustomColor.fromHexString((String)"ffffff"), HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 2.75f / (float)WaypointScreen.scaleFactor);
        FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromComponent((class_2561)class_2561.method_30163((String)"Distance")), (float)x + 408.0f / (float)WaypointScreen.scaleFactor, (float)y + 129.0f / (float)WaypointScreen.scaleFactor, CustomColor.fromHexString((String)"ffffff"), HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 2.75f / (float)WaypointScreen.scaleFactor);
        FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromComponent((class_2561)class_2561.method_30163((String)"For all")), (float)x + 408.0f / (float)WaypointScreen.scaleFactor, (float)y + 156.0f / (float)WaypointScreen.scaleFactor, CustomColor.fromHexString((String)"ffffff"), HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 2.75f / (float)WaypointScreen.scaleFactor);
        this.colorPicker.setX(x + width - 45 / WaypointScreen.scaleFactor);
        this.colorPicker.setY(y + 190 / WaypointScreen.scaleFactor);
        this.colorPicker.setWidth(39.0f / (float)WaypointScreen.scaleFactor);
        this.colorPicker.setHeight(39.0f / (float)WaypointScreen.scaleFactor);
        this.colorPicker.draw(context);
        RenderUtils.drawTexturedRect((class_4587)context.method_51448(), (class_2960)this.colorPickerBorderTexture, (float)((float)(x + width) - 48.0f / (float)WaypointScreen.scaleFactor), (float)((float)y + 186.0f / (float)WaypointScreen.scaleFactor), (float)(45.0f / (float)WaypointScreen.scaleFactor), (float)(45.0f / (float)WaypointScreen.scaleFactor), (int)(45 / WaypointScreen.scaleFactor), (int)(45 / WaypointScreen.scaleFactor));
        FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromComponent((class_2561)class_2561.method_30163((String)"Enable/")), (float)x + 573.0f / (float)WaypointScreen.scaleFactor, (float)y + 75.0f / (float)WaypointScreen.scaleFactor, CustomColor.fromHexString((String)"ffffff"), HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 2.75f / (float)WaypointScreen.scaleFactor);
        FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromComponent((class_2561)class_2561.method_30163((String)"Disable")), (float)x + 573.0f / (float)WaypointScreen.scaleFactor, (float)y + 102.0f / (float)WaypointScreen.scaleFactor, CustomColor.fromHexString((String)"ffffff"), HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 2.75f / (float)WaypointScreen.scaleFactor);
        FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromComponent((class_2561)class_2561.method_30163((String)"See through")), (float)x + 573.0f / (float)WaypointScreen.scaleFactor, (float)y + 129.0f / (float)WaypointScreen.scaleFactor, CustomColor.fromHexString((String)"ffffff"), HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 2.75f / (float)WaypointScreen.scaleFactor);
        FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromComponent((class_2561)class_2561.method_30163((String)"For all")), (float)x + 573.0f / (float)WaypointScreen.scaleFactor, (float)y + 156.0f / (float)WaypointScreen.scaleFactor, CustomColor.fromHexString((String)"ffffff"), HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 2.75f / (float)WaypointScreen.scaleFactor);
    }

    public void click(int mouseX, int mouseY) {
        if (this.hideAllBlocksButton.isClickInBounds(mouseX, mouseY)) {
            this.hideAllBlocksButton.click();
        }
        if (this.showAllBlocksButton.isClickInBounds(mouseX, mouseY)) {
            this.showAllBlocksButton.click();
        }
        if (this.hideAllNamesButton.isClickInBounds(mouseX, mouseY)) {
            this.hideAllNamesButton.click();
        }
        if (this.showAllNamesButton.isClickInBounds(mouseX, mouseY)) {
            this.showAllNamesButton.click();
        }
        if (this.hideAllDistancesButton.isClickInBounds(mouseX, mouseY)) {
            this.hideAllDistancesButton.click();
        }
        if (this.showAllDistancesButton.isClickInBounds(mouseX, mouseY)) {
            this.showAllDistancesButton.click();
        }
        if (this.enableAllSeeTroughButton.isClickInBounds(mouseX, mouseY)) {
            this.enableAllSeeTroughButton.click();
        }
        if (this.disableAllSeeTroughButton.isClickInBounds(mouseX, mouseY)) {
            this.disableAllSeeTroughButton.click();
        }
        if (this.nameInput.isClickInBounds(mouseX, mouseY)) {
            this.nameInput.click();
        } else {
            this.nameInput.setActive(false);
        }
        if (this.colorPicker.isClickInBounds(mouseX, mouseY)) {
            this.colorPicker.click(mouseX, mouseY);
        } else {
            this.colorPicker.expanded = false;
        }
        if (this.alphaSlider.isClickInBounds(mouseX, mouseY)) {
            this.alphaSlider.click();
        }
    }
}

