/*
 * Decompiled with CFR 0.152.
 */
package julianh06.wynnextras.features.raid;

import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RaidParser {
    public LocalDateTime from;
    public LocalDateTime until;
    public List<String> players = new ArrayList<String>();

    public static RaidParser parse(String input) {
        String[] tokens;
        RaidParser filter = new RaidParser();
        for (String token : tokens = input.split("\\s+")) {
            if (token.startsWith("from:")) {
                filter.from = RaidParser.parseDate(token.substring(5));
                continue;
            }
            if (token.startsWith("until:")) {
                filter.until = RaidParser.parseDate(token.substring(6));
                continue;
            }
            if (!token.startsWith("players:")) continue;
            filter.players = Arrays.asList(token.substring(8).split(","));
        }
        return filter;
    }

    private static LocalDateTime parseDate(String raw) {
        DateTimeFormatter[] formatters;
        if (raw == null || raw.isBlank()) {
            return null;
        }
        if (raw.startsWith("-")) {
            String rel = raw.substring(1);
            Pattern p = Pattern.compile("(\\d+)([dhms])");
            Matcher m = p.matcher(rel);
            if (!m.find()) {
                return null;
            }
            Duration total = Duration.ZERO;
            m.reset();
            while (m.find()) {
                long val = Long.parseLong(m.group(1));
                switch (m.group(2)) {
                    case "d": {
                        total = total.plusDays(val);
                        break;
                    }
                    case "h": {
                        total = total.plusHours(val);
                        break;
                    }
                    case "m": {
                        total = total.plusMinutes(val);
                        break;
                    }
                    case "s": {
                        total = total.plusSeconds(val);
                    }
                }
            }
            if (total.isZero()) {
                return null;
            }
            return LocalDateTime.now().minus(total);
        }
        for (DateTimeFormatter fmt : formatters = new DateTimeFormatter[]{DateTimeFormatter.ISO_LOCAL_DATE_TIME, DateTimeFormatter.ofPattern("yyyy-MM-dd['/'HH:mm]")}) {
            try {
                return LocalDateTime.parse(raw, fmt);
            }
            catch (DateTimeParseException e1) {
                try {
                    LocalDate date = LocalDate.parse(raw, fmt);
                    return date.atStartOfDay();
                }
                catch (DateTimeParseException dateTimeParseException) {
                }
            }
        }
        return null;
    }
}

