/*
 * Decompiled with CFR 0.152.
 */
package julianh06.wynnextras.features.raid;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.wynntils.core.text.StyledText;
import com.wynntils.models.raid.raids.RaidKind;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import julianh06.wynnextras.features.misc.StyledTextAdapter;
import julianh06.wynnextras.features.raid.RaidData;
import julianh06.wynnextras.features.raid.RaidKindAdapter;
import net.fabricmc.loader.api.FabricLoader;

public class RaidListData {
    public static RaidListData INSTANCE = new RaidListData();
    List<RaidData> raids = new ArrayList<RaidData>();
    static GsonBuilder builder = new GsonBuilder().registerTypeAdapter(StyledText.class, (Object)new StyledTextAdapter());
    static Gson gson = builder.registerTypeAdapter(RaidKind.class, (Object)new RaidKindAdapter(builder.create())).setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("wynnextras/raidlist.json");

    public static void load() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(CONFIG_PATH);){
                RaidListData loaded = (RaidListData)gson.fromJson((Reader)reader, RaidListData.class);
                if (loaded != null) {
                    INSTANCE = loaded;
                } else {
                    System.err.println("[WynnExtras] Deserialized data was null, keeping default INSTANCE.");
                }
            }
            catch (IOException e) {
                System.err.println("[WynnExtras] Couldn't read the raidlist file:");
                e.printStackTrace();
            }
        }
    }

    public static void save() {
        try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
            gson.toJson((Object)INSTANCE, (Appendable)writer);
        }
        catch (IOException e) {
            System.err.println("[WynnExtras] Couldn't write the raidlist file:");
            e.printStackTrace();
        }
    }
}

