/*
 * Decompiled with CFR 0.152.
 */
package julianh06.wynnextras.features.profileviewer.tabs;

import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import julianh06.wynnextras.features.guildviewer.GV;
import julianh06.wynnextras.features.profileviewer.PV;
import julianh06.wynnextras.features.profileviewer.PVScreen;
import julianh06.wynnextras.features.profileviewer.data.CharacterData;
import julianh06.wynnextras.features.profileviewer.tabs.ClassWidget;
import julianh06.wynnextras.utils.UI.Widget;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3675;
import net.minecraft.class_4050;
import net.minecraft.class_4597;
import net.minecraft.class_898;
import org.joml.Quaternionf;

public class GeneralTabWidget
extends PVScreen.TabWidget {
    static class_2960 onlineCircleTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/onlinecircle.png");
    static class_2960 offlineCircleTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/offlinecircle.png");
    static class_2960 onlineCircleTextureDark = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/onlinecircle_dark.png");
    static class_2960 offlineCircleTextureDark = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/offlinecircle_dark.png");
    private boolean createdClassWidgets = false;
    private List<ClassWidget> classWidgets = new ArrayList<ClassWidget>();
    private static boolean draggingAllowed = false;
    private GuildButtonWidget guildButtonWidget = null;
    private PVScreen pvScreen;
    static float playerRotationY = 0.0f;

    public GeneralTabWidget(PVScreen pvScreen) {
        super(0, 0, 100, 100);
        playerRotationY = 0.0f;
        this.guildButtonWidget = null;
        this.classWidgets.clear();
        this.clearChildren();
        this.pvScreen = pvScreen;
    }

    @Override
    protected void drawContent(class_332 ctx, int mouseX, int mouseY, float tickDelta) {
        if (PV.currentPlayerData == null) {
            return;
        }
        if (!this.createdClassWidgets && PV.currentPlayerData.getCharacters() != null) {
            this.classWidgets.clear();
            this.clearChildren();
            Map<String, CharacterData> map = PV.currentPlayerData.getCharacters();
            CharacterData activeCharacter = PV.currentPlayerData.getActiveCharacter() == null ? null : map.get(PV.currentPlayerData.getActiveCharacter().toString());
            ArrayList<CharacterData> sortedCharacterList = new ArrayList<CharacterData>(map.values());
            sortedCharacterList.sort(Comparator.comparing(CharacterData::getLevel).thenComparing(CharacterData::getTotalLevel).thenComparing(CharacterData::getContentCompletion).thenComparing(CharacterData::getPlaytime));
            for (CharacterData entry : sortedCharacterList.reversed()) {
                boolean isActive = false;
                if (activeCharacter != null && entry == activeCharacter) {
                    isActive = true;
                }
                this.classWidgets.add(new ClassWidget(entry, isActive));
            }
            this.children.addAll(this.classWidgets);
            this.createdClassWidgets = true;
        }
        class_2960 rankBadge = PVScreen.getRankBadge();
        int rankBadgeWidth = PVScreen.getRankBadgeWidth();
        String rankColorHexString = PV.currentPlayerData.getLegacyRankColour() != null ? PV.currentPlayerData.getLegacyRankColour().getMain() : "AAAAAA";
        if (rankBadge != null) {
            this.ui.drawImage(rankBadge, this.x + 15, this.y + 18, rankBadgeWidth, 27.0f);
        }
        this.ui.drawText(" " + PV.currentPlayerData.getUsername(), this.x + 10 + rankBadgeWidth, this.y + 21, CustomColor.fromHexString((String)rankColorHexString), 3.0f);
        if (PV.currentPlayerData.isOnline()) {
            PVScreen.DarkModeToggleWidget.drawImageWithFade(onlineCircleTextureDark, onlineCircleTexture, this.x + 15, this.y + 60, 33.0f, 33.0f, this.ui);
            this.ui.drawText(PV.currentPlayerData.getServer(), this.x + 57, this.y + 66, CustomColor.fromHexString((String)"FFFFFF"), 3.0f);
        } else {
            PVScreen.DarkModeToggleWidget.drawImageWithFade(offlineCircleTextureDark, offlineCircleTexture, this.x + 15, this.y + 60, 33.0f, 33.0f, this.ui);
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm");
            String formatted = PV.currentPlayerData.getLastJoin() == null ? "Unknown!" : PV.currentPlayerData.getLastJoin().format(formatter);
            this.ui.drawText("Last seen: " + formatted, this.x + 57, this.y + 66, CustomColor.fromHexString((String)"FFFFFF"), 3.0f);
        }
        if (PVScreen.dummy != null) {
            if (class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)340)) {
                PVScreen.dummy.method_18380(class_4050.field_18081);
                this.drawPlayer(ctx, this.x + 66 + 216, this.y + 102 + 387, (int)(210.0 / this.ui.getScaleFactor()), mouseX, mouseY, (class_1309)PVScreen.dummy, this.ui.getScaleFactor());
            } else if (class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)344)) {
                PVScreen.dummy.method_18380(class_4050.field_18078);
                this.drawPlayer(ctx, this.x + 66, this.y + 102 + 357, (int)(210.0 / this.ui.getScaleFactor()), mouseX, mouseY, (class_1309)PVScreen.dummy, this.ui.getScaleFactor());
            } else {
                PVScreen.dummy.method_18380(class_4050.field_18076);
                this.drawPlayer(ctx, this.x + 66 + 216, this.y + 102 + 414, (int)(210.0 / this.ui.getScaleFactor()), mouseX, mouseY, (class_1309)PVScreen.dummy, this.ui.getScaleFactor());
            }
        }
        if (PV.currentPlayerData.getCharacters() != null) {
            boolean i = false;
            Map<String, CharacterData> map = PV.currentPlayerData.getCharacters();
            ArrayList<CharacterData> sortedCharacterList = new ArrayList<CharacterData>(map.values());
            sortedCharacterList.sort(Comparator.comparing(CharacterData::getLevel).thenComparing(CharacterData::getTotalLevel).thenComparing(CharacterData::getContentCompletion).thenComparing(CharacterData::getPlaytime));
        } else {
            this.ui.drawText("This player has their classes private.", this.x + 900, this.y + 345, CustomColor.fromHexString((String)"FF0000"), 3.0f);
        }
        if (PV.currentPlayerData.getGuild() != null) {
            String guildString = "[" + PV.currentPlayerData.getGuild().getPrefix() + "] " + PV.currentPlayerData.getGuild().getName();
            String stars = PV.currentPlayerData.getGuild().getRankStars();
            String rankString = (stars == null ? "" : stars) + " " + PV.currentPlayerData.getGuild().getRank() + " of " + (stars == null ? "" : stars);
            this.ui.drawCenteredText(rankString, this.x + 285, this.y + 570, CustomColor.fromHexString((String)"00FFFF"), 3.0f);
            if (this.guildButtonWidget == null) {
                this.guildButtonWidget = new GuildButtonWidget(guildString, PV.currentPlayerData.getGuild().getPrefix(), this.pvScreen);
                this.children.add(this.guildButtonWidget);
            }
            int widgetWidth = (int)((double)class_310.method_1551().field_1772.method_1727(guildString) * this.ui.getScaleFactor() * 1.2);
            this.guildButtonWidget.setBounds(this.x + 285 - widgetWidth / 2, this.y + 590, widgetWidth, 20);
        }
        if (PV.currentPlayerData.getFirstJoin() != null) {
            ZoneId zone = ZoneId.systemDefault();
            DateTimeFormatter formatter = DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM).withLocale(Locale.getDefault()).withZone(zone);
            Object formatted = "First joined: ";
            formatted = (String)formatted + formatter.format(PV.currentPlayerData.getFirstJoin());
            this.ui.drawCenteredText((String)formatted, this.x + 285, this.y + 630, CustomColor.fromHexString((String)"FFFFFF"), 3.0f);
        }
        if (PV.currentPlayerData.getPlaytime() != 0.0) {
            this.ui.drawCenteredText("Total Playtime: " + Math.round(PV.currentPlayerData.getPlaytime()) + "h", this.x + 285, this.y + 660, CustomColor.fromHexString((String)"FFFFFF"), 3.0f);
        }
        if (PVScreen.selectedCharacter != null && PVScreen.selectedCharacter.getPlaytime() != 0.0f) {
            this.ui.drawCenteredText("Class Playtime: " + Math.round(PVScreen.selectedCharacter.getPlaytime()) + "h", this.x + 285, this.y + 690, CustomColor.fromHexString((String)"FFFFFF"), 3.0f);
        }
        if (PVScreen.WETeam != null && PV.currentPlayerData.getUsername() != null && PVScreen.WETeam.contains(PV.currentPlayerData.getUsername())) {
            this.ui.drawCenteredText("\u2605\u2605\u2605 WynnExtras Team Member \u2605\u2605\u2605", this.x + 285, this.y + 720, CommonColors.SHINE, 3.0f);
        }
    }

    public void drawPlayer(class_332 context, int x, int y, int scale, float mouseX, float mouseY, class_1309 player, double scaleFactor) {
        float sleepOffsetY;
        float sleepOffsetX;
        float flipOffset = 0.0f;
        if (scaleFactor == 1.0) {
            flipOffset = 180.0f;
        }
        Quaternionf rotation = new Quaternionf().rotateZ((float)Math.PI);
        rotation.rotateY((float)Math.toRadians(-20.0f + playerRotationY));
        if (PVScreen.dummy.method_18376() == class_4050.field_18078) {
            rotation.rotateY(1.5707964f);
            rotation.rotateX((float)Math.PI);
            sleepOffsetX = (float)(180.0 / scaleFactor);
            sleepOffsetY = (float)(30.0 / scaleFactor);
        } else {
            sleepOffsetX = 0.0f;
            sleepOffsetY = 0.0f;
        }
        if (PV.currentPlayer.equalsIgnoreCase("teslanator")) {
            rotation.rotateX((float)Math.PI);
            flipOffset = (float)(-390.0 / scaleFactor);
            rotation.rotateY((float)Math.PI);
        }
        class_898 dispatcher = class_310.method_1551().method_1561();
        dispatcher.method_3948(false);
        float smolScale = 1.0f;
        float thickScale = 1.0f;
        if (PV.currentPlayer.equalsIgnoreCase("legendaryvirus")) {
            smolScale = 0.5f;
            thickScale = 1.5f;
        }
        context.method_51448().method_22903();
        context.method_51448().method_22904((double)sleepOffsetX + (double)x / scaleFactor, (double)(sleepOffsetY + flipOffset) + (double)y / scaleFactor, 50.0);
        context.method_51448().method_22905(thickScale * (float)scale, smolScale * (float)scale, (float)scale);
        context.method_51448().method_22907(rotation);
        class_4597.class_4598 buffer = class_310.method_1551().method_22940().method_23000();
        dispatcher.method_62424((class_1297)player, 0.0, 0.0, 0.0, 1.0f, context.method_51448(), (class_4597)buffer, 0xF000F0);
        buffer.method_22993();
        context.method_51448().method_22909();
        dispatcher.method_3948(true);
    }

    @Override
    public void updateValues() {
        int i = 0;
        for (ClassWidget classWidget : this.classWidgets) {
            int entryX = this.x + 576 + 411 * (i % 3);
            int entryY = this.y + 15 + 144 * Math.floorDiv(i, 3);
            classWidget.setBounds(entryX, entryY, 390, 132);
            ++i;
        }
    }

    @Override
    protected boolean onClick(int button) {
        int dragX = this.x + 69;
        int dragY = this.y + 99;
        int dragWidth = 429;
        int dragHeight = 429;
        draggingAllowed = (float)PVScreen.mouseX >= this.ui.sx(dragX) && (float)PVScreen.mouseX <= this.ui.sx(dragX) + (float)this.ui.sw(dragWidth) && (float)PVScreen.mouseY >= this.ui.sy(dragY) && (float)PVScreen.mouseY <= this.ui.sy(dragY) + (float)this.ui.sh(dragHeight);
        return true;
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (button == 0 && draggingAllowed) {
            playerRotationY -= (float)(deltaX * 0.5 * this.ui.getScaleFactor());
            playerRotationY %= 360.0f;
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    @Override
    public boolean mouseReleased(double mx, double my, int button) {
        draggingAllowed = false;
        return super.mouseReleased(mx, my, button);
    }

    private static class GuildButtonWidget
    extends Widget {
        String guildString;
        private final Runnable action;

        public GuildButtonWidget(String guildString, String guildPrefix, PVScreen parent) {
            super(0, 0, 0, 0);
            this.guildString = guildString;
            this.action = () -> {
                McUtils.playSoundUI((class_3414)((class_3414)class_3417.field_15015.comp_349()));
                parent.method_25419();
                GV.open(guildPrefix);
            };
        }

        @Override
        protected boolean onClick(int button) {
            if (!this.isEnabled()) {
                return false;
            }
            if (this.action != null) {
                this.action.run();
            }
            return true;
        }

        @Override
        protected void drawContent(class_332 ctx, int mouseX, int mouseY, float tickDelta) {
            this.ui.drawCenteredText((this.hovered ? "\u00a7n" : "") + this.guildString, (float)this.x + (float)this.width / 2.0f, this.y + 10, this.hovered ? CustomColor.fromHexString((String)"00FFFF") : CustomColor.fromHexString((String)"FFFFFF"));
        }
    }
}

