/*
 * Decompiled with CFR 0.152.
 */
package julianh06.wynnextras.features.profileviewer.tabs;

import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.text.StyledText;
import com.wynntils.features.inventory.ItemHighlightFeature;
import com.wynntils.handlers.item.ItemAnnotation;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import julianh06.wynnextras.features.profileviewer.PV;
import julianh06.wynnextras.features.profileviewer.PVScreen;
import julianh06.wynnextras.features.profileviewer.WynncraftApiHandler;
import julianh06.wynnextras.features.profileviewer.data.ApiAspect;
import julianh06.wynnextras.features.profileviewer.data.Aspect;
import julianh06.wynnextras.features.profileviewer.data.User;
import julianh06.wynnextras.utils.UI.UIUtils;
import julianh06.wynnextras.utils.UI.Widget;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_4587;
import net.minecraft.class_7923;
import net.minecraft.class_9280;
import net.minecraft.class_9290;
import net.minecraft.class_9334;

public class AspectsTabWidget
extends PVScreen.TabWidget {
    static class_2960 xpbarborder = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/guildviewer/xpbarborder.png");
    static class_2960 xpbarborder_dark = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/guildviewer/xpbarborder_dark.png");
    static class_2960 xpbarbackground = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/guildviewer/xpbarbackground.png");
    static class_2960 xpbarbackground_dark = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/guildviewer/xpbarbackground_dark.png");
    static class_2960 xpbarprogress = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/guildviewer/xpbarprogress.png");
    static class_2960 rankingBackgroundWideTextureDark = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/rankingicons/rankingbackgroundwide_dark.png");
    static class_2960 rankingBackgroundWideTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/rankingicons/rankingbackgroundwide.png");
    static class_2960 dungeonBackgroundTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/aspecttabbackground.png");
    static class_2960 dungeonBackgroundTextureDark = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/aspecttabbackground_dark.png");
    private static class_1799 currentHovered;
    public static User currentPlayerAspectData;
    public static WynncraftApiHandler.FetchStatus fetchStatus;
    private static Page currentPage;
    private boolean createdPageWidgets = false;
    private List<AspectsTabPageButton> pageWidgets = new ArrayList<AspectsTabPageButton>();
    private List<AspectWidget> aspectWidgets = new ArrayList<AspectWidget>();
    private InfoWidget infoWidget = null;
    private static Map<Integer, List<ItemAnnotation>> annotationCache;

    public AspectsTabWidget() {
        super(0, 0, 0, 0);
    }

    @Override
    protected void drawContent(class_332 ctx, int mouseX, int mouseY, float tickDelta) {
        currentHovered = null;
        if (PV.currentPlayerData == null) {
            return;
        }
        if (!PV.openedAspectPage.booleanValue()) {
            PV.openedAspectPage = true;
            currentPlayerAspectData = null;
            fetchStatus = null;
            currentPage = Page.Overview;
            if (PV.currentPlayerData.getUuid() == null) {
                return;
            }
            ((CompletableFuture)WynncraftApiHandler.fetchPlayerAspectData(PV.currentPlayerData.getUuid().toString(), class_310.method_1551().field_1724.method_5845()).thenAccept(result -> {
                if (result == null) {
                    return;
                }
                if (result.status() != null) {
                    if (result.status() == WynncraftApiHandler.FetchStatus.OK) {
                        currentPlayerAspectData = result.user();
                    }
                    fetchStatus = result.status();
                }
            })).exceptionally(ex -> {
                System.err.println("Unexpected error: " + ex.getMessage());
                return null;
            });
        }
        if (fetchStatus == null) {
            this.ui.drawCenteredText("Loading aspects...", this.x + 900, this.y + 365, CustomColor.fromHexString((String)"FFFF00"), 4.0f);
            return;
        }
        switch (fetchStatus) {
            case NOKEYSET: {
                this.ui.drawCenteredText("You need to set your api-key to use this feature.", this.x + 900, this.y + 350, CustomColor.fromHexString((String)"FF0000"), 4.0f);
                this.ui.drawCenteredText("Run \"/we apikey\" for more information.", this.x + 900, this.y + 390, CustomColor.fromHexString((String)"FF0000"), 4.0f);
                return;
            }
            case FORBIDDEN: {
                this.ui.drawCenteredText("You need to upload your own aspects first to view other peoples aspects.", this.x + 900, this.y + 350, CustomColor.fromHexString((String)"FF0000"), 4.0f);
                this.ui.drawCenteredText("Run \"/we ScanAspects\" to upload your Aspects.", this.x + 900, this.y + 390, CustomColor.fromHexString((String)"FF0000"), 4.0f);
                return;
            }
            case UNAUTHORIZED: {
                this.ui.drawCenteredText("The api-key you have set is not connected to your minecraft account.", this.x + 900, this.y + 350, CustomColor.fromHexString((String)"FF0000"), 4.0f);
                this.ui.drawCenteredText("Run \"/we apikey\" for more information.", this.x + 900, this.y + 390, CustomColor.fromHexString((String)"FF0000"), 4.0f);
                return;
            }
            case NOT_FOUND: {
                this.ui.drawCenteredText("No data found for this player!", this.x + 900, this.y + 365, CustomColor.fromHexString((String)"FF0000"), 4.0f);
                return;
            }
            case SERVER_UNREACHABLE: {
                this.ui.drawCenteredText("Server unreachable. Try again later.", this.x + 900, this.y + 365, CustomColor.fromHexString((String)"FF0000"), 4.0f);
                return;
            }
            case SERVER_ERROR: {
                this.ui.drawCenteredText("Server error occurred!", this.x + 900, this.y + 365, CustomColor.fromHexString((String)"FF0000"), 4.0f);
                return;
            }
        }
        if (currentPlayerAspectData == null) {
            this.ui.drawCenteredText("No data found for this player!", this.x + 900, this.y + 365, CustomColor.fromHexString((String)"FF0000"), 4.0f);
            return;
        }
        ArrayList<ApiAspect> aspects = new ArrayList<ApiAspect>(WynncraftApiHandler.fetchAllAspects());
        if (aspects.isEmpty()) {
            this.ui.drawCenteredText("Loading aspects...", this.x + 900, this.y + 365, CustomColor.fromHexString((String)"FFFF00"), 4.0f);
            return;
        }
        ArrayList<ApiAspect> mythicAspects = new ArrayList<ApiAspect>();
        for (ApiAspect apiAspect : aspects) {
            if (!apiAspect.getRarity().equals("mythic")) continue;
            mythicAspects.add(apiAspect);
        }
        ArrayList<ApiAspect> fabledAspects = new ArrayList<ApiAspect>();
        for (ApiAspect apiAspect : aspects) {
            if (!apiAspect.getRarity().equals("fabled")) continue;
            fabledAspects.add(apiAspect);
        }
        ArrayList<ApiAspect> arrayList = new ArrayList<ApiAspect>();
        for (ApiAspect apiAspect : aspects) {
            if (!apiAspect.getRarity().equals("legendary")) continue;
            arrayList.add(apiAspect);
        }
        ArrayList<ApiAspect> arrayList2 = new ArrayList<ApiAspect>();
        for (ApiAspect apiAspect : aspects) {
            if (!apiAspect.getRequiredClass().equals("warrior")) continue;
            arrayList2.add(apiAspect);
        }
        ArrayList<ApiAspect> arrayList3 = new ArrayList<ApiAspect>();
        for (ApiAspect apiAspect : aspects) {
            if (!apiAspect.getRequiredClass().equals("shaman")) continue;
            arrayList3.add(apiAspect);
        }
        ArrayList<ApiAspect> arrayList4 = new ArrayList<ApiAspect>();
        for (ApiAspect apiAspect : aspects) {
            if (!apiAspect.getRequiredClass().equals("mage")) continue;
            arrayList4.add(apiAspect);
        }
        ArrayList<ApiAspect> arrayList5 = new ArrayList<ApiAspect>();
        for (ApiAspect apiAspect : aspects) {
            if (!apiAspect.getRequiredClass().equals("archer")) continue;
            arrayList5.add(apiAspect);
        }
        ArrayList<ApiAspect> arrayList6 = new ArrayList<ApiAspect>();
        for (ApiAspect aspect9 : aspects) {
            if (!aspect9.getRequiredClass().equals("assassin")) continue;
            arrayList6.add(aspect9);
        }
        if (!this.createdPageWidgets && PV.currentPlayerData.getCharacters() != null) {
            this.pageWidgets.clear();
            this.clearChildren();
            for (Page entry : Page.values()) {
                this.pageWidgets.add(new AspectsTabPageButton(entry));
            }
            this.children.addAll(this.pageWidgets);
            this.createdPageWidgets = true;
        }
        for (AspectsTabPageButton pageWidget : this.pageWidgets) {
            int entryX = this.x + 10 + 300 * pageWidget.page.ordinal();
            int entryY = this.y + 15;
            pageWidget.setBounds(entryX, entryY, 280, 100);
        }
        switch (currentPage.ordinal()) {
            case 0: {
                boolean bl = false;
                int maxMythic = 0;
                int maxFabled = 0;
                int maxLegendary = 0;
                int maxTotal = 0;
                block21: for (ApiAspect aspect10 : aspects) {
                    for (Aspect playerAspect : currentPlayerAspectData.getAspects()) {
                        if (!playerAspect.getName().equals(aspect10.getName())) continue;
                        if (aspect10.getRarity().equals("mythic") && playerAspect.getAmount() >= 15) {
                            ++maxMythic;
                            ++maxTotal;
                            continue block21;
                        }
                        if (aspect10.getRarity().equals("fabled") && playerAspect.getAmount() >= 75) {
                            ++maxFabled;
                            ++maxTotal;
                            continue block21;
                        }
                        if (!aspect10.getRarity().equals("legendary") || playerAspect.getAmount() < 150) continue;
                        ++maxLegendary;
                        ++maxTotal;
                        continue block21;
                    }
                }
                this.ui.drawCenteredText("Unlocked: " + currentPlayerAspectData.getAspects().size() + "/" + aspects.size(), this.x + 420, this.y + 160, CustomColor.fromHexString((String)"FFFFFF"), 5.0f);
                AspectsTabWidget.drawProgressBar(this.x + 40, this.y + 190, 800, 80, 5.0f, (float)currentPlayerAspectData.getAspects().size() / (float)aspects.size(), ctx, this.ui);
                this.ui.drawCenteredText("Total Maxed: " + maxTotal + "/" + aspects.size(), this.x + 420, this.y + 340, CustomColor.fromHexString((String)"FFFFFF"), 5.0f);
                AspectsTabWidget.drawProgressBar(this.x + 40, this.y + 380, 800, 80, 5.0f, (float)maxTotal / (float)aspects.size(), ctx, this.ui);
                if (PV.currentPlayerData.getGlobalData() != null) {
                    PVScreen.DarkModeToggleWidget.drawImageWithFade(rankingBackgroundWideTextureDark, rankingBackgroundWideTexture, this.x + 40, this.y + 510, 800.0f, 160.0f, this.ui);
                    this.ui.drawCenteredText("Total Raid Completions: " + PV.currentPlayerData.getGlobalData().getRaids().getTotal(), this.x + 440, this.y + 590, CustomColor.fromHexString((String)"FFFFFF"), 5.0f);
                }
                this.ui.drawCenteredText("Maxed Mythic Aspects: " + maxMythic + "/" + mythicAspects.size(), this.x + 960 + 400, this.y + 160, CustomColor.fromHexString((String)"FFFFFF"), 5.0f);
                AspectsTabWidget.drawProgressBar(this.x + 60 + this.width / 2, this.y + 190, 800, 80, 5.0f, (float)maxMythic / (float)mythicAspects.size(), ctx, this.ui);
                this.ui.drawCenteredText("Maxed Fabled Aspects: " + maxFabled + "/" + fabledAspects.size(), this.x + 960 + 400, this.y + 340, CustomColor.fromHexString((String)"FFFFFF"), 5.0f);
                AspectsTabWidget.drawProgressBar(this.x + 60 + this.width / 2, this.y + 380, 800, 80, 5.0f, (float)maxFabled / (float)fabledAspects.size(), ctx, this.ui);
                this.ui.drawCenteredText("Maxed Legendary Aspects: " + maxLegendary + "/" + arrayList.size(), this.x + 960 + 400, this.y + 530, CustomColor.fromHexString((String)"FFFFFF"), 4.5f);
                AspectsTabWidget.drawProgressBar(this.x + 60 + this.width / 2, this.y + 570, 800, 80, 5.0f, (float)maxLegendary / (float)arrayList.size(), ctx, this.ui);
                if (this.infoWidget == null) {
                    this.infoWidget = new InfoWidget(currentPlayerAspectData.getUpdatedAt());
                }
                this.infoWidget.setBounds(this.x + this.width - 80, this.y + this.height - 80, 50, 50);
                this.infoWidget.draw(ctx, mouseX, mouseY, tickDelta, this.ui);
                break;
            }
            default: {
                PVScreen.DarkModeToggleWidget.drawImageWithFade(dungeonBackgroundTextureDark, dungeonBackgroundTexture, this.x + 30, this.y + 87, 1740.0f, 633.0f, this.ui);
                ArrayList<ApiAspect> arrayList7 = new ArrayList<ApiAspect>(List.copyOf(aspects));
                Map<String, Integer> rarityOrder = Map.of("mythic", 0, "fabled", 1, "legendary", 2);
                AtomicReference stellar = new AtomicReference();
                arrayList7.sort(Comparator.comparing(a -> {
                    String rarity;
                    String string = rarity = a.getRarity() == null ? "" : a.getRarity().trim().toLowerCase();
                    if (a.getName().equals("Aspect of the Stellar Flurry")) {
                        stellar.set(a);
                    }
                    return rarityOrder.getOrDefault(rarity, Integer.MAX_VALUE);
                }).thenComparing(ApiAspect::getName, String.CASE_INSENSITIVE_ORDER));
                if (stellar.get() != null) {
                    arrayList7.remove(stellar.get());
                    arrayList7.add((ApiAspect)stellar.get());
                }
                if (this.aspectWidgets.isEmpty()) {
                    int i = 0;
                    for (ApiAspect aspect11 : arrayList7) {
                        Aspect playerAspect = null;
                        for (Aspect a2 : currentPlayerAspectData.getAspects()) {
                            if (!aspect11.getName().equals(a2.getName())) continue;
                            playerAspect = a2;
                            break;
                        }
                        AspectWidget aspectWidget = new AspectWidget(aspect11, playerAspect, arrayList2, arrayList3, arrayList4, arrayList5, arrayList6);
                        this.aspectWidgets.add(aspectWidget);
                        ++i;
                    }
                }
                int i = 0;
                int widgetIndex = 0;
                for (ApiAspect aspect12 : arrayList7) {
                    if (!aspect12.getRequiredClass().equals(currentPage.toString().toLowerCase())) {
                        ++widgetIndex;
                        continue;
                    }
                    int amount = AspectsTabWidget.getAspectAmountForClass(currentPage, arrayList2, arrayList3, arrayList4, arrayList5, arrayList6);
                    ctx.method_51448().method_22903();
                    int xPos = amount % 2 == 0 ? 130 * (i % (amount / 2)) : ((float)i < (float)amount / 2.0f ? 130 * (i % ((amount + 1) / 2)) - 70 : 130 * (i % (amount / 2)));
                    int yPos = 315 * Math.floorDiv(i, (amount + 1) / 2);
                    this.aspectWidgets.get(widgetIndex).setBounds(this.x + this.width / 2 - 63 * (amount / 2) + xPos, this.y + yPos + 240, 100, 100);
                    this.aspectWidgets.get(widgetIndex).draw(ctx, mouseX, mouseY, tickDelta, this.ui);
                    ++i;
                    ++widgetIndex;
                }
            }
        }
        if (currentHovered == null) {
            return;
        }
        ctx.method_51448().method_22903();
        ctx.method_51448().method_46416(0.0f, 0.0f, 8000.0f);
        ctx.method_51434(class_310.method_1551().field_1772, currentHovered.method_7950(class_1792.class_9635.field_51353, (class_1657)McUtils.player(), (class_1836)class_1836.field_41070), mouseX, mouseY);
        ctx.method_51448().method_22909();
    }

    private static int getAspectAmountForClass(Page page, List<ApiAspect> warriorAspects, List<ApiAspect> shamanAspects, List<ApiAspect> mageAspects, List<ApiAspect> archerAspects, List<ApiAspect> assassinAspects) {
        return switch (page.ordinal()) {
            case 1 -> warriorAspects.size();
            case 2 -> shamanAspects.size();
            case 3 -> mageAspects.size();
            case 4 -> archerAspects.size();
            case 5 -> assassinAspects.size();
            default -> 0;
        };
    }

    private static void drawProgressBar(int x, int y, int width, int height, float textScale, float progress, class_332 ctx, UIUtils ui) {
        PVScreen.DarkModeToggleWidget.drawImageWithFade(xpbarbackground_dark, xpbarbackground, x, y, width, height, ui);
        ctx.method_44379((int)ui.sx(x), (int)ui.sy(y), (int)ui.sx((float)x + (float)width * progress), (int)ui.sy(y + height));
        ui.drawImage(xpbarprogress, x, y, width, height);
        ctx.method_44380();
        PVScreen.DarkModeToggleWidget.drawImageWithFade(xpbarborder_dark, xpbarborder, x, y, width, height, ui);
        ui.drawCenteredText(String.format("%.2f%%", Float.valueOf(progress * 100.0f)), (float)x + (float)width / 2.0f, (float)y + (float)height / 2.0f + 2.0f, CustomColor.fromHexString((String)"FFFFFF"), textScale);
    }

    private static class_1799 toItemStack(ApiAspect aspect2, boolean max, int tier) {
        ApiAspect.Icon icon = aspect2.getIcon();
        if (icon == null) {
            return class_1799.field_8037;
        }
        if (icon.getValueString() != null) {
            class_2960 id = class_2960.method_60654((String)icon.getValueString());
            class_1792 item = (class_1792)class_7923.field_41178.method_63535(id);
            return new class_1799((class_1935)item);
        }
        if (icon.getValueObject() != null) {
            ApiAspect.IconValue iv = icon.getValueObject();
            class_2960 id = class_2960.method_60654((String)iv.getId());
            class_1792 item = (class_1792)class_7923.field_41178.method_63535(id);
            class_1799 stack = new class_1799((class_1935)item);
            if (iv.getCustomModelData() != null) {
                try {
                    int cmd = iv.getCustomModelData().getRangeDispatch().getFirst() + (max ? 1 : 0);
                    stack.method_57379(class_9334.field_49637, (Object)new class_9280(List.of(Float.valueOf(cmd)), List.of(), List.of(), List.of()));
                }
                catch (NumberFormatException cmd) {
                    // empty catch block
                }
            }
            if (aspect2.getName() != null) {
                try {
                    StyledText name = StyledText.fromString((String)aspect2.getName()).withoutFormatting();
                    String color = "";
                    if (aspect2.getRarity().equals("mythic")) {
                        color = "\u00a75";
                    }
                    if (aspect2.getRarity().equals("fabled")) {
                        color = "\u00a7c";
                    }
                    if (aspect2.getRarity().equals("legendary")) {
                        color = "\u00a7b";
                    }
                    stack.method_57379(class_9334.field_49631, (Object)class_2561.method_30163((String)(color + name.getString())));
                }
                catch (NumberFormatException name) {
                    // empty catch block
                }
            }
            if (aspect2.getTiers() != null && aspect2.getTiers().get(String.valueOf(tier)) != null) {
                List<String> lore = aspect2.getTiers().get(String.valueOf(tier)).getDescription();
                stack.method_57379(class_9334.field_49632, (Object)new class_9290(WynncraftApiHandler.parseStyledHtml(lore)));
            }
            return stack;
        }
        return class_1799.field_8037;
    }

    public static boolean isMaxed(Aspect aspect2) {
        switch (aspect2.getRarity()) {
            case "Mythic": {
                return aspect2.getAmount() >= 15;
            }
            case "Fabled": {
                return aspect2.getAmount() >= 75;
            }
            case "Legendary": {
                return aspect2.getAmount() >= 150;
            }
        }
        return false;
    }

    static {
        annotationCache = new HashMap<Integer, List<ItemAnnotation>>();
    }

    private static class InfoWidget
    extends Widget {
        static class_2960 infoIcon = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/infoicon.png");
        static class_2960 infoIconDark = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/infoicon_dark.png");
        Long lastUpdatedTimestamp;
        DateTimeFormatter formatter;

        public InfoWidget(Long lastUpdatedTimestamp) {
            super(0, 0, 0, 0);
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            this.formatter = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT).withLocale(Locale.getDefault()).withZone(ZoneId.systemDefault());
        }

        @Override
        protected void drawContent(class_332 ctx, int mouseX, int mouseY, float tickDelta) {
            PVScreen.DarkModeToggleWidget.drawImageWithFade(infoIconDark, infoIcon, this.x, this.y, this.width, this.height, this.ui);
            if (this.hovered) {
                String formatted = this.formatter.format(Instant.ofEpochMilli(this.lastUpdatedTimestamp));
                ctx.method_51434(class_310.method_1551().field_1772, List.of(class_2561.method_30163((String)"Last updated at"), class_2561.method_30163((String)formatted)), mouseX, mouseY);
            }
        }
    }

    public static enum Page {
        Overview,
        Warrior,
        Shaman,
        Mage,
        Archer,
        Assassin;

    }

    private static class AspectsTabPageButton
    extends Widget {
        static class_2960 classBackgroundTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/classbackgroundinactive.png");
        static class_2960 classBackgroundTextureDark = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/classbackgroundinactive_dark.png");
        static class_2960 classBackgroundTextureHovered = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/classbackgroundhovered.png");
        static class_2960 classBackgroundTextureHoveredDark = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/classbackgroundhovered_dark.png");
        Page page;
        private final Runnable action;

        public AspectsTabPageButton(Page page) {
            super(0, 0, 0, 0);
            this.page = page;
            this.action = () -> {
                McUtils.playSoundUI((class_3414)((class_3414)class_3417.field_15015.comp_349()));
                currentPage = page;
            };
        }

        @Override
        protected boolean onClick(int button) {
            if (!this.isEnabled()) {
                return false;
            }
            if (this.action != null) {
                this.action.run();
            }
            return true;
        }

        @Override
        protected void drawContent(class_332 ctx, int mouseX, int mouseY, float tickDelta) {
            if (this.hovered) {
                PVScreen.DarkModeToggleWidget.drawImageWithFade(classBackgroundTextureHoveredDark, classBackgroundTextureHovered, this.x, this.y, this.width, this.height, this.ui);
            } else {
                PVScreen.DarkModeToggleWidget.drawImageWithFade(classBackgroundTextureDark, classBackgroundTexture, this.x, this.y, this.width, this.height, this.ui);
            }
            CustomColor textColor = currentPage == this.page ? CustomColor.fromHexString((String)"FFFF00") : CustomColor.fromHexString((String)"FFFFFF");
            this.ui.drawCenteredText(this.page.name(), (float)this.x + (float)this.width / 2.0f, (float)this.y + (float)this.height / 2.0f, textColor, 4.0f);
        }
    }

    private static class AspectWidget
    extends Widget {
        public final Config<ItemHighlightFeature.HighlightTexture> highlightTexture = new Config((Object)ItemHighlightFeature.HighlightTexture.CIRCLE_TRANSPARENT);
        ApiAspect aspect;
        int i;
        List<ApiAspect> warriorAspects;
        List<ApiAspect> shamanAspects;
        List<ApiAspect> mageAspects;
        List<ApiAspect> archerAspects;
        List<ApiAspect> assassinAspects;
        Aspect playerAspect;

        public AspectWidget(ApiAspect aspect2, Aspect playerAspect, List<ApiAspect> warriorAspects, List<ApiAspect> shamanAspects, List<ApiAspect> mageAspects, List<ApiAspect> archerAspects, List<ApiAspect> assassinAspects) {
            super(0, 0, 0, 0);
            this.aspect = aspect2;
            this.playerAspect = playerAspect;
            this.warriorAspects = warriorAspects;
            this.shamanAspects = shamanAspects;
            this.mageAspects = mageAspects;
            this.archerAspects = archerAspects;
            this.assassinAspects = assassinAspects;
        }

        public void setI(int i) {
            this.i = i;
        }

        @Override
        protected void drawContent(class_332 ctx, int mouseX, int mouseY, float tickDelta) {
            if (this.aspect == null) {
                return;
            }
            if (!this.aspect.getRequiredClass().equals(currentPage.toString().toLowerCase())) {
                return;
            }
            CustomColor color = CustomColor.NONE;
            int neededForNextLevel = 0;
            int amount = 0;
            int tierInt = 1;
            String progress = "Not unlocked";
            String tier = "";
            if (this.playerAspect != null) {
                amount = this.playerAspect.getAmount();
                progress = String.valueOf(this.playerAspect.getAmount());
                if (this.aspect.getRarity().equals("mythic")) {
                    color = CustomColor.fromHexString((String)"AA00AA");
                    if (this.playerAspect.getAmount() >= 15) {
                        progress = "MAX";
                        tierInt = 3;
                    } else if (this.playerAspect.getAmount() >= 5) {
                        tierInt = 2;
                        tier = "Tier II";
                        amount -= 5;
                        neededForNextLevel = 10;
                    } else if (this.playerAspect.getAmount() >= 1) {
                        tierInt = 1;
                        tier = "Tier I";
                        --amount;
                        neededForNextLevel = 4;
                    }
                }
                if (this.aspect.getRarity().equals("fabled")) {
                    color = CustomColor.fromHexString((String)"FF5555");
                    if (this.playerAspect.getAmount() >= 75) {
                        tierInt = 3;
                        progress = "MAX";
                    } else if (this.playerAspect.getAmount() >= 15) {
                        tierInt = 2;
                        tier = "Tier II";
                        amount -= 15;
                        neededForNextLevel = 60;
                    } else if (this.playerAspect.getAmount() >= 1) {
                        tierInt = 1;
                        tier = "Tier I";
                        --amount;
                        neededForNextLevel = 14;
                    }
                }
                if (this.aspect.getRarity().equals("legendary")) {
                    color = CustomColor.fromHexString((String)"55FFFF");
                    if (this.playerAspect.getAmount() >= 150) {
                        tierInt = 4;
                        progress = "MAX";
                    } else if (this.playerAspect.getAmount() >= 30) {
                        tierInt = 3;
                        tier = "Tier III";
                        amount -= 30;
                        neededForNextLevel = 120;
                    } else if (this.playerAspect.getAmount() >= 5) {
                        tierInt = 2;
                        tier = "Tier II";
                        amount -= 5;
                        neededForNextLevel = 25;
                    } else if (this.playerAspect.getAmount() >= 1) {
                        tierInt = 1;
                        tier = "Tier I";
                        --amount;
                        neededForNextLevel = 4;
                    }
                }
            }
            if (!Objects.equals(color, CustomColor.NONE)) {
                RenderUtils.drawTexturedRectWithColor((class_4587)ctx.method_51448(), (class_2960)Texture.HIGHLIGHT.resource(), (CustomColor)color.withAlpha(255), (float)((float)this.x / this.ui.getScaleFactorF() - 6.0f / this.ui.getScaleFactorF()), (float)((float)this.y / this.ui.getScaleFactorF() - 6.0f / this.ui.getScaleFactorF()), (float)-1000.0f, (float)(108.0f / this.ui.getScaleFactorF()), (float)(108.0f / this.ui.getScaleFactorF()), (int)(((ItemHighlightFeature.HighlightTexture)this.highlightTexture.get()).ordinal() * 18 + 18), (int)0, (int)18, (int)18, (int)Texture.HIGHLIGHT.width(), (int)Texture.HIGHLIGHT.height());
            }
            if (this.playerAspect == null) {
                return;
            }
            class_1799 stack = AspectsTabWidget.toItemStack(this.aspect, AspectsTabWidget.isMaxed(this.playerAspect), tierInt);
            ctx.method_51448().method_22903();
            ctx.method_51448().method_22905(5.0f / this.ui.getScaleFactorF(), 5.0f / this.ui.getScaleFactorF(), 1.0f);
            ctx.method_51427(stack, this.x / 5 + 2, this.y / 5 + 2);
            ctx.method_51448().method_22909();
            this.ui.drawCenteredText((!progress.equals("MAX") ? String.valueOf(amount) : progress) + (String)(!progress.equals("MAX") ? "/" + neededForNextLevel : ""), this.x + 50, this.y + 120);
            this.ui.drawCenteredText(tier, this.x + 50, this.y - 25);
            if (this.hovered) {
                currentHovered = stack;
            }
        }
    }
}

