/*
 * Decompiled with CFR 0.152.
 */
package julianh06.wynnextras.features.profileviewer.data;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import julianh06.wynnextras.features.profileviewer.data.AbilityMapData;

public class NodeDeserializer
implements JsonDeserializer<AbilityMapData.Node> {
    public AbilityMapData.Node deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext ctx) throws JsonParseException {
        JsonObject obj = json.getAsJsonObject();
        AbilityMapData.Node node = new AbilityMapData.Node();
        node.type = this.getAsStringOrNull(obj, "type");
        if (obj.has("coordinates") && obj.get("coordinates").isJsonObject()) {
            node.coordinates = (AbilityMapData.Coordinates)ctx.deserialize(obj.get("coordinates"), AbilityMapData.Coordinates.class);
        }
        if (obj.has("family") && obj.get("family").isJsonArray()) {
            node.family = new ArrayList<String>();
            for (JsonElement e : obj.get("family").getAsJsonArray()) {
                node.family.add(e.getAsString());
            }
        }
        if (obj.has("meta") && obj.get("meta").isJsonObject()) {
            JsonObject metaObj = obj.getAsJsonObject("meta");
            AbilityMapData.Node.Meta meta = new AbilityMapData.Node.Meta();
            if (metaObj.has("page") && metaObj.get("page").isJsonPrimitive()) {
                meta.page = metaObj.get("page").getAsInt();
            }
            if (metaObj.has("id") && metaObj.get("id").isJsonPrimitive()) {
                meta.id = metaObj.get("id").getAsString();
            }
            if (metaObj.has("icon")) {
                JsonElement iconEl = metaObj.get("icon");
                if (iconEl.isJsonPrimitive()) {
                    meta.icon = iconEl.getAsString();
                } else if (iconEl.isJsonObject()) {
                    try {
                        AbilityMapData.Icon parsed = (AbilityMapData.Icon)ctx.deserialize(iconEl, AbilityMapData.Icon.class);
                        meta.icon = parsed;
                    }
                    catch (JsonParseException ex) {
                        meta.icon = iconEl;
                    }
                } else {
                    meta.icon = iconEl;
                }
            }
            node.meta = meta;
        }
        return node;
    }

    private String getAsStringOrNull(JsonObject o, String key) {
        return o.has(key) && o.get(key).isJsonPrimitive() ? o.get(key).getAsString() : null;
    }
}

