/*
 * Decompiled with CFR 0.152.
 */
package julianh06.wynnextras.features.profileviewer.data;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import julianh06.wynnextras.features.profileviewer.data.AbilityTreeData;

public class AbilityTreeDataDeserializer
implements JsonDeserializer<AbilityTreeData> {
    public AbilityTreeData deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext ctx) throws JsonParseException {
        AbilityTreeData tree = new AbilityTreeData();
        JsonObject root = json.getAsJsonObject();
        tree.archetypes = new HashMap<String, AbilityTreeData.Archetype>();
        if (root.has("archetypes")) {
            JsonObject archetypesObj = root.getAsJsonObject("archetypes");
            for (Map.Entry entry : archetypesObj.entrySet()) {
                String key = (String)entry.getKey();
                JsonObject val = ((JsonElement)entry.getValue()).getAsJsonObject();
                AbilityTreeData.Archetype archetype = new AbilityTreeData.Archetype();
                archetype.name = val.get("name").getAsString();
                archetype.description = val.get("description").getAsString();
                archetype.shortDescription = val.get("shortDescription").getAsString();
                archetype.slot = val.get("slot").getAsInt();
                archetype.icon = this.parseIcon(val.get("icon"));
                tree.archetypes.put(key, archetype);
            }
        }
        tree.pages = new HashMap<Integer, Map<String, AbilityTreeData.Ability>>();
        if (root.has("pages")) {
            JsonObject pagesObj = root.getAsJsonObject("pages");
            for (Map.Entry pageEntry : pagesObj.entrySet()) {
                int pageNumber = Integer.parseInt((String)pageEntry.getKey());
                JsonObject abilitiesObj = ((JsonElement)pageEntry.getValue()).getAsJsonObject();
                HashMap<String, AbilityTreeData.Ability> abilityMap = new HashMap<String, AbilityTreeData.Ability>();
                for (Map.Entry abilityEntry : abilitiesObj.entrySet()) {
                    JsonElement locks;
                    JsonElement links;
                    String abilityId = (String)abilityEntry.getKey();
                    JsonObject abilityData = ((JsonElement)abilityEntry.getValue()).getAsJsonObject();
                    AbilityTreeData.Ability ability = new AbilityTreeData.Ability();
                    ability.page = pageNumber;
                    ability.name = abilityData.get("name").getAsString();
                    ability.slot = abilityData.has("slot") ? abilityData.get("slot").getAsInt() : 0;
                    JsonObject coord = abilityData.getAsJsonObject("coordinates");
                    ability.coordinates = new AbilityTreeData.Coordinates();
                    ability.coordinates.x = coord.get("x").getAsInt();
                    ability.coordinates.y = coord.get("y").getAsInt();
                    JsonElement desc = abilityData.get("description");
                    if (desc != null && desc.isJsonArray()) {
                        ability.description = new ArrayList<String>();
                        for (JsonElement line : desc.getAsJsonArray()) {
                            ability.description.add(line.getAsString());
                        }
                    }
                    if (abilityData.has("requirements")) {
                        JsonObject req = abilityData.getAsJsonObject("requirements");
                        AbilityTreeData.Requirements r = new AbilityTreeData.Requirements();
                        if (req.has("ABILITY_POINTS")) {
                            r.ABILITY_POINTS = req.get("ABILITY_POINTS").getAsInt();
                        }
                        if (req.has("NODE")) {
                            r.NODE = req.get("NODE").getAsString();
                        }
                        if (req.has("ARCHETYPE") && req.get("ARCHETYPE").isJsonObject()) {
                            JsonObject ar = req.getAsJsonObject("ARCHETYPE");
                            AbilityTreeData.ArchetypeRequirement arq = new AbilityTreeData.ArchetypeRequirement();
                            arq.name = ar.get("name").getAsString();
                            arq.amount = ar.get("amount").getAsInt();
                            r.ARCHETYPE = arq;
                        }
                        ability.requirements = r;
                    }
                    if ((links = abilityData.get("links")) != null && links.isJsonArray()) {
                        ability.links = new ArrayList<String>();
                        for (JsonElement link : links.getAsJsonArray()) {
                            ability.links.add(link.getAsString());
                        }
                    }
                    if ((locks = abilityData.get("locks")) != null && locks.isJsonArray()) {
                        ability.locks = new ArrayList<String>();
                        for (JsonElement lock : locks.getAsJsonArray()) {
                            ability.locks.add(lock.getAsString());
                        }
                    }
                    ability.icon = this.parseIcon(abilityData.get("icon"));
                    abilityMap.put(abilityId, ability);
                }
                tree.pages.put(pageNumber, abilityMap);
            }
        }
        return tree;
    }

    private AbilityTreeData.Icon parseIcon(JsonElement iconElement) {
        if (!iconElement.isJsonObject()) {
            return null;
        }
        JsonObject iconObj = iconElement.getAsJsonObject();
        AbilityTreeData.Icon icon = new AbilityTreeData.Icon();
        icon.format = iconObj.has("format") ? iconObj.get("format").getAsString() : null;
        JsonElement value = iconObj.get("value");
        if (value.isJsonPrimitive()) {
            icon.value = value.getAsString();
        } else if (value.isJsonObject()) {
            JsonObject valObj = value.getAsJsonObject();
            AbilityTreeData.Icon.IconValue iv = new AbilityTreeData.Icon.IconValue();
            iv.id = valObj.has("id") ? valObj.get("id").getAsString() : null;
            iv.name = valObj.has("name") ? valObj.get("name").getAsString() : null;
            iv.customModelData = valObj.has("customModelData") ? valObj.get("customModelData") : null;
            icon.value = iv;
        }
        return icon;
    }
}

