/*
 * Decompiled with CFR 0.152.
 */
package julianh06.wynnextras.features.inventory.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import julianh06.wynnextras.features.misc.ItemStackDeserializer;
import julianh06.wynnextras.features.misc.ItemStackSerializer;
import julianh06.wynnextras.utils.OptionalTypeAdapter;
import net.minecraft.class_1799;

public abstract class BankData {
    public int lastPage = 1;
    public HashMap<Integer, List<class_1799>> BankPages = new HashMap();
    public HashMap<Integer, String> BankPageNames = new HashMap();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapterFactory(new TypeAdapterFactory(){

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Optional.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            Type actualType = ((ParameterizedType)type.getType()).getActualTypeArguments()[0];
            TypeAdapter delegate = gson.getAdapter(TypeToken.get((Type)actualType));
            return new OptionalTypeAdapter(delegate);
        }
    }).registerTypeAdapter(class_1799.class, (Object)new ItemStackSerializer()).registerTypeAdapter(class_1799.class, (Object)new ItemStackDeserializer()).setPrettyPrinting().create();

    public abstract Path getConfigPath();

    public void save() {
        Path path = this.getConfigPath();
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                BankData.getGson().toJson((Object)this, (Appendable)writer);
            }
        }
        catch (IOException e) {
            System.err.println("[WynnExtras] Couldn't write bank data:");
            e.printStackTrace();
        }
    }

    public void load() {
        Path path = this.getConfigPath();
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            System.err.println("[WynnExtras] Couldn't create config directory:");
            e.printStackTrace();
        }
        if (Files.exists(path, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(path);){
                BankData loaded = (BankData)BankData.getGson().fromJson((Reader)reader, this.getClass());
                if (loaded != null) {
                    this.BankPages = loaded.BankPages;
                    this.lastPage = loaded.lastPage;
                    this.BankPageNames = loaded.BankPageNames;
                }
            }
            catch (IOException e) {
                System.err.println("[WynnExtras] Couldn't read bank data:");
                e.printStackTrace();
            }
        } else {
            this.BankPages = new HashMap();
            this.lastPage = 1;
            this.BankPageNames = new HashMap();
        }
    }

    public static Gson getGson() {
        return GSON;
    }
}

