/*
 * Decompiled with CFR 0.152.
 */
package julianh06.wynnextras.features.crafting;

import com.wynntils.core.components.Models;
import com.wynntils.models.containers.Container;
import com.wynntils.models.containers.containers.CraftingStationContainer;
import com.wynntils.models.profession.type.ProfessionType;
import com.wynntils.models.worlds.type.BombInfo;
import com.wynntils.models.worlds.type.BombType;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.VerticalAlignment;
import com.wynntils.utils.type.Time;
import com.wynntils.utils.wynn.ContainerUtils;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import julianh06.wynnextras.config.WynnExtrasConfig;
import julianh06.wynnextras.config.simpleconfig.SimpleConfig;
import julianh06.wynnextras.features.crafting.data.IMaterial;
import julianh06.wynnextras.features.crafting.data.IRecipeData;
import julianh06.wynnextras.features.crafting.data.recipes.AlchemismRecipes;
import julianh06.wynnextras.features.crafting.data.recipes.CookingRecipes;
import julianh06.wynnextras.features.crafting.data.recipes.ScribingRecipes;
import julianh06.wynnextras.features.crafting.data.recipes.armouring.ChestplateRecipes;
import julianh06.wynnextras.features.crafting.data.recipes.armouring.HelmetRecipes;
import julianh06.wynnextras.features.crafting.data.recipes.jeweling.BraceletRecipes;
import julianh06.wynnextras.features.crafting.data.recipes.jeweling.NecklaceRecipes;
import julianh06.wynnextras.features.crafting.data.recipes.jeweling.RingRecipes;
import julianh06.wynnextras.features.crafting.data.recipes.tailoring.BootsRecipes;
import julianh06.wynnextras.features.crafting.data.recipes.tailoring.LeggingsRecipes;
import julianh06.wynnextras.features.crafting.data.recipes.weaponsmithing.DaggerRecipes;
import julianh06.wynnextras.features.crafting.data.recipes.weaponsmithing.SpearRecipes;
import julianh06.wynnextras.features.crafting.data.recipes.woodworking.BowRecipes;
import julianh06.wynnextras.features.crafting.data.recipes.woodworking.RelikRecipes;
import julianh06.wynnextras.features.crafting.data.recipes.woodworking.WandRecipes;
import julianh06.wynnextras.mixin.Accessor.HandledScreenAccessor;
import julianh06.wynnextras.utils.Pair;
import julianh06.wynnextras.utils.UI.UIUtils;
import julianh06.wynnextras.utils.UI.WEHandledScreen;
import julianh06.wynnextras.utils.UI.Widget;
import net.fabricmc.fabric.api.client.screen.v1.ScreenMouseEvents;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_437;
import net.minecraft.class_465;

public class CraftingHelperOverlay
extends WEHandledScreen {
    private static boolean registeredScroll = false;
    private static long lastScrollTime = 0L;
    private static final long scrollCooldown = 50L;
    public static float targetOffset = 0.0f;
    public static float actualOffset = 0.0f;
    static HelperWidget helperWidget;
    SelectionWidget selectionWidget1;
    SelectionWidget selectionWidget2;
    SelectionWidget selectionWidget3;
    private static RecipeState state;
    private static final Map<ProfessionType, Map<RecipeState, Float>> lastOffset;
    private static final Map<ProfessionType, RecipeState> lastState;
    class_2960 l = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/craftinghelper/l.png");
    class_2960 r = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/craftinghelper/r.png");
    class_2960 t = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/craftinghelper/t.png");
    class_2960 b = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/craftinghelper/b.png");
    class_2960 tl = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/craftinghelper/tl.png");
    class_2960 tr = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/craftinghelper/tr.png");
    class_2960 bl = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/craftinghelper/bl.png");
    class_2960 br = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/craftinghelper/br.png");
    ProfBombWidget profSpeedBombWidget;
    ProfBombWidget profXpBombWidget;
    static ScrollBarWidget scrollBarWidget;
    static String statusMessage;

    public CraftingHelperOverlay() {
        state = RecipeState.NONE;
        helperWidget = null;
        this.selectionWidget1 = null;
        this.selectionWidget2 = null;
        this.selectionWidget3 = null;
        this.profSpeedBombWidget = null;
        this.profXpBombWidget = null;
        actualOffset = 0.0f;
        targetOffset = this.ui == null ? -10.0f : -10.0f / this.ui.getScaleFactorF();
        statusMessage = "";
        Container container = Models.Container.getCurrentContainer();
        if (!(container instanceof CraftingStationContainer)) {
            return;
        }
        CraftingStationContainer container2 = (CraftingStationContainer)container;
        ProfessionType type = container2.getProfessionType();
        if (type == null) {
            return;
        }
        if (lastState.isEmpty()) {
            return;
        }
        state = lastState.get(type);
        Map<RecipeState, Float> offsets = lastOffset.get(type);
        if (offsets == null) {
            return;
        }
        Float offset = offsets.get((Object)state);
        if (offset == null) {
            return;
        }
        actualOffset = offset.floatValue();
        targetOffset = offset.floatValue();
    }

    @Override
    protected void drawBackground(class_332 ctx, int mouseX, int mouseY, float delta) {
        if (!(Models.Container.getCurrentContainer() instanceof CraftingStationContainer)) {
            return;
        }
        this.ui.drawBackground();
    }

    @Override
    protected void drawContent(class_332 ctx, int mouseX, int mouseY, float delta) {
        Container container = Models.Container.getCurrentContainer();
        if (!(container instanceof CraftingStationContainer)) {
            return;
        }
        CraftingStationContainer container2 = (CraftingStationContainer)container;
        class_437 class_4372 = McUtils.screen();
        if (!(class_4372 instanceof class_465)) {
            return;
        }
        class_465 screen = (class_465)class_4372;
        if (state == null) {
            state = RecipeState.NONE;
        }
        int xStart = ((HandledScreenAccessor)screen).getX() + ((HandledScreenAccessor)screen).getBackgroundWidth();
        int yStart = (int)((double)((HandledScreenAccessor)screen).getY() + 70.0 / this.ui.getScaleFactor());
        int widgetWidth = 600;
        int widgetHeight = (int)((double)((HandledScreenAccessor)screen).getBackgroundHeight() - 72.0 / this.ui.getScaleFactor());
        if (this.profSpeedBombWidget == null) {
            this.profSpeedBombWidget = new ProfBombWidget(BombType.PROFESSION_SPEED);
        }
        if (this.profXpBombWidget == null) {
            this.profXpBombWidget = new ProfBombWidget(BombType.PROFESSION_XP);
        }
        int speedWidth = (int)((double)class_310.method_1551().field_1772.method_1727(this.profSpeedBombWidget.text) * this.ui.getScaleFactor());
        int xpWidth = (int)((double)class_310.method_1551().field_1772.method_1727(this.profXpBombWidget.text) * this.ui.getScaleFactor());
        this.profSpeedBombWidget.setBounds((int)((float)screen.field_22789 / 2.0f * this.ui.getScaleFactorF() - (float)speedWidth / 2.0f), (int)((float)((HandledScreenAccessor)screen).getY() * this.ui.getScaleFactorF() - 100.0f), speedWidth, 30);
        this.profXpBombWidget.setBounds((int)((float)screen.field_22789 / 2.0f * this.ui.getScaleFactorF() - (float)xpWidth / 2.0f), (int)((float)((HandledScreenAccessor)screen).getY() * this.ui.getScaleFactorF() - 140.0f), xpWidth, 30);
        this.profSpeedBombWidget.draw(ctx, mouseX, mouseY, delta, this.ui);
        this.profXpBombWidget.draw(ctx, mouseX, mouseY, delta, this.ui);
        boolean dontShowWorldText = false;
        if (this.profSpeedBombWidget.bomb != null && this.profSpeedBombWidget.bomb.server().equals(Models.WorldState.getCurrentWorldName())) {
            dontShowWorldText = true;
        }
        if (this.profXpBombWidget.bomb != null && this.profXpBombWidget.bomb.server().equals(Models.WorldState.getCurrentWorldName())) {
            dontShowWorldText = true;
        }
        if ((this.profXpBombWidget.isActive || this.profSpeedBombWidget.isActive) && !dontShowWorldText) {
            int currentWorldTextYOffset = this.profXpBombWidget.isActive ? 170 : 130;
            this.ui.drawCenteredText("There are no active profession bombs on your world. Click below to switch worlds.", (float)screen.field_22789 / 2.0f * this.ui.getScaleFactorF(), (int)((float)((HandledScreenAccessor)screen).getY() * this.ui.getScaleFactorF() - (float)currentWorldTextYOffset), CustomColor.fromHexString((String)"FF0000"));
        }
        if (!this.profXpBombWidget.isActive && !this.profSpeedBombWidget.isActive) {
            this.ui.drawCenteredText("There are no active profession bombs.", (float)screen.field_22789 / 2.0f * this.ui.getScaleFactorF(), (int)((float)((HandledScreenAccessor)screen).getY() * this.ui.getScaleFactorF() - 90.0f), CustomColor.fromHexString((String)"FF0000"));
        }
        ProfessionType type = container2.getProfessionType();
        lastState.put(type, state);
        if (this.selectionWidget1 == null) {
            this.selectionWidget1 = new SelectionWidget(0);
            this.rootWidgets.add(this.selectionWidget1);
        }
        if (this.selectionWidget2 == null) {
            this.selectionWidget2 = new SelectionWidget(1);
            this.rootWidgets.add(this.selectionWidget2);
        }
        if (this.selectionWidget3 == null) {
            this.selectionWidget3 = new SelectionWidget(2);
            this.rootWidgets.add(this.selectionWidget3);
        }
        boolean big = false;
        ProfessionType professionType = type;
        int n = 0;
        switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"JEWELING", "WOODWORKING", "WEAPONSMITHING", "ARMOURING", "TAILORING"}, (ProfessionType)professionType, n)) {
            case 0: 
            case 1: {
                this.setupSelectionWidget(this.selectionWidget1, type, 0, 3, xStart, yStart, widgetWidth);
                this.setupSelectionWidget(this.selectionWidget2, type, 1, 3, xStart, yStart, widgetWidth);
                this.setupSelectionWidget(this.selectionWidget3, type, 2, 3, xStart, yStart, widgetWidth);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.setupSelectionWidget(this.selectionWidget1, type, 0, 2, xStart, yStart, widgetWidth);
                this.setupSelectionWidget(this.selectionWidget2, type, 1, 2, xStart, yStart, widgetWidth);
                this.selectionWidget3.setBounds(0, 0, 0, 0);
                break;
            }
            default: {
                this.selectionWidget1.setBounds(0, 0, 0, 0);
                this.selectionWidget2.setBounds(0, 0, 0, 0);
                this.selectionWidget3.setBounds(0, 0, 0, 0);
                big = true;
            }
        }
        this.ui.drawNineSlice((int)((double)xStart * this.ui.getScaleFactor() + 5.0), (int)((double)yStart * this.ui.getScaleFactor()) - (big ? 66 : 0), widgetWidth, (int)((double)widgetHeight * this.ui.getScaleFactor()) + (big ? 66 : 0), 33, this.l, this.r, this.t, this.b, this.tl, this.tr, this.bl, this.br, CustomColor.fromHexString((String)"cca76f"));
        int step = 142;
        int recipeWidgetAmount = 12;
        int contentHeight = recipeWidgetAmount * step;
        int visibleHeight = helperWidget == null ? 0 : helperWidget.getHeight();
        int maxOffset = Math.max(0, contentHeight - visibleHeight);
        if (helperWidget == null) {
            helperWidget = new HelperWidget(maxOffset);
            this.rootWidgets.add(helperWidget);
        }
        if (CraftingHelperOverlay.helperWidget.recipeData == null) {
            IRecipeData data = CraftingHelperOverlay.getRecipeDataInstance(type);
            helperWidget.setRecipeData(data);
        }
        if (scrollBarWidget == null) {
            scrollBarWidget = new ScrollBarWidget(maxOffset);
        }
        CraftingHelperOverlay.helperWidget.maxOffset = maxOffset;
        CraftingHelperOverlay.scrollBarWidget.maxOffset = maxOffset;
        scrollBarWidget.setBounds((int)((double)(xStart + 5) * this.ui.getScaleFactor()) + widgetWidth, (int)((double)((int)((double)((HandledScreenAccessor)screen).getY() + (double)(big ? 10 : 70) / this.ui.getScaleFactor())) * this.ui.getScaleFactor()), 30, (int)(((double)((HandledScreenAccessor)screen).getBackgroundHeight() - (double)(big ? 12 : 75) / this.ui.getScaleFactor()) * this.ui.getScaleFactor()));
        scrollBarWidget.draw(ctx, mouseX, mouseY, delta, this.ui);
        int scissorX1 = xStart;
        int scissorY1 = (int)((long)yStart + Math.round((double)(big ? -46.5f : 20.0f) / this.ui.getScaleFactor()));
        int scissorX2 = xStart + widgetWidth;
        int scissorY2 = (int)((long)(yStart + widgetHeight) - Math.round(20.0 / this.ui.getScaleFactor()));
        this.ui.drawCenteredText(statusMessage, (float)(xStart + (this.ui.getScaleFactorF() == 2.0f ? 40 : 0)) * this.ui.getScaleFactorF(), (float)(((HandledScreenAccessor)screen).getY() + ((HandledScreenAccessor)screen).getBackgroundHeight() + 10) * this.ui.getScaleFactorF(), CustomColor.fromHexString((String)"FF0000"));
        ctx.method_44379(scissorX1, scissorY1, scissorX2, scissorY2);
        this.selectionWidget1.setScissorBounds(scissorX1, scissorY1, scissorX2, scissorY2);
        this.selectionWidget2.setScissorBounds(scissorX1, scissorY1, scissorX2, scissorY2);
        this.selectionWidget3.setScissorBounds(scissorX1, scissorY1, scissorX2, scissorY2);
        helperWidget.setBounds((int)((double)xStart * this.ui.getScaleFactor() + 5.0), (int)((double)(yStart + (big ? -15 : 7)) * this.ui.getScaleFactor()), widgetWidth, (int)((double)(widgetHeight + (big ? 12 : -14)) * this.ui.getScaleFactor()));
    }

    private void setupSelectionWidget(SelectionWidget selectionWidget, ProfessionType type, int i, int maxWidgets, int xStart, int yStart, int widgetWidth) {
        int spacing = 20;
        int totalSpacing = spacing * (maxWidgets - 1);
        int sectionWidth = (widgetWidth - totalSpacing) / maxWidgets;
        int x = (int)((double)(xStart + 2) * this.ui.getScaleFactor()) + i * (sectionWidth + spacing);
        int y = (int)((double)yStart * this.ui.getScaleFactor()) - 60;
        selectionWidget.setBounds(x, y, sectionWidth, 50);
        selectionWidget.setText(this.getSelectorText(type, i));
    }

    private String getSelectorText(ProfessionType type, int i) {
        ProfessionType professionType = type;
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"ARMOURING", "WOODWORKING", "JEWELING", "TAILORING", "WEAPONSMITHING"}, (ProfessionType)professionType, n)) {
            case 0 -> {
                switch (i) {
                    case 0: {
                        yield "Helmet";
                    }
                    case 1: {
                        yield "Chestplate";
                    }
                }
                yield null;
            }
            case 1 -> {
                switch (i) {
                    case 0: {
                        yield "Bow";
                    }
                    case 1: {
                        yield "Wand";
                    }
                    case 2: {
                        yield "Relik";
                    }
                }
                yield null;
            }
            case 2 -> {
                switch (i) {
                    case 0: {
                        yield "Ring";
                    }
                    case 1: {
                        yield "Bracelet";
                    }
                    case 2: {
                        yield "Necklace";
                    }
                }
                yield null;
            }
            case 3 -> {
                switch (i) {
                    case 0: {
                        yield "Pants";
                    }
                    case 1: {
                        yield "Boots";
                    }
                }
                yield null;
            }
            case 4 -> {
                switch (i) {
                    case 0: {
                        yield "Spear";
                    }
                    case 1: {
                        yield "Dagger";
                    }
                }
                yield null;
            }
            default -> null;
        };
    }

    @Override
    protected void drawForeground(class_332 ctx, int mouseX, int mouseY, float delta) {
        if (!(Models.Container.getCurrentContainer() instanceof CraftingStationContainer)) {
            return;
        }
        if (!(McUtils.screen() instanceof class_465)) {
            return;
        }
        try {
            ctx.method_44380();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean mouseClicked(double x, double y, int button) {
        if (scrollBarWidget != null) {
            scrollBarWidget.mouseClicked(x, y, button);
        }
        if (this.profSpeedBombWidget != null) {
            this.profSpeedBombWidget.mouseClicked(x, y, button);
        }
        if (this.profXpBombWidget != null) {
            this.profXpBombWidget.mouseClicked(x, y, button);
        }
        return super.mouseClicked(x, y, button);
    }

    @Override
    public boolean mouseReleased(double x, double y, int button) {
        if (scrollBarWidget != null) {
            scrollBarWidget.mouseReleased(x, y, button);
        }
        return super.mouseReleased(x, y, button);
    }

    private static IRecipeData getRecipeDataInstance(ProfessionType type) {
        if (state == null) {
            return null;
        }
        ProfessionType professionType = type;
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"WEAPONSMITHING", "ARMOURING", "WOODWORKING", "JEWELING", "ALCHEMISM", "SCRIBING", "COOKING", "TAILORING"}, (ProfessionType)professionType, n)) {
            case 0 -> {
                switch (state.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 1: {
                        yield SpearRecipes.INSTANCE;
                    }
                    case 2: {
                        yield DaggerRecipes.INSTANCE;
                    }
                    case 0: 
                    case 3: 
                }
                yield null;
            }
            case 1 -> {
                switch (state.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 1: {
                        yield HelmetRecipes.INSTANCE;
                    }
                    case 2: {
                        yield ChestplateRecipes.INSTANCE;
                    }
                    case 0: 
                    case 3: 
                }
                yield null;
            }
            case 2 -> {
                switch (state.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 1: {
                        yield BowRecipes.INSTANCE;
                    }
                    case 2: {
                        yield WandRecipes.INSTANCE;
                    }
                    case 3: {
                        yield RelikRecipes.INSTANCE;
                    }
                    case 0: 
                }
                yield null;
            }
            case 3 -> {
                switch (state.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 1: {
                        yield RingRecipes.INSTANCE;
                    }
                    case 2: {
                        yield BraceletRecipes.INSTANCE;
                    }
                    case 3: {
                        yield NecklaceRecipes.INSTANCE;
                    }
                    case 0: 
                }
                yield null;
            }
            case 4 -> AlchemismRecipes.INSTANCE;
            case 5 -> ScribingRecipes.INSTANCE;
            case 6 -> CookingRecipes.INSTANCE;
            case 7 -> {
                switch (state.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 1: {
                        yield LeggingsRecipes.INSTANCE;
                    }
                    case 2: {
                        yield BootsRecipes.INSTANCE;
                    }
                    case 0: 
                    case 3: 
                }
                yield null;
            }
            default -> null;
        };
    }

    private static void drawRecipe(int x, int y, int width, int height, int level, IRecipeData recipe, boolean hovered, UIUtils ui) {
        if (recipe == null) {
            return;
        }
        List<Pair<IMaterial, Integer>> materials = recipe.getMaterials(level);
        if (materials.isEmpty() || materials.size() < 2) {
            return;
        }
        ui.drawImage(materials.getFirst().getFirst().getTexture(), x + 10, y + 5, 60.0f, 60.0f);
        ui.drawText(materials.getFirst().getFirst().getName() + " " + String.valueOf(materials.getFirst().getSecond()), x + 80, (float)y + (float)height / 4.0f + 4.0f, CustomColor.fromHexString((String)"FFFFFF"), HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, 3.0f);
        ui.drawImage(materials.get(1).getFirst().getTexture(), x + 10, y + 60, 60.0f, 60.0f);
        ui.drawText(materials.get(1).getFirst().getName() + " " + String.valueOf(materials.get(1).getSecond()), x + 80, (float)y + (float)(3 * height) / 4.0f - 4.0f, CustomColor.fromHexString((String)"FFFFFF"), HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, 3.0f);
    }

    static {
        state = RecipeState.NONE;
        lastOffset = new HashMap<ProfessionType, Map<RecipeState, Float>>();
        lastState = new HashMap<ProfessionType, RecipeState>();
        scrollBarWidget = null;
        statusMessage = "";
    }

    private static enum RecipeState {
        NONE,
        FIRST,
        SECOND,
        THIRD;

    }

    private static class HelperWidget
    extends Widget {
        IRecipeData recipeData;
        List<RecipeWidget> recipeWidgets = new ArrayList<RecipeWidget>();
        private static final Queue<Integer> CLICK_QUEUE = new ArrayDeque<Integer>();
        public int maxOffset;
        private static long lastClick = 0L;

        public HelperWidget(int maxOffset) {
            super(0, 0, 0, 0);
            this.maxOffset = maxOffset;
            this.recipeData = null;
            if (class_310.method_1551().field_1755 == null) {
                return;
            }
            ScreenMouseEvents.afterMouseScroll((class_437)class_310.method_1551().field_1755).register((screen, mX, mY, horizontalAmount, verticalAmount) -> {
                long now = System.currentTimeMillis();
                if (now - lastScrollTime < 50L) {
                    return;
                }
                lastScrollTime = now;
                if (this.hovered) {
                    targetOffset = verticalAmount > 0.0 ? (targetOffset -= 104.0f) : (targetOffset += 104.0f);
                }
            });
        }

        @Override
        protected void drawContent(class_332 ctx, int mouseX, int mouseY, float tickDelta) {
            int i;
            boolean big;
            Container container = Models.Container.getCurrentContainer();
            if (!(container instanceof CraftingStationContainer)) {
                return;
            }
            CraftingStationContainer container2 = (CraftingStationContainer)container;
            ProfessionType type = container2.getProfessionType();
            if (state == RecipeState.NONE && type != ProfessionType.ALCHEMISM && type != ProfessionType.COOKING && type != ProfessionType.SCRIBING) {
                this.ui.drawCenteredText("Select the type", (float)this.x + (float)this.width / 2.0f, (float)this.y + (float)this.height / 2.0f - 30.0f, CustomColor.fromHexString((String)"FF0000"), 4.0f);
                this.ui.drawCenteredText("you want to craft.", (float)this.x + (float)this.width / 2.0f, (float)this.y + (float)this.height / 2.0f + 30.0f, CustomColor.fromHexString((String)"FF0000"), 4.0f);
            }
            if (this.recipeData == null) {
                return;
            }
            float snapValue = 0.5f;
            int widgetHeight = 130;
            int widgetAmount = 12;
            boolean bl = big = type == ProfessionType.ALCHEMISM || type == ProfessionType.COOKING || type == ProfessionType.SCRIBING;
            targetOffset = this.ui == null ? 0.0f : Math.clamp(targetOffset, big ? -8.0f * (this.ui.getScaleFactorF() - 3.0f) : 0.0f, (float)this.maxOffset);
            float speed = 0.3f;
            float diff = targetOffset - actualOffset;
            actualOffset = Math.abs(diff) < snapValue || !SimpleConfig.getInstance(WynnExtrasConfig.class).smoothScrollToggle ? targetOffset : (actualOffset += diff * speed * tickDelta);
            Map<Object, Object> map = lastOffset.get(type) == null ? new HashMap() : lastOffset.get(type);
            map.put((Object)state, Float.valueOf(actualOffset));
            lastOffset.put(type, map);
            if (this.recipeWidgets.isEmpty()) {
                for (i = 0; i < widgetAmount; ++i) {
                    int level = i * 10;
                    if (i == 11) {
                        level = 103;
                    }
                    RecipeWidget recipeWidget = new RecipeWidget(this.recipeData, i, level);
                    this.recipeWidgets.add(recipeWidget);
                    this.addChild(recipeWidget);
                }
            }
            for (i = 0; i < widgetAmount; ++i) {
                int baseY = this.y + 10 + 140 * i;
                int drawY = baseY - (int)actualOffset;
                this.recipeWidgets.get(i).setBounds(this.x + 30, drawY, this.width - 60, widgetHeight);
            }
        }

        @Override
        public boolean mouseClicked(double mx, double my, int button) {
            if (this.contains((int)mx, (int)my)) {
                HelperWidget.resetMaterialSlots();
            }
            return super.mouseClicked(mx, my, button);
        }

        public void setRecipeData(IRecipeData recipeData) {
            this.recipeData = recipeData;
            this.recipeWidgets.clear();
            this.children.clear();
            HelperWidget.resetMaterialSlots();
        }

        private static void resetMaterialSlots() {
            ContainerUtils.clickOnSlot((int)0, (int)McUtils.containerMenu().field_7763, (int)0, (List)McUtils.containerMenu().method_7602());
            ContainerUtils.clickOnSlot((int)9, (int)McUtils.containerMenu().field_7763, (int)0, (List)McUtils.containerMenu().method_7602());
            CLICK_QUEUE.clear();
        }

        private static class RecipeWidget
        extends Widget {
            final IRecipeData recipeData;
            final int index;
            final int level;
            boolean isClicking;

            public RecipeWidget(IRecipeData recipeData, int index, int level) {
                super(0, 0, 0, 0);
                this.recipeData = recipeData;
                this.index = index;
                this.level = level;
                this.isClicking = false;
            }

            @Override
            protected void drawContent(class_332 ctx, int mouseX, int mouseY, float tickDelta) {
                this.ui.drawButton(this.x, this.y, this.width, this.height, 19, this.hovered && helperWidget.hovered);
                CraftingHelperOverlay.drawRecipe(this.x, this.y, this.width, this.height, this.level, this.recipeData, this.hovered, this.ui);
                this.ui.drawLine((float)this.x + (float)this.width * 0.8f, this.y + 5, (float)this.x + (float)this.width * 0.8f, this.y + this.height - 9, this.ui.getScaleFactorF(), this.hovered ? CustomColor.fromHexString((String)"c5b490") : CustomColor.fromHexString((String)"a68a73"));
                if (this.level < 100) {
                    this.ui.drawCenteredText(String.valueOf(Math.max(1, this.level)), (float)this.x + (float)this.width * 0.9f, (float)this.y + (float)this.height / 4.0f + 4.0f);
                    this.ui.drawCenteredText("-", (float)this.x + (float)this.width * 0.9f, (float)this.y + (float)(2 * this.height) / 4.0f);
                    this.ui.drawCenteredText(String.valueOf(this.level + 9), (float)this.x + (float)this.width * 0.9f, (float)this.y + (float)(3 * this.height) / 4.0f - 4.0f);
                } else if (this.level == 100) {
                    this.ui.drawCenteredText("100", (float)this.x + (float)this.width * 0.9f, (float)this.y + (float)this.height / 4.0f + 4.0f);
                    this.ui.drawCenteredText("-", (float)this.x + (float)this.width * 0.9f, (float)this.y + (float)(2 * this.height) / 4.0f);
                    this.ui.drawCenteredText("103", (float)this.x + (float)this.width * 0.9f, (float)this.y + (float)(3 * this.height) / 4.0f - 4.0f);
                } else if (this.level == 103) {
                    this.ui.drawCenteredText("103", (float)this.x + (float)this.width * 0.9f, (float)this.y + (float)this.height / 4.0f + 4.0f);
                    this.ui.drawCenteredText("-", (float)this.x + (float)this.width * 0.9f, (float)this.y + (float)(2 * this.height) / 4.0f);
                    this.ui.drawCenteredText("105", (float)this.x + (float)this.width * 0.9f, (float)this.y + (float)(3 * this.height) / 4.0f - 4.0f);
                }
                Container container = Models.Container.getCurrentContainer();
                if (!(container instanceof CraftingStationContainer)) {
                    return;
                }
                CraftingStationContainer container2 = (CraftingStationContainer)container;
                ProfessionType profession = container2.getProfessionType();
                try {
                    int level = Models.Profession.getLevel(profession);
                    if (level > 0 && level < this.level) {
                        this.ui.drawRect(this.x, this.y, this.width, this.height, this.hovered ? CustomColor.fromHSV((float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f) : CustomColor.fromHSV((float)0.0f, (float)0.0f, (float)0.0f, (float)0.75f));
                        this.ui.drawCenteredText("Requires " + profession.getDisplayName(), (float)this.x + (float)this.width / 2.0f, (float)this.y + (float)this.height / 2.0f - 20.0f, this.hovered ? CustomColor.fromHexString((String)"FF0000").withAlpha(0.2f) : CustomColor.fromHexString((String)"FF0000"));
                        this.ui.drawCenteredText("level " + this.level + " to craft.", (float)this.x + (float)this.width / 2.0f, (float)this.y + (float)this.height / 2.0f + 20.0f, this.hovered ? CustomColor.fromHexString((String)"FF0000").withAlpha(0.2f) : CustomColor.fromHexString((String)"FF0000"));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.checkClick();
            }

            @Override
            protected boolean onClick(int button) {
                if (!helperWidget.hovered) {
                    return false;
                }
                Container container = Models.Container.getCurrentContainer();
                if (!(container instanceof CraftingStationContainer)) {
                    return false;
                }
                CraftingStationContainer container2 = (CraftingStationContainer)container;
                statusMessage = "";
                ProfessionType profession = container2.getProfessionType();
                try {
                    int level = Models.Profession.getLevel(profession);
                    if (level > 0 && level < this.level) {
                        return false;
                    }
                }
                catch (Exception level) {
                    // empty catch block
                }
                McUtils.playSoundUI((class_3414)((class_3414)class_3417.field_15015.comp_349()));
                List<Pair<IMaterial, Integer>> materials = this.recipeData.getMaterials(this.level);
                if (materials.isEmpty() || materials.size() < 2) {
                    return true;
                }
                this.clickMaterial(materials.getFirst(), true);
                this.clickMaterial(materials.get(1), false);
                return true;
            }

            private void clickMaterial(Pair<IMaterial, Integer> material, boolean isFirstMaterial) {
                int materialAmount = material.getSecond();
                class_2371 slots = McUtils.containerMenu().field_7761;
                int available = 0;
                boolean canClick = false;
                for (class_1735 slot : slots) {
                    try {
                        if (!(slot.field_7871 instanceof class_1661)) continue;
                        if (slot.method_7677().method_65130().getString().contains(material.getFirst().getName())) {
                            canClick = true;
                            for (int i = 0; i < materialAmount; ++i) {
                                CLICK_QUEUE.add(slot.field_7874);
                            }
                            break;
                        }
                        if (available < materialAmount) continue;
                        break;
                    }
                    catch (Exception exception) {
                    }
                }
                if (!canClick) {
                    statusMessage = "You don't have the required materials to craft this.";
                }
            }

            private void checkClick() {
                if (McUtils.containerMenu().method_7611(0).method_7677().method_65130() == null || McUtils.containerMenu().method_7611(9).method_7677().method_65130() == null) {
                    return;
                }
                if (McUtils.containerMenu().method_7611(0).method_7677().method_65130().getString() == null || McUtils.containerMenu().method_7611(9).method_7677().method_65130().getString() == null) {
                    return;
                }
                if (!(McUtils.containerMenu().method_7611(0).method_7677().method_65130().getString().contains("Material Slot") && McUtils.containerMenu().method_7611(9).method_7677().method_65130().getString().contains("Material Slot") || this.isClicking)) {
                    return;
                }
                this.isClicking = true;
                if (!CLICK_QUEUE.isEmpty() && lastClick < Time.now().timestamp() - 1L) {
                    Integer next = CLICK_QUEUE.poll();
                    if (next == null) {
                        return;
                    }
                    ContainerUtils.clickOnSlot((int)next, (int)McUtils.containerMenu().field_7763, (int)0, (List)McUtils.containerMenu().method_7602());
                    lastClick = Time.now().timestamp();
                } else if (CLICK_QUEUE.isEmpty()) {
                    this.isClicking = false;
                }
            }
        }
    }

    private static class SelectionWidget
    extends Widget {
        final int index;
        String text;
        int scissorX1;
        int scissorY1;
        int scissorX2;
        int scissorY2;

        public SelectionWidget(int index) {
            super(0, 0, 0, 0);
            this.index = index;
        }

        public void setScissorBounds(int scissorX1, int scissorY1, int scissorX2, int scissorY2) {
            this.scissorX1 = scissorX1;
            this.scissorX2 = scissorX2;
            this.scissorY1 = scissorY1;
            this.scissorY2 = scissorY2;
        }

        @Override
        protected void drawContent(class_332 ctx, int mouseX, int mouseY, float tickDelta) {
            class_437 class_4372 = McUtils.screen();
            if (!(class_4372 instanceof class_465)) {
                return;
            }
            class_465 screen = (class_465)class_4372;
            if (state == null) {
                return;
            }
            ctx.method_44380();
            this.ui.drawButton(this.x, this.y - 6, this.width + 2, this.height + 10, 13, this.hovered || this.index == state.ordinal() - 1);
            this.ui.drawCenteredText(this.text, (float)this.x + (float)this.width / 2.0f, (float)this.y + (float)this.height / 2.0f);
            int xStart = ((HandledScreenAccessor)screen).getX() + ((HandledScreenAccessor)screen).getBackgroundWidth();
            int yStart = ((HandledScreenAccessor)screen).getY() + 22;
            int widgetWidth = 600;
            int widgetHeight = ((HandledScreenAccessor)screen).getBackgroundHeight() - 24;
            ctx.method_44379(this.scissorX1, this.scissorY1, this.scissorX2, this.scissorY2);
        }

        @Override
        protected boolean onClick(int button) {
            McUtils.playSoundUI((class_3414)((class_3414)class_3417.field_15015.comp_349()));
            switch (this.index) {
                case 0: {
                    if (state != RecipeState.FIRST) {
                        state = RecipeState.FIRST;
                        break;
                    }
                    state = RecipeState.NONE;
                    break;
                }
                case 1: {
                    if (state != RecipeState.SECOND) {
                        state = RecipeState.SECOND;
                        break;
                    }
                    state = RecipeState.NONE;
                    break;
                }
                case 2: {
                    state = state != RecipeState.THIRD ? RecipeState.THIRD : RecipeState.NONE;
                }
            }
            CraftingHelperOverlay.helperWidget.recipeData = null;
            Container container = Models.Container.getCurrentContainer();
            if (!(container instanceof CraftingStationContainer)) {
                return true;
            }
            CraftingStationContainer container2 = (CraftingStationContainer)container;
            ProfessionType type = container2.getProfessionType();
            targetOffset = 0.0f;
            if (type == null) {
                return true;
            }
            Map<RecipeState, Float> offsets = lastOffset.get(type);
            if (offsets == null) {
                return true;
            }
            Float offset = offsets.get((Object)state);
            if (offset == null) {
                return true;
            }
            targetOffset = offset.floatValue();
            return true;
        }

        public void setText(String text) {
            this.text = text;
        }
    }

    private static class ProfBombWidget
    extends Widget {
        final BombType type;
        public BombInfo bomb;
        public boolean isActive;
        public String text;

        public ProfBombWidget(BombType type) {
            super(0, 0, 0, 0);
            this.type = type;
        }

        @Override
        protected void drawContent(class_332 ctx, int mouseX, int mouseY, float tickDelta) {
            try {
                if (this.bomb != null && this.bomb.server().equals(Models.WorldState.getCurrentWorldName())) {
                    this.hovered = false;
                }
                String currentWorld = Models.WorldState.getCurrentWorldName();
                this.isActive = false;
                this.bomb = null;
                for (BombInfo bomb : Models.Bomb.getBombBells()) {
                    if (bomb.bomb() != this.type) continue;
                    this.isActive = true;
                    if (bomb.server().equals(currentWorld)) {
                        this.bomb = bomb;
                        break;
                    }
                    if (this.bomb != null && bomb.getRemainingLong() <= this.bomb.getRemainingLong()) continue;
                    this.bomb = bomb;
                }
                if (this.isActive) {
                    Object worldColor = this.bomb.server().equals(currentWorld) ? "\u00a7a" : "\u00a7f";
                    worldColor = (String)worldColor + (this.hovered ? "\u00a7n" : "");
                    String bombType = "?";
                    if (this.type == BombType.PROFESSION_SPEED) {
                        bombType = "Speed";
                    }
                    if (this.type == BombType.PROFESSION_XP) {
                        bombType = "XP";
                    }
                    this.text = "\u00a76" + (this.hovered ? "\u00a7n" : "") + "Profession " + bombType + " \u00a77" + (this.hovered ? "\u00a7n" : "") + "on " + (String)worldColor + this.bomb.server() + " \u00a76" + (this.hovered ? "\u00a7n" : "") + "(" + this.bomb.getRemainingString() + ")";
                    if (this.bomb.getRemainingLong() < 30000L) {
                        long seconds = Time.now().timestamp() / 1000L;
                        Object color = seconds % 2L == 0L ? "\u00a7c" : "\u00a74";
                        color = (String)color + (this.hovered ? "\u00a7n" : "");
                        this.text = (String)color + "Profession " + bombType + " on " + this.bomb.server() + " (" + this.bomb.getRemainingString() + ") (EXPIRING SOON)";
                    }
                    this.ui.drawCenteredText(this.text, (float)this.x + (float)this.width / 2.0f, (float)this.y + (float)this.height / 2.0f);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        protected boolean onClick(int button) {
            if (this.bomb.server().equals(Models.WorldState.getCurrentWorldName())) {
                return true;
            }
            McUtils.playSoundUI((class_3414)((class_3414)class_3417.field_15015.comp_349()));
            if (this.bomb == null) {
                return true;
            }
            class_310 client = class_310.method_1551();
            if (client.field_1724 != null) {
                McUtils.setScreen(null);
                client.field_1724.field_3944.method_45730("switch " + this.bomb.server());
            }
            return true;
        }
    }

    private static class ScrollBarWidget
    extends Widget {
        ScrollBarButtonWidget scrollBarButtonWidget = new ScrollBarButtonWidget();
        int currentMouseY = 0;
        public int maxOffset;

        public ScrollBarWidget(int maxOffset) {
            super(0, 0, 0, 0);
            this.addChild(this.scrollBarButtonWidget);
            this.maxOffset = maxOffset;
        }

        private void setOffset(int mouseY, int maxOffset, int scrollAreaHeight) {
            float relativeY = (float)mouseY * this.ui.getScaleFactorF() - (float)this.y - (float)this.scrollBarButtonWidget.getHeight() / 2.0f;
            relativeY = Math.max(-1.15f * this.ui.getScaleFactorF(), Math.min(relativeY, (float)scrollAreaHeight));
            float scrollPercent = relativeY / (float)scrollAreaHeight;
            targetOffset = scrollPercent * (float)maxOffset;
        }

        @Override
        protected void drawContent(class_332 ctx, int mouseX, int mouseY, float tickDelta) {
            this.currentMouseY = mouseY;
            this.ui.drawSliderBackground(this.x, this.y, this.width, this.height, 5, false);
            int buttonHeight = 50;
            int scrollAreaHeight = this.height - buttonHeight;
            if (this.scrollBarButtonWidget.isHeld) {
                this.setOffset(mouseY, this.maxOffset, scrollAreaHeight);
                actualOffset = targetOffset;
            }
            float percent = this.maxOffset == 0 ? 0.0f : actualOffset / (float)this.maxOffset;
            percent = Math.clamp(percent, 0.0f, 1.0f);
            int yPos = this.y + (int)((float)scrollAreaHeight * percent);
            this.scrollBarButtonWidget.setBounds(this.x, yPos, this.width, buttonHeight);
        }

        @Override
        protected boolean onClick(int button) {
            McUtils.playSoundUI((class_3414)((class_3414)class_3417.field_15015.comp_349()));
            int buttonHeight = 30;
            int scrollAreaHeight = this.height - buttonHeight;
            this.setOffset(this.currentMouseY, this.maxOffset, scrollAreaHeight);
            return false;
        }

        @Override
        public boolean mouseReleased(double mx, double my, int button) {
            this.scrollBarButtonWidget.mouseReleased(mx, my, button);
            return true;
        }

        private static class ScrollBarButtonWidget
        extends Widget {
            public boolean isHeld = false;

            public ScrollBarButtonWidget() {
                super(0, 0, 0, 0);
            }

            @Override
            protected void drawContent(class_332 ctx, int mouseX, int mouseY, float tickDelta) {
                this.ui.drawButton(this.x, this.y, this.width, this.height, 5, this.hovered || this.isHeld, false);
            }

            @Override
            protected boolean onClick(int button) {
                McUtils.playSoundUI((class_3414)((class_3414)class_3417.field_15015.comp_349()));
                this.isHeld = true;
                return true;
            }

            @Override
            public boolean mouseReleased(double mx, double my, int button) {
                this.isHeld = false;
                return true;
            }
        }
    }
}

