/*
 * Decompiled with CFR 0.152.
 */
package julianh06.wynnextras.features.abilitytree;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.wynntils.core.components.Models;
import com.wynntils.models.character.type.SavableSkillPointSet;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.type.Time;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import julianh06.wynnextras.annotations.WEModule;
import julianh06.wynnextras.core.WynnExtras;
import julianh06.wynnextras.core.command.Command;
import julianh06.wynnextras.features.abilitytree.TreeData;
import julianh06.wynnextras.features.abilitytree.TreeScreen;
import julianh06.wynnextras.features.profileviewer.WynncraftApiHandler;
import julianh06.wynnextras.features.profileviewer.data.AbilityMapData;
import julianh06.wynnextras.features.profileviewer.data.AbilityMapDataDeserializer;
import julianh06.wynnextras.features.profileviewer.data.AbilityTreeData;
import julianh06.wynnextras.features.profileviewer.data.AbilityTreeDataDeserializer;
import julianh06.wynnextras.features.profileviewer.data.IconDeserializer;
import julianh06.wynnextras.features.profileviewer.data.NodeDeserializer;
import julianh06.wynnextras.features.profileviewer.data.SkillPoints;
import julianh06.wynnextras.utils.UI.WEScreen;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2848;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_746;

@WEModule
public class TreeLoader {
    static final int GUI_SETTLE_TICKS = 4;
    static int ticksSinceLastAction = 0;
    static int socketClicksPerformed = 0;
    static boolean inTreeMenu = false;
    static boolean inResetMenu = false;
    static boolean wasStarted = false;
    static boolean treeMenuWasOpened = false;
    static boolean resetMenuWasOpened = false;
    static boolean wasReset = false;
    static int clickedSockets = 0;
    static class_465<?> screen = null;
    static boolean resetTree = false;
    static List<AbilityMapData.Node> abilitiesToClick2 = null;
    static AbilityTreeData classTree = null;
    static Gson gson = new GsonBuilder().registerTypeAdapter(AbilityMapData.class, (Object)new AbilityMapDataDeserializer()).registerTypeAdapter(AbilityTreeData.class, (Object)new AbilityTreeDataDeserializer()).registerTypeAdapter(AbilityMapData.Icon.class, (Object)new IconDeserializer()).registerTypeAdapter(AbilityMapData.Node.class, (Object)new NodeDeserializer()).registerTypeAdapter(AbilityTreeData.Icon.class, (Object)new IconDeserializer()).setPrettyPrinting().create();
    private static Command openTreeScreen = new Command("tree", "", ctx -> {
        WEScreen.open(TreeScreen::new);
        return 1;
    }, null, null);
    public static boolean loadSkillpoints = false;
    public static SavableSkillPointSet skillPointSet;
    public static boolean loadingSkillpoints;
    private static final int CLICK_CONFIRM_TIMEOUT_TICKS = 1;
    private static final int MAX_ATTEMPTS_PER_ABILITY = 15;
    private static final int GUI_SETTLE_TICKS_DEFAULT = 4;
    private static PendingClick pendingClick;
    private static int lagTickCounter;
    private static boolean fastMode;
    private static PendingResetClick pendingReset;
    private static final int RESET_CLICK_TIMEOUT = 5;
    private static final int MAX_RESET_ATTEMPTS = 15;
    private static boolean scrolledUp;
    private static class_1799 firstNode;
    private static long lastResetTryClick;
    private static long finishedTreeTime;

    public static void resetAll() {
        treeMenuWasOpened = false;
        resetMenuWasOpened = false;
        wasReset = false;
        clickedSockets = 0;
        resetTree = false;
        abilitiesToClick2 = null;
        ticksSinceLastAction = 0;
        socketClicksPerformed = 0;
    }

    public static void init() {
        TreeData.loadAll();
        ClientTickEvents.END_CLIENT_TICK.register(tick -> {
            class_310 client = class_310.method_1551();
            if (client.field_1724 == null || client.field_1687 == null) {
                return;
            }
            class_437 currScreen = client.field_1755;
            if (currScreen == null) {
                return;
            }
            screen = currScreen instanceof class_465 ? (class_465)currScreen : null;
            String InventoryTitle = currScreen.method_25440().getString();
            boolean oneTrue = inTreeMenu || inResetMenu;
            inTreeMenu = InventoryTitle.equals("\udaff\udfea\ue000");
            inResetMenu = InventoryTitle.equals("\udaff\udfea\ue001");
            if (!inTreeMenu && !inResetMenu && !wasStarted && oneTrue) {
                TreeLoader.resetAll();
            }
            if (wasStarted && inTreeMenu) {
                wasStarted = false;
            }
        });
        ClientTickEvents.END_CLIENT_TICK.register(tick -> {
            if (!resetTree) {
                return;
            }
            class_310 client = class_310.method_1551();
            if (client.field_1724 == null || client.field_1687 == null) {
                return;
            }
            class_746 player = client.field_1724;
            boolean hasTreeManipulation = Models.StatusEffect.getStatusEffects().stream().anyMatch(effect -> effect.getName().getStringWithoutFormatting().equals("Tree Manipulation"));
            if (++ticksSinceLastAction < 4) {
                return;
            }
            if (pendingReset != null && screen != null) {
                ++TreeLoader.pendingReset.ticksWaiting;
                if (TreeLoader.pendingReset.ticksWaiting >= 5) {
                    ++TreeLoader.pendingReset.attempts;
                    if (TreeLoader.pendingReset.attempts > 15) {
                        McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix(class_2561.method_30163((String)"Reset failed due to lag, please try again.")));
                        TreeLoader.resetAll();
                        pendingReset = null;
                        return;
                    }
                    if (TreeLoader.pendingReset.stage.equals("socket")) {
                        TreeLoader.clickOnSockets(client, (class_1657)player, screen);
                    } else if (TreeLoader.pendingReset.stage.equals("confirm")) {
                        TreeLoader.confirmReset(client, (class_1657)player, screen);
                    }
                    TreeLoader.pendingReset.ticksWaiting = 0;
                    return;
                }
                if (TreeLoader.pendingReset.stage.equals("socket")) {
                    if (TreeLoader.countOccurences("Ability Shard", screen) < 3) {
                        pendingReset = null;
                        ticksSinceLastAction = 0;
                        return;
                    }
                    TreeLoader.pendingReset.stage = "confirm";
                } else if (TreeLoader.pendingReset.stage.equals("confirm") && inTreeMenu && !inResetMenu) {
                    pendingReset = null;
                    resetTree = false;
                    return;
                }
                return;
            }
            if (!treeMenuWasOpened) {
                TreeLoader.openTreeMenu(client, (class_1657)player);
                return;
            }
            if (hasTreeManipulation && inTreeMenu && !resetMenuWasOpened) {
                client.field_1761.method_2906(TreeLoader.screen.method_17577().field_7763, 58, 1, class_1713.field_7794, (class_1657)client.field_1724);
                lastResetTryClick = Time.now().timestamp();
                resetMenuWasOpened = true;
                wasReset = true;
                return;
            }
            if (inTreeMenu && !resetMenuWasOpened) {
                TreeLoader.openTreeResetMenu(client, (class_1657)player, screen);
                return;
            }
            if (inResetMenu && !wasReset) {
                int shardCount = TreeLoader.countOccurences("Ability Shard", screen);
                if (shardCount < 3) {
                    if (socketClicksPerformed < shardCount + 1) {
                        TreeLoader.clickOnSockets(client, (class_1657)player, screen);
                        ++socketClicksPerformed;
                        pendingReset = new PendingResetClick("socket");
                        TreeLoader.pendingReset.ticksWaiting = 0;
                        return;
                    }
                    McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix(class_2561.method_30163((String)"Couldn't reset your tree. You either canceled exited the menu or you don't have 3 Ability Shards in your Inventory")));
                    TreeLoader.resetAll();
                    return;
                }
                TreeLoader.confirmReset(client, (class_1657)player, screen);
                pendingReset = new PendingResetClick("confirm");
                TreeLoader.pendingReset.ticksWaiting = 0;
                return;
            }
            if (inTreeMenu && wasReset) {
                resetTree = false;
            }
            if (clickedSockets >= 6) {
                TreeLoader.resetAll();
            }
        });
        int[] abilityClickTicks = new int[]{0};
        int[] currentPage = new int[]{1};
        AtomicInteger failCycles = new AtomicInteger();
        int MAX_FAIL_CYCLES = 30;
        AtomicBoolean pendingPageSwitch = new AtomicBoolean(false);
        AtomicReference prevPageStacks = new AtomicReference(new ArrayList());
        int PAGE_SWITCH_TIMEOUT = 40;
        AtomicInteger pageSwitchTicks = new AtomicInteger();
        ClientTickEvents.END_CLIENT_TICK.register(tick -> {
            if (Time.now().timestamp() - lastResetTryClick < 1000L) {
                return;
            }
            if (abilitiesToClick2 == null || abilitiesToClick2.isEmpty()) {
                abilityClickTicks[0] = 0;
                failCycles.set(0);
                pendingClick = null;
                return;
            }
            if (resetTree) {
                abilityClickTicks[0] = 0;
                currentPage[0] = 1;
                failCycles.set(0);
                pendingClick = null;
                return;
            }
            if (!inTreeMenu) {
                abilityClickTicks[0] = 0;
                return;
            }
            class_310 client = class_310.method_1551();
            if (client.field_1724 == null || client.field_1687 == null || client.field_1755 == null) {
                abilityClickTicks[0] = 0;
                return;
            }
            class_746 player = client.field_1724;
            class_465 screen = (class_465)client.field_1755;
            abilityClickTicks[0] = abilityClickTicks[0] + 1;
            if (abilityClickTicks[0] < 4) {
                return;
            }
            if (pendingPageSwitch.get()) {
                pageSwitchTicks.incrementAndGet();
                ArrayList inv = new ArrayList(McUtils.containerMenu().method_7602());
                boolean changed = false;
                int i = 0;
                for (class_1799 stack : (List)prevPageStacks.get()) {
                    if (stack == null) {
                        ++i;
                        continue;
                    }
                    if (stack.method_7909().equals(class_1802.field_8162)) {
                        ++i;
                        continue;
                    }
                    class_1799 invStack = (class_1799)inv.get(i);
                    if (invStack == null) {
                        ++i;
                        continue;
                    }
                    if (invStack.method_7909().equals(class_1802.field_8162)) {
                        ++i;
                        continue;
                    }
                    ++i;
                    if (class_1799.method_7984((class_1799)invStack, (class_1799)stack)) continue;
                    changed = true;
                    break;
                }
                if (changed) {
                    pendingPageSwitch.set(false);
                    abilityClickTicks[0] = 0;
                    ((List)prevPageStacks.get()).clear();
                    return;
                }
                if (pageSwitchTicks.get() > 40) {
                    pendingPageSwitch.set(false);
                    ((List)prevPageStacks.get()).clear();
                    return;
                }
                return;
            }
            if (failCycles.get() >= 30) {
                TreeLoader.resetAll();
                if (McUtils.mc().field_1755 != null) {
                    McUtils.mc().field_1755.method_25419();
                }
                McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix(class_2561.method_30163((String)"Something went wrong! Try again")));
                abilitiesToClick2 = null;
                abilityClickTicks[0] = 0;
                failCycles.set(0);
                pendingClick = null;
                return;
            }
            if (pendingClick != null) {
                ++TreeLoader.pendingClick.ticksWaiting;
                boolean stillHasUnlock = TreeLoader.hasUnlockPrefix(TreeLoader.pendingClick.abilityName, screen);
                if (!stillHasUnlock) {
                    abilitiesToClick2.removeFirst();
                    failCycles.set(0);
                    pendingClick = null;
                    abilityClickTicks[0] = 0;
                    fastMode = true;
                } else if (TreeLoader.pendingClick.ticksWaiting >= 2) {
                    fastMode = false;
                    if (++lagTickCounter > 1) {
                        TreeLoader.clickOnAbility(client, (class_1657)player, TreeLoader.pendingClick.abilityName, screen);
                        TreeLoader.pendingClick.ticksWaiting = 0;
                        lagTickCounter = 0;
                    }
                    return;
                }
            }
            if (abilitiesToClick2 == null) {
                return;
            }
            if (abilitiesToClick2.isEmpty()) {
                TreeLoader.resetAll();
                if (McUtils.mc().field_1755 != null) {
                    McUtils.mc().field_1755.method_25419();
                }
                McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix(class_2561.method_30163((String)("Finished loading the ability tree." + (loadSkillpoints ? " Continuing with skill points. " : "")))));
                if (skillPointSet != null) {
                    int currentSlot = player.method_31548().field_7545;
                    player.method_31548().field_7545 = 7;
                    client.field_1761.method_2919((class_1657)player, class_1268.field_5808);
                    player.method_31548().field_7545 = currentSlot;
                    loadingSkillpoints = true;
                    finishedTreeTime = Time.now().timestamp();
                }
                return;
            }
            AbilityMapData.Node abilityNode = abilitiesToClick2.getFirst();
            AbilityTreeData.Ability abilityFromNode = TreeLoader.getAbilityFromNode(abilityNode, classTree);
            if (abilityFromNode == null) {
                return;
            }
            String abilityName = TreeLoader.extractAbilityNameFromHtml(abilityFromNode.name);
            if (abilityName == null) {
                return;
            }
            int pageOffset = abilityNode.meta.page - currentPage[0];
            if (pageOffset != 0 && !pendingPageSwitch.get()) {
                ArrayList inv = new ArrayList(McUtils.containerMenu().method_7602());
                prevPageStacks.set(inv);
                String direction = pageOffset > 0 ? "Next Page" : "Previous Page";
                TreeLoader.clickOnAbility(client, (class_1657)player, direction, screen);
                currentPage[0] = currentPage[0] + (pageOffset > 0 ? 1 : -1);
                pendingPageSwitch.set(true);
                pageSwitchTicks.set(0);
                return;
            }
            if (TreeLoader.hasUnlockPrefix(abilityName, screen)) {
                TreeLoader.clickOnAbility(client, (class_1657)player, abilityName, screen);
                pendingClick = new PendingClick(abilityNode, abilityName, currentPage[0]);
                TreeLoader.pendingClick.ticksWaiting = 0;
                abilityClickTicks[0] = fastMode ? 0 : 1;
                return;
            }
            if (abilitiesToClick2.size() > 1) {
                AbilityMapData.Node removed = abilitiesToClick2.removeFirst();
                abilitiesToClick2.add(Math.min(failCycles.get(), abilitiesToClick2.size() - 1), removed);
                failCycles.set(failCycles.get() + 1);
            }
        });
        ClientTickEvents.END_CLIENT_TICK.register(tick -> {
            if (!loadingSkillpoints || skillPointSet == null) {
                return;
            }
            if (Time.now().timestamp() - finishedTreeTime < 600L) {
                class_310.method_1551().field_1761.method_2906(TreeLoader.screen.method_17577().field_7763, 4, 0, class_1713.field_7794, (class_1657)McUtils.player());
                return;
            }
            int finishedSkillPoints = 0;
            int[] pointArray = skillPointSet.getSkillPointsAsArray();
            for (int i = 0; i < 5; ++i) {
                int remainingPoints = pointArray[i];
                if (remainingPoints == 0) {
                    ++finishedSkillPoints;
                    continue;
                }
                if (remainingPoints % 5 == 0) {
                    class_310.method_1551().field_1761.method_2906(TreeLoader.screen.method_17577().field_7763, 11 + i, 0, class_1713.field_7794, (class_1657)McUtils.player());
                    int n = i;
                    pointArray[n] = pointArray[n] - 5;
                    break;
                }
                TreeLoader.clickSlotHelper(11 + i, screen, class_310.method_1551());
                int n = i;
                pointArray[n] = pointArray[n] - 1;
                break;
            }
            if (finishedSkillPoints == 5) {
                McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix(class_2561.method_30163((String)"Finished assigning skill points.")));
                skillPointSet = null;
                loadingSkillpoints = false;
                return;
            }
            skillPointSet = new SavableSkillPointSet(pointArray);
        });
    }

    public static String extractAbilityNameFromHtml(String html) {
        if (html == null) {
            return null;
        }
        String plain = html.replaceAll("<[^>]+>", " ");
        plain = plain.replaceAll("\u00a7.", "");
        plain = plain.replace("&nbsp;", " ").replace("&amp;", "&").replace("&#39;", "'").replace("&quot;", "\"");
        plain = plain.replace('\u2019', '\'').replace('\u2018', '\'');
        plain = plain.replaceAll("[\\p{C}]+", " ").replaceAll("\\s+", " ").trim();
        return (plain = plain.replaceAll("^[\\p{Punct}\\s]+", "").replaceAll("[\\p{Punct}\\s]+$", "")).isEmpty() ? null : plain;
    }

    public static AbilityMapData.Node getNodeFromAbility(AbilityTreeData.Ability ability, AbilityMapData treeData) {
        int page = ability.page;
        for (AbilityMapData.Node node : treeData.pages.get(page)) {
            if (ability.coordinates.x != node.coordinates.x || ability.coordinates.y != node.coordinates.y % 6) continue;
            return node;
        }
        return null;
    }

    public static AbilityTreeData.Ability getAbilityFromNode(AbilityMapData.Node node, AbilityTreeData treeData) {
        if (treeData == null) {
            return null;
        }
        Map<String, AbilityTreeData.Ability> page = treeData.pages.get(node.meta.page);
        for (AbilityTreeData.Ability ability : page.values()) {
            if (ability.coordinates.x != node.coordinates.x || ability.coordinates.y != node.coordinates.y % 6) continue;
            return ability;
        }
        return null;
    }

    public static List<AbilityMapData.Node> convertNodeMapToList(AbilityMapData treeMap) {
        ArrayList<AbilityMapData.Node> result = new ArrayList<AbilityMapData.Node>();
        if (treeMap == null) {
            return result;
        }
        if (treeMap.pages == null) {
            return result;
        }
        for (List<AbilityMapData.Node> page : treeMap.pages.values()) {
            result.addAll(page);
        }
        return result;
    }

    public static List<AbilityTreeData.Ability> convertNodeTreeToList(AbilityTreeData treeData) {
        ArrayList<AbilityTreeData.Ability> result = new ArrayList<AbilityTreeData.Ability>();
        if (treeData == null) {
            return result;
        }
        if (treeData.pages == null) {
            return result;
        }
        for (Map<String, AbilityTreeData.Ability> page : treeData.pages.values()) {
            result.addAll(page.values());
        }
        return result;
    }

    private static String normalizeArchetypeKey(String display) {
        if (display == null) {
            return null;
        }
        return (display + " Archetype").toLowerCase();
    }

    private static Optional<String> extractArchetypeInfo(List<String> description) {
        if (description == null) {
            return Optional.empty();
        }
        Pattern archetypeLine = Pattern.compile("(.+?)\\s+Archetype", 2);
        for (String line : description) {
            String plain;
            Matcher m;
            if (line == null || !(m = archetypeLine.matcher(plain = line.replaceAll("<[^>]+>", "").replaceAll("\u00a7.", "").trim())).find()) continue;
            return Optional.of(m.group(1).trim());
        }
        return Optional.empty();
    }

    public static Optional<Integer> extractCountFromComponentsString(String componentsToString) {
        if (componentsToString == null) {
            return Optional.empty();
        }
        String plain = componentsToString.replaceAll("\u00a7.", "");
        Pattern p = Pattern.compile("\\b(\\d+)\\/(\\d+)\\b");
        Matcher m = p.matcher(plain);
        if (m.find()) {
            int max = Integer.parseInt(m.group(2));
            return Optional.of(max);
        }
        return Optional.empty();
    }

    public static Map<String, Integer> getArchetypeCounts(Map<String, AbilityTreeData.Archetype> archetypes) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        if (archetypes == null) {
            return result;
        }
        for (Map.Entry<String, AbilityTreeData.Archetype> e : archetypes.entrySet()) {
            String mapKey;
            Optional<Object> res;
            class_1799 archetypeItem;
            String internalKey = e.getKey();
            AbilityTreeData.Archetype at = e.getValue();
            if (at == null) continue;
            try {
                archetypeItem = McUtils.inventory().method_5438(at.slot);
            }
            catch (Exception ex) {
                continue;
            }
            if (archetypeItem == null) continue;
            String displayName = null;
            try {
                class_2561 cn = archetypeItem.method_65130();
                if (cn != null) {
                    displayName = String.valueOf(cn).trim();
                }
            }
            catch (Exception cn) {
                // empty catch block
            }
            String lore = null;
            try {
                if (archetypeItem.method_57353() != null) {
                    lore = archetypeItem.method_57353().toString();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Optional<Object> optional = res = lore == null ? Optional.empty() : TreeLoader.extractCountFromComponentsString(lore);
            if (res.isEmpty()) continue;
            int count = (Integer)res.get();
            if (displayName != null && !"null".equalsIgnoreCase(displayName) && !displayName.isEmpty()) {
                mapKey = TreeLoader.normalizeArchetypeKey(displayName);
            } else {
                String string = mapKey = internalKey == null ? "" : internalKey.toLowerCase();
            }
            if (mapKey.isEmpty()) continue;
            result.put(mapKey, count);
        }
        return result;
    }

    public static List<AbilityTreeData.Ability> calculateNodeOrder(final Map<String, AbilityTreeData.Archetype> archetypes, List<AbilityMapData.Node> nodez, final List<String> unlockedNodes, AbilityTreeData treeData) {
        boolean progress;
        ArrayList<AbilityTreeData.Ability> result = new ArrayList<AbilityTreeData.Ability>();
        if (nodez == null || nodez.isEmpty()) {
            return result;
        }
        ArrayList<AbilityTreeData.Ability> nodes = new ArrayList<AbilityTreeData.Ability>();
        for (AbilityMapData.Node node : nodez) {
            nodes.add(TreeLoader.getAbilityFromNode(node, treeData));
        }
        final HashMap<String, AbilityTreeData.Ability> byName = new HashMap<String, AbilityTreeData.Ability>();
        for (AbilityTreeData.Ability ability : nodes) {
            if (ability == null || ability.name == null) continue;
            byName.put(ability.name.toLowerCase(), ability);
        }
        final HashSet<String> hashSet = new HashSet<String>();
        if (unlockedNodes != null) {
            for (String s : unlockedNodes) {
                if (s == null) continue;
                hashSet.add(s.toLowerCase());
            }
            unlockedNodes.clear();
            unlockedNodes.addAll(hashSet);
        }
        final HashSet hashSet2 = new HashSet();
        final HashSet visited = new HashSet();
        final Map<String, Integer> archetypeCounts = TreeLoader.getArchetypeCounts(archetypes);
        final ArrayDeque stack = new ArrayDeque();
        class Resolver {
            Resolver() {
            }

            boolean resolve(String name) {
                boolean ok;
                String req;
                if (name == null || name.isEmpty()) {
                    return true;
                }
                String key = name.toLowerCase();
                if (hashSet.contains(key)) {
                    return true;
                }
                if (visited.contains(key)) {
                    return true;
                }
                if (hashSet2.contains(key)) {
                    throw new IllegalStateException("Cycle detected in requirements at: " + key);
                }
                AbilityTreeData.Ability node = (AbilityTreeData.Ability)byName.get(key);
                if (node == null) {
                    hashSet.add(key);
                    if (unlockedNodes != null && !unlockedNodes.contains(key)) {
                        unlockedNodes.add(key);
                    }
                    return true;
                }
                AbilityTreeData.ArchetypeRequirement arReq = null;
                if (node.requirements != null) {
                    arReq = node.requirements.ARCHETYPE;
                }
                if (arReq != null) {
                    int have;
                    String arcName = arReq.name == null ? null : arReq.name.trim();
                    String arcKey = arcName == null ? null : TreeLoader.normalizeArchetypeKey(arcName);
                    int need = arReq.amount;
                    int n = have = arcKey == null ? 0 : archetypeCounts.getOrDefault(arcKey, 0);
                    if (have < need) {
                        return false;
                    }
                }
                hashSet2.add(key);
                if (node.requirements != null && node.requirements.NODE != null && !(req = node.requirements.NODE.trim()).isEmpty() && !(ok = this.resolve(req))) {
                    hashSet2.remove(key);
                    return false;
                }
                hashSet2.remove(key);
                visited.add(key);
                if (!hashSet.contains(key)) {
                    stack.push(node);
                    hashSet.add(key);
                    try {
                        Optional<String> optDisplay = TreeLoader.extractArchetypeInfo(node.description);
                        if (optDisplay.isPresent()) {
                            String display = optDisplay.get();
                            String internalArchetypeName = TreeLoader.getInternalName(display, archetypes);
                            String mapKey = TreeLoader.normalizeArchetypeKey(internalArchetypeName);
                            archetypeCounts.put(mapKey, archetypeCounts.getOrDefault(mapKey, 0) + 1);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (unlockedNodes != null && !unlockedNodes.contains(key)) {
                        unlockedNodes.add(key);
                    }
                }
                return true;
            }
        }
        Resolver resolver = new Resolver();
        for (AbilityTreeData.Ability a : nodes) {
            String key;
            if (a == null || a.name == null || hashSet.contains(key = a.name.toLowerCase()) || visited.contains(key)) continue;
            resolver.resolve(key);
        }
        do {
            progress = false;
            for (AbilityTreeData.Ability a : nodes) {
                boolean resolved;
                String key;
                if (a == null || a.name == null || visited.contains(key = a.name.toLowerCase()) || !(resolved = resolver.resolve(key))) continue;
                progress = true;
            }
        } while (progress);
        while (!stack.isEmpty()) {
            result.add((AbilityTreeData.Ability)stack.removeLast());
        }
        return result;
    }

    public static String getInternalName(String displayName, Map<String, AbilityTreeData.Archetype> archetypes) {
        AbilityTreeData.Archetype at;
        if (displayName == null || archetypes == null) {
            return null;
        }
        String target = TreeLoader.normalizeDisplay(displayName);
        for (Map.Entry<String, AbilityTreeData.Archetype> e : archetypes.entrySet()) {
            String raw;
            String cand;
            at = e.getValue();
            if (at == null || !(cand = TreeLoader.normalizeDisplay(raw = at.name)).equals(target)) continue;
            return e.getKey();
        }
        for (Map.Entry<String, AbilityTreeData.Archetype> e : archetypes.entrySet()) {
            String cand;
            at = e.getValue();
            if (at == null || (cand = TreeLoader.normalizeDisplay(at.name)).isEmpty() || !cand.contains(target) && !target.contains(cand)) continue;
            return e.getKey();
        }
        return null;
    }

    private static String normalizeDisplay(String s) {
        if (s == null) {
            return "";
        }
        String plain = s.replaceAll("<[^>]+>", " ");
        plain = plain.replaceAll("\u00a7.", "");
        plain = plain.replace("&nbsp;", " ").replace("&amp;", "&").replace("&#39;", "'").replace("&quot;", "\"");
        plain = plain.replace('\u2019', '\'').replace('\u2018', '\'');
        plain = plain.replaceAll("[\\p{C}]+", " ").replaceAll("\\s+", " ").trim().toLowerCase();
        return plain;
    }

    public static void savePlayerAbilityTree(String playerName, String characterUUID, String className, SkillPoints skillPoints, AbilityMapData classMap, AbilityTreeData classTree, AbilityMapData playerTree) {
        try {
            if (characterUUID == null) {
                McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix(class_2561.method_30163((String)"Couldnt save tree: characterUUID == null")));
                return;
            }
            String abilityApiUrl = "https://api.wynncraft.com/v3/player/" + playerName + "/characters/" + characterUUID + "/abilities";
            String abilityResponse = TreeLoader.makeHttpRequest(abilityApiUrl);
            if (abilityResponse == null) {
                McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix(class_2561.method_30163((String)"Failed to fetch ability tree data: abilityResponse == null")));
                return;
            }
            Path treesDir = FabricLoader.getInstance().getConfigDir().resolve("wynnextras/trees");
            Files.createDirectories(treesDir, new FileAttribute[0]);
            String baseName = playerName + "_" + characterUUID;
            String fileName = baseName + ".json";
            Path filePath = treesDir.resolve(fileName);
            int counter = 1;
            while (Files.exists(filePath, new LinkOption[0])) {
                fileName = baseName + " (" + counter + ").json";
                filePath = treesDir.resolve(fileName);
                ++counter;
            }
            JsonObject out = new JsonObject();
            out.addProperty("name", fileName.replace(".json", ""));
            out.addProperty("visibleName", "");
            out.addProperty("strength", (Number)skillPoints.getStrength());
            out.addProperty("dexterity", (Number)skillPoints.getDexterity());
            out.addProperty("intelligence", (Number)skillPoints.getIntelligence());
            out.addProperty("defence", (Number)Math.max(skillPoints.getDefence(), skillPoints.getDefense()));
            out.addProperty("agility", (Number)skillPoints.getAgility());
            String formatted = className.substring(0, 1).toUpperCase() + className.substring(1).toLowerCase();
            out.addProperty("className", formatted);
            out.add("playerMap", gson.toJsonTree((Object)playerTree));
            out.add("playerTree", gson.toJsonTree((Object)classTree));
            try (FileWriter writer = new FileWriter(filePath.toFile());){
                String prettyJson = gson.toJson((JsonElement)out);
                writer.write(prettyJson);
                writer.flush();
                McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix(class_2561.method_30163((String)"The Ability tree was saved successfully. Use /Wynnextras tree (or /we tree) to view or load it.")));
                TreeData.loadAll();
                return;
            }
            catch (IOException e) {
                System.err.println("[WynnExtras] Couldn't write ability tree file:");
                e.printStackTrace();
                McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix(class_2561.method_30163((String)"Failed to save ability tree file")));
            }
        }
        catch (Exception e) {
            System.err.println("[WynnExtras] Error fetching ability tree:");
            e.printStackTrace();
            McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix(class_2561.method_30163((String)"Error fetching ability tree")));
        }
    }

    public static void deletePlayerAbilityTree(String fileName) {
        try {
            Path treesDir = FabricLoader.getInstance().getConfigDir().resolve("wynnextras/trees");
            Files.createDirectories(treesDir, new FileAttribute[0]);
            Path filePath = treesDir.resolve(fileName);
            if (Files.deleteIfExists(filePath)) {
                McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix(class_2561.method_30163((String)"The Ability tree was deleted successfully.")));
                TreeData.loadAll();
            } else {
                McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix(class_2561.method_30163((String)("Ability tree file not found: " + fileName))));
            }
        }
        catch (IOException e) {
            System.err.println("[WynnExtras] Couldn't delete ability tree file:");
            e.printStackTrace();
            McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix(class_2561.method_30163((String)"Failed to delete ability tree file")));
        }
    }

    private static String makeHttpRequest(String urlString) {
        try {
            int responseCode;
            URL url = new URL(urlString);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("User-Agent", "WynnExtras-Mod/1.0");
            if (WynncraftApiHandler.INSTANCE.API_KEY != null && !WynncraftApiHandler.INSTANCE.API_KEY.isEmpty()) {
                connection.setRequestProperty("Authorization", "Bearer " + WynncraftApiHandler.INSTANCE.API_KEY);
            }
            if ((responseCode = connection.getResponseCode()) == 200) {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                reader.close();
                return response.toString();
            }
            if (responseCode == 403) {
                McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix(class_2561.method_30163((String)"HTTP Request failed: 403")));
                return null;
            }
            if (responseCode == 401) {
                McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix(class_2561.method_30163((String)"HTTP Request failed: 401")));
                return null;
            }
            System.err.println("[WynnExtras] HTTP Error: " + responseCode);
            return null;
        }
        catch (IOException e) {
            System.err.println("[WynnExtras] Network error:");
            e.printStackTrace();
            return null;
        }
    }

    public static void openTreeMenu(class_310 client, class_1657 player) {
        int currentSlot = player.method_31548().field_7545;
        player.method_31548().field_7545 = 7;
        client.field_1724.field_3944.method_52787((class_2596)new class_2848((class_1297)player, class_2848.class_2849.field_12979));
        client.field_1761.method_2919(player, class_1268.field_5808);
        client.field_1724.field_3944.method_52787((class_2596)new class_2848((class_1297)player, class_2848.class_2849.field_12984));
        player.method_31548().field_7545 = currentSlot;
        treeMenuWasOpened = true;
    }

    public static void openTreeResetMenu(class_310 client, class_1657 player, class_465<?> screen) {
        if (!inTreeMenu) {
            return;
        }
        resetMenuWasOpened = TreeLoader.clickOnNameInInventory("Reset", screen, client);
    }

    public static void clickOnSockets(class_310 client, class_1657 player, class_465<?> screen) {
        if (!inResetMenu) {
            return;
        }
        boolean wasClicked = TreeLoader.clickOnNameInInventory("Empty Socket", screen, client);
        if (wasClicked) {
            ++clickedSockets;
        }
    }

    public static void confirmReset(class_310 client, class_1657 player, class_465<?> screen) {
        if (!inResetMenu) {
            return;
        }
        wasReset = TreeLoader.clickOnNameInInventory("Confirm", screen, client);
    }

    public static void clickOnAbility(class_310 client, class_1657 player, String nameToClick, class_465<?> screen) {
        if (!inTreeMenu) {
            return;
        }
        TreeLoader.clickOnNameInInventory(nameToClick, screen, client);
    }

    public static boolean hasUnlockPrefix(String ability, class_465<?> screen) {
        String unlockName = "Unlock " + ability;
        for (int i = 0; i < screen.method_17577().field_7761.size(); ++i) {
            String name;
            class_1735 slot = (class_1735)screen.method_17577().field_7761.get(i);
            if (!slot.method_7681() || slot.method_7677().method_65130() == null || !(name = slot.method_7677().method_65130().getString()).contains(unlockName)) continue;
            return true;
        }
        return false;
    }

    public static int countOccurences(String count, class_465<?> screen) {
        int socketsFilled = 0;
        for (int i = 0; i < screen.method_17577().field_7761.size(); ++i) {
            String name;
            class_1735 slot = (class_1735)screen.method_17577().field_7761.get(i);
            if (!slot.method_7681() || slot.method_7677().method_65130() == null || !(name = slot.method_7677().method_65130().getString()).contains(count)) continue;
            ++socketsFilled;
        }
        return socketsFilled;
    }

    public static boolean clickOnNameInInventory(String nameToClick, class_465<?> screen, class_310 client) {
        for (int i = 0; i < screen.method_17577().field_7761.size(); ++i) {
            String name;
            class_1735 slot = (class_1735)screen.method_17577().field_7761.get(i);
            if (!slot.method_7681() || slot.method_7677().method_65130() == null || !(name = slot.method_7677().method_65130().getString()).contains(nameToClick)) continue;
            TreeLoader.clickSlotHelper(i, screen, client);
            return true;
        }
        return false;
    }

    public static void clickSlotHelper(int slotid, class_465<?> screen, class_310 client) {
        client.field_1761.method_2906(screen.method_17577().field_7763, slotid, 0, class_1713.field_7790, (class_1657)client.field_1724);
        ticksSinceLastAction = 0;
    }

    static {
        loadingSkillpoints = false;
        pendingClick = null;
        lagTickCounter = 0;
        fastMode = true;
        pendingReset = null;
        scrolledUp = false;
        firstNode = null;
        lastResetTryClick = 0L;
        finishedTreeTime = 0L;
    }

    private static class PendingClick {
        AbilityMapData.Node node;
        String abilityName;
        int attempts;
        int ticksWaiting;
        int expectedPage;

        PendingClick(AbilityMapData.Node node, String abilityName, int expectedPage) {
            this.node = node;
            this.abilityName = abilityName;
            this.attempts = 0;
            this.ticksWaiting = 0;
            this.expectedPage = expectedPage;
        }
    }

    private static class PendingResetClick {
        String stage;
        int ticksWaiting;
        int attempts;

        PendingResetClick(String stage) {
            this.stage = stage;
            this.ticksWaiting = 0;
            this.attempts = 0;
        }
    }
}

