/*
 * Decompiled with CFR 0.152.
 */
package julianh06.wynnextras.features.abilitytree;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import julianh06.wynnextras.features.profileviewer.data.AbilityMapData;
import julianh06.wynnextras.features.profileviewer.data.AbilityTreeData;
import net.fabricmc.loader.api.FabricLoader;

public class TreeData {
    public String name;
    public String visibleName;
    public int strength;
    public int dexterity;
    public int intelligence;
    public int defence;
    public int agility;
    public String className;
    public AbilityMapData playerMap;
    public AbilityTreeData playerTree;
    public static Map<String, TreeData> trees = new HashMap<String, TreeData>();
    public static Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public static TreeData safeLoadTree(Path pathToFile) {
        TreeData treeData;
        block9: {
            BufferedReader reader = Files.newBufferedReader(pathToFile);
            try {
                reader.mark(2);
                int firstChar = reader.read();
                if (firstChar == 91) {
                    throw new IOException("Tree file " + String.valueOf(pathToFile.getFileName()) + " is in API array form! Use /savePlayerAbilityTree to convert it to object form.");
                }
                reader.reset();
                treeData = (TreeData)gson.fromJson((Reader)reader, TreeData.class);
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonParseException | IOException e) {
                    System.err.println("[TreeData] Failed to load " + String.valueOf(pathToFile) + ":");
                    e.printStackTrace();
                    return null;
                }
            }
            reader.close();
        }
        return treeData;
    }

    public static void loadAll() {
        trees.clear();
        Path treesDir = FabricLoader.getInstance().getConfigDir().resolve("wynnextras/trees");
        if (!Files.isDirectory(treesDir, new LinkOption[0])) {
            try {
                Files.createDirectories(treesDir, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(treesDir, "*.json");){
            for (Path file : stream) {
                TreeData t = TreeData.safeLoadTree(file);
                if (t == null || t.name == null) continue;
                trees.put(t.name, t);
                System.out.println("[TreeData] Loaded ability tree: " + t.name);
            }
        }
        catch (IOException e) {
            System.err.println("[TreeData] Failed to scan directory: " + String.valueOf(treesDir));
        }
    }

    public static void saveAll() {
        Path treesDir = FabricLoader.getInstance().getConfigDir().resolve("wynnextras/trees");
        if (!Files.isDirectory(treesDir, new LinkOption[0])) {
            try {
                Files.createDirectories(treesDir, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        for (TreeData tree : trees.values()) {
            Path file = treesDir.resolve(tree.name + ".json");
            try {
                String json = gson.toJson((Object)tree);
                Files.writeString(file, (CharSequence)json, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException e) {
                System.err.println("[TreeData] Failed to save tree: " + tree.name);
            }
        }
    }

    public static TreeData getTree(String name) {
        return trees.get(name);
    }
}

