/*
 * Decompiled with CFR 0.152.
 */
package julianh06.wynnextras.core;

import com.wynntils.utils.mc.McUtils;
import java.time.Duration;
import java.time.Instant;
import julianh06.wynnextras.annotations.WEModule;
import julianh06.wynnextras.config.WynnExtrasConfig;
import julianh06.wynnextras.config.simpleconfig.SimpleConfig;
import julianh06.wynnextras.core.Core;
import julianh06.wynnextras.core.CurrentVersionData;
import julianh06.wynnextras.core.command.Command;
import julianh06.wynnextras.core.loader.WELoader;
import julianh06.wynnextras.event.CharInputEvent;
import julianh06.wynnextras.event.ClickEvent;
import julianh06.wynnextras.event.KeyInputEvent;
import julianh06.wynnextras.event.TickEvent;
import julianh06.wynnextras.event.WorldChangeEvent;
import julianh06.wynnextras.features.abilitytree.TreeLoader;
import julianh06.wynnextras.features.aspects.maintracking;
import julianh06.wynnextras.features.bankoverlay.BankOverlay2;
import julianh06.wynnextras.features.chat.RaidChatNotifier;
import julianh06.wynnextras.features.guildviewer.GV;
import julianh06.wynnextras.features.inventory.BankOverlay;
import julianh06.wynnextras.features.inventory.BankOverlayType;
import julianh06.wynnextras.features.inventory.data.AccountBankData;
import julianh06.wynnextras.features.inventory.data.BookshelfData;
import julianh06.wynnextras.features.inventory.data.CharacterBankData;
import julianh06.wynnextras.features.inventory.data.MiscBucketData;
import julianh06.wynnextras.features.misc.FastRequeue;
import julianh06.wynnextras.features.misc.PlayerHider;
import julianh06.wynnextras.features.misc.ProvokeTimer;
import julianh06.wynnextras.features.profileviewer.PV;
import julianh06.wynnextras.features.profileviewer.WynncraftApiHandler;
import julianh06.wynnextras.features.raid.RaidListData;
import julianh06.wynnextras.features.waypoints.WaypointData;
import julianh06.wynnextras.features.waypoints.Waypoints;
import julianh06.wynnextras.mixin.Accessor.KeybindingAccessor;
import julianh06.wynnextras.sound.ModSounds;
import julianh06.wynnextras.utils.MinecraftUtils;
import julianh06.wynnextras.utils.TickScheduler;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1735;
import net.minecraft.class_2371;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWKeyCallbackI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WEModule
public class WynnExtras
implements ClientModInitializer {
    private static Command discordCmd = new Command("discord", "", context -> {
        McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix((class_2561)class_2561.method_43470((String)"")).method_10852((class_2561)class_2561.method_43470((String)"https://discord.gg/UbC6vZDaD5").method_10862(class_2583.field_24360.method_10977(class_124.field_1075).method_30938(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11749, "https://discord.gg/UbC6vZDaD5")))));
        return 1;
    }, null, null);
    private static Command configCmd = new Command("config", "", context -> {
        class_437 configScreen = SimpleConfig.getConfigScreen(WynnExtrasConfig.class, null).get();
        MinecraftUtils.mc().method_63588(() -> MinecraftUtils.mc().method_1507(configScreen));
        return 1;
    }, null, null);
    public static final String MOD_ID = "wynnextras";
    public static final Logger LOGGER = LoggerFactory.getLogger("wynnextras");
    public static class_2371<class_1735> testInv;
    public static int testInvSize;
    GLFWKeyCallbackI previousCallback;
    private static final class_2960 PILL_FONT;
    private static final class_2583 BACKGROUND_STYLE;
    private static final class_2583 FOREGROUND_STYLE;
    private static final class_2561 WYNNEXTRAS_BACKGROUND_PILL;
    private static final class_2561 WYNNEXTRAS_FOREGROUND_PILL;
    public static String latestVersion;
    private static int ticksUntilNotify;
    public static int normalGUIScale;
    private static WynnExtrasConfig config;
    private static Instant lastNotificationTime;
    private static final Duration COOLDOWN;

    public static class_5250 addWynnExtrasPrefix(class_2561 text) {
        return class_2561.method_43473().method_10852(WYNNEXTRAS_BACKGROUND_PILL).method_10852(WYNNEXTRAS_FOREGROUND_PILL).method_10852(text);
    }

    public static class_5250 addWynnExtrasPrefix(String text) {
        return WynnExtras.addWynnExtrasPrefix(class_2561.method_30163((String)text));
    }

    public void onInitializeClient() {
        Core.init(MOD_ID);
        CurrentVersionData.INSTANCE.version = FabricLoader.getInstance().getModContainer(MOD_ID).map(mod -> mod.getMetadata().getVersion().getFriendlyString()).orElse("unknown");
        CurrentVersionData.save();
        latestVersion = CurrentVersionData.fetchLatestVersion();
        WELoader.loadAll();
        TickScheduler.init();
        ClickEvent.register();
        PlayerHider.registerBossPlayerHider();
        BankOverlay.registerBankOverlay();
        PV.register();
        GV.register();
        ProvokeTimer.init();
        Waypoints.register();
        FastRequeue.registerFastRequeue();
        TreeLoader.init();
        maintracking.init();
        RaidListData.load();
        WaypointData.load();
        RaidChatNotifier.INSTANCE.load();
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            AccountBankData.INSTANCE.load();
            CharacterBankData.INSTANCE.load();
            BookshelfData.INSTANCE.load();
            MiscBucketData.INSTANCE.load();
            WynncraftApiHandler.load();
            System.out.println("loaded bankdata");
        });
        ModSounds.registerSounds();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void initKeyInputEvent(TickEvent event) {
        if (!KeyInputEvent.initialized && class_310.method_1551().method_22683() != null) {
            KeyInputEvent.init();
            this.previousCallback = GLFW.glfwSetKeyCallback((long)class_310.method_1551().method_22683().method_4490(), (window, key, scancode, action, mods) -> {
                if (action == 1 || action == 2 || action == 0) {
                    new KeyInputEvent(key, scancode, action, mods).post();
                }
                if (BankOverlay2.searchbar2 != null && BankOverlay.currentOverlayType != BankOverlayType.NONE && BankOverlay2.searchbar2.isFocused() && key == ((KeybindingAccessor)class_310.method_1551().field_1690.field_1822).getBoundKey().method_1444()) {
                    return;
                }
                for (BankOverlay2.PageWidget page : BankOverlay2.pages) {
                    if (page.sign == null || page.sign.textInputWidget == null || BankOverlay.currentOverlayType == BankOverlayType.NONE || !page.sign.textInputWidget.isFocused() || key != ((KeybindingAccessor)class_310.method_1551().field_1690.field_1822).getBoundKey().method_1444()) continue;
                    return;
                }
                if (BankOverlay.currentOverlayType != BankOverlayType.NONE && 49 <= key && key <= 57) {
                    return;
                }
                if (this.previousCallback != null) {
                    this.previousCallback.invoke(window, key, scancode, action, mods);
                }
            });
            GLFW.glfwSetCharCallback((long)class_310.method_1551().method_22683().method_4490(), (win, codepoint) -> new CharInputEvent((char)codepoint).post());
        }
    }

    @SubscribeEvent
    public void onWorldChange(WorldChangeEvent event) {
        if (latestVersion != null && !CurrentVersionData.INSTANCE.version.equals(latestVersion)) {
            ticksUntilNotify = 50;
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent event) {
        if (config == null) {
            config = SimpleConfig.getInstance(WynnExtrasConfig.class);
        }
        if (WynnExtras.config.differentGUIScale && class_310.method_1551().field_1755 == null && normalGUIScale != -1) {
            class_310.method_1551().field_1690.method_42474().method_41748((Object)normalGUIScale);
            normalGUIScale = -1;
        }
        if (ticksUntilNotify < 0) {
            return;
        }
        if (--ticksUntilNotify == 0) {
            WynnExtras.tryNotifyVersionUpdate(CurrentVersionData.INSTANCE.version, latestVersion);
        }
    }

    public static void tryNotifyVersionUpdate(String currentVersion, String latestVersion) {
        if (latestVersion == null || currentVersion.equals(latestVersion)) {
            return;
        }
        Instant now = Instant.now();
        if (lastNotificationTime == null || Duration.between(lastNotificationTime, now).compareTo(COOLDOWN) >= 0) {
            lastNotificationTime = now;
            McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix(class_2561.method_30163((String)("\u00a7aA new version of WynnExtras is available: \u00a7b" + latestVersion + "\u00a7a! You're currently using version \u00a7b" + currentVersion + "\u00a7a. You can download it now on Modrinth!"))));
        }
    }

    static {
        PILL_FONT = class_2960.method_60656((String)"banner/pill");
        latestVersion = null;
        BACKGROUND_STYLE = class_2583.field_24360.method_27704(PILL_FONT).method_10977(class_124.field_1077);
        FOREGROUND_STYLE = class_2583.field_24360.method_27704(PILL_FONT).method_10977(class_124.field_1068);
        WYNNEXTRAS_BACKGROUND_PILL = class_2561.method_43470((String)"\ue060\udaff\udfff\ue046\udaff\udfff\ue048\udaff\udfff\ue03d\udaff\udfff\ue03d\udaff\udfff\ue034\udaff\udfff\ue047\udaff\udfff\ue043\udaff\udfff\ue041\udaff\udfff\ue030\udaff\udfff\ue042\udaff\udfff\ue062\udaff\udfc2").method_27696(BACKGROUND_STYLE);
        WYNNEXTRAS_FOREGROUND_PILL = class_2561.method_43470((String)"\ue016\ue018\ue00d\ue00d\ue004\ue017\ue013\ue011\ue000\ue012\udb00\udc06").method_27696(FOREGROUND_STYLE);
        ticksUntilNotify = -1;
        normalGUIScale = -1;
        lastNotificationTime = null;
        COOLDOWN = Duration.ofMinutes(15L);
    }
}

