/*
 * Decompiled with CFR 0.152.
 */
package julianh06.wynnextras.core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public class CurrentVersionData {
    public static CurrentVersionData INSTANCE = new CurrentVersionData();
    public String version;
    static Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("wynnextras/version.json");
    private static final String MODRINTH_API = "https://api.modrinth.com/v2/project/cjWpppr5/version";

    public static void load() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(CONFIG_PATH);){
                CurrentVersionData loaded = (CurrentVersionData)gson.fromJson((Reader)reader, CurrentVersionData.class);
                if (loaded != null) {
                    INSTANCE = loaded;
                } else {
                    System.err.println("[WynnExtras] Deserialized data was null, keeping default INSTANCE.");
                }
            }
            catch (IOException e) {
                System.err.println("[WynnExtras] Couldn't read the version file:");
                e.printStackTrace();
            }
        }
    }

    public static void save() {
        try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
            gson.toJson((Object)INSTANCE, (Appendable)writer);
        }
        catch (IOException e) {
            System.err.println("[WynnExtras] Couldn't write the version file:");
            e.printStackTrace();
        }
    }

    public static String fetchLatestVersion() {
        try {
            URL url = new URL(MODRINTH_API);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            JsonArray versions = JsonParser.parseReader((Reader)new InputStreamReader(conn.getInputStream())).getAsJsonArray();
            String latest = null;
            String latestDate = "";
            for (JsonElement el : versions) {
                JsonObject obj = el.getAsJsonObject();
                String version = obj.get("version_number").getAsString();
                String date = obj.get("date_published").getAsString();
                if (date.compareTo(latestDate) <= 0) continue;
                latest = version;
                latestDate = date;
            }
            return latest;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

