/*
 * Decompiled with CFR 0.152.
 */
package julianh06.wynnextras.config.simpleconfig.gui;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import julianh06.wynnextras.config.simpleconfig.annotations.ConfigEntry;
import julianh06.wynnextras.config.simpleconfig.gui.registry.GuiRegistry;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.TextListEntry;
import me.shedaniel.clothconfig2.gui.entries.TooltipListEntry;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;

@Environment(value=EnvType.CLIENT)
public class DefaultGuiTransformers {
    private static final ConfigEntryBuilder ENTRY_BUILDER = ConfigEntryBuilder.create();

    private DefaultGuiTransformers() {
    }

    public static GuiRegistry apply(GuiRegistry registry) {
        registry.registerAnnotationTransformer((guis, name, field, config, defaults, guiProvider) -> guis.stream().peek(gui -> {
            if (!(gui instanceof TextListEntry)) {
                ConfigEntry.Tooltip tooltip = field.getAnnotation(ConfigEntry.Tooltip.class);
                DefaultGuiTransformers.tryApplyTooltip(gui, (class_2561[])Arrays.stream(tooltip.value()).map(s -> class_2561.method_43470((String)s)).toArray(class_2561[]::new));
            }
        }).collect(Collectors.toList()), ConfigEntry.Tooltip.class);
        return registry;
    }

    private static void tryApplyTooltip(AbstractConfigListEntry<?> gui, class_2561[] text) {
        if (gui instanceof TooltipListEntry) {
            TooltipListEntry tooltipGui = (TooltipListEntry)gui;
            tooltipGui.setTooltipSupplier(() -> Optional.of(text));
        }
    }

    private static void tryRemoveTooltip(AbstractConfigListEntry<?> gui) {
        if (gui instanceof TooltipListEntry) {
            TooltipListEntry tooltipGui = (TooltipListEntry)gui;
            tooltipGui.setTooltipSupplier(Optional::empty);
        }
    }
}

